/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import tv.amwa.maj.exception.NoMoreObjectsException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.TaggedValueDefinition;
import tv.amwa.maj.model.impl.DefinitionObjectImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=19456, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TaggedValueDefinition", description="The TaggedValueDefinition class documents the TaggedValue objects used in the file.", symbol="TaggedValueDefinition")
public class TaggedValueDefinitionImpl
extends DefinitionObjectImpl
implements TaggedValueDefinition,
Serializable,
Cloneable {
    private static final long serialVersionUID = 6631196590993410617L;
    private transient Set<PropertyDefinition> parentProperties = null;

    public TaggedValueDefinitionImpl() {
    }

    public TaggedValueDefinitionImpl(AUID identification, @AAFString String name) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a tagged value definition with a null id.");
        }
        this.setAUID(identification);
        this.setName(name);
    }

    @Override
    public void addParentProperty(PropertyDefinition parentProperty) throws NullPointerException {
        if (parentProperty == null) {
            throw new NullPointerException("Cannot add a null value to the set of parent properties.");
        }
        if (this.parentProperties == null) {
            this.parentProperties = Collections.synchronizedSet(new HashSet());
        }
        this.parentProperties.add(parentProperty);
    }

    @Override
    public int countParentProperties() throws PropertyNotPresentException {
        if (this.parentProperties == null) {
            throw new PropertyNotPresentException("The optional parent properties property is not present for this tagged value definition.");
        }
        return this.parentProperties.size();
    }

    public Set<PropertyDefinition> getParentProperties() throws PropertyNotPresentException {
        if (this.parentProperties == null) {
            throw new PropertyNotPresentException("The optional parent properties property is not present for this tagged value definition.");
        }
        return new HashSet<PropertyDefinition>(this.parentProperties);
    }

    @Override
    public void removeParentProperty(PropertyDefinition parentProperty) throws NullPointerException, NoMoreObjectsException, PropertyNotPresentException {
        if (parentProperty == null) {
            throw new NullPointerException("Cannot remove a parent property from this tagged value definition using a null value.");
        }
        if (this.parentProperties == null) {
            throw new PropertyNotPresentException("The optional parent properties property is not present for this tagged value definition.");
        }
        if (!this.parentProperties.contains(parentProperty)) {
            throw new NoMoreObjectsException("The given parent property is not contained within the set of parent properties of this tagged value definition.");
        }
        this.parentProperties.remove(parentProperty);
        if (this.parentProperties.size() == 0) {
            this.parentProperties = null;
        }
    }

    @Override
    public TaggedValueDefinition clone() {
        return (TaggedValueDefinition)super.clone();
    }
}

