/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.model.SourceReferenceSegment;
import tv.amwa.maj.model.impl.SegmentImpl;
import tv.amwa.maj.record.PackageID;
import tv.amwa.maj.record.impl.PackageIDImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=4096, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="SourceReference", description="The SourceReference class represents the essence or other data described by a Track in a Package.", symbol="SourceReference", isConcrete=false)
public class SourceReferenceSegmentImpl
extends SegmentImpl
implements SourceReferenceSegment,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5589293931478011918L;
    private PackageID sourcePackageID = null;
    private int sourceTrackID;
    private int[] channelIds = null;
    private int[] monoSourceTrackIDs = null;

    @Override
    @MediaProperty(uuid1=100729091, uuid2=1792, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 7}, definedName="ChannelIDs", typeName="UInt32Array", optional=true, uniqueIdentifier=false, pid=4355, symbol="ChannelIDs")
    public int[] getChannelIDs() throws PropertyNotPresentException {
        if (this.channelIds == null) {
            throw new PropertyNotPresentException("The optional channel ids property is not present in this source reference segment.");
        }
        return (int[])this.channelIds.clone();
    }

    @Override
    @MediaPropertySetter(value="ChannelIDs")
    public void setChannelIDs(int[] channelIDs) throws IllegalArgumentException {
        if (channelIDs == null) {
            this.channelIds = null;
            return;
        }
        for (int x : channelIDs) {
            if (x >= 0) continue;
            throw new IllegalArgumentException("The channel id at index " + x + " is negative, which is not allowed for this source reference segment.");
        }
        this.channelIds = (int[])channelIDs.clone();
    }

    @Override
    public int getChannelIDsSize() throws PropertyNotPresentException {
        if (this.channelIds == null) {
            throw new PropertyNotPresentException("The optional channel ids property is not present in this source reference segment.");
        }
        return this.channelIds.length;
    }

    @MediaPropertyClear(value="ChannelIDs")
    public void clearChannelIDs() {
        this.channelIds = null;
    }

    @Override
    @MediaProperty(uuid1=100729091, uuid2=2048, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="MonoSourceTrackIDs", aliases={"MonoSourceSlotIDs"}, typeName="UInt32Array", optional=true, uniqueIdentifier=false, pid=4356, symbol="MonoSourceTrackIDs")
    public int[] getMonoSourceTrackIDs() throws PropertyNotPresentException {
        if (this.monoSourceTrackIDs == null) {
            throw new PropertyNotPresentException("The optional mono source track ids property is not present in this source reference.");
        }
        return (int[])this.monoSourceTrackIDs.clone();
    }

    @Override
    @MediaPropertySetter(value="MonoSourceTrackIDs")
    public void setMonoSourceTrackIDs(int[] monoSourceTrackIDs) throws IllegalArgumentException {
        if (monoSourceTrackIDs == null) {
            this.monoSourceTrackIDs = null;
            return;
        }
        for (int x : monoSourceTrackIDs) {
            if (x >= 0) continue;
            throw new IllegalArgumentException("The source track id at index " + x + " is negative, which is not permitted for this source reference.");
        }
        this.monoSourceTrackIDs = (int[])monoSourceTrackIDs.clone();
    }

    @Override
    @MediaPropertyCount(value="MonoSourceTrackIDs")
    public int getMonoSourceTrackIDsSize() throws PropertyNotPresentException {
        if (this.monoSourceTrackIDs == null) {
            throw new PropertyNotPresentException("The optional mono source track ids property is not present in this source reference.");
        }
        return this.monoSourceTrackIDs.length;
    }

    @MediaPropertyClear(value="MonoSourceTrackIDs")
    public void clearMonoSourceTrackIDs() {
        this.monoSourceTrackIDs = null;
    }

    @Override
    @MediaProperty(uuid1=100729091, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="SourcePackageID", aliases={"SourceID", "SourceMobID"}, typeName="PackageIDType", optional=true, uniqueIdentifier=false, pid=4353, symbol="SourcePackageID")
    public PackageID getSourcePackageID() throws PropertyNotPresentException {
        if (this.sourcePackageID == null) {
            throw new PropertyNotPresentException("The optional source id property is not present for this source reference, implying that this is a reference to a track within the same package.");
        }
        return this.sourcePackageID.clone();
    }

    @Override
    @MediaPropertySetter(value="SourcePackageID")
    public void setSourcePackageID(PackageID sourcePackageID) {
        if (sourcePackageID == null) {
            this.sourcePackageID = null;
            return;
        }
        this.sourcePackageID = sourcePackageID.clone();
    }

    @Override
    @MediaProperty(uuid1=100729091, uuid2=512, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="SourceTrackID", aliases={"SourceMobSlotID"}, typeName="UInt32", optional=false, uniqueIdentifier=false, pid=4354, symbol="SourceTrackID")
    public int getSourceTrackID() {
        return this.sourceTrackID;
    }

    @Override
    @MediaPropertySetter(value="SourceTrackID")
    public void setSourceTrackID(int sourceTrackID) throws IllegalArgumentException {
        if (sourceTrackID < 0) {
            throw new IllegalArgumentException("Cannot set the source track id of this source reference to a negative value.");
        }
        this.sourceTrackID = sourceTrackID;
    }

    public static final int initializeSourceTrackID() {
        return 0;
    }

    @Override
    public SourceReferenceSegment clone() {
        return (SourceReferenceSegment)super.clone();
    }

    public String getSourcePackageIDString() {
        return PackageIDImpl.toPersistentForm(this.sourcePackageID);
    }

    public void setSourcePackageIDString(String sourcePackageID) {
        this.sourcePackageID = PackageIDImpl.fromPersistentForm(sourcePackageID);
    }
}

