/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.List;
import tv.amwa.maj.enumeration.AppendOption;
import tv.amwa.maj.enumeration.CriteriaType;
import tv.amwa.maj.enumeration.EdgeType;
import tv.amwa.maj.enumeration.FilmType;
import tv.amwa.maj.enumeration.OperationChoice;
import tv.amwa.maj.enumeration.PackageKind;
import tv.amwa.maj.enumeration.PulldownDirectionType;
import tv.amwa.maj.enumeration.PulldownKindType;
import tv.amwa.maj.exception.AdjacentTransitionException;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.exception.BadRateException;
import tv.amwa.maj.exception.BadSizeException;
import tv.amwa.maj.exception.EventSemanticsException;
import tv.amwa.maj.exception.FilmDescriptorOnlyException;
import tv.amwa.maj.exception.InsufficientTransitionMaterialException;
import tv.amwa.maj.exception.InvalidDataDefinitionException;
import tv.amwa.maj.exception.InvalidPackageTypeException;
import tv.amwa.maj.exception.LeadingTransitionException;
import tv.amwa.maj.exception.NotSourceClipException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.exception.PulldownDirectionException;
import tv.amwa.maj.exception.TapeDescriptorOnlyException;
import tv.amwa.maj.exception.TrackExistsException;
import tv.amwa.maj.exception.TrackNotFoundException;
import tv.amwa.maj.exception.TraversalNotPossibleException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.Component;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.EssenceDescriptor;
import tv.amwa.maj.model.Filler;
import tv.amwa.maj.model.FindSourceInformation;
import tv.amwa.maj.model.Pulldown;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.Sequence;
import tv.amwa.maj.model.SourcePackage;
import tv.amwa.maj.model.Track;
import tv.amwa.maj.model.impl.AuxiliaryDescriptorImpl;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.EdgeCodeSegmentImpl;
import tv.amwa.maj.model.impl.FillerImpl;
import tv.amwa.maj.model.impl.FilmDescriptorImpl;
import tv.amwa.maj.model.impl.PackageImpl;
import tv.amwa.maj.model.impl.PulldownImpl;
import tv.amwa.maj.model.impl.SegmentImpl;
import tv.amwa.maj.model.impl.SequenceImpl;
import tv.amwa.maj.model.impl.SourceClipImpl;
import tv.amwa.maj.model.impl.TapeDescriptorImpl;
import tv.amwa.maj.model.impl.TimecodeSegmentImpl;
import tv.amwa.maj.record.PackageID;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.TimecodeValue;
import tv.amwa.maj.record.impl.EdgeCodeValueImpl;
import tv.amwa.maj.record.impl.PackageIDImpl;
import tv.amwa.maj.record.impl.TimeStampImpl;
import tv.amwa.maj.record.impl.TimecodeValueImpl;
import tv.amwa.maj.union.SourceReferenceValue;
import tv.amwa.maj.union.impl.SourceReferenceValueImpl;
import tv.amwa.maj.union.impl.TimecodeClipImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=14080, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="SourcePackage", aliases={"SourceMob"}, description="The SourcePackage class describes essence that is either stored in a digital form in a file or stored on a physical media, such as tape or film.", symbol="SourcePackage")
public class SourcePackageImpl
extends PackageImpl
implements SourcePackage,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3857642937486744441L;
    private EssenceDescriptor essenceDescription;

    public SourcePackageImpl() {
    }

    public SourcePackageImpl(PackageID packageID, @AAFString String name, EssenceDescriptor essenceDescription) throws NullPointerException {
        if (packageID == null) {
            throw new NullPointerException("Cannot create a new source package using a null package id value.");
        }
        if (essenceDescription == null) {
            throw new NullPointerException("Cannot create a new source package using a null essence description value.");
        }
        this.setPackageID(packageID);
        this.setPackageName(name);
        this.setEssenceDescriptor(essenceDescription);
        this.setPackageLastModified(new TimeStampImpl());
        this.setCreationTime(new TimeStampImpl());
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=515, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="EssenceDescription", typeName="EssenceDescriptorStrongReference", optional=false, uniqueIdentifier=false, pid=18177, symbol="EssenceDescription")
    public EssenceDescriptor getEssenceDescription() {
        return this.essenceDescription;
    }

    @Override
    @Deprecated
    public EssenceDescriptor getEssenceDescriptor() {
        return this.getEssenceDescription();
    }

    @Override
    @MediaPropertySetter(value="EssenceDescription")
    public void setEssenceDescription(EssenceDescriptor essenceDescriptor) throws NullPointerException {
        if (essenceDescriptor == null) {
            throw new NullPointerException("Cannot set the essence descriptor for this source package to a null value.");
        }
        this.essenceDescription = essenceDescriptor;
    }

    public static final EssenceDescriptor initializeEssenceDescription() {
        return new AuxiliaryDescriptorImpl("application/octet-stream");
    }

    @Override
    @Deprecated
    public void setEssenceDescriptor(EssenceDescriptor essenceDescriptor) throws NullPointerException {
        this.setEssenceDescription(essenceDescriptor);
    }

    @Override
    public void addNilReference(int trackID, long length, DataDefinition dataDefinition, Rational editRate) throws NullPointerException, IllegalArgumentException, BadRateException, BadLengthException, TrackExistsException {
        if (editRate.getDenominator() == 0) {
            throw new BadRateException("Cannot set an edit rate with a 0 denominator.");
        }
        SourceClipImpl subClip = new SourceClipImpl(dataDefinition, length, new SourceReferenceValueImpl(PackageIDImpl.getZeroPackageID(), 0, 0L));
        this.appendNewTimelineTrack(editRate, subClip, trackID, null, 0L);
    }

    public void addStaticNilReference(int trackID, DataDefinition dataDefinition) throws NullPointerException, IllegalArgumentException, TrackExistsException {
        if (dataDefinition == null) {
            throw new NullPointerException("Cannot set the data definition of a new static reference using a null value.");
        }
        try {
            SourceClipImpl staticClip = new SourceClipImpl(dataDefinition, 0L, new SourceReferenceValueImpl(PackageIDImpl.getZeroPackageID(), 0, 0L));
            this.appendNewStaticTrack(staticClip, trackID, null);
        }
        catch (BadLengthException badLengthException) {
            // empty catch block
        }
    }

    @Override
    public void addPulldownReference(AppendOption addType, Rational editRate, int trackID, DataDefinition essenceKind, SourceReferenceValue reference, long sourceReferenceLength, PulldownKindType pulldownKind, int phaseFrame, PulldownDirectionType direction) throws NullPointerException, PulldownDirectionException, BadLengthException, NotSourceClipException, TrackExistsException {
        if (editRate == null) {
            throw new NullPointerException("Cannot add a pulldown reference to this source package using a null edit rate value.");
        }
        if (essenceKind == null) {
            throw new NullPointerException("Cannot add a pulldown reference to this source package using a null essence kind.");
        }
        if (reference == null) {
            throw new NullPointerException("Cannot add a pulldown reference to this source package using a null source reference value.");
        }
        if (addType == null) {
            throw new NullPointerException("Cannot add a pulldown reference to this source package using a null add type.");
        }
        if (pulldownKind == null) {
            throw new NullPointerException("Cannot add a pulldown reference to this source package using a null pulldown kind.");
        }
        if (direction == null) {
            throw new NullPointerException("Cannot add a pulldown reference to this source package using a null pulldown direction.");
        }
        if (direction != PulldownDirectionType.FilmToTapeSpeed && direction != PulldownDirectionType.TapeToFilmSpeed) {
            throw new PulldownDirectionException("Pulldown direction must be either film to tape speed or tape to film speed.");
        }
        if (sourceReferenceLength < 0L) {
            throw new BadLengthException("Cannot add a pulldown reference to this source package using a negative length.");
        }
        PulldownImpl pulldown = new PulldownImpl(essenceKind, new FillerImpl(essenceKind, 0L), pulldownKind, direction, phaseFrame);
        if (pulldownKind.name().contains("OneToOne")) {
            pulldown.setComponentLength(sourceReferenceLength);
        } else {
            pulldown.setComponentLength(PulldownImpl.mapOffset((Pulldown)pulldown, (long)sourceReferenceLength, (boolean)true).numFrames);
        }
        Track track = null;
        SourceClipImpl sourceClip = null;
        try {
            track = this.lookupPackageTrack(trackID);
        }
        catch (TrackNotFoundException snfe) {
            sourceClip = new SourceClipImpl(essenceKind, sourceReferenceLength, reference);
            pulldown.setInputSegment(sourceClip);
            this.appendNewTimelineTrack(editRate, pulldown, trackID, null, 0L);
            return;
        }
        Segment segment = track.getTrackSegment();
        if (segment instanceof Sequence) {
            try {
                Sequence sequence = (Sequence)segment;
                int numberOfSegments = sequence.countComponentObjects();
                if (numberOfSegments == 0) {
                    sourceClip = new SourceClipImpl(essenceKind, sourceReferenceLength, reference);
                    pulldown.setInputSegment(sourceClip);
                    sequence.appendComponentObject(pulldown);
                }
                for (int x = 0; x < numberOfSegments; ++x) {
                    Component subSegment = sequence.getComponentObjectAt(0);
                    if (!(subSegment instanceof Segment) || subSegment.getComponentLength() == 0L) continue;
                    SequenceImpl.setNthComponent(sequence, pulldown, x);
                    if (subSegment instanceof SourceClipImpl) {
                        sourceClip = (SourceClipImpl)subSegment;
                    }
                    sourceClip = null;
                }
            }
            catch (InvalidDataDefinitionException e) {
                e.printStackTrace();
                sourceClip = null;
            }
            catch (LeadingTransitionException e) {
                sourceClip = null;
            }
            catch (EventSemanticsException e) {
                sourceClip = null;
            }
            catch (BadPropertyException e) {
                sourceClip = null;
            }
            catch (AdjacentTransitionException e) {
                sourceClip = null;
            }
            catch (InsufficientTransitionMaterialException e) {
                sourceClip = null;
            }
            catch (IndexOutOfBoundsException e) {
                sourceClip = null;
            }
        } else {
            track.setTrackSegment(pulldown);
            sourceClip = segment instanceof SourceClipImpl ? (SourceClipImpl)segment : null;
        }
        if (sourceClip == null) {
            throw new NotSourceClipException("The existing contents of the given track does not contain a source clip to add a pulldown refernce to.");
        }
        sourceClip.setComponentDataDefinition(essenceKind);
        sourceClip.setComponentLength(sourceReferenceLength);
        sourceClip.setSourceReference(reference);
        pulldown.setInputSegment(sourceClip);
    }

    @Override
    public void appendEdgecodeTrack(Rational editRate, int trackID, long startEC, long length, FilmType filmKind, EdgeType codeFormat, byte[] header) throws NullPointerException, IllegalArgumentException, BadLengthException, BadSizeException, FilmDescriptorOnlyException, TrackExistsException {
        if (editRate == null) {
            throw new NullPointerException("Cannot append an edgecode track to the tracks of a source package with a null edit rate value.");
        }
        if (trackID < 0) {
            throw new IllegalArgumentException("Cannot use a negative track id value when appending an edgecode value to the tracks of a source package.");
        }
        if (filmKind == null) {
            throw new NullPointerException("Cannot append an edgecode track to the tracks of a source package with a null film kind.");
        }
        if (codeFormat == null) {
            throw new NullPointerException("Cannot append an edgecode track to the tracks of a source package with a null code format value.");
        }
        if (!(this.essenceDescription instanceof FilmDescriptorImpl)) {
            throw new FilmDescriptorOnlyException("The appendEdgecodeTrack() method of source package is defined for film essence only.");
        }
        FillerImpl filler1 = null;
        FillerImpl filler2 = null;
        try {
            filler1 = new FillerImpl(DataDefinitionImpl.forIdentification(DataDefinitionImpl.Edgecode), 0L);
            filler2 = new FillerImpl(DataDefinitionImpl.forIdentification(DataDefinitionImpl.Edgecode), 0L);
        }
        catch (BadLengthException badLengthException) {
            // empty catch block
        }
        SequenceImpl sequence = new SequenceImpl(DataDefinitionImpl.forIdentification(DataDefinitionImpl.Edgecode));
        EdgeCodeValueImpl edgecodeValue = new EdgeCodeValueImpl(startEC, filmKind, codeFormat);
        if (header != null) {
            edgecodeValue.setEdgeCodeHeader(header);
        }
        EdgeCodeSegmentImpl edgecodeClip = new EdgeCodeSegmentImpl(length, edgecodeValue);
        try {
            sequence.appendComponentObject(filler1);
            sequence.appendComponentObject(edgecodeClip);
            sequence.appendComponentObject(filler2);
        }
        catch (InvalidDataDefinitionException invalidDataDefinitionException) {
        }
        catch (LeadingTransitionException leadingTransitionException) {
        }
        catch (EventSemanticsException eventSemanticsException) {
        }
        catch (BadPropertyException badPropertyException) {
        }
        catch (AdjacentTransitionException adjacentTransitionException) {
        }
        catch (InsufficientTransitionMaterialException insufficientTransitionMaterialException) {
            // empty catch block
        }
        this.appendNewTimelineTrack(editRate, sequence, trackID, null, 0L);
    }

    @Override
    public void appendPhysicalSourceReference(Rational editRate, int trackID, DataDefinition essenceKind, SourceReferenceValue reference, long sourceReferenceLength) throws NullPointerException, BadLengthException, InvalidDataDefinitionException, TrackExistsException {
        if (editRate == null) {
            throw new NullPointerException("Cannot append a new physical source reference to the tracks of this source package using a null edit rate.");
        }
        if (essenceKind == null) {
            throw new NullPointerException("Cannot append a new physical source reference to the tracks of this source package using a null essence kind.");
        }
        if (reference == null) {
            throw new NullPointerException("Cannot append a new physical source reference to the tracks of this source package using a null source reference value.");
        }
        if (trackID < 0) {
            throw new IllegalArgumentException("Cannot append a new physical source reference to the tracks of this source package using a negative track id.");
        }
        this.addPhysicalSourceReference(AppendOption.Append, editRate, trackID, essenceKind, reference, sourceReferenceLength);
    }

    @Override
    public void appendTimecodeTrack(Rational editRate, int trackID, TimecodeValue startTC, long length) throws NullPointerException, IllegalArgumentException, TapeDescriptorOnlyException, TrackExistsException {
        if (editRate == null) {
            throw new NullPointerException("Cannot set the edit rate of a new timecode track for a source package with a null value.");
        }
        if (startTC == null) {
            throw new NullPointerException("Cannot use a null value for the start time code of a new timecode track.");
        }
        if (!(this.essenceDescription instanceof TapeDescriptorImpl)) {
            throw new TapeDescriptorOnlyException("The appendTimecodeTrack() method in source package is defined for tape essence only.");
        }
        if (length == -1L) {
            length = new TimecodeValueImpl(startTC.getFramesPerSecond(), 24, 0, 0, 0, startTC.getDropFrame()).getStartTimecode();
        } else if (length < 0L) {
            throw new IllegalArgumentException("Cannot set a negative value for the length of a new timecode track for a source package.");
        }
        SequenceImpl sequence = new SequenceImpl(DataDefinitionImpl.forIdentification(DataDefinitionImpl.Timecode));
        try {
            TimecodeSegmentImpl timecode = new TimecodeSegmentImpl(length, startTC);
            sequence.appendComponentObject(timecode);
            try {
                Track track = this.lookupPackageTrack(trackID);
                track.setTrackSegment(sequence);
            }
            catch (TrackNotFoundException snfe) {
                this.appendNewTimelineTrack(editRate, sequence, trackID, null, 0L);
            }
        }
        catch (BadLengthException badLengthException) {
        }
        catch (LeadingTransitionException leadingTransitionException) {
        }
        catch (InvalidDataDefinitionException invalidDataDefinitionException) {
        }
        catch (EventSemanticsException eventSemanticsException) {
        }
        catch (BadPropertyException badPropertyException) {
        }
        catch (AdjacentTransitionException adjacentTransitionException) {
        }
        catch (InsufficientTransitionMaterialException insufficientTransitionMaterialException) {
            // empty catch block
        }
    }

    @Override
    public void newPhysicalSourceReference(Rational editRate, int trackID, DataDefinition essenceKind, SourceReferenceValue reference, long sourceReferenceLength) throws NullPointerException, BadLengthException, TrackExistsException {
        if (editRate == null) {
            throw new NullPointerException("Cannot insert a new physical source reference track into the list of tracks of this source package with a null edit rate.");
        }
        if (essenceKind == null) {
            throw new NullPointerException("Cannot insert a new physical source reference track into the list of tracks of this source package with a null essence kind.");
        }
        if (reference == null) {
            throw new NullPointerException("Cannot insert a new physical source reference track into the list of tracks of this source package with a null source reference.");
        }
        try {
            this.addPhysicalSourceReference(AppendOption.ForceOverwrite, editRate, trackID, essenceKind, reference, sourceReferenceLength);
        }
        catch (InvalidDataDefinitionException invalidDataDefinitionException) {
            // empty catch block
        }
    }

    @Override
    public void specifyValidCodeRange(DataDefinition essenceKind, int trackID, Rational editRate, long startOffset, long length) throws NullPointerException, BadLengthException, TrackExistsException {
        TimecodeClipImpl timecodeClip = this.findTimecodeClip(startOffset);
        TimecodeValue timecode = timecodeClip.result.getTimecode();
        if (length == -1L) {
            length = new TimecodeValueImpl(timecode.getFramesPerSecond(), 24, 0, 0, 0, timecode.getDropFrame()).getStartTimecode();
        }
        long position = startOffset;
        long endFillerLength = timecodeClip.timecodeTrackLength;
        endFillerLength -= position;
        endFillerLength -= length;
        SourceClipImpl sourceClip = new SourceClipImpl(essenceKind, length, new SourceReferenceValueImpl(PackageIDImpl.getZeroPackageID(), 0, 0L));
        Track track = null;
        try {
            track = this.lookupPackageTrack(trackID);
        }
        catch (TrackNotFoundException snfe) {
            try {
                SequenceImpl sequence = new SequenceImpl(essenceKind);
                FillerImpl filler1 = new FillerImpl(essenceKind, 0L);
                FillerImpl filler2 = new FillerImpl(essenceKind, 0L);
                sequence.appendComponentObject(filler1);
                sequence.appendComponentObject(sourceClip);
                sequence.appendComponentObject(filler2);
                this.appendNewTimelineTrack(editRate, sequence, trackID, null, 0L);
            }
            catch (BadLengthException sequence) {
            }
            catch (InvalidDataDefinitionException sequence) {
            }
            catch (LeadingTransitionException sequence) {
            }
            catch (EventSemanticsException sequence) {
            }
            catch (BadPropertyException sequence) {
            }
            catch (AdjacentTransitionException sequence) {
            }
            catch (InsufficientTransitionMaterialException sequence) {
                // empty catch block
            }
            return;
        }
        Segment segment = track.getTrackSegment();
        Sequence sequence = segment.generateSequence();
        List<? extends Component> segmentSequence = sequence.getComponentObjects();
        int numberOfSegments = segmentSequence.size();
        long sequencePosition = 0L;
        for (int sequenceLoop = 0; sequenceLoop < numberOfSegments; ++sequenceLoop) {
            Segment subSegment = (Segment)segmentSequence.get(sequenceLoop);
            long segmentLength = 0L;
            try {
                segmentLength = subSegment.getComponentLength();
            }
            catch (BadPropertyException badPropertyException) {
                // empty catch block
            }
            if (segmentLength == 0L) continue;
            long beginPosition = sequencePosition;
            long endPosition = sequencePosition + segmentLength;
            if (position < endPosition && beginPosition <= position && subSegment instanceof Filler && sequenceLoop == numberOfSegments - 1) {
                try {
                    long firstFillerLength = position;
                    endFillerLength = segmentLength;
                    endFillerLength -= length;
                    subSegment.setComponentLength(firstFillerLength);
                    long sequenceLength = sequence.getComponentLength();
                    sequenceLength -= segmentLength;
                    sequence.setComponentLength(sequenceLength += firstFillerLength);
                    FillerImpl filler2 = new FillerImpl(essenceKind, endFillerLength -= (firstFillerLength -= sequencePosition));
                    sequence.appendComponentObject(sourceClip);
                    sequence.appendComponentObject(filler2);
                }
                catch (BadPropertyException badPropertyException) {
                }
                catch (InvalidDataDefinitionException invalidDataDefinitionException) {
                }
                catch (LeadingTransitionException leadingTransitionException) {
                }
                catch (EventSemanticsException eventSemanticsException) {
                }
                catch (AdjacentTransitionException adjacentTransitionException) {
                }
                catch (InsufficientTransitionMaterialException insufficientTransitionMaterialException) {
                    // empty catch block
                }
            }
            sequencePosition += segmentLength;
        }
    }

    @Override
    public List<FindSourceInformation> searchSource(int trackID, long offset, PackageKind packageKind, CriteriaType mediaCriteria, OperationChoice operationChoice) throws NullPointerException, InvalidPackageTypeException, TraversalNotPossibleException {
        return null;
    }

    private TimecodeClipImpl findTimecodeClip(long position) throws IllegalArgumentException {
        int physical = -1;
        boolean found = false;
        Track track = null;
        for (Track trackItem : this.getPackageTracks()) {
            if (!trackItem.getDataDefinition().isTimecodeKind()) continue;
            try {
                physical = trackItem.getEssenceTrackNumber();
            }
            catch (PropertyNotPresentException pnpe) {
                throw new IllegalArgumentException("Physical track numbers must be present when searching for timecode clips in the tracks of a source package.");
            }
            if (physical != 0 && physical != 1) continue;
            found = true;
            track = trackItem;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("This source package is missing its primary timecode track.");
        }
        Segment segment = track.getTrackSegment();
        return SegmentImpl.offsetToTimecodeClip(segment, position);
    }

    @Override
    public SourcePackage clone() {
        return (SourcePackage)super.clone();
    }
}

