/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.enumeration.FadeType;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.PackageNotFoundException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.extensions.quantel.QSourceClip;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.Package;
import tv.amwa.maj.model.SourceClip;
import tv.amwa.maj.model.impl.SourceReferenceSegmentImpl;
import tv.amwa.maj.record.impl.PackageIDImpl;
import tv.amwa.maj.union.Fade;
import tv.amwa.maj.union.SourceReferenceValue;
import tv.amwa.maj.union.impl.FadeImpl;
import tv.amwa.maj.union.impl.SourceReferenceValueImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=4352, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="SourceClip", description="The SourceClip class represents the essence and identifies the source of the essence.", symbol="SourceClip")
public class SourceClipImpl
extends SourceReferenceSegmentImpl
implements SourceClip,
QSourceClip,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5642395327782333462L;
    private Long startPosition = null;
    private long fadeInLength = 0L;
    private FadeType fadeInType = FadeType.None;
    private boolean fadeInPresent = false;
    private long fadeOutLength = 0L;
    private FadeType fadeOutType = FadeType.None;
    private boolean fadeOutPresent = false;
    private Integer rushChannelMask = null;
    private Stream rushBlob = null;

    public SourceClipImpl() {
    }

    public SourceClipImpl(DataDefinition dataDefinition, long length, SourceReferenceValue sourceReference) throws NullPointerException, BadLengthException {
        if (dataDefinition == null) {
            throw new NullPointerException("Cannot create a new source clip with a null data definition.");
        }
        if (sourceReference == null) {
            throw new NullPointerException("Cannot create a new source clip with a null source reference.");
        }
        this.setComponentDataDefinition(dataDefinition);
        this.setLengthPresent(true);
        this.setComponentLength(length);
        this.setSourceReference(sourceReference);
    }

    @Override
    public SourceReferenceValue getSourceReference() {
        try {
            return new SourceReferenceValueImpl(this.getSourcePackageID(), this.getSourceTrackID(), this.startPosition);
        }
        catch (PropertyNotPresentException pnpe) {
            return SourceReferenceValueImpl.inContextReference(this.getSourceTrackID(), this.startPosition);
        }
    }

    @Override
    public void setSourceReference(SourceReferenceValue sourceReference) throws NullPointerException {
        if (sourceReference == null) {
            throw new NullPointerException("Cannot set the source reference of this clip with a null source reference value.");
        }
        try {
            this.setSourcePackageID(sourceReference.getSourcePackageID());
        }
        catch (PropertyNotPresentException e) {
            this.setSourcePackageID(null);
        }
        this.setSourceTrackID(sourceReference.getSourceTrackID());
        try {
            this.setStartPosition(sourceReference.getStartPosition());
        }
        catch (PropertyNotPresentException e) {
            this.setStartPosition(null);
        }
    }

    @Override
    public Package resolveRef() throws PackageNotFoundException {
        throw new PackageNotFoundException("The MAJ API does not currently provide a built-in package reference resolution facility.");
    }

    @Override
    @Deprecated
    public void setFade(long fadeInLength, FadeType fadeInType, long fadeOutLength, FadeType fadeOutType) throws BadLengthException {
        this.setFade(new FadeImpl(fadeInLength, fadeInType, fadeOutLength, fadeOutType));
    }

    @Override
    @Deprecated
    public FadeImpl getFade() {
        try {
            return new FadeImpl(this.fadeInLength, this.fadeInPresent ? this.fadeInType : null, this.fadeOutLength, this.fadeOutPresent ? this.fadeOutType : null);
        }
        catch (BadLengthException ble) {
            ble.printStackTrace();
            return null;
        }
    }

    @Override
    @Deprecated
    public void setFade(Fade fade) throws NullPointerException {
        if (fade == null) {
            throw new NullPointerException("Cannot set the fade value of this source clip using a null pointer.");
        }
        try {
            this.fadeInLength = fade.getFadeInLength();
            this.fadeInType = fade.getFadeInType();
            this.fadeInPresent = true;
        }
        catch (PropertyNotPresentException pnpe) {
            this.fadeInPresent = false;
        }
        try {
            this.fadeOutLength = fade.getFadeOutLength();
            this.fadeOutType = fade.getFadeOutType();
            this.fadeOutPresent = true;
        }
        catch (PropertyNotPresentException pnpe) {
            this.fadeOutPresent = false;
        }
    }

    @Override
    @MediaProperty(uuid1=117572097, uuid2=261, uuid3=512, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FadeInLength", typeName="LengthType", optional=true, uniqueIdentifier=false, pid=4610, symbol="FadeInLength")
    @Deprecated
    public long getFadeInLength() throws PropertyNotPresentException {
        if (!this.fadeInPresent) {
            throw new PropertyNotPresentException("The fade in property is not present in this source clip.");
        }
        return this.fadeInLength;
    }

    @Deprecated
    @MediaPropertySetter(value="FadeInLength")
    public void setFadeInLength(Long fadeInLength) {
        if (fadeInLength == null) {
            this.fadeInPresent = false;
            return;
        }
        this.fadeInLength = fadeInLength;
        if (this.fadeInType == null) {
            this.fadeInType = FadeType.None;
        }
        this.fadeInPresent = true;
    }

    @Override
    @MediaProperty(uuid1=87033089, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="FadeInType", typeName="FadeType", optional=true, uniqueIdentifier=false, pid=4611, symbol="FadeInType")
    @Deprecated
    public FadeType getFadeInType() throws PropertyNotPresentException {
        if (!this.fadeInPresent) {
            throw new PropertyNotPresentException("The fade in property is not present in this source clip.");
        }
        return this.fadeInType;
    }

    @Deprecated
    @MediaPropertySetter(value="FadeInType")
    public void setFadeInType(FadeType fadeInType) {
        if (fadeInType == null) {
            this.fadeInPresent = false;
            this.fadeInType = null;
            return;
        }
        this.fadeInType = fadeInType;
        this.fadeInPresent = true;
    }

    @Override
    @MediaProperty(uuid1=117572097, uuid2=261, uuid3=768, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FadeOutLength", typeName="LengthType", optional=true, uniqueIdentifier=false, pid=4612, symbol="FadeOutLength")
    @Deprecated
    public long getFadeOutLength() throws PropertyNotPresentException {
        if (!this.fadeOutPresent) {
            throw new PropertyNotPresentException("The fade out property is not present out this source clip.");
        }
        return this.fadeOutLength;
    }

    @Deprecated
    @MediaPropertySetter(value="FadeOutLength")
    public void setFadeOutLength(Long fadeOutLength) {
        if (fadeOutLength == null) {
            this.fadeOutPresent = false;
            return;
        }
        this.fadeOutLength = fadeOutLength;
        if (this.fadeOutType == null) {
            this.fadeOutType = FadeType.None;
        }
        this.fadeOutPresent = true;
    }

    @Override
    @MediaProperty(uuid1=87033090, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="FadeOutType", typeName="FadeType", optional=true, uniqueIdentifier=false, pid=4613, symbol="FadeOutType")
    @Deprecated
    public FadeType getFadeOutType() throws PropertyNotPresentException {
        if (!this.fadeOutPresent) {
            throw new PropertyNotPresentException("The fade out property is not present out this source clip.");
        }
        return this.fadeOutType;
    }

    @Deprecated
    @MediaPropertySetter(value="FadeOutType")
    public void setFadeOutType(FadeType fadeOutType) {
        if (fadeOutType == null) {
            this.fadeOutPresent = false;
            this.fadeOutType = null;
            return;
        }
        this.fadeOutType = fadeOutType;
        this.fadeOutPresent = true;
    }

    @Override
    @MediaProperty(uuid1=117571843, uuid2=260, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="StartPosition", aliases={"StartTime"}, typeName="PositionType", optional=true, uniqueIdentifier=false, pid=4609, symbol="StartPosition")
    public long getStartPosition() throws PropertyNotPresentException {
        if (this.startPosition == null) {
            throw new PropertyNotPresentException("The context-sensitive optional start time property is not present in this source clip.");
        }
        return this.startPosition;
    }

    @Override
    @MediaPropertySetter(value="StartPosition")
    public void setStartPosition(Long startPosition) {
        if (startPosition == null) {
            this.startPosition = null;
        }
        try {
            this.startPosition = this.getSourcePackageID().equals(PackageIDImpl.getZeroPackageID()) ? Long.valueOf(0L) : startPosition;
        }
        catch (PropertyNotPresentException pnpe) {
            this.startPosition = startPosition;
        }
    }

    @Override
    @MediaProperty(uuid1=296928023, uuid2=-30424, uuid3=18850, uuid4={-81, 101, 102, 97, 80, -44, 66, -93}, definedName="Rush channel mask", symbol="Rush_channel_mask", aliases={"Rush_channel_mask"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @UInt32
    public int getRushChannelMask() throws PropertyNotPresentException {
        if (this.rushChannelMask == null) {
            throw new PropertyNotPresentException("The optional rush channel mask property is not present for this Quantel source clip.");
        }
        return this.rushChannelMask;
    }

    @Override
    @MediaPropertySetter(value="Rush channel mask")
    public void setRushChannelMask(@UInt32 Integer rushChannelMask) throws IllegalArgumentException {
        if (rushChannelMask == null) {
            this.rushChannelMask = null;
            return;
        }
        if (rushChannelMask < 0) {
            throw new IllegalArgumentException("The rush channel mask property cannot be negative.");
        }
        this.rushChannelMask = rushChannelMask;
    }

    @Override
    @MediaProperty(uuid1=120384408, uuid2=6707, uuid3=16557, uuid4={-98, -25, 31, -128, -92, 124, 56, 103}, definedName="Rush blob", symbol="Rush_blob", aliases={"Rush_blob"}, typeName="Stream", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public Stream getRushBlob() throws PropertyNotPresentException {
        if (this.rushBlob == null) {
            throw new PropertyNotPresentException("The optional rush blob property is not present for this Quantel source clip.");
        }
        return this.rushBlob;
    }

    @Override
    @MediaPropertySetter(value="Rush blob")
    public void setRushBlob(Stream rushBlob) {
        this.rushBlob = rushBlob;
    }

    Package resolveReference() throws PackageNotFoundException {
        return null;
    }

    @Override
    public SourceClip clone() {
        return (SourceClip)super.clone();
    }
}

