/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import tv.amwa.maj.enumeration.LayoutType;
import tv.amwa.maj.enumeration.RGBAComponentKind;
import tv.amwa.maj.enumeration.ScanningDirectionType;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.misctype.DataValue;
import tv.amwa.maj.misctype.VideoLineMap;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.RGBADescriptor;
import tv.amwa.maj.model.impl.PictureDescriptorImpl;
import tv.amwa.maj.record.RGBAComponent;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.RGBAComponentImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=10496, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="RGBADescriptor", description="The RGBADescriptor class specifies that a File SourcePackage is associated with video essence formatted with three color component or with three color components and an alpha component as specified in this document.", symbol="RGBADescriptor")
public class RGBADescriptorImpl
extends PictureDescriptorImpl
implements RGBADescriptor,
Serializable,
Cloneable {
    private static final long serialVersionUID = 5533596704038036966L;
    private Integer alphaMaxRef = null;
    private Integer alphaMinRef = null;
    private Integer componentMaxRef = null;
    private Integer componentMinRef = null;
    private RGBAComponent[] pixelLayout;
    private byte[] palette = null;
    private RGBAComponent[] paletteLayout = null;
    private ScanningDirectionType scanningDirection = null;

    public RGBADescriptorImpl() {
    }

    public RGBADescriptorImpl(ContainerDefinition containerFormat, @UInt32 int storedHeight, @UInt32 int storedWidth, LayoutType frameLayout, @VideoLineMap int[] videoLineMap, Rational imageAspectRatio, RGBAComponent[] pixelLayout) throws NullPointerException, IllegalArgumentException {
        if (frameLayout == null) {
            throw new NullPointerException("Cannot create a new RGBA descriptor with a null frame layout value.");
        }
        if (videoLineMap == null) {
            throw new NullPointerException("Cannot create a new RGBA descriptor with a null video line map value.");
        }
        if (imageAspectRatio == null) {
            throw new NullPointerException("Cannot create a new RGBA descriptor with a null image aspect ration value.");
        }
        if (pixelLayout == null) {
            throw new NullPointerException("Cannot create a new RGBA descriptor with a null pixel layout descriptor.");
        }
        this.setContainerFormat(containerFormat);
        this.setStoredView(storedHeight, storedWidth);
        this.setFrameLayout(frameLayout);
        this.setVideoLineMap(videoLineMap);
        this.setImageAspectRatio(imageAspectRatio);
        if (RGBADescriptorImpl.paletteRequired(pixelLayout)) {
            throw new IllegalArgumentException("Cannot create a new RGBA descriptor requiring a palette without a palette and palette layout.");
        }
        this.setPixelLayout(pixelLayout);
    }

    public RGBADescriptorImpl(ContainerDefinition containerFormat, @UInt32 int storedHeight, @UInt32 int storedWidth, LayoutType frameLayout, @VideoLineMap int[] videoLineMap, Rational imageAspectRatio, RGBAComponent[] pixelLayout, @DataValue byte[] palette, RGBAComponent[] paletteLayout) throws NullPointerException, IllegalArgumentException {
        if (frameLayout == null) {
            throw new NullPointerException("Cannot create a new RGBA descriptor with a null frame layout value.");
        }
        if (videoLineMap == null) {
            throw new NullPointerException("Cannot create a new RGBA descriptor with a null video line map value.");
        }
        if (imageAspectRatio == null) {
            throw new NullPointerException("Cannot create a new RGBA descriptor with a null image aspect ration value.");
        }
        if (pixelLayout == null) {
            throw new NullPointerException("Cannot create a new RGBA descriptor with a null pixel layout descriptor.");
        }
        this.setContainerFormat(containerFormat);
        this.setStoredView(storedHeight, storedWidth);
        this.setFrameLayout(frameLayout);
        this.setVideoLineMap(videoLineMap);
        this.setImageAspectRatio(imageAspectRatio);
        this.setPalette(palette);
        this.setPaletteLayout(paletteLayout);
        this.setPixelLayout(pixelLayout);
    }

    @Override
    @MediaProperty(uuid1=67175683, uuid2=3328, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="AlphaMaxRef", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=13320, symbol="AlphaMaxRef")
    public int getAlphaMaxRef() {
        if (this.alphaMaxRef == null) {
            return 255;
        }
        return this.alphaMaxRef;
    }

    @Override
    @MediaPropertySetter(value="AlphaMaxRef")
    public void setAlphaMaxRef(Integer alphaMaxRef) throws IllegalArgumentException {
        if (alphaMaxRef == null) {
            this.alphaMaxRef = null;
            return;
        }
        if (alphaMaxRef < 0) {
            throw new IllegalArgumentException("Cannot set the alpha maximum reference level for this RGBA descriptor to a negative value");
        }
        this.alphaMaxRef = alphaMaxRef;
    }

    @Override
    @MediaProperty(uuid1=67175683, uuid2=3584, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="AlphaMinRef", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=13321, symbol="AlphaMinRef")
    public int getAlphaMinRef() {
        if (this.alphaMinRef == null) {
            return 0;
        }
        return this.alphaMinRef;
    }

    @Override
    @MediaPropertySetter(value="AlphaMinRef")
    public void setAlphaMinRef(Integer alphaMinRef) throws IllegalArgumentException {
        if (alphaMinRef == null) {
            this.alphaMinRef = null;
            return;
        }
        if (alphaMinRef < 0) {
            throw new IllegalArgumentException("Cannot set the alpha minimum reference level for this RGBA descriptor to a negative value.");
        }
        this.alphaMinRef = alphaMinRef;
    }

    @Override
    @MediaProperty(uuid1=67175683, uuid2=2816, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="ComponentMaxRef", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=13318, symbol="ComponentMaxRef")
    public int getComponentMaxRef() {
        if (this.componentMaxRef == null) {
            return 255;
        }
        return this.componentMaxRef;
    }

    @Override
    @MediaPropertySetter(value="ComponentMaxRef")
    public void setComponentMaxRef(Integer componentMaxRef) throws IllegalArgumentException {
        if (componentMaxRef == null) {
            this.componentMaxRef = null;
            return;
        }
        if (componentMaxRef < 0) {
            throw new IllegalArgumentException("Cannot set the component minimum refererence level for this RGBA descriptor using a negative value.");
        }
        this.componentMaxRef = componentMaxRef;
    }

    @Override
    @MediaProperty(uuid1=67175683, uuid2=3072, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="ComponentMinRef", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=13319, symbol="ComponentMinRef")
    public int getComponentMinRef() {
        if (this.componentMinRef == null) {
            return 0;
        }
        return this.componentMinRef;
    }

    @Override
    @MediaPropertySetter(value="ComponentMinRef")
    public void setComponentMinRef(Integer componentMinRef) throws IllegalArgumentException {
        if (componentMinRef == null) {
            this.componentMinRef = null;
            return;
        }
        if (componentMinRef < 0) {
            throw new IllegalArgumentException("Cannot set the component minimum reference level for thie RGBA descriptor using a negative value.");
        }
        this.componentMinRef = componentMinRef;
    }

    @Override
    @MediaProperty(uuid1=67175683, uuid2=2048, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Palette", typeName="DataValue", optional=true, uniqueIdentifier=false, pid=13315, symbol="Palette")
    public byte[] getPalette() throws PropertyNotPresentException {
        if (this.palette == null) {
            throw new PropertyNotPresentException("The optional pallette property is not present for this RGBA descriptor.");
        }
        return (byte[])this.palette.clone();
    }

    @Override
    public void setPalette(byte[] palette) throws IllegalArgumentException {
        if (palette == null && RGBADescriptorImpl.paletteRequired(this.pixelLayout)) {
            throw new IllegalArgumentException("Cannot unset the palette for an RGBA descriptor which requires palette values.");
        }
        if (palette == null) {
            this.palette = null;
            return;
        }
        this.palette = (byte[])palette.clone();
    }

    @MediaPropertySetter(value="Palette")
    public void setPaletteFromStream(ByteBuffer palette) {
        if (palette == null) {
            this.palette = null;
            return;
        }
        this.palette = new byte[palette.limit()];
        palette.rewind();
        palette.get(this.palette);
    }

    @MediaPropertyClear(value="Palette")
    public void omitPalette() throws IllegalArgumentException {
        if (RGBADescriptorImpl.paletteRequired(this.pixelLayout)) {
            throw new IllegalArgumentException("Cannot unset the palette for an RGBA descriptor which requires palette values.");
        }
        this.palette = null;
    }

    @Override
    public int countPaletteLayoutElements() {
        return RGBADescriptorImpl.countLayoutElements(this.paletteLayout);
    }

    public int getPaletteSize() {
        return this.palette.length;
    }

    @Override
    @MediaProperty(uuid1=67175683, uuid2=2304, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PaletteLayout", typeName="RGBALayout", optional=true, uniqueIdentifier=false, pid=13316, symbol="PaletteLayout")
    public RGBAComponent[] getPaletteLayout() throws PropertyNotPresentException {
        if (this.paletteLayout == null) {
            throw new PropertyNotPresentException("The optional palette layout property is not present for this RGBA descriptor.");
        }
        return this.paletteLayout;
    }

    @Override
    public void setPaletteLayout(RGBAComponent[] paletteLayoutArray) throws IllegalArgumentException {
        if (paletteLayoutArray == null && RGBADescriptorImpl.paletteRequired(this.pixelLayout)) {
            throw new IllegalArgumentException("Cannot remove the palette layout for a RGBA descriptor that requires palette values.");
        }
        if (RGBADescriptorImpl.paletteRequired(paletteLayoutArray)) {
            throw new IllegalArgumentException("Cannot set a pallette layout for an RGBA descriptor with components that reference palette.");
        }
        if (paletteLayoutArray == null) {
            this.paletteLayout = null;
            return;
        }
        this.paletteLayout = new RGBAComponent[paletteLayoutArray.length];
        for (int x = 0; x < this.paletteLayout.length; ++x) {
            if (paletteLayoutArray[x] == null) continue;
            this.paletteLayout[x] = paletteLayoutArray[x].clone();
        }
    }

    @MediaPropertySetter(value="PaletteLayout")
    public void setPaletteLayoutFromStream(Object[] paletteLayoutArray) {
        if (paletteLayoutArray == null) {
            this.paletteLayout = null;
            return;
        }
        this.paletteLayout = new RGBAComponentImpl[paletteLayoutArray.length];
        for (int x = 0; x < this.paletteLayout.length; ++x) {
            if (paletteLayoutArray[x] == null) continue;
            this.paletteLayout[x] = ((RGBAComponent)paletteLayoutArray[x]).clone();
        }
    }

    @Override
    @MediaProperty(uuid1=67175683, uuid2=1536, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PixelLayout", typeName="RGBALayout", optional=false, uniqueIdentifier=false, pid=13313, symbol="PixelLayout")
    public RGBAComponent[] getPixelLayout() {
        return (RGBAComponent[])this.pixelLayout.clone();
    }

    @Override
    public void setPixelLayout(RGBAComponent[] pixelLayoutArray) throws NullPointerException, IllegalArgumentException {
        if (pixelLayoutArray == null) {
            throw new NullPointerException("Cannot set the pixel layout of this RGBA descriptor with a null value.");
        }
        if (!RGBADescriptorImpl.validatePixelLayout(pixelLayoutArray)) {
            throw new IllegalArgumentException("The given pixel array is not valid as it contains a mix of palette and RGB data.");
        }
        if (RGBADescriptorImpl.paletteRequired(pixelLayoutArray) && (this.palette == null || this.paletteLayout == null)) {
            throw new IllegalArgumentException("Palette and palette layout properties must be set for pixel layouts containing palette entries.");
        }
        this.pixelLayout = new RGBAComponent[pixelLayoutArray.length];
        for (int x = 0; x < this.pixelLayout.length; ++x) {
            if (pixelLayoutArray[x] == null) continue;
            this.pixelLayout[x] = pixelLayoutArray[x].clone();
        }
    }

    @MediaPropertySetter(value="PixelLayout")
    public void setPixelLayoutFromStream(Object[] pixelLayoutArray) throws NullPointerException, IllegalArgumentException, ClassCastException {
        if (pixelLayoutArray == null) {
            throw new NullPointerException("Cannot set the pixel layout of this RGBA descriptor with a null value.");
        }
        this.pixelLayout = new RGBAComponent[pixelLayoutArray.length];
        for (int x = 0; x < this.pixelLayout.length; ++x) {
            if (pixelLayoutArray[x] == null) continue;
            this.pixelLayout[x] = ((RGBAComponent)pixelLayoutArray[x]).clone();
        }
        if (!RGBADescriptorImpl.validatePixelLayout(this.pixelLayout)) {
            throw new IllegalArgumentException("The given pixel array is not valid as it contains a mix of palette and RGB data.");
        }
    }

    public static final RGBAComponent[] initializePixelLayout() {
        RGBAComponent[] initialElements = new RGBAComponent[8];
        for (int x = 0; x < 8; ++x) {
            initialElements[x] = new RGBAComponentImpl(RGBAComponentKind.Null, 0);
        }
        return initialElements;
    }

    @Override
    public int countPixelLayoutElements() {
        return RGBADescriptorImpl.countLayoutElements(this.pixelLayout);
    }

    @Override
    @MediaProperty(uuid1=0x4010404, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="ScanningDirection", typeName="ScanningDirectionType", optional=true, uniqueIdentifier=false, pid=13317, symbol="ScanningDirection")
    public ScanningDirectionType getScanningDirection() {
        if (this.scanningDirection == null) {
            return SCANNINGDIRECTION_DEFAULT;
        }
        return this.scanningDirection;
    }

    @Override
    @MediaPropertySetter(value="ScanningDirection")
    public void setScanningDirection(ScanningDirectionType scanningDirection) {
        this.scanningDirection = scanningDirection == null ? ScanningDirectionType.LeftToRightTopToBottom : scanningDirection;
    }

    private static boolean paletteRequired(RGBAComponent[] pixelLayout) {
        if (pixelLayout == null) {
            return false;
        }
        for (RGBAComponent component : pixelLayout) {
            if (component.getCode() != RGBAComponentKind.Palette) continue;
            return true;
        }
        return false;
    }

    private static boolean validatePixelLayout(RGBAComponent[] pixelLayout) {
        if (pixelLayout == null) {
            return false;
        }
        boolean paletteFound = false;
        boolean rgbFound = false;
        block4: for (int x = 0; x < pixelLayout.length; ++x) {
            switch (pixelLayout[x].getCode()) {
                case Palette: {
                    paletteFound = true;
                    if (!rgbFound) continue block4;
                    return false;
                }
                case Red: 
                case Green: 
                case Blue: {
                    rgbFound = true;
                    if (!paletteFound) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    private static int countLayoutElements(RGBAComponent[] layout) {
        int componentCount = 0;
        block3: for (RGBAComponent component : layout) {
            switch (component.getCode()) {
                case None: 
                case Fill: 
                case Null: {
                    continue block3;
                }
                default: {
                    ++componentCount;
                }
            }
        }
        return componentCount;
    }

    @Override
    public RGBADescriptor clone() {
        return (RGBADescriptor)super.clone();
    }

    public List<String> getPixelLayoutStringList() {
        return RGBADescriptorImpl.layoutToList(this.pixelLayout);
    }

    public void setPixelLayoutStringList(List<String> pixelLayout) {
        this.pixelLayout = RGBADescriptorImpl.layoutFromList(pixelLayout);
    }

    public List<String> getPaletteLayoutStringList() {
        return RGBADescriptorImpl.layoutToList(this.paletteLayout);
    }

    public void setPaletteLayoutStringList(List<String> paletteLayout) {
        this.paletteLayout = RGBADescriptorImpl.layoutFromList(paletteLayout);
    }

    private static final List<String> layoutToList(RGBAComponent[] layout) {
        if (layout == null) {
            return null;
        }
        ArrayList<String> layoutList = new ArrayList<String>(layout.length);
        for (int x = 0; x < layout.length; ++x) {
            layoutList.add(RGBAComponentImpl.toPersistentForm(layout[x]));
        }
        return layoutList;
    }

    private static final RGBAComponent[] layoutFromList(List<String> layoutList) {
        if (layoutList == null) {
            return null;
        }
        RGBAComponent[] layout = new RGBAComponent[layoutList.size()];
        for (int x = 0; x < layout.length; ++x) {
            layout[x] = RGBAComponentImpl.fromPersistentForm(layoutList.get(x));
        }
        return layout;
    }
}

