/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.enumeration.PulldownDirectionType;
import tv.amwa.maj.enumeration.PulldownKindType;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.exception.TimecodeNotFoundException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.misctype.PhaseFrameType;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.Pulldown;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.SourceClip;
import tv.amwa.maj.model.TimecodeSegment;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.SegmentImpl;
import tv.amwa.maj.model.impl.SourceClipImpl;
import tv.amwa.maj.model.impl.TimecodeSegmentImpl;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.TimecodeValue;
import tv.amwa.maj.union.impl.SourceReferenceValueImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=3072, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="Pulldown", description="The Pulldown class converts between film frame rates and videotape frame rates.", symbol="Pulldown")
public class PulldownImpl
extends SegmentImpl
implements Pulldown,
Serializable,
Cloneable {
    private static final long serialVersionUID = 4587590050086371546L;
    private Segment inputSegment;
    private PulldownKindType pulldownKind;
    private PulldownDirectionType pulldownDirection;
    private int phaseFrame;

    public PulldownImpl() {
    }

    public PulldownImpl(DataDefinition dataDefinition, Segment inputSegment, PulldownKindType pulldownKind, PulldownDirectionType pulldownDirection, @PhaseFrameType int phaseFrame) throws NullPointerException {
        if (dataDefinition == null) {
            throw new NullPointerException("Cannot create a new pulldown segment with a null data definition.");
        }
        if (inputSegment == null) {
            throw new NullPointerException("Cannot create a new pulldown segment with a null input segment value.");
        }
        if (pulldownKind == null) {
            throw new NullPointerException("Cannot create a new pulldown segment with a null pulldown kind value.");
        }
        if (pulldownDirection == null) {
            throw new NullPointerException("Cannot create a new pulldown segment with a null pulldown direction value.");
        }
        this.setComponentDataDefinition(dataDefinition);
        this.setInputSegment(inputSegment);
        this.setPulldownKind(pulldownKind);
        this.setPulldownDirection(pulldownDirection);
        this.setPhaseFrame(phaseFrame);
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=519, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="InputSegment", typeName="SegmentStrongReference", optional=false, uniqueIdentifier=false, pid=3329, symbol="InputSegment")
    public Segment getInputSegment() {
        return this.inputSegment;
    }

    @Override
    @MediaPropertySetter(value="InputSegment")
    public void setInputSegment(Segment inputSegment) throws NullPointerException, IllegalArgumentException {
        if (inputSegment == null) {
            throw new NullPointerException("Cannot set the input segment of this pulldown using a null segment value.");
        }
        if (!(inputSegment instanceof SourceClip) && !(inputSegment instanceof TimecodeSegment)) {
            throw new IllegalArgumentException("The input segment must for a pulldown operation must be either a source clip or a timecode.");
        }
        this.inputSegment = inputSegment;
    }

    @Override
    @MediaProperty(uuid1=88084481, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PhaseFrame", typeName="PhaseFrameType", optional=false, uniqueIdentifier=false, pid=3332, symbol="PhaseFrame")
    public int getPhaseFrame() {
        return this.phaseFrame;
    }

    public static final Segment initializeInputSegment() {
        return new SourceClipImpl(DataDefinitionImpl.forName("Unknown"), 0L, SourceReferenceValueImpl.originalSource());
    }

    @Override
    @MediaPropertySetter(value="PhaseFrame")
    public void setPhaseFrame(int phaseFrame) {
        this.phaseFrame = phaseFrame;
    }

    public static final int initializePhaseFrame() {
        return 0;
    }

    @Override
    @MediaProperty(uuid1=88084481, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PulldownDirection", typeName="PulldownDirectionType", optional=false, uniqueIdentifier=false, pid=3331, symbol="PulldownDirection")
    public PulldownDirectionType getPulldownDirection() {
        return this.pulldownDirection;
    }

    @Override
    @MediaPropertySetter(value="PulldownDirection")
    public void setPulldownDirection(PulldownDirectionType pulldownDirection) throws NullPointerException {
        if (pulldownDirection == null) {
            throw new NullPointerException("Cannot set the pulldown direction for this pulldown segment to null.");
        }
        this.pulldownDirection = pulldownDirection;
    }

    public static final PulldownDirectionType initializePulldownDirection() {
        return PulldownDirectionType.FilmToTapeSpeed;
    }

    @Override
    @MediaProperty(uuid1=88084481, uuid2=512, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PulldownKind", typeName="PulldownKindType", optional=false, uniqueIdentifier=false, pid=3330, symbol="PulldownKind")
    public PulldownKindType getPulldownKind() {
        return this.pulldownKind;
    }

    @Override
    @MediaPropertySetter(value="PulldownKind")
    public void setPulldownKind(PulldownKindType pulldownKind) throws NullPointerException {
        if (pulldownKind == null) {
            throw new NullPointerException("Cannot set the pulldown kind for this pulldown segment to null.");
        }
        this.pulldownKind = pulldownKind;
    }

    public static final PulldownKindType initializePulldownKind() {
        return PulldownKindType.OneToOnePAL;
    }

    @Override
    public Pulldown clone() {
        return (Pulldown)super.clone();
    }

    @Override
    public TimecodeValue segmentOffsetToTC(long offset) throws TimecodeNotFoundException {
        return this.internalSegmentOffsetToTC(offset);
    }

    @Override
    public long segmentTCToOffset(TimecodeValue timecode, Rational editrate) throws NullPointerException, TimecodeNotFoundException {
        if (timecode == null) {
            throw new NullPointerException("Cannot compute offset from a null timecode value.");
        }
        if (!(this.inputSegment instanceof TimecodeSegmentImpl)) {
            throw new TimecodeNotFoundException("The input segment of this pulldown segment is not a timecode segment.");
        }
        TimecodeSegment timecodeSegment = (TimecodeSegment)this.inputSegment;
        TimecodeValue startTimecode = timecodeSegment.getTimecode();
        long segmentLength = 0L;
        try {
            segmentLength = timecodeSegment.getComponentLength();
        }
        catch (BadPropertyException bpe) {
            throw new NullPointerException("Cannot get the length of the input segment of this pulldown segment.");
        }
        long offset = timecode.getStartTimecode() - startTimecode.getStartTimecode();
        if (offset < 0L || offset >= segmentLength) {
            throw new TimecodeNotFoundException("Calculated offset is out of range.");
        }
        Offset mapOffset = PulldownImpl.mapOffset(this, offset, true);
        return mapOffset.numFrames;
    }

    static Offset mapOffset(Pulldown pulldown, long offset, boolean reverse) {
        Offset mapOffset = new Offset();
        int phaseOffset = pulldown.getPhaseFrame();
        boolean drop = pulldown.getPulldownDirection() == PulldownDirectionType.TapeToFilmSpeed;
        PulldownMask pulldownMask = PulldownImpl.getPulldownMask(pulldown.getPulldownKind());
        if (pulldownMask.isOneToOne) {
            mapOffset.numFrames = offset;
        } else {
            if (reverse) {
                drop = !drop;
            }
            int zeroPos = 0;
            int sign = 0;
            sign = offset < (long)zeroPos ? -1 : 1;
            int maskones = PulldownImpl.maskGetBits(pulldownMask.mask);
            int ones = 0;
            int tmpOnes = 0;
            if (drop) {
                int remainder;
                int revolutions = (int)Math.abs(offset) / pulldownMask.length;
                mapOffset.srcPhase = remainder = (int)(offset % (long)pulldownMask.length);
                ones = revolutions * maskones;
                tmpOnes = PulldownImpl.getRemFramesDrop(pulldownMask.mask, remainder, phaseOffset, pulldownMask.length);
                ones += tmpOnes;
                mapOffset.numFrames = ones *= sign;
            } else if (pulldownMask.mask != 0) {
                int remainder;
                int revolutions = (int)Math.abs(offset) / maskones;
                mapOffset.srcPhase = remainder = (int)(offset % (long)maskones);
                int full = revolutions * pulldownMask.length;
                tmpOnes = PulldownImpl.getRemFramesDouble(pulldownMask.mask, remainder, phaseOffset, pulldownMask.length);
                full += tmpOnes;
                mapOffset.numFrames = full *= sign;
            }
        }
        return mapOffset;
    }

    private static int getRemFramesDrop(int maskBits, int ones, int phase, int masksize) {
        int remMask = maskBits;
        for (int phaseCounter = 0; phaseCounter < phase; ++phaseCounter) {
            remMask <<= 1;
        }
        int remFramesDrop = 0;
        int maskBitsLeft = masksize;
        while (ones > 0) {
            if (maskBitsLeft == 0) {
                remMask = maskBits;
                maskBitsLeft = masksize;
            }
            if (remMask < 0) {
                ++remFramesDrop;
            }
            --ones;
            remMask <<= 1;
            --maskBitsLeft;
        }
        return remFramesDrop;
    }

    private static int getRemFramesDouble(int maskBits, int ones, int phase, int masksize) {
        int remMask = maskBits;
        for (int phaseCounter = 0; phaseCounter < phase; ++phaseCounter) {
            remMask <<= 1;
        }
        int remFramesDouble = 0;
        int phaseCount = phase;
        int maskBitsLeft = masksize;
        while (ones > 0) {
            if (maskBitsLeft == 0) {
                remMask = maskBits;
                phaseCount = 0;
                maskBitsLeft = masksize;
            }
            ++remFramesDouble;
            if (remMask < 0) {
                --ones;
            }
            ++phaseCount;
            remMask <<= 1;
            --maskBitsLeft;
        }
        return remFramesDouble;
    }

    private static int maskGetBits(int maskBits) {
        int ones = 0;
        while (maskBits > 0) {
            if (maskBits < 0) {
                ++ones;
            }
            maskBits <<= 1;
        }
        return ones;
    }

    private static PulldownMask getPulldownMask(PulldownKindType pulldown) {
        PulldownMask mask = new PulldownMask();
        switch (pulldown) {
            case TwoThreePD: {
                mask.mask = -671088640;
                mask.length = 5;
                mask.isOneToOne = false;
                break;
            }
            case PALPD: {
                mask.mask = -524416;
                mask.length = 25;
                mask.isOneToOne = false;
                break;
            }
            case OneToOneNTSC: 
            case OneToOnePAL: {
                mask.isOneToOne = true;
                break;
            }
        }
        return mask;
    }

    private TimecodeValue internalSegmentOffsetToTC(long offset) throws TimecodeNotFoundException {
        if (!(this.inputSegment instanceof TimecodeSegmentImpl)) {
            throw new TimecodeNotFoundException("Cannot compute offset as a timecode value cannot be found.");
        }
        TimecodeValue timecode = ((TimecodeSegmentImpl)this.inputSegment).getTimecode().clone();
        Offset offsetDetails = PulldownImpl.mapOffset(this, offset, false);
        timecode.setStartTimecode(timecode.getStartTimecode() + offsetDetails.numFrames);
        return timecode;
    }

    static class Offset {
        long numFrames;
        int srcPhase;

        Offset() {
        }
    }

    static class PulldownMask {
        int mask = 0;
        int length = 0;
        boolean isOneToOne = false;

        PulldownMask() {
        }
    }
}

