/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import tv.amwa.maj.enumeration.AlphaTransparencyType;
import tv.amwa.maj.enumeration.FieldNumber;
import tv.amwa.maj.enumeration.LayoutType;
import tv.amwa.maj.enumeration.SignalStandardType;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.integer.UInt16;
import tv.amwa.maj.model.PictureDescriptor;
import tv.amwa.maj.model.impl.AAFFileDescriptorImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.record.impl.RationalImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=9984, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="PictureDescriptor", aliases={"DigitalImageDescriptor"}, description="The DigitalImageDescriptor class specifies that a File SourcePackage is associated with video essence that is formatted either using RGBA or luminance/chrominance formatting.", symbol="PictureDescriptor", isConcrete=false)
public class PictureDescriptorImpl
extends AAFFileDescriptorImpl
implements PictureDescriptor,
tv.amwa.maj.extensions.avid.PictureDescriptor,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5920151389391521249L;
    private AUID pictureCompression = null;
    private int storedWidth;
    private int storedHeight;
    private Integer storedF2Offset = null;
    private int sampledHeight = 0;
    private int sampledWidth = 0;
    private int sampledXOffset = 0;
    private int sampledYOffset = 0;
    private boolean sampledValuesPresent = false;
    private int displayHeight = 0;
    private int displayWidth = 0;
    private int displayXOffset = 0;
    private int displayYOffset = 0;
    private boolean displayValuesPresent = false;
    private Integer displayF2Offset = null;
    private Byte activeFormatDescriptor = null;
    private AlphaTransparencyType alphaTransparency = null;
    private AUID codingEquations = null;
    private AUID colorPrimaries = null;
    private FieldNumber fieldDominance = null;
    private Integer imageStartOffset = null;
    private Integer imageEndOffset = null;
    private LayoutType frameLayout;
    private Integer imageAlignmentFactor = null;
    private Rational imageAspectRatio;
    private SignalStandardType signalStandard = null;
    private AUID transferCharacteristic = null;
    private int[] videoLineMap;
    @Int32
    private Integer dataOffset = null;
    @UInt16
    private Short frameIndexByteOrder = null;
    @Int32
    private Integer frameSampleSize = null;
    @Int32
    private Integer imageSize = null;
    @Int32
    private Integer resolutionID = null;

    @Override
    @MediaProperty(uuid1=67175170, uuid2=2304, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="ActiveFormatDescriptor", typeName="UInt8", optional=true, uniqueIdentifier=false, pid=12824, symbol="ActiveFormatDescriptor")
    public byte getActiveFormatDescriptor() throws PropertyNotPresentException {
        if (this.activeFormatDescriptor == null) {
            throw new PropertyNotPresentException("The optional active format descriptor is not present in this picture descriptor.");
        }
        return this.activeFormatDescriptor;
    }

    @Override
    @MediaPropertySetter(value="ActiveFormatDescriptor")
    public void setActiveFormatDescriptor(Byte activeFormatDescriptor) throws IllegalArgumentException {
        if (activeFormatDescriptor == null) {
            this.activeFormatDescriptor = null;
            return;
        }
        if (activeFormatDescriptor < 0 || activeFormatDescriptor > 15) {
            throw new IllegalArgumentException("The active format descriptor is a 4-bit value and so cannot lie outside the range 0 to 15.");
        }
        this.activeFormatDescriptor = activeFormatDescriptor;
    }

    @Override
    @MediaProperty(uuid1=85983490, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="AlphaTransparency", typeName="AlphaTransparencyType", optional=true, uniqueIdentifier=false, pid=12815, symbol="AlphaTransparency")
    public AlphaTransparencyType getAlphaTransparency() {
        if (this.alphaTransparency == null) {
            return ALPHATRANSPARENCY_DEFAULT;
        }
        return this.alphaTransparency;
    }

    @Override
    @MediaPropertySetter(value="AlphaTransparency")
    public void setAlphaTransparency(AlphaTransparencyType alphaTransparency) {
        this.alphaTransparency = alphaTransparency;
    }

    @Override
    @MediaProperty(uuid1=67174913, uuid2=259, uuid3=256, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="CodingEquations", typeName="CodingEquationsType", optional=true, uniqueIdentifier=false, pid=12826, symbol="CodingEquations")
    public AUID getCodingEquations() throws PropertyNotPresentException {
        if (this.codingEquations == null) {
            throw new PropertyNotPresentException("The optional coding equations property is not present in this RGBA descriptor.");
        }
        return this.codingEquations.clone();
    }

    @Override
    @MediaPropertySetter(value="CodingEquations")
    public void setCodingEquations(AUID codingEquations) {
        this.codingEquations = codingEquations == null ? null : codingEquations.clone();
    }

    @Override
    @MediaProperty(uuid1=67174913, uuid2=262, uuid3=256, uuid4={6, 14, 43, 52, 1, 1, 1, 9}, definedName="ColorPrimaries", typeName="ColorPrimariesType", optional=true, uniqueIdentifier=false, pid=12825, symbol="ColorPrimaries")
    public AUID getColorPrimaries() throws PropertyNotPresentException {
        if (this.colorPrimaries == null) {
            throw new PropertyNotPresentException("The optional color primaries type is not present in this picture descriptor.");
        }
        return this.colorPrimaries.clone();
    }

    @Override
    @MediaPropertySetter(value="ColorPrimaries")
    public void setColorPrimaries(AUID colorPrimaries) {
        this.colorPrimaries = colorPrimaries == null ? null : colorPrimaries.clone();
    }

    @Override
    @MediaProperty(uuid1=67175937, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PictureCompression", aliases={"Compression", "DigitalImageDescriptorCompression", "PictureEssenceCoding"}, typeName="AUID", optional=true, uniqueIdentifier=false, pid=12801, symbol="PictureCompression")
    public AUID getPictureCompression() throws PropertyNotPresentException {
        if (this.pictureCompression == null) {
            throw new PropertyNotPresentException("The optional compression property is not present in this picture descriptor.");
        }
        return this.pictureCompression.clone();
    }

    @Override
    @MediaPropertySetter(value="PictureCompression")
    public void setPictureCompression(AUID pictureCompression) {
        this.pictureCompression = pictureCompression == null ? null : pictureCompression.clone();
    }

    @Override
    @MediaProperty(uuid1=67175170, uuid2=1792, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="DisplayF2Offset", typeName="Int32", optional=true, uniqueIdentifier=false, pid=12823, symbol="DisplayF2Offset")
    public int getDisplayF2Offset() {
        if (this.displayF2Offset == null) {
            return 0;
        }
        return this.displayF2Offset;
    }

    @Override
    @MediaPropertySetter(value="DisplayF2Offset")
    public void setDisplayF2Offset(Integer displayF2Offset) throws IllegalArgumentException {
        if (displayF2Offset == null) {
            this.displayF2Offset = null;
            return;
        }
        if (displayF2Offset != 0 && displayF2Offset != 1) {
            throw new IllegalArgumentException("The given display field 2 offset is not one of the valid values of 0 and 1.");
        }
        this.displayF2Offset = displayF2Offset;
    }

    @Override
    public int[] getDisplayView() {
        if (!this.displayValuesPresent) {
            return new int[]{this.storedHeight, this.storedWidth, 0, 0};
        }
        return new int[]{this.displayHeight, this.displayWidth, this.displayXOffset, this.displayYOffset};
    }

    @Override
    public void setDisplayView(int displayHeight, int displayWidth, int displayXOffset, int displayYOffset) throws IllegalPropertyValueException {
        if (displayXOffset < 0 || displayXOffset >= this.storedWidth) {
            throw new IllegalPropertyValueException("The given display x offset is outside the acceptable range for the stored width of this picture descriptor.");
        }
        if (displayYOffset < 0 || displayYOffset >= this.storedHeight) {
            throw new IllegalPropertyValueException("The given display y offset is outside the acceptable range for the stored height of this picture descriptor.");
        }
        if (displayHeight < 0 || displayHeight > this.storedHeight - displayYOffset) {
            throw new IllegalPropertyValueException("The given display height is outside the available range for the given offsets.");
        }
        if (displayWidth < 0 || displayWidth > this.storedWidth - displayXOffset) {
            throw new IllegalPropertyValueException("The given display width is outside the available range for the given offsets.");
        }
        this.displayHeight = displayHeight;
        this.displayWidth = displayWidth;
        this.displayXOffset = displayXOffset;
        this.displayYOffset = displayYOffset;
        this.displayValuesPresent = true;
    }

    @Override
    @MediaProperty(uuid1=67175681, uuid2=2816, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="DisplayHeight", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=12808, symbol="DisplayHeight")
    public int getDisplayHeight() {
        if (!this.displayValuesPresent) {
            return this.storedHeight;
        }
        return this.displayHeight;
    }

    @MediaPropertySetter(value="DisplayHeight")
    public void setDisplayHeight(int displayHeight) throws IllegalArgumentException {
        if (displayHeight < 0) {
            throw new IllegalArgumentException("The display height of a picture descriptor cannot be negative.");
        }
        this.displayHeight = displayHeight;
        this.displayValuesPresent = true;
    }

    @Override
    @MediaProperty(uuid1=67175681, uuid2=3072, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="DisplayWidth", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=12809, symbol="DisplayWidth")
    public int getDisplayWidth() {
        if (!this.displayValuesPresent) {
            return this.storedWidth;
        }
        return this.displayWidth;
    }

    @MediaPropertySetter(value="DisplayWidth")
    public void setDisplayWidth(int displayWidth) throws IllegalArgumentException {
        if (displayWidth < 0) {
            throw new IllegalArgumentException("Cannot set the display width of this picture descriptor to a negative value.");
        }
        this.displayWidth = displayWidth;
        this.displayValuesPresent = true;
    }

    @Override
    @MediaProperty(uuid1=67175681, uuid2=3328, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="DisplayXOffset", typeName="Int32", optional=true, uniqueIdentifier=false, pid=12810, symbol="DisplayXOffset")
    public int getDisplayXOffset() {
        if (!this.displayValuesPresent) {
            return 0;
        }
        return this.displayXOffset;
    }

    @MediaPropertySetter(value="DisplayXOffset")
    public void setDisplayXOffset(int displayXOffset) {
        this.displayXOffset = displayXOffset;
        this.displayValuesPresent = true;
    }

    @Override
    @MediaProperty(uuid1=67175681, uuid2=3584, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="DisplayYOffset", typeName="Int32", optional=true, uniqueIdentifier=false, pid=12811, symbol="DisplayYOffset")
    public int getDisplayYOffset() {
        if (!this.displayValuesPresent) {
            return 0;
        }
        return this.displayYOffset;
    }

    @MediaPropertySetter(value="DisplayYOffset")
    public void setDisplayYOffset(int displayYOffset) {
        this.displayYOffset = displayYOffset;
        this.displayValuesPresent = true;
    }

    @Override
    public boolean areDisplayValuesPresent() {
        return this.displayValuesPresent;
    }

    @Override
    @MediaProperty(uuid1=67175169, uuid2=1536, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FieldDominance", typeName="FieldNumber", optional=true, uniqueIdentifier=false, pid=12818, symbol="FieldDominance")
    public FieldNumber getFieldDominance() throws PropertyNotPresentException {
        if (this.fieldDominance == null) {
            throw new PropertyNotPresentException("The optional field dominance property is not present in this picture descriptor.");
        }
        return this.fieldDominance;
    }

    @Override
    @MediaPropertySetter(value="FieldDominance")
    public void setFieldDominance(FieldNumber fieldDominance) {
        this.fieldDominance = fieldDominance;
    }

    @Override
    @MediaProperty(uuid1=68681987, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ImageEndOffset", aliases={"FieldEndOffset"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=12820, symbol="ImageEndOffset")
    public int getImageEndOffset() {
        if (this.imageEndOffset == null) {
            return 0;
        }
        return this.imageEndOffset;
    }

    @Override
    @MediaPropertySetter(value="ImageEndOffset")
    public void setImageEndOffset(Integer imageEndOffset) throws IllegalArgumentException {
        if (imageEndOffset == null) {
            this.imageEndOffset = null;
            return;
        }
        if (imageEndOffset < 0) {
            throw new IllegalArgumentException("Cannot set the image end offset value to a negative value for this picture descriptor.");
        }
        this.imageEndOffset = imageEndOffset;
    }

    @Override
    @MediaProperty(uuid1=68681986, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ImageStartOffset", aliases={"FieldStartOffset"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=12819, symbol="ImageStartOffset")
    public int getImageStartOffset() {
        if (this.imageStartOffset == null) {
            return 0;
        }
        return this.imageStartOffset;
    }

    @Override
    @MediaPropertySetter(value="ImageStartOffset")
    public void setImageStartOffset(Integer imageStartOffset) throws IllegalArgumentException {
        if (imageStartOffset == null) {
            this.imageStartOffset = null;
            return;
        }
        if (imageStartOffset < 0) {
            throw new IllegalArgumentException("Cannot set the image end offset to a negative value for this picture descriptor.");
        }
        this.imageStartOffset = imageStartOffset;
    }

    @Override
    @MediaProperty(uuid1=67175169, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="FrameLayout", typeName="LayoutType", optional=false, uniqueIdentifier=false, pid=12812, symbol="FrameLayout")
    public LayoutType getFrameLayout() {
        return this.frameLayout;
    }

    @Override
    @MediaPropertySetter(value="FrameLayout")
    public void setFrameLayout(LayoutType frameLayout) throws NullPointerException {
        if (frameLayout == null) {
            throw new NullPointerException("Cannot set the frame layout of this picture descriptor using a null value.");
        }
        this.frameLayout = frameLayout;
    }

    public static final LayoutType initializeFrameLayout() {
        return LayoutType.FullFrame;
    }

    @Override
    @MediaProperty(uuid1=68681985, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ImageAlignmentFactor", aliases={"ImageAlignmentOffset"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=12817, symbol="ImageAlignmentFactor")
    public int getImageAlignmentFactor() {
        if (this.imageAlignmentFactor == null) {
            return 1;
        }
        return this.imageAlignmentFactor;
    }

    @Override
    @MediaPropertySetter(value="ImageAlignmentFactor")
    public void setImageAlignmentFactor(Integer imageAlignmentFactor) throws IllegalArgumentException {
        if (imageAlignmentFactor == null) {
            this.imageAlignmentFactor = null;
            return;
        }
        if (imageAlignmentFactor < 0) {
            throw new IllegalArgumentException("Cannot set the image alignment factor to a negative value for this picture descriptor.");
        }
        this.imageAlignmentFactor = imageAlignmentFactor;
    }

    @Override
    @MediaProperty(uuid1=0x4010101, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="ImageAspectRatio", aliases={"AspectRatio"}, typeName="Rational", optional=false, uniqueIdentifier=false, pid=12814, symbol="ImageAspectRatio")
    public Rational getImageAspectRatio() {
        return this.imageAspectRatio.clone();
    }

    @Override
    @MediaPropertySetter(value="ImageAspectRatio")
    public void setImageAspectRatio(Rational imageAspectRatio) throws NullPointerException {
        if (imageAspectRatio == null) {
            throw new NullPointerException("Cannot set the image aspect ratio of this picture descriptor to a null value.");
        }
        this.imageAspectRatio = imageAspectRatio.clone();
    }

    public static final Rational initializeImageAspectRatio() {
        return new RationalImpl(1, 1);
    }

    @Override
    public int[] getSampledView() {
        if (!this.sampledValuesPresent) {
            return new int[]{this.storedHeight, this.storedWidth, 0, 0};
        }
        return new int[]{this.sampledHeight, this.sampledWidth, this.sampledXOffset, this.sampledYOffset};
    }

    @Override
    public void setSampledView(int sampledHeight, int sampledWidth, int sampledXOffset, int sampledYOffset) throws IllegalPropertyValueException {
        if (sampledXOffset < 0 || sampledXOffset >= this.storedWidth) {
            throw new IllegalArgumentException("The given sampled x offset is outside the acceptable range for the stored width of this picture descriptor.");
        }
        if (sampledYOffset < 0 || sampledYOffset >= this.storedHeight) {
            throw new IllegalArgumentException("The given sampled y offset is outside the acceptable range for the stored height of this picture descriptor.");
        }
        if (sampledHeight < 0 || sampledHeight > this.storedHeight - sampledYOffset) {
            throw new IllegalPropertyValueException("The given sampled height is outside the available range for the given offsets.");
        }
        if (sampledWidth < 0 || sampledWidth > this.storedWidth - sampledXOffset) {
            throw new IllegalArgumentException("The given sampled width is outside the available range for the given offsets.");
        }
        this.sampledHeight = sampledHeight;
        this.sampledWidth = sampledWidth;
        this.sampledXOffset = sampledXOffset;
        this.sampledYOffset = sampledYOffset;
        this.sampledValuesPresent = true;
    }

    @Override
    @MediaProperty(uuid1=67175681, uuid2=1792, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="SampledHeight", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=12804, symbol="SampledHeight")
    public int getSampledHeight() {
        if (!this.sampledValuesPresent) {
            return this.storedHeight;
        }
        return this.sampledHeight;
    }

    @MediaPropertySetter(value="SampledHeight")
    public void setSampledHeight(int sampledHeight) throws IllegalArgumentException {
        if (sampledHeight < 0) {
            throw new IllegalArgumentException("Cannot set the sampled height for this picture descriptor to a negative value.");
        }
        this.sampledHeight = sampledHeight;
        this.sampledValuesPresent = true;
    }

    @Override
    @MediaProperty(uuid1=67175681, uuid2=2048, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="SampledWidth", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=12805, symbol="SampledWidth")
    public int getSampledWidth() {
        if (!this.sampledValuesPresent) {
            return this.storedWidth;
        }
        return this.sampledWidth;
    }

    @MediaPropertySetter(value="SampledWidth")
    public void setSampledWidth(int sampledWidth) throws IllegalArgumentException {
        if (sampledWidth < 0) {
            throw new IllegalArgumentException("Cannot set the sampled width of this picture descriptor to a negative value.");
        }
        this.sampledWidth = sampledWidth;
        this.sampledValuesPresent = true;
    }

    @Override
    @MediaProperty(uuid1=67175681, uuid2=2304, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="SampledXOffset", typeName="Int32", optional=true, uniqueIdentifier=false, pid=12806, symbol="SampledXOffset")
    public int getSampledXOffset() {
        if (!this.sampledValuesPresent) {
            return 0;
        }
        return this.sampledXOffset;
    }

    @MediaPropertySetter(value="SampledXOffset")
    public void setSampledXOffset(int sampledXOffset) {
        this.sampledXOffset = sampledXOffset;
        this.sampledValuesPresent = true;
    }

    @Override
    @MediaProperty(uuid1=67175681, uuid2=2560, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="SampledYOffset", typeName="Int32", optional=true, uniqueIdentifier=false, pid=12807, symbol="SampledYOffset")
    public int getSampledYOffset() {
        if (!this.sampledValuesPresent) {
            return 0;
        }
        return this.sampledYOffset;
    }

    @MediaPropertySetter(value="SampledYOffset")
    public void setSampledYOffset(int sampledYOffset) {
        this.sampledYOffset = sampledYOffset;
        this.sampledValuesPresent = true;
    }

    @Override
    public boolean areSampledValuesPresent() {
        return this.sampledValuesPresent;
    }

    @Override
    @MediaProperty(uuid1=67436819, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="SignalStandard", typeName="SignalStandardType", optional=true, uniqueIdentifier=false, pid=12821, symbol="SignalStandard")
    public SignalStandardType getSignalStandard() throws PropertyNotPresentException {
        if (this.signalStandard == null) {
            throw new PropertyNotPresentException("The optional signal standard property is not present in this picture descriptor.");
        }
        return this.signalStandard;
    }

    @Override
    @MediaPropertySetter(value="SignalStandard")
    public void setSignalStandard(SignalStandardType signalStandard) {
        this.signalStandard = signalStandard;
    }

    @Override
    @MediaProperty(uuid1=67175170, uuid2=2048, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="StoredF2Offset", typeName="Int32", optional=true, uniqueIdentifier=false, pid=12822, symbol="StoredF2Offset")
    public int getStoredF2Offset() {
        if (this.storedF2Offset == null) {
            return 0;
        }
        return this.storedF2Offset;
    }

    @Override
    @MediaPropertySetter(value="StoredF2Offset")
    public void setStoredF2Offset(Integer storedF2Offset) throws IllegalArgumentException {
        if (storedF2Offset == null) {
            this.storedF2Offset = null;
            return;
        }
        if (storedF2Offset != 0 && storedF2Offset != -1) {
            throw new IllegalArgumentException("The given stored field 2 offset is not one of the valid values of 0 and -1.");
        }
        this.storedF2Offset = storedF2Offset;
    }

    @Override
    public int[] getStoredView() {
        return new int[]{this.storedHeight, this.storedWidth};
    }

    @Override
    public void setStoredView(int storedHeight, int storedWidth) throws IllegalArgumentException {
        this.setStoredHeight(storedHeight);
        this.setStoredWidth(storedWidth);
    }

    @Override
    @MediaProperty(uuid1=67175682, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="StoredHeight", typeName="UInt32", optional=false, uniqueIdentifier=false, pid=12802, symbol="StoredHeight")
    public int getStoredHeight() {
        return this.storedHeight;
    }

    @MediaPropertySetter(value="StoredHeight")
    public void setStoredHeight(int storedHeight) throws IllegalArgumentException {
        if (storedHeight < 0) {
            throw new IllegalArgumentException("The given stored height is negative, which is not permitted.");
        }
        this.storedHeight = storedHeight;
    }

    public static final int initializeStoredHeight() {
        return 0;
    }

    @Override
    @MediaProperty(uuid1=67175682, uuid2=512, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="StoredWidth", typeName="UInt32", optional=false, uniqueIdentifier=false, pid=12803, symbol="StoredWidth")
    public int getStoredWidth() {
        return this.storedWidth;
    }

    @MediaPropertySetter(value="StoredWidth")
    public void setStoredWidth(int storedWidth) throws IllegalArgumentException {
        if (storedWidth < 0) {
            throw new IllegalArgumentException("The given stored width is negative, which is not permitted.");
        }
        this.storedWidth = storedWidth;
    }

    public static final int initializeStoredWidth() {
        return 0;
    }

    @Override
    @MediaProperty(uuid1=67174913, uuid2=257, uuid3=512, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TransferCharacteristic", aliases={"Gamma"}, typeName="TransferCharacteristicType", optional=true, uniqueIdentifier=false, pid=12816, symbol="TransferCharacteristic")
    public AUID getTransferCharacteristic() throws PropertyNotPresentException {
        if (this.transferCharacteristic == null) {
            throw new PropertyNotPresentException("The optional transfer characteristic type is not present in this picture descriptor.");
        }
        return this.transferCharacteristic.clone();
    }

    @Override
    @MediaPropertySetter(value="TransferCharacteristic")
    public void setTransferCharacteristic(AUID transferCharacteristic) {
        this.transferCharacteristic = transferCharacteristic == null ? null : transferCharacteristic.clone();
    }

    @Override
    @MediaProperty(uuid1=67175170, uuid2=1280, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="VideoLineMap", typeName="Int32Array", optional=false, uniqueIdentifier=false, pid=12813, symbol="VideoLineMap")
    public int[] getVideoLineMap() {
        return (int[])this.videoLineMap.clone();
    }

    @Override
    public void setVideoLineMap(int[] videoLineMap) throws NullPointerException, IllegalArgumentException {
        if (videoLineMap == null) {
            throw new NullPointerException("Cannot set the video line map of this picture descriptor using a null value.");
        }
        if (videoLineMap.length == 0 || videoLineMap.length > 2) {
            throw new IllegalArgumentException("The size of the video line map must be 1 or 2 for this picture descriptor.");
        }
        this.videoLineMap = (int[])videoLineMap.clone();
    }

    @MediaPropertySetter(value="VideoLineMap")
    public void setVideoLineMap(List<Integer> videoLineMap) throws NullPointerException, IllegalArgumentException {
        if (videoLineMap == null) {
            throw new NullPointerException("Cannot set the video line map of this picture descriptor using a null value.");
        }
        if (videoLineMap.size() == 0 || videoLineMap.size() > 2) {
            System.err.println("The size of the video line map should be 1 or 2 for this picture descriptor and was set to length " + videoLineMap.size() + " from a stream.");
        }
        this.videoLineMap = new int[videoLineMap.size()];
        for (int u = 0; u < this.videoLineMap.length; ++u) {
            if (videoLineMap.get(u) == null) {
                throw new NullPointerException("Cannot set the video line map with null integer values.");
            }
            this.videoLineMap[u] = videoLineMap.get(u);
        }
    }

    public static final List<Integer> initializeVideoLineMap() {
        ArrayList<Integer> initialList = new ArrayList<Integer>(1);
        initialList.add(0);
        return initialList;
    }

    @Override
    @MediaPropertyCount(value="VideoLineMap")
    public int getVideoLineMapSize() {
        return this.videoLineMap.length;
    }

    @Override
    public PictureDescriptor clone() {
        return (PictureDescriptor)super.clone();
    }

    @Override
    @MediaProperty(uuid1=-1075936796, uuid2=-17208, uuid3=19133, uuid4={-88, 14, 33, 77, -64, -15, 70, -124}, definedName="DataOffset", typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, symbol="DataOffset", namespace="http://www.amwa.tv/is03/extensions/avid", prefix="avid")
    @Int32
    public int getDataOffset() throws PropertyNotPresentException {
        if (this.dataOffset == null) {
            throw new NullPointerException("The optional data offset property is not present for this picture descriptor.");
        }
        return this.dataOffset;
    }

    @Override
    @MediaPropertySetter(value="DataOffset")
    public void setDataOffset(@Int32 Integer dataOffset) {
        this.dataOffset = dataOffset;
    }

    @Override
    @MediaProperty(uuid1=-1249996195, uuid2=5901, uuid3=4564, uuid4={-96, -113, 0, 96, -108, -21, 117, -53}, definedName="FrameIndexByteOrder", typeName="UInt16", optional=true, uniqueIdentifier=false, pid=0, symbol="FrameIndexByteOrder", namespace="http://www.amwa.tv/is03/extensions/avid", prefix="avid")
    @UInt16
    public short getFrameIndexByteOrder() throws PropertyNotPresentException {
        if (this.frameIndexByteOrder == null) {
            throw new NullPointerException("The optional frame index byte order property is not present for this picture descriptor.");
        }
        return this.frameIndexByteOrder;
    }

    @Override
    @MediaPropertySetter(value="FrameIndexByteOrder")
    public void setFrameIndexByteOrder(@UInt16 Short frameIndexByteOrder) throws IllegalArgumentException {
        if (frameIndexByteOrder == null) {
            this.frameIndexByteOrder = null;
            return;
        }
        if (frameIndexByteOrder < 0) {
            throw new IllegalArgumentException("Cannot set the frame index byte order with a negative value.");
        }
        this.frameIndexByteOrder = frameIndexByteOrder;
    }

    @Override
    @MediaProperty(uuid1=-836056496, uuid2=20907, uuid3=4563, uuid4={-96, 36, 0, 96, -108, -21, 117, -53}, definedName="FrameSampleSize", typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, symbol="FrameSampleSize", namespace="http://www.amwa.tv/is03/extensions/avid", prefix="avid")
    @Int32
    public int getFrameSampleSize() throws PropertyNotPresentException {
        if (this.frameSampleSize == null) {
            throw new NullPointerException("The optional frame sample size property is not present for this picture descriptor.");
        }
        return this.frameSampleSize;
    }

    @Override
    @MediaPropertySetter(value="FrameSampleSize")
    public void setFrameSampleSize(@Int32 Integer frameSampleSize) {
        this.frameSampleSize = frameSampleSize;
    }

    @Override
    @MediaProperty(uuid1=-836056497, uuid2=20907, uuid3=4563, uuid4={-96, 36, 0, 96, -108, -21, 117, -53}, definedName="ImageSize", typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, symbol="ImageSize", namespace="http://www.amwa.tv/is03/extensions/avid", prefix="avid")
    @Int32
    public int getImageSize() throws PropertyNotPresentException {
        if (this.imageSize == null) {
            throw new NullPointerException("The optional image size property is not present for this picture descriptor.");
        }
        return this.imageSize;
    }

    @Override
    @MediaPropertySetter(value="ImageSize")
    public void setImageSize(@Int32 Integer imageSize) {
        this.imageSize = imageSize;
    }

    @Override
    @MediaProperty(uuid1=-836056499, uuid2=20907, uuid3=4563, uuid4={-96, 36, 0, 96, -108, -21, 117, -53}, definedName="ResolutionID", typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, symbol="ResolutionID", namespace="http://www.amwa.tv/is03/extensions/avid", prefix="avid")
    @Int32
    public int getResolutionID() throws PropertyNotPresentException {
        if (this.resolutionID == null) {
            throw new NullPointerException("The optional resolution ID property is not present for this picture descriptor.");
        }
        return this.resolutionID;
    }

    @Override
    @MediaPropertySetter(value="ResolutionID")
    public void setResolutionID(@Int32 Integer resolutionID) {
        this.resolutionID = resolutionID;
    }

    public String getCodingEquationsString() {
        return AUIDImpl.toPersistentForm(this.codingEquations);
    }

    public void setCodingEquationsString(String codingEquations) {
        this.codingEquations = AUIDImpl.fromPersistentForm(codingEquations);
    }

    public String getColorPrimariesString() {
        return AUIDImpl.toPersistentForm(this.colorPrimaries);
    }

    public void setColorPrimariesString(String colorPrimaries) {
        this.colorPrimaries = AUIDImpl.fromPersistentForm(colorPrimaries);
    }

    public String getImageAspectRatioString() {
        return RationalImpl.toPersistentForm(this.imageAspectRatio);
    }

    public void setImageAspectRatioString(String imageAspectRatio) {
        this.imageAspectRatio = RationalImpl.fromPersistentForm(imageAspectRatio);
    }

    public String getTransferCharacteristicString() {
        return AUIDImpl.toPersistentForm(this.transferCharacteristic);
    }

    public void setTransferCharacteristicString(String transferCharacteristic) {
        this.transferCharacteristic = AUIDImpl.fromPersistentForm(transferCharacteristic);
    }

    public String getPictureCompressionString() {
        return AUIDImpl.toPersistentForm(this.pictureCompression);
    }

    public void setPictureCompressionString(String pictureCompressionString) {
        this.pictureCompression = AUIDImpl.fromPersistentForm(pictureCompressionString);
    }
}

