/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.NetworkLocator;
import tv.amwa.maj.model.impl.LocatorImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=12800, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="NetworkLocator", description="The NetworkLocator class provides information to help find a file containing essence.", symbol="NetworkLocator")
public class NetworkLocatorImpl
extends LocatorImpl
implements NetworkLocator,
Serializable,
Cloneable {
    private static final long serialVersionUID = -991161509805417107L;

    public NetworkLocatorImpl() {
    }

    public NetworkLocatorImpl(@AAFString String urlString) throws NullPointerException, IllegalArgumentException {
        this.setURL(urlString);
    }

    @Override
    @MediaProperty(uuid1=0x1020101, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="URL", aliases={"URLString"}, typeName="UTF16String", optional=false, uniqueIdentifier=false, pid=16385, symbol="URL")
    public String getURL() {
        return this.getPath();
    }

    @Override
    @MediaPropertySetter(value="URL")
    public void setURL(String urlString) throws NullPointerException, IllegalArgumentException {
        if (urlString == null) {
            throw new NullPointerException("Cannot create a network locator from a null URL.");
        }
        try {
            URI uRI = new URI(urlString);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.setPath(urlString);
    }

    public static final String initializeURL() {
        return "http://www.amwa.tv/";
    }

    @Override
    public NetworkLocator clone() {
        return (NetworkLocator)super.clone();
    }

    public String getURLPersist() {
        return this.getPath();
    }

    public void setURLPersist(String urlString) {
        if (urlString != null) {
            this.setPath(urlString);
        }
    }
}

