/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.enumeration.ContentScanningType;
import tv.amwa.maj.enumeration.LayoutType;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.integer.UInt16;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.integer.UInt8;
import tv.amwa.maj.misctype.VideoLineMap;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.MPEGVideoDescriptor;
import tv.amwa.maj.model.impl.CDCIDescriptorImpl;
import tv.amwa.maj.record.Rational;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=20736, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="MPEGVideoDescriptor", description="Describes essence that is encoded according to the MPEG specifications.", symbol="MPEGVideoDescriptor")
public class MPEGVideoDescriptorImpl
extends CDCIDescriptorImpl
implements MPEGVideoDescriptor,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7207964203762950920L;
    private Boolean singleSequence = null;
    private Boolean constantBPictureCount = null;
    private ContentScanningType codedContentScanning = null;
    private Boolean lowDelay = null;
    private Boolean closedGOP = null;
    private Boolean identicalGOP = null;
    @UInt16
    private Short maxGOP = null;
    @UInt16
    private Short maxBPictureCount = null;
    @UInt32
    private Integer bitRate = null;
    @UInt8
    private Byte profileAndLevel = null;

    public MPEGVideoDescriptorImpl() {
    }

    public MPEGVideoDescriptorImpl(ContainerDefinition containerFormat, @UInt32 int storedHeight, @UInt32 int storedWidth, LayoutType frameLayout, @VideoLineMap int[] videoLineMap, Rational imageAspectRatio, @UInt32 int horizontalSubsampling, @UInt32 int componentWidth) throws NullPointerException, IllegalArgumentException {
        if (frameLayout == null) {
            throw new NullPointerException("Cannot create a CDCI descriptor using a null frame layout value.");
        }
        if (videoLineMap == null) {
            throw new NullPointerException("Cannot create a CDCI descriptor using a null video line map value.");
        }
        if (imageAspectRatio == null) {
            throw new NullPointerException("Cannot create a CDCI descriptor using a null image aspect ratio.");
        }
        this.setContainerFormat(containerFormat);
        this.setStoredView(storedHeight, storedWidth);
        this.setFrameLayout(frameLayout);
        this.setVideoLineMap(videoLineMap);
        this.setImageAspectRatio(imageAspectRatio);
        this.setHorizontalSubsampling(horizontalSubsampling);
        this.setComponentDepth(componentWidth);
    }

    @Override
    @MediaProperty(uuid1=67175938, uuid2=267, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="BitRate", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=0, symbol="BitRate")
    public int getBitRate() throws PropertyNotPresentException {
        if (this.bitRate == null) {
            throw new PropertyNotPresentException("The optional bit rate property is not present in this MPEG video descriptor.");
        }
        return this.bitRate;
    }

    @Override
    @MediaPropertySetter(value="BitRate")
    public void setBitRate(Integer bitRate) throws IllegalArgumentException {
        if (bitRate != null && bitRate < 0) {
            throw new IllegalArgumentException("Cannot set the bit rate to a negative value.");
        }
        this.bitRate = bitRate;
    }

    @Override
    @MediaProperty(uuid1=67175938, uuid2=262, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="ClosedGOP", typeName="Boolean", optional=true, uniqueIdentifier=false, pid=0, symbol="ClosedGOP")
    public boolean getClosedGOP() throws PropertyNotPresentException {
        if (this.closedGOP == null) {
            throw new PropertyNotPresentException("The optional closed GOP property is not present in this MPEG video descriptor.");
        }
        return this.closedGOP;
    }

    @Override
    @MediaPropertySetter(value="ClosedGOP")
    public void setClosedGOP(Boolean closedGOP) {
        this.closedGOP = closedGOP;
    }

    @Override
    @MediaProperty(uuid1=67175938, uuid2=260, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="CodedContentScanning", typeName="ContentScanningType", optional=true, uniqueIdentifier=false, pid=0, symbol="CodedContentScanning")
    public ContentScanningType getCodedContentScanning() throws PropertyNotPresentException {
        if (this.codedContentScanning == null) {
            throw new PropertyNotPresentException("The optional coded content scanning property is not present in this MPEG video descriptor.");
        }
        return this.codedContentScanning;
    }

    @Override
    @MediaPropertySetter(value="CodedContentScanning")
    public void setCodedContentScanning(ContentScanningType codedContentScanning) {
        this.codedContentScanning = codedContentScanning;
    }

    @Override
    @MediaProperty(uuid1=67175938, uuid2=259, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="ConstantBPictureCount", typeName="Boolean", optional=true, uniqueIdentifier=false, pid=0, symbol="ConstantBPictureCount")
    public boolean getConstantBPictureCount() throws PropertyNotPresentException {
        if (this.constantBPictureCount == null) {
            throw new PropertyNotPresentException("The optional constant B picture count property is not present in this MPEG video descriptor.");
        }
        return this.constantBPictureCount;
    }

    @Override
    @MediaPropertySetter(value="ConstantBPictureCount")
    public void setConstantBPictureCount(Boolean constanBPictureCount) {
        this.constantBPictureCount = constanBPictureCount;
    }

    @Override
    @MediaProperty(uuid1=67175938, uuid2=263, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="IdenticalGOP", typeName="Boolean", optional=true, uniqueIdentifier=false, pid=0, symbol="IdenticalGOP")
    public boolean getIdenticalGOP() throws PropertyNotPresentException {
        if (this.identicalGOP == null) {
            throw new PropertyNotPresentException("The optional identifical GOP property is not present in this MPEG video descriptor.");
        }
        return this.identicalGOP;
    }

    @Override
    @MediaPropertySetter(value="IdenticalGOP")
    public void setIdenticalGOP(Boolean identicalGOP) {
        this.identicalGOP = identicalGOP;
    }

    @Override
    @MediaProperty(uuid1=67175938, uuid2=261, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="LowDelay", typeName="Boolean", optional=true, uniqueIdentifier=false, pid=0, symbol="LowDelay")
    public boolean getLowDelay() throws PropertyNotPresentException {
        if (this.lowDelay == null) {
            throw new PropertyNotPresentException("The optional low delay property is not present in this MPEG video descriptor.");
        }
        return this.lowDelay;
    }

    @Override
    @MediaPropertySetter(value="LowDelay")
    public void setLowDelay(Boolean lowDelay) {
        this.lowDelay = lowDelay;
    }

    @Override
    @MediaProperty(uuid1=67175938, uuid2=265, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="MaxBPictureCount", typeName="UInt16", optional=true, uniqueIdentifier=false, pid=0, symbol="MaxBPictureCount")
    public short getMaxBPictureCount() throws PropertyNotPresentException {
        if (this.maxBPictureCount == null) {
            throw new PropertyNotPresentException("The optional maximum B picture count property is not present in this MPEG video descriptor.");
        }
        return this.maxBPictureCount;
    }

    @Override
    @MediaPropertySetter(value="MaxBPictureCount")
    public void setMaxBPictureCount(Short maxBPictureCount) throws IllegalArgumentException {
        if (maxBPictureCount != null && maxBPictureCount < 0) {
            throw new IllegalArgumentException("The maximum B picture count cannot be a negative value.");
        }
        this.maxBPictureCount = maxBPictureCount;
    }

    @Override
    @MediaProperty(uuid1=67175938, uuid2=264, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="MaxGOP", typeName="UInt16", optional=true, uniqueIdentifier=false, pid=0, symbol="MaxGOP")
    public short getMaxGOP() throws PropertyNotPresentException {
        if (this.maxGOP == null) {
            throw new PropertyNotPresentException("The optional max GOP property is not present in this MPEG video descriptor.");
        }
        return this.maxGOP;
    }

    @Override
    @MediaPropertySetter(value="MaxGOP")
    public void setMaxGOP(Short maxGOP) throws IllegalArgumentException {
        if (maxGOP != null && maxGOP < 0) {
            throw new IllegalArgumentException("The max GOP property cannot be set to a negative value.");
        }
        this.maxGOP = maxGOP;
    }

    @Override
    @MediaProperty(uuid1=67175938, uuid2=266, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="ProfileAndLevel", typeName="UInt8", optional=true, uniqueIdentifier=false, pid=0, symbol="ProfileAndLevel")
    public byte getProfileAndLevel() throws PropertyNotPresentException {
        if (this.profileAndLevel == null) {
            throw new PropertyNotPresentException("The optional profile and level property is not present in this MPEG video descriptor.");
        }
        return this.profileAndLevel;
    }

    @Override
    @MediaPropertySetter(value="ProfileAndLevel")
    public void setProfileAndLevel(Byte profileAndLevel) {
        this.profileAndLevel = profileAndLevel;
    }

    @Override
    @MediaProperty(uuid1=67175938, uuid2=258, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="SingleSequence", typeName="Boolean", optional=true, uniqueIdentifier=false, pid=0, symbol="SingleSequence")
    public boolean getSingleSequence() throws PropertyNotPresentException {
        if (this.singleSequence == null) {
            throw new PropertyNotPresentException("The optional single sequence property is not present in this MPEG video descriptor.");
        }
        return this.singleSequence;
    }

    @Override
    @MediaPropertySetter(value="SingleSequence")
    public void setSingleSequence(Boolean singleSequence) {
        this.singleSequence = singleSequence;
    }

    @Override
    public MPEGVideoDescriptor clone() {
        return (MPEGVideoDescriptor)super.clone();
    }
}

