/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListInsertAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.model.EssenceDescriptor;
import tv.amwa.maj.model.Locator;
import tv.amwa.maj.model.SubDescriptor;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=9216, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="EssenceDescriptor", description="The EssenceDescriptor class describes the format of the essence associated with a file SourcePackage or of the media associated with a physical SourcePackage.", symbol="EssenceDescriptor", isConcrete=false)
public class EssenceDescriptorImpl
extends InterchangeObjectImpl
implements EssenceDescriptor,
Serializable,
Cloneable {
    private static final long serialVersionUID = 9112399211748828585L;
    private List<Locator> locators = Collections.synchronizedList(new Vector());
    private List<SubDescriptor> subDescriptors = Collections.synchronizedList(new Vector());

    @Override
    @MediaListAppend(value="Locators")
    public void appendLocator(Locator locator) throws NullPointerException {
        if (locator == null) {
            throw new NullPointerException("Cannot append a null locator to the list of locators of this essence descriptor.");
        }
        StrongReferenceVector.append(this.locators, locator);
    }

    @Override
    @MediaPropertyCount(value="Locators")
    public int countLocators() {
        return this.locators.size();
    }

    @Override
    @MediaListGetAt(value="Locators")
    public Locator getLocatorAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.locators, index);
    }

    @MediaProperty(uuid1=100729092, uuid2=1539, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Locators", aliases={"Locator", "EssenceDescriptorLocator", "EssenceDescriptorLocators"}, typeName="LocatorStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=12033, symbol="Locators")
    public List<Locator> getLocators() throws PropertyNotPresentException {
        if (this.locators.size() == 0) {
            throw new PropertyNotPresentException("No locators are present for this essence descriptor.");
        }
        return StrongReferenceVector.getOptionalList(this.locators);
    }

    @Override
    @MediaListInsertAt(value="Locators")
    public void insertLocatorAt(int index, Locator locator) throws NullPointerException, IndexOutOfBoundsException {
        if (locator == null) {
            throw new NullPointerException("Cannot insert a null locator into the list of locators of this essence descriptor.");
        }
        StrongReferenceVector.insert(this.locators, index, locator);
    }

    @Override
    @MediaListPrepend(value="Locators")
    public void prependLocator(Locator locator) throws NullPointerException {
        if (locator == null) {
            throw new NullPointerException("Cannot prepend a null locator to the list of locators of this essence descriptor.");
        }
        StrongReferenceVector.prepend(this.locators, locator);
    }

    @Override
    @MediaListRemoveAt(value="Locators")
    public void removeLocatorAt(int index) throws IndexOutOfBoundsException {
        StrongReferenceVector.remove(this.locators, index);
    }

    @Override
    @MediaPropertyClear(value="Locators")
    public void clearLocators() {
        this.locators = Collections.synchronizedList(new Vector());
    }

    @MediaProperty(uuid1=100729092, uuid2=1552, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 9}, definedName="SubDescriptors", typeName="SubDescriptorStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=12034, symbol="SubDescriptors")
    public List<SubDescriptor> getSubDescriptors() throws PropertyNotPresentException {
        if (this.subDescriptors.size() == 0) {
            throw new PropertyNotPresentException("No sub descriptors are present for this essence descriptor.");
        }
        return StrongReferenceVector.getOptionalList(this.subDescriptors);
    }

    @Override
    @MediaPropertyCount(value="SubDescriptors")
    public int countSubDescriptors() {
        return this.subDescriptors.size();
    }

    @Override
    @MediaListAppend(value="SubDescriptors")
    public void appendSubDescriptor(SubDescriptor subDescriptor) throws NullPointerException {
        if (subDescriptor == null && this.subDescriptors.isEmpty()) {
            return;
        }
        if (subDescriptor == null) {
            throw new NullPointerException("Cannot append a null sub descriptor to the list of sub descriptors of this essence descriptor.");
        }
        StrongReferenceVector.append(this.subDescriptors, subDescriptor);
    }

    @Override
    @MediaListGetAt(value="SubDescriptors")
    public SubDescriptor getSubDescriptorAt(@UInt32 int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.subDescriptors, index);
    }

    @Override
    @MediaListPrepend(value="SubDescriptors")
    public void prependSubDescriptor(SubDescriptor subDescriptor) {
        if (subDescriptor == null) {
            throw new NullPointerException("Cannot prepend a null sub descriptor to the list of sub descriptors of this essence descriptor.");
        }
        StrongReferenceVector.prepend(this.subDescriptors, subDescriptor);
    }

    @Override
    @MediaListInsertAt(value="SubDescriptors")
    public void insertSubDescriptorAt(@UInt32 int index, SubDescriptor subDescriptor) throws NullPointerException, IndexOutOfBoundsException {
        if (subDescriptor == null) {
            throw new NullPointerException("Cannot insert a null sub descriptor to the list of sub descriptors of this essence descriptor.");
        }
        StrongReferenceVector.insert(this.subDescriptors, index, subDescriptor);
    }

    @Override
    @MediaListRemoveAt(value="SubDescriptors")
    public void removeSubDescriptorAt(@UInt32 int index) throws IndexOutOfBoundsException {
        StrongReferenceVector.remove(this.subDescriptors, index);
    }

    @MediaPropertyClear(value="SubDescriptors")
    public void clearSubDescriptors() {
        this.subDescriptors.clear();
    }

    @Override
    public EssenceDescriptor clone() {
        return (EssenceDescriptor)super.clone();
    }

    @Override
    public String getComment() {
        return "local essence descriptor persistent id: " + this.getPersistentID();
    }
}

