/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.model.DefinitionObject;
import tv.amwa.maj.model.impl.DefinitionType;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=6656, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="DefinitionObject", description="The DefinitionObject class defines an item to be referenced.", symbol="DefinitionObject", isConcrete=false)
public class DefinitionObjectImpl
extends InterchangeObjectImpl
implements DefinitionObject,
DefinitionType,
WeakReferenceTarget,
Serializable,
Cloneable {
    private static final long serialVersionUID = -6442990440375118888L;
    private AUID definitionObjectIdentification;
    private String definitionObjectName;
    private String definitionObjectDescription = null;
    private String localizedUID = null;
    private static int nameCounter = 1;

    @Override
    @MediaProperty(uuid1=16848131, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="DefinitionObjectIdentification", aliases={"AUID", "Identification"}, typeName="AUID", optional=false, uniqueIdentifier=true, pid=6913, symbol="DefinitionObjectIdentification")
    public AUID getAUID() {
        return this.definitionObjectIdentification.clone();
    }

    @MediaPropertySetter(value="DefinitionObjectIdentification")
    public void setAUID(AUID identification) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot set the identification of this definition to a null value.");
        }
        this.definitionObjectIdentification = identification.clone();
    }

    public static final AUID initializeDefinitionObjectIdentification() {
        return AUIDImpl.randomAUID();
    }

    @Override
    @MediaProperty(uuid1=17236226, uuid2=769, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="DefinitionObjectName", aliases={"Name"}, typeName="UTF16String", optional=false, uniqueIdentifier=false, pid=6914, symbol="DefinitionObjectName")
    public String getName() {
        return this.definitionObjectName;
    }

    @Override
    @MediaPropertySetter(value="DefinitionObjectName")
    public void setName(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Cannot set the name of a definition from a null string.");
        }
        this.definitionObjectName = name;
    }

    public static final String initializeDefinitionObjectName() {
        return "DefaultDefinitionName" + nameCounter++;
    }

    @Override
    @MediaProperty(uuid1=50463489, uuid2=513, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="DefinitionObjectDescription", aliases={"Description"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=6915, symbol="DefinitionObjectDescription")
    public String getDescription() throws PropertyNotPresentException {
        if (this.definitionObjectDescription == null) {
            throw new PropertyNotPresentException("The optional description of the definition is not present.");
        }
        return this.definitionObjectDescription;
    }

    @Override
    @MediaPropertySetter(value="DefinitionObjectDescription")
    public void setDescription(String description) {
        this.definitionObjectDescription = description;
    }

    public String getLocalizedUID() {
        if (this.localizedUID == null) {
            return this.definitionObjectIdentification.toString();
        }
        return this.localizedUID;
    }

    public void setLocalizedUID(String localizedUID) {
        localizedUID.replaceAll("\\W", "_");
        this.localizedUID = localizedUID;
    }

    @Override
    public DefinitionObject clone() {
        return (DefinitionObject)super.clone();
    }

    @Override
    public String getWeakTargetReference() {
        return this.definitionObjectIdentification.toString();
    }

    public String getDefinitionObjectIdentificationString() {
        return AUIDImpl.toPersistentForm(this.definitionObjectIdentification);
    }

    public void setDefinitionObjectIdentificationString(String definitionObjectIdentification) {
        this.definitionObjectIdentification = AUIDImpl.fromPersistentForm(definitionObjectIdentification);
    }
}

