/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import tv.amwa.maj.constant.DataDefinitionConstant;
import tv.amwa.maj.constant.DataDefinitionDescription;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.impl.DefinitionObjectImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=6912, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="DataDefinition", description="The DataDefinition class specifies the kind of data that can be stored in a Component.", symbol="DataDefinition")
public class DataDefinitionImpl
extends DefinitionObjectImpl
implements DataDefinition,
Serializable,
Cloneable,
DataDefinitionConstant {
    private static final long serialVersionUID = 6917594583440410327L;
    private static final Map<String, DataDefinition> definitionsByName = new HashMap<String, DataDefinition>();
    private static final Map<AUID, DataDefinition> definitionsById = new HashMap<AUID, DataDefinition>();

    public static final int registerDataDefinitionsFromClass(Class<?> classWithDataDefinitions) throws NullPointerException {
        Field[] fields;
        if (classWithDataDefinitions == null) {
            throw new NullPointerException("Cannot register parameter definitions using a null class.");
        }
        int registered = 0;
        for (Field field : fields = classWithDataDefinitions.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) continue;
            try {
                Object value = field.get(null);
                if (!(value instanceof AUID) || !field.isAnnotationPresent(DataDefinitionDescription.class)) continue;
                DataDefinitionDescription dataDefinitionMetadata = field.getAnnotation(DataDefinitionDescription.class);
                DataDefinitionImpl definedDataDefinition = new DataDefinitionImpl((AUID)value, field.getName());
                if (dataDefinitionMetadata.description().length() > 0) {
                    definedDataDefinition.setDescription(dataDefinitionMetadata.description());
                }
                DataDefinitionImpl.registerDataDefinition(definedDataDefinition);
                for (String alias : dataDefinitionMetadata.aliases()) {
                    definitionsByName.put(alias, definedDataDefinition);
                }
                ++registered;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return registered;
    }

    public static final boolean registerDataDefinition(DataDefinition definedDataDefinition) throws NullPointerException {
        if (definedDataDefinition == null) {
            throw new NullPointerException("Cannot register a new data definition using a null value.");
        }
        boolean alreadyContained = definitionsById.containsKey(definedDataDefinition.getAUID());
        definitionsByName.put(definedDataDefinition.getName(), definedDataDefinition);
        definitionsByName.put("DataDef_" + definedDataDefinition.getName(), definedDataDefinition);
        definitionsById.put(definedDataDefinition.getAUID(), definedDataDefinition);
        return alreadyContained;
    }

    public static final DataDefinition forName(String dataDefinitionName) throws NullPointerException {
        if (dataDefinitionName == null) {
            throw new NullPointerException("Cannot retrieve a data definition with a null name.");
        }
        return definitionsByName.get(dataDefinitionName);
    }

    public static final DataDefinition forIdentification(AUID identification) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot retrieve a data definition with a null identification.");
        }
        if (!definitionsById.containsKey(identification)) {
            byte[] idBytes = identification.getAUIDValue();
            for (AUID candidate : definitionsById.keySet()) {
                byte[] candidateBytes = candidate.getAUIDValue();
                boolean stillACandidate = true;
                for (int x = 0; x < 8; ++x) {
                    if (idBytes[x] == candidateBytes[x + 8] && candidateBytes[x] == idBytes[x + 8]) continue;
                    stillACandidate = false;
                    break;
                }
                if (!stillACandidate) continue;
                return definitionsById.get(candidate);
            }
            return null;
        }
        return definitionsById.get(identification);
    }

    public static final DataDefinition forAUID(AUID identification) throws NullPointerException {
        return DataDefinitionImpl.forIdentification(identification);
    }

    public static final Collection<String> inventory() {
        TreeSet<String> inventory = new TreeSet<String>();
        for (AUID definitionID : definitionsById.keySet()) {
            inventory.add(definitionsById.get(definitionID).getName());
        }
        return inventory;
    }

    public static final int count() {
        return definitionsById.size();
    }

    public DataDefinitionImpl() {
    }

    public DataDefinitionImpl(AUID identification, @AAFString String name) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a data definition with a null identifier.");
        }
        this.setAUID(identification);
        this.setName(name);
    }

    @Override
    public boolean doesDataDefConvertFrom(DataDefinition dataDef) throws NullPointerException {
        if (dataDef == null) {
            throw new NullPointerException("Cannot check conversion properties for a null value.");
        }
        if (this.getName().contains("test-string")) {
            return true;
        }
        return this.getName().contains(dataDef.getName());
    }

    @Override
    public boolean doesDataDefConvertTo(DataDefinition dataDef) throws NullPointerException {
        if (dataDef == null) {
            throw new NullPointerException("Cannot check conversion properties for a null value.");
        }
        if (dataDef.getName().contains("test-string")) {
            return true;
        }
        return dataDef.getName().contains(this.getName());
    }

    @Override
    public boolean isAuxilaryKind() {
        return this.getAUID().equals(Auxiliary);
    }

    @Override
    public boolean isDataDefOf(DataDefinition dataDef) throws NullPointerException {
        if (dataDef == null) {
            throw new NullPointerException("Cannot check data definition compatibility with a null value.");
        }
        return this.getName().contains(dataDef.getName());
    }

    @Override
    public boolean isDescriptiveMetadataKind() {
        return DescriptiveMetadata.equals(this.getAUID());
    }

    @Override
    public boolean isEdgecodeKind() {
        return this.getAUID().equals(Edgecode);
    }

    @Override
    public boolean isMatteKind() {
        return this.getAUID().equals(Matte);
    }

    @Override
    public boolean isPictureKind() {
        return this.getAUID().equals(Picture);
    }

    @Override
    public boolean isPictureWithMatteKind() {
        return this.getAUID().equals(PictureWithMatte);
    }

    @Override
    public boolean isSoundKind() {
        return this.getAUID().equals(Sound);
    }

    @Override
    public boolean isTimecodeKind() {
        return this.getAUID().equals(Timecode);
    }

    @Override
    public DataDefinition clone() {
        return (DataDefinition)super.clone();
    }

    @Override
    public String getWeakTargetReference() {
        if (this.getName().startsWith("DataDef_")) {
            return this.getName();
        }
        return "DataDef_" + this.getName();
    }

    static {
        DataDefinitionImpl.registerDataDefinitionsFromClass(DataDefinitionConstant.class);
    }
}

