/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.exception.ObjectNotFoundException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.extensions.quantel.QComponent;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertyRemove;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.model.Component;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.KLVData;
import tv.amwa.maj.model.TaggedValue;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.model.impl.TaggedValueImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=512, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="Component", description="The Component class represents an essence element.", symbol="Component", isConcrete=false)
public class ComponentImpl
extends InterchangeObjectImpl
implements Component,
QComponent,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8957903353705107217L;
    private WeakReference<DataDefinition> componentDataDefinition;
    private long componentLength = 0L;
    private boolean lengthPresent = false;
    private List<KLVData> componentKLVData = Collections.synchronizedList(new Vector());
    private List<TaggedValue> componentUserComments = Collections.synchronizedList(new Vector());
    private List<TaggedValue> componentAttributes = Collections.synchronizedList(new Vector());
    private String jupiterID = null;
    private Integer jupiterClipOffset = null;
    private String editName = null;

    @MediaProperty(uuid1=50397712, uuid2=2048, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 7}, definedName="ComponentAttributes", aliases={"Attributes"}, typeName="TaggedValueStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=517, symbol="ComponentAttributes")
    public List<TaggedValue> getComponentAttributes() throws PropertyNotPresentException {
        if (this.componentAttributes.size() == 0) {
            throw new PropertyNotPresentException("No attributes are present for this component.");
        }
        return StrongReferenceVector.getOptionalList(this.componentAttributes);
    }

    @Override
    public void appendComponentAttribute(String name, String value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Cannot set the name of a tagged value attribute with a null value.");
        }
        if (value == null) {
            throw new NullPointerException("Cannot set the value of a tagged value attribute with a null value.");
        }
        TaggedValueImpl taggedValue = new TaggedValueImpl(name, TypeDefinitions.UTF16String, (Serializable)((Object)value));
        StrongReferenceVector.appendNoClone(this.componentAttributes, taggedValue);
    }

    @Override
    @MediaListAppend(value="ComponentAttributes")
    public void appendComponentAttribute(TaggedValue componentAttribute) throws NullPointerException {
        if (componentAttribute == null) {
            throw new NullPointerException("Cannot append a null tagged value to the attributes of this component.");
        }
        StrongReferenceVector.append(this.componentAttributes, componentAttribute);
    }

    @Override
    @MediaPropertyRemove(value="ComponentAttributes")
    public void removeComponentAttribute(TaggedValue componentAttribute) throws NullPointerException, PropertyNotPresentException, ObjectNotFoundException {
        if (componentAttribute == null) {
            throw new NullPointerException("Cannot remove a tagged value attribute from a component using a null value.");
        }
        if (this.componentAttributes.size() == 0) {
            throw new PropertyNotPresentException("No attributes are present for this component.");
        }
        if (!this.componentAttributes.contains(componentAttribute)) {
            throw new ObjectNotFoundException("Cannot remove the given tagged value as it is not currentlty contained in the list of attributes of this component.");
        }
        StrongReferenceVector.remove(this.componentAttributes, componentAttribute);
    }

    @Override
    @MediaPropertyCount(value="ComponentAttributes")
    public int countComponentAttributes() {
        return this.componentAttributes.size();
    }

    @MediaListPrepend(value="ComponentAttributes")
    public void prependComponentAttribute(TaggedValue componentAttribute) throws NullPointerException {
        if (componentAttribute == null) {
            throw new NullPointerException("Cannot prepend a null attribute to those of this component.");
        }
        StrongReferenceVector.prepend(this.componentAttributes, componentAttribute);
    }

    @Override
    @MediaPropertyClear(value="ComponentAttributes")
    public void clearComponentAttributes() {
        this.componentAttributes = Collections.synchronizedList(new Vector());
    }

    @MediaProperty(uuid1=50462978, uuid2=5632, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 7}, definedName="ComponentUserComments", aliases={"UserComments"}, typeName="TaggedValueStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=516, symbol="ComponentUserComments")
    public List<TaggedValue> getComponentUserComments() throws PropertyNotPresentException {
        if (this.componentUserComments.size() == 0) {
            throw new PropertyNotPresentException("No user comments are present for this component.");
        }
        return StrongReferenceVector.getOptionalList(this.componentUserComments);
    }

    @Override
    public void appendComponentUserComment(String name, String value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Cannot set the name of a tagged value user comment for this component with a null value.");
        }
        if (value == null) {
            throw new NullPointerException("Cannot set the value of a tagged value user comment for this component with a null value.");
        }
        TaggedValueImpl taggedValue = new TaggedValueImpl(name, TypeDefinitions.UTF16String, (Serializable)((Object)value));
        StrongReferenceVector.appendNoClone(this.componentUserComments, taggedValue);
    }

    @Override
    @MediaListAppend(value="ComponentUserComments")
    public void appendComponentUserComment(TaggedValue userComment) {
        if (userComment == null) {
            throw new NullPointerException("Cannot append a comment using a null value.");
        }
        StrongReferenceVector.append(this.componentUserComments, userComment);
    }

    @Override
    @MediaPropertyCount(value="ComponentUserComments")
    public int countComponentUserComments() {
        return this.componentUserComments.size();
    }

    @Override
    @MediaPropertyRemove(value="ComponentUserComments")
    public void removeComponentUserComment(TaggedValue userComment) throws NullPointerException, PropertyNotPresentException, ObjectNotFoundException {
        if (userComment == null) {
            throw new NullPointerException("Cannot remove a user comment from the set of comments of this component using a null value.");
        }
        if (this.componentUserComments.size() == 0) {
            throw new PropertyNotPresentException("No user comments are present for this component.");
        }
        if (!this.componentUserComments.contains(userComment)) {
            throw new ObjectNotFoundException("The given user comment cannot be removed as it is not currently contained in the set of user comments of this component.");
        }
        StrongReferenceVector.remove(this.componentUserComments, userComment);
    }

    @Override
    @MediaPropertyClear(value="ComponentUserComments")
    public void clearComponentUserComments() {
        this.componentUserComments = Collections.synchronizedList(new Vector());
    }

    @MediaListPrepend(value="ComponentUserComments")
    public void prependComponentUserComment(TaggedValue userComment) throws NullPointerException {
        if (userComment == null) {
            throw new NullPointerException("Cannot add a null user comment to this component.");
        }
        StrongReferenceVector.prepend(this.componentUserComments, userComment);
    }

    @Override
    @MediaProperty(uuid1=67567872, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ComponentDataDefinition", aliases={"DataDefinition"}, typeName="DataDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=513, symbol="ComponentDataDefinition")
    public DataDefinition getComponentDataDefinition() {
        return this.componentDataDefinition.getTarget();
    }

    @Override
    @MediaPropertySetter(value="ComponentDataDefinition")
    public void setComponentDataDefinition(DataDefinition componentDataDefinition) throws NullPointerException {
        if (componentDataDefinition == null) {
            throw new NullPointerException("Cannot set the data definition of this component with a null value.");
        }
        this.componentDataDefinition = new WeakReference<DataDefinition>(componentDataDefinition);
    }

    public static final DataDefinition initializeComponentDataDefinition() {
        return DataDefinitionImpl.forName("Unknown");
    }

    @MediaProperty(uuid1=50397712, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ComponentKLVData", aliases={"KLVData"}, typeName="KLVDataStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=515, symbol="ComponentKLVData")
    public List<KLVData> getComponentKLVData() throws PropertyNotPresentException {
        if (this.componentKLVData.size() == 0) {
            throw new PropertyNotPresentException("No KLV data values are present for this component.");
        }
        return StrongReferenceVector.getOptionalList(this.componentKLVData);
    }

    @Override
    @MediaListAppend(value="ComponentKLVData")
    public void appendComponentKLVData(KLVData klvData) throws NullPointerException {
        if (klvData == null) {
            throw new NullPointerException("Cannot add to the list of KLV data items with a null value.");
        }
        StrongReferenceVector.append(this.componentKLVData, klvData);
    }

    @Override
    @MediaPropertyCount(value="ComponentKLVData")
    public int countComponentKLVData() {
        return this.componentKLVData.size();
    }

    @Override
    @MediaPropertyRemove(value="ComponentKLVData")
    public void removeComponentKLVData(KLVData klvData) throws NullPointerException, PropertyNotPresentException, ObjectNotFoundException {
        if (klvData == null) {
            throw new NullPointerException("The given KLV data item is null and so cannot be removed from the list of KLV data items of the component.");
        }
        if (this.componentKLVData.size() == 0) {
            throw new PropertyNotPresentException("No KLV data values are present for this component.");
        }
        if (!this.componentKLVData.contains(klvData)) {
            throw new ObjectNotFoundException("The given KLV data item cannot be removed from the list of KLV data items of this component as it is not currently contained.");
        }
        StrongReferenceVector.remove(this.componentKLVData, klvData);
    }

    @MediaListPrepend(value="ComponentKLVData")
    public void prependComponentKLVData(KLVData klvData) throws NullPointerException {
        if (klvData == null) {
            throw new NullPointerException("Cannot prepend a null KLV data value to this component.");
        }
        StrongReferenceVector.prepend(this.componentKLVData, klvData);
    }

    @Override
    @MediaPropertyClear(value="ComponentKLVData")
    public void clearComponentKLVData() {
        this.componentKLVData = Collections.synchronizedList(new Vector());
    }

    @Override
    @MediaProperty(uuid1=117572097, uuid2=259, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ComponentLength", aliases={"Length"}, typeName="LengthType", optional=true, uniqueIdentifier=false, pid=514, symbol="ComponentLength")
    public long getComponentLength() throws BadPropertyException {
        if (!this.lengthPresent) {
            throw new BadPropertyException("The optional length property is not set in the current context of this component.");
        }
        return this.componentLength;
    }

    @Override
    public void setComponentLength(long componentLength) throws BadLengthException {
        if (componentLength < -1L) {
            throw new BadLengthException("Cannot set a negative length value for a component except in open MXF headers.");
        }
        this.componentLength = componentLength;
    }

    @MediaPropertySetter(value="ComponentLength")
    public void setComponentLengthFromStream(long componentLength) throws BadLengthException {
        if (componentLength < -1L) {
            throw new BadLengthException("Cannot set a negative length value for a component except in open MXF headers.");
        }
        this.lengthPresent = true;
        this.componentLength = componentLength;
    }

    @Override
    public boolean getLengthPresent() {
        return this.lengthPresent;
    }

    @Override
    public void setLengthPresent(boolean lengthPresent) {
        this.lengthPresent = lengthPresent;
    }

    @Override
    @MediaProperty(uuid1=1172384523, uuid2=-21475, uuid3=17326, uuid4={-99, -76, 54, -16, 101, -81, -61, -21}, definedName="Jupiter ID", symbol="Jupiter_ID", aliases={"Jupiter_ID"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public String getJupiterID() throws PropertyNotPresentException {
        if (this.jupiterID == null) {
            throw new PropertyNotPresentException("The optional Jupiter ID property is not present for this Quantel component.");
        }
        return this.jupiterID;
    }

    @Override
    @MediaPropertySetter(value="Jupiter ID")
    public void setJupiterID(String jupiterID) {
        this.jupiterID = jupiterID;
    }

    @Override
    @MediaProperty(uuid1=-1709905003, uuid2=-19950, uuid3=19729, uuid4={-68, 93, -78, -13, 107, 55, -70, 43}, definedName="Jupiter Clip Offset", symbol="Jupiter_Clip_Offset", aliases={"Jupiter_Clip_Offset"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getJupiterClipOffset() throws PropertyNotPresentException {
        if (this.jupiterClipOffset == null) {
            throw new PropertyNotPresentException("The optional jupiter clip offset property is not present for this Quantel component.");
        }
        return this.jupiterClipOffset;
    }

    @Override
    @MediaPropertySetter(value="Jupiter Clip Offset")
    public void setJupiterClipOffset(@Int32 Integer jupiterClipOffset) {
        this.jupiterClipOffset = jupiterClipOffset;
    }

    @Override
    @MediaProperty(uuid1=-19088744, uuid2=8807, uuid3=4563, uuid4={-118, 76, 0, 80, 4, 14, -9, -46}, definedName="EditName", symbol="EditName", aliases={"EditName"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public String getEditName() throws PropertyNotPresentException {
        if (this.editName == null) {
            throw new PropertyNotPresentException("The optional edit name property is not present for thie Quantel component.");
        }
        return this.editName;
    }

    @Override
    @MediaPropertySetter(value="EditName")
    public void setEditName(String editName) {
        this.editName = editName;
    }

    @Override
    public String getComment() {
        return "local component persistent id: " + this.getPersistentID();
    }

    @Override
    public Component clone() {
        return (Component)super.clone();
    }
}

