/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.io.aaf.AAFConstants;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinitionWeakObjectReference;
import tv.amwa.maj.meta.impl.ClassDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionObjectReferenceImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=518, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionWeakObjectReference", description="The TypeDefinitionWeakObjectReference class defines a property type that defines an object relationship where the target of the weak reference is referenced by the object with the property with the TypeDefinitionWeakObjectReference type.", symbol="TypeDefinitionWeakObjectReference")
public final class TypeDefinitionWeakObjectReferenceImpl
extends TypeDefinitionObjectReferenceImpl
implements TypeDefinitionWeakObjectReference,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1790614459668387476L;
    private AUID[] targetSet;

    protected TypeDefinitionWeakObjectReferenceImpl() {
    }

    public TypeDefinitionWeakObjectReferenceImpl(AUID identification, @AAFString String typeName, ClassDefinition objectType, AUID[] targetSet) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a weak object reference type definition using a null identification.");
        }
        if (objectType == null) {
            throw new NullPointerException("Cannot create a weak object reference type definition using a null object type.");
        }
        if (targetSet == null) {
            throw new NullPointerException("Cannot create a weak object reference type definition using a null target set.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
        this.setReferencedType(objectType);
        this.setTargetSet(targetSet);
    }

    @MediaProperty(uuid1=100729095, uuid2=2560, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="WeakReferencedType", aliases={"ReferencedType"}, typeName="ClassDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=18, symbol="WeakReferencedType")
    public ClassDefinition getReferencedType() {
        return this.getObjectType();
    }

    @Override
    @MediaPropertySetter(value="WeakReferencedType")
    public void setReferencedType(ClassDefinition referencedType) {
        super.setReferencedType(referencedType);
    }

    public static final ClassDefinition initializeWeakReferencedType() {
        return Warehouse.lookForClass(DataDefinition.class);
    }

    @Override
    @MediaProperty(uuid1=50397699, uuid2=2816, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="TargetSet", aliases={"ReferenceTargetSet", "TargetList"}, typeName="AUIDArray", optional=false, uniqueIdentifier=false, pid=19, symbol="TargetSet")
    public AUID[] getTargetSet() {
        return (AUID[])this.targetSet.clone();
    }

    @MediaPropertySetter(value="TargetSet")
    public void setTargetSet(AUID[] targetSet) throws NullPointerException {
        if (targetSet == null) {
            throw new NullPointerException("Cannot set the target set of a weak object reference to a null value.");
        }
        this.targetSet = new AUID[targetSet.length];
        for (int x = 0; x < targetSet.length; ++x) {
            this.targetSet[x] = targetSet[x].clone();
        }
    }

    public static final AUID[] initializeTargetSet() {
        return new AUID[0];
    }

    @Override
    public PropertyValue createValue(Object javaValue) throws ClassCastException {
        if (javaValue == null) {
            return new TypeDefinitionObjectReferenceImpl.ObjectReferenceValue(this, null);
        }
        if (javaValue instanceof TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue) {
            return (TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue)javaValue;
        }
        if (javaValue instanceof String) {
            try {
                Method forName = this.getReferencedType().getJavaImplementation().getMethod("forName", String.class);
                javaValue = forName.invoke(null, (String)javaValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (javaValue instanceof AUID) {
            return new TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue(this, (AUID)javaValue);
        }
        return super.createValue(javaValue);
    }

    @Override
    public TypeCategory getTypeCategory() {
        return TypeCategory.WeakObjRef;
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionWeakObjectReference");
        super.appendMetadictXML(typeElement, namespace, prefix);
        XMLBuilder.appendElement((Node)typeElement, namespace, prefix, "ReferencedType", this.getReferencedType().getName());
        Element targets = XMLBuilder.createChild(typeElement, namespace, prefix, "TargetSet");
        for (AUID id : this.targetSet) {
            PropertyDefinition targetProperty = ClassDefinitionImpl.globalPropertyIDLookup(id);
            if (targetProperty != null) {
                XMLBuilder.appendElement((Node)targets, namespace, prefix, "MetaDefRef", targetProperty.getName());
            }
            if (id.equals(AAFConstants.RootMetaDictionaryProperty)) {
                XMLBuilder.appendElement((Node)targets, namespace, prefix, "MetaDefRef", "MetaDictionary");
            }
            if (!id.equals(AAFConstants.RootPrefaceProperty)) continue;
            XMLBuilder.appendElement((Node)targets, namespace, prefix, "MetaDefRef", "Preface");
        }
    }

    @Override
    public TypeDefinitionWeakObjectReference clone() {
        return (TypeDefinitionWeakObjectReference)super.clone();
    }
}

