/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.BadTypeException;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListInsertAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionCharacter;
import tv.amwa.maj.meta.TypeDefinitionEnumeration;
import tv.amwa.maj.meta.TypeDefinitionExtendibleEnumeration;
import tv.amwa.maj.meta.TypeDefinitionFixedArray;
import tv.amwa.maj.meta.TypeDefinitionInteger;
import tv.amwa.maj.meta.TypeDefinitionObjectReference;
import tv.amwa.maj.meta.TypeDefinitionRecord;
import tv.amwa.maj.meta.TypeDefinitionStrongObjectReference;
import tv.amwa.maj.meta.TypeDefinitionVariableArray;
import tv.amwa.maj.meta.impl.MethodBag;
import tv.amwa.maj.meta.impl.PropertyDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionObjectReferenceImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.util.Utilities;

@MediaClass(uuid1=0xD010101, uuid2=521, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionVariableArray", description="The TypeDefinitionVariableArray class defines a property type that has a varying number of values of the underlying type. The order of the values is meaningful.", symbol="TypeDefinitionVariableArray")
public final class TypeDefinitionVariableArrayImpl
extends TypeDefinitionImpl
implements TypeDefinitionVariableArray,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = 8075771349769610773L;
    private WeakReference<TypeDefinition> variableArrayElementType;

    protected TypeDefinitionVariableArrayImpl() {
    }

    public TypeDefinitionVariableArrayImpl(AUID identification, @AAFString String typeName, TypeDefinition elementType) throws NullPointerException, IllegalArgumentException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new variable size array type definition with a null identification.");
        }
        if (elementType == null) {
            throw new NullPointerException("Cannot create a new variable size array type definition with a null element type.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
        this.setElementType(elementType);
    }

    @Override
    public void appendElement(PropertyValue arrayProperty, PropertyValue element) throws NullPointerException, IllegalPropertyValueException, BadTypeException {
        Object value;
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot append to null variable size array value.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value type does not match this variable size array property definition.");
        }
        if (element == null) {
            throw new NullPointerException("Cannot append a null element to a variable size array value.");
        }
        if (!this.variableArrayElementType.equals(element.getType())) {
            throw new BadTypeException("The element type of the variable size array value does not match the type of the element to append.");
        }
        Object object = value = element instanceof TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue ? element : element.getValue();
        if (arrayProperty.getValue() == null) {
            List<Object> values = Collections.synchronizedList(new Vector(1));
            values.add(value);
            ((VariableArrayValue)arrayProperty).setValue(values);
        } else {
            ((VariableArrayValue)arrayProperty).getValue().add(value);
        }
    }

    @Override
    public PropertyValue createEmptyValue() {
        return new VariableArrayValue(this, Collections.synchronizedList(new Vector()));
    }

    @Override
    public PropertyValue createValueFromArray(Object[] initialData) throws ClassCastException {
        if (initialData == null) {
            return new VariableArrayValue(this, null);
        }
        List<Object> values = Collections.synchronizedList(new Vector());
        for (int x = 0; x < initialData.length; ++x) {
            this.variableArrayElementType.getTarget().createValue(initialData[x]);
            values.add(initialData[x]);
        }
        return new VariableArrayValue(this, values);
    }

    @Override
    public PropertyValue createValueFromList(List<Object> initialData) {
        if (initialData == null) {
            return new VariableArrayValue(this, null);
        }
        for (Object element : initialData) {
            this.variableArrayElementType.getTarget().createValue(element);
        }
        List<Object> values = Collections.synchronizedList(new Vector<Object>(initialData));
        return new VariableArrayValue(this, values);
    }

    @Override
    public PropertyValue createValueFromValues(PropertyValue[] elementValues) throws BadTypeException {
        if (elementValues == null) {
            return new VariableArrayValue(this, null);
        }
        for (PropertyValue value : elementValues) {
            if (this.variableArrayElementType.equals(value.getType())) continue;
            throw new BadTypeException("At least one of the elements of the given property values array does not match the element type of this variable size array type definition.");
        }
        List<Object> values = Collections.synchronizedList(new Vector());
        for (int x = 0; x < elementValues.length; ++x) {
            values.add(elementValues[x].getValue());
        }
        return new VariableArrayValue(this, values);
    }

    @Override
    public int getCount(PropertyValue arrayProperty) throws NullPointerException, IllegalPropertyValueException {
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot count the number of elements in a null variable size array property value.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value type does not match this variable size array property definition.");
        }
        Object values = ((VariableArrayValue)arrayProperty).getValue();
        if (values == null) {
            return 0;
        }
        return values.size();
    }

    @Override
    public PropertyValue getElementValue(PropertyValue arrayProperty, int index) throws NullPointerException, IllegalPropertyValueException, IndexOutOfBoundsException, ClassCastException {
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot retrieve an element from a null variable size array.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value type does not match this variable size array property definition.");
        }
        Object variableArray = ((VariableArrayValue)arrayProperty).getValue();
        if (variableArray == null) {
            throw new IndexOutOfBoundsException("The variable array value is representing a not present value (null).");
        }
        try {
            if (TypeDefinitions.UTF16StringArray.equals(this)) {
                return TypeDefinitions.UTF16String.createValue(variableArray.get(index));
            }
            return this.variableArrayElementType.getTarget().createValue(variableArray.get(index));
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for the given variable size array.");
        }
    }

    @Override
    public List<PropertyValue> getElements(PropertyValue arrayProperty) throws NullPointerException, IllegalPropertyValueException {
        Vector<PropertyValue> elementValues;
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot retrieve the elements of a null variable size array.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value type does not match this variable size array property definition.");
        }
        Object arrayValue = ((VariableArrayValue)arrayProperty).getValue();
        if (arrayValue != null) {
            elementValues = new Vector(arrayValue.size());
            Iterator iterator = arrayValue.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (TypeDefinitions.UTF16StringArray.equals(this)) {
                    elementValues.add(TypeDefinitions.UTF16String.createValue(value));
                    continue;
                }
                elementValues.add(this.variableArrayElementType.getTarget().createValue(value));
            }
        } else {
            elementValues = new Vector<PropertyValue>();
        }
        return elementValues;
    }

    @Override
    public Object[] getArray(PropertyValue arrayProperty) throws NullPointerException, IllegalPropertyValueException {
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot retrieve the elements of a null variable size array.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value type does not match this variable size array property definition.");
        }
        Object valueList = ((VariableArrayValue)arrayProperty).getValue();
        return valueList.toArray();
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=3328, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="VariableArrayElementType", aliases={"ElementType"}, typeName="TypeDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=25, symbol="VariableArrayElementType")
    public TypeDefinition getType() {
        return this.variableArrayElementType.getTarget();
    }

    @MediaPropertySetter(value="VariableArrayElementType")
    public void setElementType(TypeDefinition elementType) throws NullPointerException, IllegalArgumentException {
        if (elementType == null) {
            throw new NullPointerException("Cannot set the element type of this variable size array type definition using a null value.");
        }
        if (!(elementType instanceof TypeDefinitionInteger || elementType instanceof TypeDefinitionRecord || elementType instanceof TypeDefinitionEnumeration || elementType instanceof TypeDefinitionExtendibleEnumeration || elementType instanceof TypeDefinitionFixedArray || elementType instanceof TypeDefinitionObjectReference || elementType instanceof TypeDefinitionCharacter)) {
            throw new IllegalArgumentException("Cannot set the element type of this variable size array type definition to the given element type.");
        }
        this.variableArrayElementType = new WeakReference<TypeDefinition>(elementType);
    }

    public static final TypeDefinition initializeVariableArrayElementType() {
        return TypeDefinitions.Int32;
    }

    @Override
    public void insertElement(PropertyValue arrayProperty, int index, PropertyValue element) throws NullPointerException, IllegalPropertyValueException, IndexOutOfBoundsException, BadTypeException {
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot insert an element into a null variable size array.");
        }
        if (element == null) {
            throw new NullPointerException("Cannot insert a null propery value into a variable size array.");
        }
        if (arrayProperty.getValue() == null) {
            throw new NullPointerException("Cannot insert a value into a null-valued variable sized array. Use appendElement() or prependElement() instead.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value type does not match this variable size array property definition.");
        }
        if (!this.variableArrayElementType.equals(element.getType())) {
            throw new BadTypeException("The given element cannot be inserted into the variable size array because its type does not match the element type.");
        }
        Object value = element instanceof TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue ? element : element.getValue();
        try {
            ((VariableArrayValue)arrayProperty).getValue().add(index, value);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("The given index for element insertion is outside the acceptable range for the given variable size array.");
        }
    }

    @Override
    public void prependElement(PropertyValue arrayProperty, PropertyValue element) throws NullPointerException, IllegalPropertyValueException, BadTypeException {
        Object value;
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot insert an element into a null variable size array.");
        }
        if (element == null) {
            throw new NullPointerException("Cannot prepend a null propery value into a variable size array.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value type does not match this variable size array property definition.");
        }
        if (!this.variableArrayElementType.equals(element.getType())) {
            throw new BadTypeException("The given element cannot be prepended into the variable size array because its type does not match the element type.");
        }
        Object object = value = element instanceof TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue ? element : element.getValue();
        if (arrayProperty.getValue() == null) {
            List<Object> values = Collections.synchronizedList(new Vector(1));
            values.add(value);
            ((VariableArrayValue)arrayProperty).setValue(values);
        } else {
            ((VariableArrayValue)arrayProperty).getValue().add(0, value);
        }
    }

    @Override
    public void removeElement(PropertyValue arrayProperty, int index) throws NullPointerException, IllegalPropertyValueException, IndexOutOfBoundsException {
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot remove an element from a null variable size array.");
        }
        if (arrayProperty.getValue() == null) {
            throw new NullPointerException("Cannot remove an element from a null-valued variable size array.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value type does not match this variable size array property definition.");
        }
        try {
            ((VariableArrayValue)arrayProperty).getValue().remove(index);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for the given variable size array.");
        }
    }

    @Override
    public void setElementAt(PropertyValue arrayProperty, int index, PropertyValue element) throws NullPointerException, IllegalPropertyValueException, IndexOutOfBoundsException, BadTypeException {
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot replace an element from a null variable size array.");
        }
        if (element == null) {
            throw new NullPointerException("Cannot replace a value in a variable size array with a null propery value.");
        }
        if (arrayProperty.getValue() == null) {
            throw new NullPointerException("Cannot set an element at the given index in a null-valued variable sized array property value.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value type does not match this variable size array property definition.");
        }
        if (!this.variableArrayElementType.equals(element.getType())) {
            throw new BadTypeException("The given property value to use to replace an existing property if of a type that does not match the underlying element type of this variable size array type definition.");
        }
        Object value = element instanceof TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue ? element : element.getValue();
        try {
            ((VariableArrayValue)arrayProperty).getValue().set(index, value);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for the given variable size array.");
        }
    }

    @Override
    public void setArray(PropertyValue arrayProperty, Object[] data) throws NullPointerException, IllegalPropertyValueException, ClassCastException {
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot set the value of a null variable size array.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value type does not match this variable size array property definition.");
        }
        if (data == null) {
            ((VariableArrayValue)arrayProperty).setValue(null);
        } else {
            ((VariableArrayValue)arrayProperty).setValue((List)((VariableArrayValue)this.createValue(data)).getValue());
        }
    }

    @Override
    public void setArray(PropertyValue arrayProperty, List<Object> data) throws NullPointerException, IllegalPropertyValueException, ClassCastException {
        if (arrayProperty == null) {
            throw new NullPointerException("Cannot set the value of a null variable size array.");
        }
        if (!this.equals(arrayProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value type does not match this variable size array property definition.");
        }
        if (data == null) {
            ((VariableArrayValue)arrayProperty).setValue(null);
        } else {
            ((VariableArrayValue)arrayProperty).setValue((List)((VariableArrayValue)this.createValue(data)).getValue());
        }
    }

    @Override
    public PropertyValue createValue(Object javaValue) throws ClassCastException {
        if (javaValue == null) {
            return new VariableArrayValue(this, null);
        }
        if (this.getName().equals("DataValue") && javaValue instanceof String) {
            javaValue = (Vector<Object>)Utilities.hexStringToBytes((String)((Object)javaValue));
        }
        List<Object> values = Collections.synchronizedList(new Vector());
        if (javaValue.getClass().isArray()) {
            Vector<Object> objectList = new Vector<Object>(Array.getLength(javaValue));
            for (int u = 0; u < Array.getLength(javaValue); ++u) {
                objectList.add(Array.get(javaValue, u));
            }
            javaValue = objectList;
        }
        if (javaValue instanceof Collection) {
            for (Object item : (Collection)javaValue) {
                if (item instanceof PropertyValue) {
                    if (!((PropertyValue)item).getType().equals(this.variableArrayElementType)) {
                        throw new ClassCastException("An element of the given collection to create a new variable array with has a type that does not match the property type of this variable array type definition.");
                    }
                    values.add(((PropertyValue)item).getValue());
                    continue;
                }
                if (TypeDefinitions.UTF16StringArray.equals(this)) {
                    TypeDefinitions.UTF16String.createValue(item);
                } else {
                    this.variableArrayElementType.getTarget().createValue(item);
                }
                values.add(item);
            }
        } else if (javaValue instanceof PropertyValue) {
            if (!((PropertyValue)((Object)javaValue)).getType().equals(this.variableArrayElementType)) {
                throw new ClassCastException("The given property value to make a new variable array with has a type that does not match the property type of this variable array type definition.");
            }
            values.add(((PropertyValue)((Object)javaValue)).getValue());
        } else {
            this.variableArrayElementType.getTarget().createValue(javaValue);
            values.add(javaValue);
        }
        return new VariableArrayValue(this, values);
    }

    @Override
    public TypeCategory getTypeCategory() {
        return TypeCategory.VariableArray;
    }

    @Override
    MethodBag makeMethodBag(Method getter, Method[] candidateMethods, String propertyName) {
        return new VariableArrayMethodBag(getter, candidateMethods, propertyName);
    }

    @Override
    public void setPropertyValue(MetadataObject metadataObject, PropertyDefinition property, PropertyValue value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        VariableArrayMethodBag methods = (VariableArrayMethodBag)((PropertyDefinitionImpl)property).getMethodBag();
        if (methods.hasSetter()) {
            methods.set(metadataObject, value.getValue());
            return;
        }
        methods.clear(metadataObject);
        Iterator iterator = ((VariableArrayValue)value).getValue().iterator();
        while (iterator.hasNext()) {
            Object nextElement = iterator.next();
            methods.append(metadataObject, nextElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) throws EndOfDataException {
        PropertyValue arrayValue = this.createEmptyValue();
        try {
            int setCount = buffer.getInt();
            int elementSize = buffer.getInt();
            if (this.equals(TypeDefinitions.UInt8Array) && elementSize > 1) {
                setCount = elementSize;
                elementSize = 1;
            }
            for (int u = 0; u < setCount; ++u) {
                int preservedLimit = buffer.limit();
                try {
                    buffer.limit(buffer.position() + elementSize);
                    PropertyValue elementValue = this.variableArrayElementType.getTarget().createFromBytes(buffer);
                    this.appendElement(arrayValue, elementValue);
                    continue;
                }
                finally {
                    buffer.limit(preservedLimit);
                }
            }
        }
        catch (BufferUnderflowException bue) {
            throw new EndOfDataException("Reached the end of the buffer before a variable array was written. Buffer underflow exception: " + bue.getMessage());
        }
        return arrayValue;
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        super.lengthAsBytes(value);
        long length = 8L;
        if (this.getCount(value) == 0) {
            return length;
        }
        PropertyValue sampleElement = null;
        Iterator<PropertyValue> iterator = this.getElements(value).iterator();
        if (iterator.hasNext()) {
            PropertyValue temporaryElement;
            sampleElement = temporaryElement = iterator.next();
        }
        return length += sampleElement.getType().lengthAsBytes(sampleElement) * (long)this.getCount(value);
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        if ((long)buffer.remaining() < this.lengthAsBytes(value)) {
            throw new InsufficientSpaceException("Insufficient space to write the given variable array value to the given buffer.");
        }
        int count = this.getCount(value);
        buffer.putInt(count);
        if (count == 0) {
            buffer.putInt(16);
            return null;
        }
        PropertyValue sampleElement = null;
        Iterator<PropertyValue> iterator = this.getElements(value).iterator();
        if (iterator.hasNext()) {
            PropertyValue temporaryElement;
            sampleElement = temporaryElement = iterator.next();
        }
        buffer.putInt((int)sampleElement.getType().lengthAsBytes(sampleElement));
        Vector<PropertyValue> arrayStrongReferences = new Vector<PropertyValue>(count);
        for (PropertyValue elementValue : this.getElements(value)) {
            elementValue.getType().writeAsBytes(elementValue, buffer);
            if (!(elementValue.getType() instanceof TypeDefinitionStrongObjectReference)) continue;
            arrayStrongReferences.add(elementValue);
        }
        return arrayStrongReferences;
    }

    @Override
    public boolean resolveReferences(PropertyValue value, Map<AUID, MetadataObject> referenceMap) throws NullPointerException, IllegalPropertyValueException {
        super.resolveReferences(value, referenceMap);
        boolean allResolved = true;
        Object setValue = ((VariableArrayValue)value).getValue();
        Vector elements = new Vector(setValue);
        for (int x = 0; x < elements.size(); ++x) {
            if (!(elements.get(x) instanceof TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue)) continue;
            TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue unresolvedReference = (TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue)elements.get(x);
            if (referenceMap.containsKey(unresolvedReference.getValue())) {
                setValue.remove(x);
                setValue.add(x, referenceMap.get(unresolvedReference.getValue()));
                continue;
            }
            System.err.println("Unable to resolve reference " + unresolvedReference.getValue().toString() + " for a varialbe array.");
            allResolved = false;
        }
        return allResolved;
    }

    @Override
    public String nameToAAFName(String name) {
        if (this.getType() instanceof TypeDefinitionObjectReference) {
            return "kAAFTypeID_" + super.nameToAAFName(name);
        }
        return "aaf" + super.nameToAAFName(name);
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionVariableArray");
        super.appendMetadictXML(typeElement, namespace, prefix);
        XMLBuilder.appendElement((Node)typeElement, namespace, prefix, "ElementType", this.variableArrayElementType.getTarget().getName());
    }

    @Override
    public TypeDefinitionVariableArray clone() {
        return (TypeDefinitionVariableArray)super.clone();
    }

    public static class VariableArrayValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionVariableArrayImpl type;
        private List<Object> value;

        private VariableArrayValue(TypeDefinitionVariableArrayImpl type, List<Object> propertyValue) {
            this.type = type;
            this.setValue(propertyValue);
        }

        @Override
        public TypeDefinitionImpl getType() {
            return this.type;
        }

        @Override
        public List<Object> getValue() {
            return this.value;
        }

        public boolean isDefinedType() {
            return true;
        }

        private void setValue(List<Object> value) {
            this.value = value;
        }
    }

    public static class VariableArrayMethodBag
    extends MethodBag {
        private Method append = null;
        private Method prepend = null;
        private Method count = null;
        private Method insertAt = null;
        private Method removeAt = null;
        private Method getAt = null;
        private Method setter = null;
        private Method clear = null;

        public VariableArrayMethodBag(Method getter, Method[] candidateMethods, String propertyName) {
            super(getter, candidateMethods, propertyName);
            for (Method candidate : candidateMethods) {
                MediaListAppend appendCandidate = candidate.getAnnotation(MediaListAppend.class);
                if (appendCandidate != null && appendCandidate.value().equals(propertyName)) {
                    this.append = candidate;
                    continue;
                }
                MediaListPrepend prependCandidate = candidate.getAnnotation(MediaListPrepend.class);
                if (prependCandidate != null && prependCandidate.value().equals(propertyName)) {
                    this.prepend = candidate;
                    continue;
                }
                MediaPropertyCount countCandidate = candidate.getAnnotation(MediaPropertyCount.class);
                if (countCandidate != null && countCandidate.value().equals(propertyName)) {
                    this.count = candidate;
                    continue;
                }
                MediaListInsertAt insertAtCandidate = candidate.getAnnotation(MediaListInsertAt.class);
                if (insertAtCandidate != null && insertAtCandidate.value().equals(propertyName)) {
                    this.insertAt = candidate;
                    continue;
                }
                MediaListRemoveAt removeAtCandidate = candidate.getAnnotation(MediaListRemoveAt.class);
                if (removeAtCandidate != null && removeAtCandidate.value().equals(propertyName)) {
                    this.removeAt = candidate;
                    continue;
                }
                MediaListGetAt getAtCandidate = candidate.getAnnotation(MediaListGetAt.class);
                if (getAtCandidate != null && getAtCandidate.value().equals(propertyName)) {
                    this.getAt = candidate;
                    continue;
                }
                MediaPropertySetter setterCandidate = candidate.getAnnotation(MediaPropertySetter.class);
                if (setterCandidate != null && setterCandidate.value().equals(propertyName)) {
                    this.setter = candidate;
                    continue;
                }
                MediaPropertyClear clearCandidate = candidate.getAnnotation(MediaPropertyClear.class);
                if (clearCandidate == null || !clearCandidate.value().equals(propertyName)) continue;
                this.clear = candidate;
            }
        }

        public void append(MetadataObject metadataObject, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.append.invoke((Object)metadataObject, value);
        }

        public void prepend(MetadataObject metadataObject, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.prepend.invoke((Object)metadataObject, value);
        }

        public int count(MetadataObject metadataObject) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return (Integer)this.count.invoke((Object)metadataObject, new Object[0]);
        }

        public void insertAt(MetadataObject metadataObject, int index, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.insertAt.invoke((Object)metadataObject, index, value);
        }

        public void removeAt(MetadataObject metadataObject, int index) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.removeAt.invoke((Object)metadataObject, index);
        }

        public Object getAt(MetadataObject metadataObject, int index) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return this.getAt.invoke((Object)metadataObject, index);
        }

        public boolean hasSetter() {
            return this.setter != null;
        }

        public void set(MetadataObject metadataObject, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Class<?> parameterType = this.setter.getParameterTypes()[0];
            Class<?> componentType = parameterType.getComponentType();
            if (parameterType.isArray() && value instanceof List) {
                if (componentType.isPrimitive()) {
                    if (componentType.equals(Byte.TYPE)) {
                        List byteList = (List)value;
                        byte[] byteValues = new byte[byteList.size()];
                        for (int x = 0; x < byteValues.length; ++x) {
                            byteValues[x] = (Byte)byteList.get(x);
                        }
                        this.setter.invoke((Object)metadataObject, new Object[]{byteValues});
                        return;
                    }
                    if (componentType.equals(Short.TYPE)) {
                        List shortList = (List)value;
                        short[] shortValues = new short[shortList.size()];
                        for (int x = 0; x < shortValues.length; ++x) {
                            shortValues[x] = (Short)shortList.get(x);
                        }
                        this.setter.invoke((Object)metadataObject, new Object[]{shortValues});
                        return;
                    }
                    if (componentType.equals(Integer.TYPE)) {
                        List intList = (List)value;
                        int[] intValues = new int[intList.size()];
                        for (int x = 0; x < intValues.length; ++x) {
                            intValues[x] = (Integer)intList.get(x);
                        }
                        this.setter.invoke((Object)metadataObject, new Object[]{intValues});
                        return;
                    }
                    if (componentType.equals(Long.TYPE)) {
                        List longList = (List)value;
                        long[] longValues = new long[longList.size()];
                        for (int x = 0; x < longValues.length; ++x) {
                            longValues[x] = (Long)longList.get(x);
                        }
                        this.setter.invoke((Object)metadataObject, new Object[]{longValues});
                        return;
                    }
                    if (componentType.equals(Boolean.TYPE)) {
                        List booleanList = (List)value;
                        boolean[] booleanValues = new boolean[booleanList.size()];
                        for (int x = 0; x < booleanValues.length; ++x) {
                            booleanValues[x] = (Boolean)booleanList.get(x);
                        }
                        this.setter.invoke((Object)metadataObject, new Object[]{booleanValues});
                        return;
                    }
                    if (componentType.equals(Character.TYPE)) {
                        List charList = (List)value;
                        char[] charValues = new char[charList.size()];
                        for (int x = 0; x < charValues.length; ++x) {
                            charValues[x] = ((Character)charList.get(x)).charValue();
                        }
                        this.setter.invoke((Object)metadataObject, new Object[]{charValues});
                        return;
                    }
                    if (componentType.equals(Float.TYPE)) {
                        List floatList = (List)value;
                        float[] floatValues = new float[floatList.size()];
                        for (int x = 0; x < floatValues.length; ++x) {
                            floatValues[x] = ((Byte)floatList.get(x)).byteValue();
                        }
                        this.setter.invoke((Object)metadataObject, new Object[]{floatValues});
                        return;
                    }
                    if (componentType.equals(Double.TYPE)) {
                        List doubleList = (List)value;
                        double[] doubleValues = new double[doubleList.size()];
                        for (int x = 0; x < doubleValues.length; ++x) {
                            doubleValues[x] = ((Byte)doubleList.get(x)).byteValue();
                        }
                        this.setter.invoke((Object)metadataObject, new Object[]{doubleValues});
                        return;
                    }
                }
                value = ((Collection)value).toArray((Object[])Array.newInstance(componentType, 0));
            }
            if (parameterType.equals(ByteBuffer.class) && value instanceof List) {
                List byteList = (List)value;
                byte[] byteValues = new byte[byteList.size()];
                for (int x = 0; x < byteValues.length; ++x) {
                    byteValues[x] = (Byte)byteList.get(x);
                }
                this.setter.invoke((Object)metadataObject, ByteBuffer.wrap(byteValues));
                return;
            }
            this.setter.invoke((Object)metadataObject, new Object[]{value});
        }

        public void clear(MetadataObject metadataObject) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.clear == null) {
                System.err.println("Unable to call clear method for varaible array property " + this.getPropertyName() + ".");
            } else {
                this.clear.invoke((Object)metadataObject, new Object[0]);
            }
        }

        public String getAppendName() {
            if (this.append == null) {
                return null;
            }
            return this.append.getName();
        }

        public String getClearName() {
            if (this.clear == null) {
                return null;
            }
            return this.clear.getName();
        }

        public String getCountName() {
            if (this.count == null) {
                return null;
            }
            return this.count.getName();
        }

        public String getPrependName() {
            if (this.prepend == null) {
                return null;
            }
            return this.prepend.getName();
        }

        public String getInsertAtName() {
            if (this.insertAt == null) {
                return null;
            }
            return this.insertAt.getName();
        }

        public String getRemoveAtName() {
            if (this.removeAt == null) {
                return null;
            }
            return this.removeAt.getName();
        }

        public String getGetAtName() {
            if (this.getAt == null) {
                return null;
            }
            return this.getAt.getName();
        }

        public String getSetterName() {
            if (this.setter == null) {
                return null;
            }
            return this.setter.getName();
        }
    }
}

