/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.BadTypeException;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionRecord;
import tv.amwa.maj.meta.impl.SingletonTypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.DateStruct;
import tv.amwa.maj.record.PackageID;
import tv.amwa.maj.record.ProductVersion;
import tv.amwa.maj.record.RGBAComponent;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.TimeStamp;
import tv.amwa.maj.record.TimeStruct;
import tv.amwa.maj.record.VersionType;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.record.impl.DateStructImpl;
import tv.amwa.maj.record.impl.PackageIDImpl;
import tv.amwa.maj.record.impl.ProductVersionImpl;
import tv.amwa.maj.record.impl.RGBAComponentImpl;
import tv.amwa.maj.record.impl.RationalImpl;
import tv.amwa.maj.record.impl.TimeStampImpl;
import tv.amwa.maj.record.impl.TimeStructImpl;
import tv.amwa.maj.record.impl.VersionTypeImpl;

@MediaClass(uuid1=0xD010101, uuid2=525, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionRecord", description="The TypeDefinitionRecord class defines a property type that consists of an ordered set of fields, where each field has a name and type.", symbol="TypeDefinitionRecord")
public final class TypeDefinitionRecordImpl
extends SingletonTypeDefinitionImpl
implements TypeDefinitionRecord,
Serializable,
Cloneable {
    private static final long serialVersionUID = -2858335381258759227L;
    private static final Map<Class<?>, Class<?>> majImplementations = new HashMap(10);
    private String[] memberNames;
    private Map<String, TypeDefinition> memberTypes;
    private Class<?> specification;
    private Class<?> implementation;

    public static final void registerInterfaceMapping(Class<?> recordTypeInterface, Class<?> recordTypeImplementation) throws NullPointerException, IllegalArgumentException {
        if (recordTypeImplementation == null || recordTypeInterface == null) {
            throw new NullPointerException("Cannot register record type interface or implementation with a null value.");
        }
        if (!recordTypeInterface.isInterface()) {
            throw new IllegalArgumentException("The record type interface must be an interface.");
        }
        if (recordTypeImplementation.isInterface()) {
            throw new IllegalArgumentException("The recond type implementation must be a member class.");
        }
        if (!recordTypeInterface.isAssignableFrom(recordTypeImplementation)) {
            throw new IllegalArgumentException("The given record type implementation does not implement the given interface.");
        }
        majImplementations.put(recordTypeInterface, recordTypeImplementation);
    }

    protected TypeDefinitionRecordImpl() {
    }

    public TypeDefinitionRecordImpl(AUID identification, @AAFString String typeName, @AAFString String[] names, Map<String, TypeDefinition> elements, Class<?> specification) throws NullPointerException, IllegalArgumentException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new record type definition with a null identifier.");
        }
        if (names == null) {
            throw new NullPointerException("Cannot create a new record type definition with a null member names array.");
        }
        if (elements == null) {
            throw new NullPointerException("Cannpt create a new record type definition with a null member name to member type map.");
        }
        if (specification == null) {
            throw new NullPointerException("Cannot create a new record type definition with a null Java specification.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
        this.setMembers(names, elements);
        this.setSpecification(specification);
    }

    public TypeDefinitionRecordImpl(AUID identification, @AAFString String typeName, @AAFString String[] names, TypeDefinition[] types, Class<?> specification) throws NullPointerException, IndexOutOfBoundsException, IllegalArgumentException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new record type definition with a null identifier.");
        }
        if (names == null) {
            throw new NullPointerException("Cannot create a new record type definition with a null member names array.");
        }
        if (types == null) {
            throw new NullPointerException("Cannpt create a new record type definition with a null types array.");
        }
        if (specification == null) {
            throw new NullPointerException("Cannot create a new record type definition with a null Java specification.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
        this.setMembers(names, types);
        this.setSpecification(specification);
    }

    @MediaProperty(uuid1=50397699, uuid2=1536, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="MemberNames", typeName="UTF16StringArray", optional=false, uniqueIdentifier=false, pid=29, symbol="MemberNames")
    public final String[] getMemberNames() {
        return (String[])this.memberNames.clone();
    }

    public static final String[] initializeMemberNames() {
        return new String[0];
    }

    @MediaPropertyClear(value="MemberNames")
    public void clearMemberNames() {
    }

    @MediaListAppend(value="MemberNames")
    public void appendMemberName(String memberName) {
    }

    @MediaProperty(uuid1=100729095, uuid2=4352, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="MemberTypes", typeName="TypeDefinitionWeakReferenceVector", optional=false, uniqueIdentifier=false, pid=28, symbol="MemberTypes")
    public final List<TypeDefinition> getMemberTypes() {
        Vector<TypeDefinition> types = new Vector<TypeDefinition>();
        for (int x = 0; x < this.memberNames.length; ++x) {
            types.add(this.memberTypes.get(this.memberNames[x]));
        }
        return types;
    }

    public static final List<TypeDefinition> initializeMemberTypes() {
        return new ArrayList<TypeDefinition>();
    }

    @MediaPropertyClear(value="MemberTypes")
    public void clearMemberTypes() {
    }

    @MediaListAppend(value="MemberTypes")
    public void appendMemberName(TypeDefinition memberType) {
    }

    void setMembers(String[] memberNames, Map<String, TypeDefinition> memberTypes) throws NullPointerException, IllegalArgumentException {
        if (memberNames == null) {
            throw new NullPointerException("Cannot set the member names of this record type definition with a null string array.");
        }
        if (memberTypes == null) {
            throw new NullPointerException("Cannot set the member types of this record type definition with a null name to type map.");
        }
        for (String memberName : memberNames) {
            if (memberName == null) {
                throw new NullPointerException("Cannot set the member names of this record type definition with a null member name.");
            }
            if (memberTypes.containsKey(memberName)) continue;
            throw new IllegalArgumentException("Could not set the members of this record type definition as a type definition for member " + memberName + " could not be found in the given map.");
        }
        for (int x = 0; x < memberNames.length; ++x) {
            for (int y = x + 1; y < memberNames.length; ++y) {
                if (!memberNames[x].equals(memberNames[y])) continue;
                throw new IllegalArgumentException("Cannot set the member names of this record using an array containing duplicate names.");
            }
        }
        block6: for (TypeDefinition type : memberTypes.values()) {
            switch (type.getTypeCategory()) {
                case Int: 
                case Record: 
                case Enum: 
                case ExtEnum: 
                case FixedArray: {
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Cannot set the member types of this record using a type definition that is not permitted for records.");
        }
        this.memberNames = memberNames;
        this.memberTypes = new HashMap<String, TypeDefinition>(memberTypes.size());
        for (String name : memberTypes.keySet()) {
            this.memberTypes.put(name, memberTypes.get(name));
        }
    }

    void setMembers(String[] memberNames, TypeDefinition[] memberTypeArray) throws NullPointerException, IllegalArgumentException {
        if (memberNames == null) {
            throw new NullPointerException("Cannot set the member names of this record type definition using a null string array.");
        }
        if (memberTypeArray == null) {
            throw new NullPointerException("Cannot set the member types of this record type definition using a null array of types.");
        }
        if (memberNames.length != memberTypeArray.length) {
            throw new IllegalArgumentException("Cannot set the member types of this record type definition with name and type arrays of different lengths.");
        }
        HashMap<String, TypeDefinition> memberTypes = new HashMap<String, TypeDefinition>();
        for (int x = 0; x < memberNames.length; ++x) {
            if (memberNames[x] == null) {
                throw new NullPointerException("Cannot set the member names of this record type definition with a null member name at index " + x + ".");
            }
            if (memberTypeArray[x] == null) {
                throw new NullPointerException("Cannot set the member types of this record type definition with a null member type at index " + x + ".");
            }
            memberTypes.put(memberNames[x], memberTypeArray[x]);
        }
        this.setMembers(memberNames, memberTypes);
    }

    void setSpecification(Class<?> specification) throws IllegalArgumentException {
        if (!specification.isInterface()) {
            throw new IllegalArgumentException("The specification of an implementing object of this type is not an interface.");
        }
        this.specification = specification;
        this.implementation = majImplementations.get(specification);
    }

    @Override
    public Class<?> getSpecification() {
        return this.specification;
    }

    @Override
    public Class<?> getImplementation() {
        return majImplementations.get(this.specification);
    }

    @Override
    public final PropertyValue createValueFromObject(Object initialData) throws BadTypeException {
        if (initialData == null) {
            return new RecordValue(this, null);
        }
        if (!this.specification.isInstance(initialData)) {
            throw new BadTypeException("The given initial data for a new record value does not implement the specification " + this.specification.getCanonicalName() + ".");
        }
        return new RecordValue(this, initialData);
    }

    @Override
    public final PropertyValue createValueFromValues(PropertyValue[] memberValues) throws NullPointerException, IllegalArgumentException, BadTypeException {
        if (memberValues == null) {
            throw new NullPointerException("Cannot create a new record property value from a null array of member values.");
        }
        if (memberValues.length != this.memberNames.length) {
            throw new IllegalArgumentException("Cannot create a new record from the given array of member values as the wrong length.");
        }
        try {
            Object baseValue = majImplementations.get(this.specification).newInstance();
            RecordValue recordProperty = new RecordValue(this, baseValue);
            for (int x = 0; x < memberValues.length; ++x) {
                if (!this.memberTypes.get(this.memberNames[x]).equals(memberValues[x].getType())) {
                    throw new BadTypeException("The type of the element at index " + x + " in the array of member values does not match the required type for this record type definition.");
                }
                this.setValue((PropertyValue)recordProperty, this.memberNames[x], memberValues[x]);
            }
            return recordProperty;
        }
        catch (Exception e) {
            if (e instanceof BadTypeException) {
                throw (BadTypeException)e;
            }
            throw new BadTypeException("Cannot create an instance of the underling record property type due to a " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public final int getCount() {
        return this.memberNames.length;
    }

    @Override
    public final Object getObject(PropertyValue recordProperty) throws NullPointerException, BadTypeException, IllegalPropertyValueException {
        if (recordProperty == null) {
            throw new NullPointerException("Cannot create an object instance representing a null record property value.");
        }
        if (!this.equals(recordProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property does not match this record type definition.");
        }
        return recordProperty.getValue();
    }

    @Override
    public final String getMemberName(int index) throws IndexOutOfBoundsException {
        try {
            return this.memberNames[index];
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for the array of member names of this record type definition.");
        }
    }

    @Override
    public final TypeDefinition getMemberType(int index) throws IndexOutOfBoundsException {
        try {
            return this.memberTypes.get(this.memberNames[index]);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for the arrays of members of this record type definition.");
        }
    }

    @Override
    public final PropertyValue getValue(PropertyValue recordProperty, int index) throws NullPointerException, IllegalPropertyValueException, IndexOutOfBoundsException {
        String memberName;
        try {
            memberName = this.memberNames[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for the array of names of this record type definition.");
        }
        return this.getValue(recordProperty, memberName);
    }

    @Override
    public final PropertyValue getValue(PropertyValue recordProperty, String memberName) throws NullPointerException, IllegalPropertyValueException, IllegalArgumentException {
        if (recordProperty == null) {
            throw new NullPointerException("Cannot retrieve a property value from a null record property value.");
        }
        if (!this.equals(recordProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property does not match this record property value.");
        }
        if (memberName == null) {
            throw new NullPointerException("Cannot retrieve a property value using a null member name.");
        }
        if (!this.memberTypes.containsKey(memberName)) {
            throw new IllegalArgumentException("The given argument name does not match the name of a record member for this record type definition.");
        }
        if (!this.specification.isInstance(recordProperty.getValue())) {
            throw new IllegalPropertyValueException("The implementing class of the record property value does not match the type specification of: " + this.specification.getCanonicalName());
        }
        Class<?> valueImplementation = recordProperty.getValue().getClass();
        Method[] methods = valueImplementation.getMethods();
        String expectedName = "get" + memberName;
        for (Method method : methods) {
            if (!method.getName().equalsIgnoreCase(expectedName)) continue;
            try {
                Object baseValue = method.invoke(recordProperty.getValue(), new Object[0]);
                return this.memberTypes.get(memberName).createValue(baseValue);
            }
            catch (Exception e) {
                throw new IllegalPropertyValueException("Unable to retrieve property value for " + memberName + " due to a " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
        throw new IllegalPropertyValueException("The class " + valueImplementation.getCanonicalName() + " does not have a method to retrieve value " + memberName + ".");
    }

    @Override
    public final void setObject(PropertyValue recordProperty, Object data) throws NullPointerException, IllegalPropertyValueException, BadTypeException {
        if (recordProperty == null) {
            throw new NullPointerException("Cannot set the value of a null record property value.");
        }
        if (!this.equals(recordProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this record type definition.");
        }
        if (data == null) {
            ((RecordValue)recordProperty).setValue(null);
            return;
        }
        if (!this.specification.isInstance(data)) {
            throw new BadTypeException("The given data to set a record property value does not implement the required specification.");
        }
        ((RecordValue)recordProperty).setValue(data);
    }

    @Override
    public final void setValue(PropertyValue recordProperty, int index, PropertyValue memberProperty) throws NullPointerException, IllegalPropertyValueException, IndexOutOfBoundsException, BadTypeException {
        try {
            String memberName = this.memberNames[index];
            this.setValue(recordProperty, memberName, memberProperty);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("The given index is outside the acceptable range for this type definition.");
        }
    }

    @Override
    public final void setValue(PropertyValue recordProperty, String memberName, PropertyValue memberProperty) throws NullPointerException, IllegalPropertyValueException, IllegalArgumentException, BadTypeException {
        if (recordProperty == null) {
            throw new NullPointerException("Cannot set the value of a null record property value.");
        }
        if (!this.equals(recordProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this record type definition.");
        }
        if (memberName == null) {
            throw new NullPointerException("Cannot set the value of a record with a null member name.");
        }
        if (!this.memberTypes.containsKey(memberName)) {
            throw new IllegalArgumentException("Cannot set the value of a record with a member name that is not known for this record type definition.");
        }
        if (memberProperty == null) {
            throw new NullPointerException("Cannot set the value of a record member using a null value.");
        }
        if (!this.memberTypes.get(memberName).equals(memberProperty.getType())) {
            throw new BadTypeException("The type of the given member property does not match the type of the member property at the given index.");
        }
        if (recordProperty.getValue() == null) {
            throw new NullPointerException("Cannot set a member value of a null internal record proeprty value.");
        }
        if (!this.specification.isInstance(recordProperty.getValue())) {
            throw new IllegalPropertyValueException("The internal implementation of the record proeprty value does not match the specification of this record type.");
        }
        Class<?> valueImplementation = recordProperty.getValue().getClass();
        Method[] methods = valueImplementation.getMethods();
        String expectedMethod = "set" + memberName;
        for (Method method : methods) {
            if (!method.getName().equalsIgnoreCase(expectedMethod)) continue;
            try {
                method.invoke(recordProperty.getValue(), memberProperty.getValue());
                return;
            }
            catch (InvocationTargetException ite) {
                throw new IllegalPropertyValueException("Unable to set the value of " + memberName + " due to a InvocationTargetException: " + ite.getTargetException().getMessage());
            }
            catch (Exception e) {
                throw new IllegalPropertyValueException("Unable to set the value of " + memberName + " due to a " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
        throw new IllegalPropertyValueException("Unable to find a setter method for " + memberName + " in value implementation " + valueImplementation.getCanonicalName() + ".");
    }

    @Override
    public final PropertyValue createValue(Object javaValue) throws ClassCastException {
        if (javaValue == null) {
            throw new ClassCastException("Cannot create a record propery value from a null value.");
        }
        try {
            if (javaValue instanceof PropertyValue[]) {
                return this.createValueFromValues((PropertyValue[])javaValue);
            }
            if (javaValue instanceof String) {
                return this.createValueFromString((String)javaValue);
            }
            return this.createValueFromObject(javaValue);
        }
        catch (NullPointerException e) {
            throw new ClassCastException("Cannot create a record propery value from a null value.");
        }
        catch (IllegalPropertyValueException e) {
            throw new ClassCastException("Illegal value exception thrown when trying to create a record property value: " + e.getMessage());
        }
        catch (BadTypeException e) {
            throw new ClassCastException("Bad type exception thrown when trying to create a record property value: " + e.getMessage());
        }
    }

    public final PropertyValue createValueFromString(String content) throws ClassCastException {
        try {
            Class<?> implementation = majImplementations.get(this.specification);
            Method stringFactory = implementation.getMethod("parseFactory", String.class);
            return this.createValueFromObject(stringFactory.invoke(null, content));
        }
        catch (Exception e) {
            throw new ClassCastException("Cannot create a " + this.getName() + " record value from the given string '" + content + "' due to a " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public final TypeCategory getTypeCategory() {
        return TypeCategory.Record;
    }

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        super.createFromBytes(buffer);
        if (this.implementation != null) {
            try {
                Method bufferCreateMethod = this.implementation.getMethod("createFromBuffer", ByteBuffer.class);
                return new RecordValue(this, bufferCreateMethod.invoke(null, buffer));
            }
            catch (NoSuchMethodException bufferCreateMethod) {
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof EndOfDataException) {
                    throw (EndOfDataException)cause;
                }
                if (cause instanceof NullPointerException) {
                    throw (NullPointerException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException("Unexpected " + cause.getClass().getName() + " thrown when reading a record property value from a buffer: " + cause.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Illegal access exception thrown when reading a " + this.getName() + " value: " + iae.getMessage());
            }
        }
        PropertyValue[] values = new PropertyValue[this.memberNames.length];
        for (int u = 0; u < this.memberNames.length; ++u) {
            String memberName = this.memberNames[u];
            TypeDefinition memberType = this.memberTypes.get(memberName);
            values[u] = memberType.createFromBytes(buffer);
        }
        return this.createValueFromValues(values);
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        super.lengthAsBytes(value);
        if (this.implementation != null) {
            try {
                Method bufferLengthMethod = this.implementation.getMethod("lengthAsBuffer", this.getSpecification());
                return (Long)bufferLengthMethod.invoke(null, value.getValue());
            }
            catch (NoSuchMethodException bufferLengthMethod) {
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof NullPointerException) {
                    throw (NullPointerException)cause;
                }
                if (cause instanceof IllegalPropertyValueException) {
                    throw (IllegalPropertyValueException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException("Unexpected " + cause.getClass().getName() + " thrown when calculating the length of a record property value: " + cause.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Illegal access exception thrown when calculating the length of a " + this.getName() + " value: " + iae.getMessage());
            }
        }
        long length = 0L;
        for (int u = 0; u < this.memberNames.length; ++u) {
            String memberName = this.memberNames[u];
            TypeDefinition memberType = this.memberTypes.get(memberName);
            length += memberType.lengthAsBytes(this.getValue(value, u));
        }
        return length;
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        if (this.implementation != null) {
            try {
                Method bufferWriteMethod = this.implementation.getMethod("writeToBuffer", this.getSpecification(), ByteBuffer.class);
                bufferWriteMethod.invoke(null, value.getValue(), buffer);
                return null;
            }
            catch (NoSuchMethodException bufferWriteMethod) {
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof NullPointerException) {
                    throw (NullPointerException)cause;
                }
                if (cause instanceof IllegalPropertyValueException) {
                    throw (IllegalPropertyValueException)cause;
                }
                if (cause instanceof InsufficientSpaceException) {
                    throw (InsufficientSpaceException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException("Unexpected " + cause.getClass().getName() + " thrown when writing a record property value to a buffer: " + cause.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Illegal access exception thrown when writing a " + this.getName() + " value: " + iae.getMessage());
            }
        }
        long length = this.lengthAsBytes(value);
        if ((long)buffer.remaining() < length) {
            throw new InsufficientSpaceException("The given buffer is too small to write the given record value in to.");
        }
        for (int u = 0; u < this.memberNames.length; ++u) {
            String memberName = this.memberNames[u];
            TypeDefinition memberType = this.memberTypes.get(memberName);
            memberType.writeAsBytes(this.getValue(value, u), buffer);
        }
        return null;
    }

    @Override
    public List<PropertyValue> writeAsStructuredStorageBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        if (this.implementation != null) {
            try {
                Method bufferWriteMethod = null;
                try {
                    bufferWriteMethod = this.implementation.getMethod("writeToStructuredStorageBuffer", this.getSpecification(), ByteBuffer.class);
                }
                catch (NoSuchMethodException nmess) {
                    bufferWriteMethod = this.implementation.getMethod("writeToBuffer", this.getSpecification(), ByteBuffer.class);
                }
                bufferWriteMethod.invoke(null, value.getValue(), buffer);
                return null;
            }
            catch (NoSuchMethodException bufferWriteMethod) {
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof NullPointerException) {
                    throw (NullPointerException)cause;
                }
                if (cause instanceof IllegalPropertyValueException) {
                    throw (IllegalPropertyValueException)cause;
                }
                if (cause instanceof InsufficientSpaceException) {
                    throw (InsufficientSpaceException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException("Unexpected " + cause.getClass().getName() + " thrown when writing a record property value to a buffer: " + cause.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Illegal access exception thrown when writing a " + this.getName() + " value: " + iae.getMessage());
            }
        }
        long length = this.lengthAsBytes(value);
        if ((long)buffer.remaining() < length) {
            throw new InsufficientSpaceException("The given buffer is too small to write the given record value in to.");
        }
        for (int u = 0; u < this.memberNames.length; ++u) {
            String memberName = this.memberNames[u];
            TypeDefinition memberType = this.memberTypes.get(memberName);
            memberType.writeAsBytes(this.getValue(value, u), buffer);
        }
        return null;
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionRecord");
        super.appendMetadictXML(typeElement, namespace, prefix);
        Element members = XMLBuilder.createChild(typeElement, namespace, prefix, "Members");
        for (String memberName : this.memberNames) {
            XMLBuilder.appendElement((Node)members, namespace, prefix, "Name", memberName);
            XMLBuilder.appendElement((Node)members, namespace, prefix, "Type", this.memberTypes.get(memberName).getName());
        }
    }

    @Override
    public TypeDefinitionRecord clone() {
        return (TypeDefinitionRecord)super.clone();
    }

    static {
        TypeDefinitionRecordImpl.registerInterfaceMapping(Rational.class, RationalImpl.class);
        TypeDefinitionRecordImpl.registerInterfaceMapping(AUID.class, AUIDImpl.class);
        TypeDefinitionRecordImpl.registerInterfaceMapping(PackageID.class, PackageIDImpl.class);
        TypeDefinitionRecordImpl.registerInterfaceMapping(ProductVersion.class, ProductVersionImpl.class);
        TypeDefinitionRecordImpl.registerInterfaceMapping(VersionType.class, VersionTypeImpl.class);
        TypeDefinitionRecordImpl.registerInterfaceMapping(RGBAComponent.class, RGBAComponentImpl.class);
        TypeDefinitionRecordImpl.registerInterfaceMapping(DateStruct.class, DateStructImpl.class);
        TypeDefinitionRecordImpl.registerInterfaceMapping(TimeStruct.class, TimeStructImpl.class);
        TypeDefinitionRecordImpl.registerInterfaceMapping(TimeStamp.class, TimeStampImpl.class);
    }

    public static final class RecordValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionRecordImpl type;
        private Object value;

        private RecordValue(TypeDefinitionRecordImpl type, Object value) {
            this.type = type;
            this.setValue(value);
        }

        @Override
        public TypeDefinition getType() {
            return this.type;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public boolean isDefinedType() {
            return true;
        }

        private void setValue(Object value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (o instanceof PropertyValue) {
                return this.getValue().equals(((PropertyValue)o).getValue());
            }
            return this.getValue().equals(o);
        }
    }
}

