/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.exception.AlreadyUniquelyIdentifiedException;
import tv.amwa.maj.exception.BadParameterException;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.exception.ObjectAlreadyAttachedException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.EmitXMLClassIDAs;
import tv.amwa.maj.industry.HiddenClass;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyContains;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertyRemove;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MediaSetAdd;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.io.aaf.AAFConstants;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.impl.MetaDefinitionImpl;
import tv.amwa.maj.meta.impl.PropertyDefinitionImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=0xD010101, uuid2=513, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="ClassDefinition", description="The ClassDefinition class is used to programatically represent the class hierarchy defined in the AAF object specification.", symbol="ClassDefinition")
public final class ClassDefinitionImpl
extends MetaDefinitionImpl
implements ClassDefinition,
Serializable,
XMLSerializable,
WeakReferenceTarget,
CommonConstants,
Cloneable {
    private static final long serialVersionUID = 3707298326242517329L;
    private boolean concrete = true;
    private WeakReference<ClassDefinition> parentClass = null;
    private Map<AUID, PropertyDefinition> properties = Collections.synchronizedMap(new HashMap());
    private Map<String, PropertyDefinition> propertiesByName = Collections.synchronizedMap(new HashMap());
    private Map<Short, PropertyDefinition> propertiesByTag = Collections.synchronizedMap(new HashMap());
    private Set<PropertyDefinition> allDefinitions = null;
    private PropertyDefinition unqiueIdentifier = null;
    private Class<?> javaImplementation = null;
    private EmitXMLClassIDAs emitXMLClassId = EmitXMLClassIDAs.Parent;
    private static Map<String, String> classNameMap = null;

    public static final void initalizeClassNameMap() {
        int classMapSize = AAFConstants.classNameAliases.length / 2;
        classNameMap = Collections.synchronizedMap(new HashMap(classMapSize));
        for (int x = 0; x < classMapSize; ++x) {
            classNameMap.put(AAFConstants.classNameAliases[x * 2], AAFConstants.classNameAliases[x * 2 + 1]);
        }
    }

    protected ClassDefinitionImpl() {
    }

    public ClassDefinitionImpl(AUID identification, String className, ClassDefinition parentClass, boolean isConcrete) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new class definition with a null class identifier.");
        }
        this.setIdentification(identification);
        this.setName(className);
        if (parentClass == null) {
            this.setParent(this);
        } else {
            this.setParent(parentClass);
        }
        this.setIsConcrete(isConcrete);
        Warehouse.register(this);
    }

    public static final ClassDefinition forClass(Class<?> aafClass) throws NullPointerException, IllegalArgumentException {
        boolean isConcrete;
        ClassDefinitionImpl classDef = new ClassDefinitionImpl();
        classDef.setJavaImplementation(aafClass);
        MediaClass classMetadata = aafClass.getAnnotation(MediaClass.class);
        if (classMetadata == null) {
            HiddenClass hiddenClass = aafClass.getAnnotation(HiddenClass.class);
            if (hiddenClass == null) {
                throw new IllegalArgumentException("The class " + aafClass.getName() + " is not annotated as a media class or a hidden class.");
            }
            return Warehouse.lookForClass(aafClass.getSuperclass());
        }
        AUIDImpl classID = new AUIDImpl(classMetadata.uuid1(), (short)classMetadata.uuid2(), (short)classMetadata.uuid3(), classMetadata.uuid4());
        ClassDefinition parent = aafClass.getSuperclass().equals(Object.class) ? classDef : Warehouse.lookForClass(aafClass.getSuperclass());
        classDef.setIdentification(classID);
        classDef.setParent(parent);
        classDef.setName(classMetadata.definedName());
        boolean bl = isConcrete = !Modifier.isAbstract(aafClass.getModifiers());
        if (isConcrete) {
            isConcrete = classMetadata.isConcrete();
        }
        classDef.setIsConcrete(isConcrete);
        classDef.setDescription(classMetadata.description());
        classDef.setSymbol(classMetadata.symbol());
        classDef.setAliases(classMetadata.aliases());
        classDef.setEmitXMLClassIDAs(classMetadata.emitXMLClassID());
        if (classMetadata.namespace().length() > 0) {
            classDef.setNamespace(classMetadata.namespace());
        }
        if (classMetadata.prefix().length() > 0) {
            classDef.setPrefix(classMetadata.prefix());
        }
        int propertyWeight = Integer.MIN_VALUE + classDef.getHierarchyDepth() * 1000;
        for (Method propertyFinder : aafClass.getDeclaredMethods()) {
            MediaProperty property = propertyFinder.getAnnotation(MediaProperty.class);
            if (property == null) continue;
            AUIDImpl propertyID = new AUIDImpl(property.uuid1(), (short)property.uuid2(), (short)property.uuid3(), property.uuid4());
            try {
                PropertyDefinitionImpl justRegistered = (PropertyDefinitionImpl)classDef.registerNewPropertyDefinition(propertyID, property.definedName(), property.aliases(), property.symbol(), property.typeName(), property.optional(), property.uniqueIdentifier(), (short)property.pid());
                justRegistered.setAnnotatedGetter(propertyFinder);
                if (property.namespace().length() > 0) {
                    justRegistered.setNamespace(property.namespace());
                }
                if (property.prefix().length() > 0) {
                    justRegistered.setPrefix(property.prefix());
                }
                justRegistered.setDescription(property.description());
                justRegistered.setIsXMLCDATA(property.isXMLCDATA());
                justRegistered.setIsXMLAttribute(property.isXMLAttribute());
                justRegistered.setFlattenXML(property.flattenXML());
                if (property.uniqueIdentifier()) {
                    classDef.setUniqueIdentifier(justRegistered);
                }
                if (property.weight() == 0) {
                    justRegistered.setWeight(propertyWeight);
                } else {
                    justRegistered.setWeight(property.weight());
                }
                ++propertyWeight;
            }
            catch (AlreadyUniquelyIdentifiedException auie) {
                throw new IllegalArgumentException("The class contains two AAF property annotations claiming to be its unique identifier, one of which is '" + property.definedName() + "'.");
            }
            catch (ObjectAlreadyAttachedException bpe) {
                throw new IllegalArgumentException("The class contains two AAF property annotations with the same identification with defined name '" + property.definedName() + "'.");
            }
        }
        Warehouse.register(classDef);
        return classDef;
    }

    private int getHierarchyDepth() {
        int depth = 0;
        ClassDefinition target = this;
        ClassDefinition parent = target.getParent();
        while (!target.equals(target.getParent())) {
            ++depth;
            target = parent;
            parent = target.getParent();
        }
        return depth;
    }

    @Override
    @MediaPropertyCount(value="Properties")
    public int countPropertyDefinitions() {
        return this.properties.size();
    }

    @MediaPropertyClear(value="Properties")
    public void clearPropertyDefinitions() {
        this.properties.clear();
        this.propertiesByName.clear();
        this.propertiesByTag.clear();
    }

    @Override
    public MetadataObject createInstance() {
        try {
            if (this.javaImplementation != null) {
                return (MetadataObject)this.javaImplementation.newInstance();
            }
        }
        catch (Exception iae) {
            return null;
        }
        return null;
    }

    public String getJavaClassName() throws PropertyNotPresentException {
        if (this.javaImplementation == null) {
            throw new PropertyNotPresentException("The optional java implementation property is not present in this class definition.");
        }
        return this.javaImplementation.getCanonicalName();
    }

    @Override
    public Class<?> getJavaImplementation() throws PropertyNotPresentException {
        if (this.javaImplementation == null) {
            throw new PropertyNotPresentException("The optional java class implementation that can be associated with this AAF class definition is not present.");
        }
        return this.javaImplementation;
    }

    @Override
    public void setJavaImplementation(Class<?> javaImplementation) {
        this.javaImplementation = javaImplementation;
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ParentClass", typeName="ClassDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=8, symbol="ParentClass")
    public ClassDefinition getParent() {
        return this.parentClass.getTarget();
    }

    @MediaPropertySetter(value="ParentClass")
    public void setParent(ClassDefinition parent) throws NullPointerException {
        if (parent == null) {
            throw new NullPointerException("Cannot set a parent class for this class definition to a null value. For a root class, use itself as a parent.");
        }
        this.parentClass = new WeakReference<ClassDefinition>(parent);
    }

    public ClassDefinition initializeParentClass() {
        return this;
    }

    @MediaProperty(uuid1=100729095, uuid2=512, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Properties", typeName="PropertyDefinitionStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=9, symbol="Properties")
    public Set<PropertyDefinition> getPropertyDefinitions() {
        return new HashSet<PropertyDefinition>(this.properties.values());
    }

    void setPropertyDefinitions(Set<? extends PropertyDefinition> properties) throws NullPointerException {
        this.properties = Collections.synchronizedMap(new HashMap());
        this.propertiesByName = Collections.synchronizedMap(new HashMap());
        this.propertiesByTag = Collections.synchronizedMap(new HashMap());
        for (PropertyDefinition propertyDefinition : properties) {
            if (propertyDefinition == null) continue;
            this.properties.put(propertyDefinition.getAUID(), propertyDefinition);
            this.propertiesByName.put(propertyDefinition.getName(), propertyDefinition);
            this.propertiesByName.put(propertyDefinition.getSymbol(), propertyDefinition);
            this.putAliases(propertyDefinition);
            try {
                if (propertyDefinition.getLocalIdentification() != 0) {
                    this.propertiesByTag.put(propertyDefinition.getLocalIdentification(), propertyDefinition);
                }
                Warehouse.register(propertyDefinition);
            }
            catch (PropertyNotPresentException propertyNotPresentException) {}
        }
    }

    @MediaSetAdd(value="Properties")
    public void addPropertyDefinition(PropertyDefinition propertyDefinition) throws NullPointerException {
        if (propertyDefinition == null) {
            throw new NullPointerException("Cannot add a null property definition to this class.");
        }
        propertyDefinition.setMemberOf(this);
        this.properties.put(propertyDefinition.getAUID(), propertyDefinition);
        this.propertiesByName.put(propertyDefinition.getName(), propertyDefinition);
        this.propertiesByName.put(propertyDefinition.getSymbol(), propertyDefinition);
        this.putAliases(propertyDefinition);
        if (propertyDefinition.getLocalIdentification() != 0) {
            this.propertiesByTag.put(propertyDefinition.getLocalIdentification(), propertyDefinition);
        }
    }

    @MediaPropertyContains(value="Properties")
    public boolean containsPropertyDefinition(PropertyDefinition propertyDefinition) throws NullPointerException {
        if (propertyDefinition == null) {
            throw new NullPointerException("Cannot test to see if a null value is contained in the properties of this class definition.");
        }
        return this.properties.containsKey(propertyDefinition.getAUID());
    }

    @MediaPropertyRemove(value="Properties")
    public void removePropertyDefinition(PropertyDefinition propertyDefinition) throws NullPointerException {
        if (propertyDefinition == null) {
            throw new NullPointerException("Cannot remove a null property definition from the properties of this class definition.");
        }
        PropertyDefinition propertyImplementation = this.properties.remove(propertyDefinition.getAUID());
        this.propertiesByName.remove(propertyDefinition.getName());
        this.propertiesByName.remove(propertyImplementation.getSymbol());
        this.propertiesByTag.remove(propertyDefinition.getLocalIdentification());
    }

    @Override
    public PropertyDefinition getUniqueIdentifierProperty() {
        if (this == this.parentClass.getTarget()) {
            return this.unqiueIdentifier;
        }
        if (this.unqiueIdentifier == null) {
            return this.parentClass.getTarget().getUniqueIdentifierProperty();
        }
        return this.unqiueIdentifier;
    }

    @Override
    public boolean isConcrete() {
        return this.concrete;
    }

    @MediaProperty(uuid1=100729095, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="IsConcrete", typeName="Boolean", optional=false, uniqueIdentifier=false, pid=10, symbol="IsConcrete")
    public boolean getIsConcrete() {
        return this.concrete;
    }

    @MediaPropertySetter(value="IsConcrete")
    public void setIsConcrete(boolean concrete) {
        this.concrete = concrete;
    }

    public static final boolean initializeIsConcrete() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return this.equals(this.parentClass.getTarget());
    }

    @Override
    public boolean isUniquelyIdentified() {
        return this.getUniqueIdentifierProperty() != null;
    }

    @Override
    public PropertyDefinition lookupPropertyDefinition(AUID propertyID) throws NullPointerException, BadParameterException {
        if (propertyID == null) {
            throw new NullPointerException("Cannot lookup a property definition with a null id.");
        }
        if (!this.properties.containsKey(propertyID)) {
            if (this.parentClass == null) {
                System.err.println("*-*-*: " + this.getName());
            }
            if (this.parentClass.getTarget() != this) {
                return this.parentClass.getTarget().lookupPropertyDefinition(propertyID);
            }
            throw new BadParameterException("Cannot find the given property registered with this class definition.");
        }
        return this.properties.get(propertyID);
    }

    @Override
    public PropertyDefinition lookupPropertyDefinition(String propertyName) throws NullPointerException, BadParameterException {
        if (propertyName == null) {
            throw new NullPointerException("Cannot lookup a property definition with a null name.");
        }
        if (!this.propertiesByName.containsKey(propertyName)) {
            if (this.parentClass.getTarget() != this) {
                return this.parentClass.getTarget().lookupPropertyDefinition(propertyName);
            }
            throw new BadParameterException("Cannot find the given property by name registered with this class definition.");
        }
        return this.propertiesByName.get(propertyName);
    }

    @Override
    public PropertyDefinition lookupPropertyDefinition(short propertyTag) throws BadParameterException {
        if (!this.propertiesByTag.containsKey(propertyTag)) {
            if (this.parentClass != null && this.parentClass.getTarget() != this) {
                return this.parentClass.getTarget().lookupPropertyDefinition(propertyTag);
            }
            throw new BadParameterException("Cannot find the given property by local identification tag registered with this class definition.");
        }
        return this.propertiesByTag.get(propertyTag);
    }

    public static final PropertyDefinition globalPropertyIDLookup(AUID propertyID) {
        return Warehouse.lookForProperty(propertyID);
    }

    @Override
    public PropertyDefinition registerNewPropertyDefinition(AUID identification, String name, String[] aliases, String symbol, String typeName, boolean isOptional, boolean isUniqueIdentifier, Short pid) throws NullPointerException, AlreadyUniquelyIdentifiedException, ObjectAlreadyAttachedException {
        if (this.properties.containsKey(identification)) {
            throw new ObjectAlreadyAttachedException("Cannot register a property with the same identity as one that is already registered.");
        }
        PropertyDefinitionImpl creation = new PropertyDefinitionImpl(identification, name, typeName, this, isOptional);
        creation.setSymbol(symbol);
        creation.setLocalIdentification(pid);
        creation.setAliases(aliases);
        if (isUniqueIdentifier && this.isUniquelyIdentified()) {
            throw new AlreadyUniquelyIdentifiedException("Cannot add another property to the set of already uniquely identified properties that is also a unique indentifier.");
        }
        creation.setIsUniqueIdentifier(isUniqueIdentifier);
        this.properties.put(creation.getAUID(), creation);
        this.propertiesByName.put(creation.getName(), creation);
        this.propertiesByName.put(creation.getSymbol(), creation);
        this.putAliases(creation);
        if (pid != null && pid != 0) {
            this.propertiesByTag.put(creation.getLocalIdentification(), creation);
        }
        Warehouse.register(creation);
        return creation;
    }

    private void putAliases(PropertyDefinition severalNames) {
        if (severalNames == null) {
            return;
        }
        if (severalNames.getAliases() == null) {
            return;
        }
        for (String alias : severalNames.getAliases()) {
            PropertyDefinition checkBeforeRemoving;
            if (this.propertiesByName.containsKey(alias) && (alias.equals((checkBeforeRemoving = this.propertiesByName.get(alias)).getName()) || alias.equals(checkBeforeRemoving.getSymbol()))) {
                System.err.println("Warning: Cannot use alias " + alias + " for property " + severalNames.getMemberOf().getName() + "." + severalNames.getName() + " because it clashes with another property name or symbol in the same class.");
                continue;
            }
            this.propertiesByName.put(alias, severalNames);
        }
    }

    @Override
    public PropertyDefinition registerOptionalPropertyDefinition(AUID identification, String name, String[] aliases, String symbol, String typeName) throws NullPointerException, ObjectAlreadyAttachedException {
        try {
            return this.registerNewPropertyDefinition(identification, name, aliases, symbol, typeName, true, false, null);
        }
        catch (AlreadyUniquelyIdentifiedException auie) {
            return null;
        }
    }

    @Override
    String getSymbolName() {
        return this.javaImplementation.getCanonicalName().replace('.', '_');
    }

    @Override
    public String getComment() {
        if (this.javaImplementation == null) {
            return "No known implementing class. Symbol: " + this.getSymbol();
        }
        return "Java implementing class: " + this.javaImplementation.getCanonicalName() + " Symbol: " + this.getSymbol();
    }

    public static final ClassDefinition forAUID(AUID identification) {
        return Warehouse.lookForClass(identification);
    }

    @Override
    public synchronized Set<PropertyDefinition> getAllPropertyDefinitions() {
        if (this.allDefinitions != null) {
            return this.allDefinitions;
        }
        this.allDefinitions = new HashSet<PropertyDefinition>(this.getPropertyDefinitions());
        this.allDefinitions.addAll(this.getParent().getAllPropertyDefinitions());
        return this.allDefinitions;
    }

    @Override
    public int countProperties(MetadataObject metadataObject) throws NullPointerException, IllegalArgumentException {
        if (metadataObject == null) {
            throw new NullPointerException("Cannot count properties for a null metadata object.");
        }
        if (!metadataObject.getClass().equals(this.javaImplementation)) {
            throw new IllegalArgumentException("The given object is not an instance of this defined class.");
        }
        int propertyPresentCounter = 0;
        for (PropertyDefinition propertyDefinition : this.getAllPropertyDefinitions()) {
            if (propertyDefinition.getIsOptional()) {
                if (!propertyDefinition.isPropertyPresent(metadataObject)) continue;
                ++propertyPresentCounter;
                continue;
            }
            ++propertyPresentCounter;
        }
        return propertyPresentCounter;
    }

    public static final boolean isKnownProperty(PropertyDefinition property) {
        return Warehouse.isKnownProperty(property);
    }

    @Override
    public SortedMap<? extends PropertyDefinition, ? extends PropertyValue> getProperties(MetadataObject metadataObject) {
        Set<PropertyDefinition> allPropertyDefinitions = this.getAllPropertyDefinitions();
        TreeMap<PropertyDefinition, PropertyValue> propertyValues = new TreeMap<PropertyDefinition, PropertyValue>();
        for (PropertyDefinition propertyDefinition : allPropertyDefinitions) {
            try {
                propertyValues.put(propertyDefinition, propertyDefinition.getPropertyValue(metadataObject));
            }
            catch (Exception e) {
                if (propertyDefinition.getIsOptional() || e.getCause() instanceof BadPropertyException) continue;
                System.err.println("Could not retrieve a value for required property " + this.getName() + "." + propertyDefinition.getName() + " because of a " + e.getClass().getName() + ": " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
        return propertyValues;
    }

    @Override
    public String getNamespace() {
        if (this.namespace == null) {
            if (this.parentClass.getTarget() == this) {
                return "unknown";
            }
            return this.parentClass.getTarget().getNamespace();
        }
        return this.namespace;
    }

    @Override
    public String getPrefix() {
        if (this.prefix == null) {
            if (this.parentClass.getTarget() == this) {
                return "unknown";
            }
            return this.parentClass.getTarget().getPrefix();
        }
        return this.prefix;
    }

    @Override
    public EmitXMLClassIDAs getEmitXMLClassIDAs() {
        if (this.isRoot()) {
            return this.emitXMLClassId == EmitXMLClassIDAs.Parent ? EmitXMLClassIDAs.Element : this.emitXMLClassId;
        }
        if (this.emitXMLClassId == EmitXMLClassIDAs.Parent) {
            return this.getParent().getEmitXMLClassIDAs();
        }
        return this.emitXMLClassId;
    }

    void setEmitXMLClassIDAs(EmitXMLClassIDAs emitAs) {
        this.emitXMLClassId = emitAs;
    }

    @Override
    public String getWeakTargetReference() {
        return this.getIdentification().toString();
    }

    void setUniqueIdentifier(PropertyDefinition uniqueIdentifier) {
        this.unqiueIdentifier = uniqueIdentifier;
    }

    @Override
    public PropertyValue getUniqueIdentifierValue(MetadataObject uniquelyIdentifiedObject) throws NullPointerException, IllegalArgumentException {
        return this.getUniqueIdentifierProperty().getPropertyValue(uniquelyIdentifiedObject);
    }

    public static final int countClassDefinitions() {
        return Warehouse.countClassDefinitions();
    }

    public static final Collection<ClassDefinition> getClassDefinitions() {
        return Warehouse.getClassDefinitions();
    }

    @Override
    public String nameToAAFName(String name) {
        if (classNameMap != null) {
            String mappedName = classNameMap.get(name);
            return mappedName != null ? mappedName : name;
        }
        return name;
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element classElement = XMLBuilder.createChild(metadict, namespace, prefix, "ClassDefinition");
        super.appendMetadictXML(classElement, namespace, prefix);
        if (!this.isRoot()) {
            XMLBuilder.appendElement((Node)classElement, namespace, prefix, "ParentClass", this.parentClass.getTarget().getName());
        }
        XMLBuilder.appendElement((Node)classElement, namespace, prefix, "IsConcrete", this.isConcrete());
    }

    @Override
    public ClassDefinition clone() {
        return (ClassDefinition)super.clone();
    }
}

