/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import tv.amwa.maj.io.xml.AAFElement;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.model.Preface;
import tv.amwa.maj.model.impl.IdentificationImpl;

public class XMLFactory {
    public static final Preface readPreface(String inputFileName) throws FileNotFoundException, IOException, NullPointerException, SAXException {
        if (inputFileName == null) {
            throw new NullPointerException("The given AAF XML file reference is null.");
        }
        File aafxFile = new File(inputFileName);
        if (!(aafxFile = aafxFile.getAbsoluteFile()).exists()) {
            throw new FileNotFoundException("The given AAF XML file does not exist.");
        }
        if (!aafxFile.isFile()) {
            throw new FileNotFoundException("The given AAF XML file name is not a file.");
        }
        if (!aafxFile.canRead()) {
            throw new IOException("Insufficient privileges to read the given AAF XML file.");
        }
        Map<String, InputStream> streams = XMLBuilder.parseDocTypeToStreams(aafxFile);
        return (Preface)XMLBuilder.createFromXML(new InputSource(new FileInputStream(aafxFile)), streams);
    }

    public static final void writePreface(Preface preface, String outputFileName) throws NullPointerException, IOException {
        if (outputFileName == null) {
            throw new NullPointerException("Cannot write to a file specified as null.");
        }
        File aafxFile = new File(outputFileName);
        aafxFile = aafxFile.getAbsoluteFile();
        XMLFactory.overwriteFile(aafxFile, preface);
    }

    public static final void overwriteFile(File aafxFile, Preface preface) throws NullPointerException, IOException {
        if (aafxFile == null) {
            throw new NullPointerException("Cannot write to a file specified as null.");
        }
        if (preface == null) {
            throw new NullPointerException("Cannot write to an AAF XML file with a null header.");
        }
        if (!aafxFile.getParentFile().canWrite()) {
            throw new IOException("Cannot write to the directory of the given file.");
        }
        if (aafxFile.exists() && !aafxFile.canWrite()) {
            throw new IOException("Insufficient privileges to write to the given file.");
        }
        preface.updateDictionaries();
        preface.updateEssenceContainers();
        AAFElement documentRoot = new AAFElement(preface);
        String asXML = XMLBuilder.toXML(documentRoot, aafxFile);
        FileWriter fileWriter = new FileWriter(aafxFile);
        fileWriter.write(asXML);
        fileWriter.close();
        XMLBuilder.writeStreams(documentRoot.getDocument(), aafxFile);
    }

    public static final void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java tv.amwa.maj.io.xml.XMLFactory <reg_xml_file>");
            System.exit(1);
        }
        try {
            Preface header = XMLFactory.readPreface(args[0]);
            header.appendIdentification(new IdentificationImpl("portability 4 media", "MAJ API", "0.0.1 development", IdentificationImpl.APIProductID));
            System.out.println(header.toString());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

