/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.xml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.io.xml.MasterContentHandler;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.ExtensionScheme;
import tv.amwa.maj.meta.MetaDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionIndirect;
import tv.amwa.maj.meta.TypeDefinitionInteger;
import tv.amwa.maj.meta.TypeDefinitionObjectReference;
import tv.amwa.maj.meta.TypeDefinitionOpaque;
import tv.amwa.maj.meta.TypeDefinitionRename;
import tv.amwa.maj.meta.TypeDefinitionSet;
import tv.amwa.maj.meta.TypeDefinitionVariableArray;
import tv.amwa.maj.meta.impl.TypeDefinitionEnumerationImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionExtendibleEnumerationImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionFixedArrayImpl;
import tv.amwa.maj.model.ApplicationPluginObject;
import tv.amwa.maj.model.InterchangeObject;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.util.Utilities;

public final class XMLBuilder {
    private XMLBuilder() {
    }

    public static final Element createChild(Node parent, String namespace, String prefix, String elementName) {
        Document document = parent.getOwnerDocument();
        Element childElement = document.createElementNS(namespace, elementName);
        childElement.setPrefix(prefix);
        if (parent instanceof Element) {
            ((Element)parent).appendChild(childElement);
        }
        if (parent instanceof DocumentFragment) {
            ((DocumentFragment)parent).appendChild(childElement);
        }
        return childElement;
    }

    public static final Element appendElement(Node parent, String namespace, String prefix, String elementName, long value) {
        Document document = parent.getOwnerDocument();
        Element element = document.createElementNS(namespace, elementName);
        element.setPrefix(prefix);
        element.setTextContent(Long.toString(value));
        parent.appendChild(element);
        return element;
    }

    public static final Element appendElement(Node parent, String namespace, String prefix, String elementName, String value) {
        Document document = parent.getOwnerDocument();
        Element element = document.createElementNS(namespace, elementName);
        element.setPrefix(prefix);
        Text text = document.createTextNode(value);
        element.appendChild(text);
        parent.appendChild(element);
        return element;
    }

    public static final DocumentFragment createDocumentFragment() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return document.createDocumentFragment();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final String transformNodeToString(Node node) {
        StringWriter writer = new StringWriter();
        try {
            node.normalize();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", 2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("version", "1.0");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            writer = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static final String toXMLNonMetadata(XMLSerializable item) {
        DocumentFragment fragment = XMLBuilder.createDocumentFragment();
        item.appendXMLChildren(fragment);
        fragment.normalize();
        return XMLBuilder.transformNodeToString(fragment);
    }

    public static final String toXML(MetadataObject metadataObject) throws NullPointerException, IllegalArgumentException {
        if (metadataObject == null) {
            throw new NullPointerException("Cannot create an XML representation of a null value.");
        }
        DocumentFragment fragment = XMLBuilder.createDocumentFragment();
        XMLBuilder.appendObject(fragment, metadataObject);
        String asXML = XMLBuilder.transformNodeToString(fragment);
        String docType = XMLBuilder.makeDoctype(fragment, "toString");
        if (docType != null) {
            StringBuffer withDocType = new StringBuffer(asXML.length() + docType.length() + 1);
            withDocType.append(asXML.substring(0, 39));
            withDocType.append(docType);
            withDocType.append(asXML.substring(39));
            return withDocType.toString();
        }
        return asXML;
    }

    public static final void appendObject(Node parent, MetadataObject metadataObject) {
        String comment;
        InterchangeObject interchangeObject;
        if (metadataObject == null) {
            System.err.println("Unable to serialize to XML a child of element " + parent.getNodeName() + " at this time.");
            return;
        }
        Document document = parent.getOwnerDocument();
        ClassDefinition metaClass = Warehouse.lookForClass(metadataObject.getClass());
        SortedMap<? extends PropertyDefinition, ? extends PropertyValue> values = metaClass.getProperties(metadataObject);
        Element element = null;
        if (metadataObject instanceof InterchangeObject && (interchangeObject = (InterchangeObject)metadataObject).countApplicationPlugins() > 0) {
            for (ApplicationPluginObject plugin : interchangeObject.getApplicationPlugins()) {
                ClassDefinition pluginObjectClass = plugin.getObjectClass();
                if (pluginObjectClass.getAUID().equals(CommonConstants.ApplicationPluginObjectID)) continue;
                ExtensionScheme applicationScheme = plugin.getApplicationScheme();
                element = document.createElementNS(applicationScheme.getSchemeURI(), pluginObjectClass.getSymbol());
                element.setPrefix(applicationScheme.getPreferredPrefix());
                break;
            }
        }
        if (element == null) {
            element = document.createElementNS(metaClass.getNamespace(), metaClass.getSymbol());
            element.setPrefix(metaClass.getPrefix());
        }
        if (metadataObject instanceof WeakReferenceTarget && !(metadataObject instanceof MetaDefinition)) {
            XMLBuilder.setAttribute(element, metaClass.getNamespace(), metaClass.getPrefix(), "uid", ((WeakReferenceTarget)((Object)metadataObject)).getWeakTargetReference());
        }
        if (metadataObject instanceof XMLSerializable && (comment = ((XMLSerializable)((Object)metadataObject)).getComment()) != null) {
            XMLBuilder.appendComment(element, comment);
        }
        Iterator iterator = values.keySet().iterator();
        while (iterator.hasNext()) {
            PropertyDefinition alienProperty;
            PropertyDefinition property = alienProperty = (PropertyDefinition)iterator.next();
            PropertyValue value = (PropertyValue)values.get(property);
            if (property.getIsXMLAttribute()) {
                XMLBuilder.setAttribute(element, property.getNamespace(), property.getPrefix(), property.getSymbol(), value);
                continue;
            }
            if (property.getIsXMLCDATA()) {
                if (property.getTypeDefinition().getTypeCategory() != TypeCategory.StrongObjRef) {
                    String stringValue = XMLBuilder.propertyValueToString(value);
                    if (stringValue == null) continue;
                    Text textNode = document.createTextNode(XMLBuilder.propertyValueToString(value));
                    element.appendChild(textNode);
                    continue;
                }
                XMLBuilder.appendObject(element, (MetadataObject)value.getValue());
                continue;
            }
            if (property.getFlattenXML()) {
                XMLBuilder.appendValue(element, property.getNamespace(), property.getPrefix(), property.getSymbol(), value);
                Node lastChild = element.getLastChild();
                NodeList lastChildContent = lastChild.getChildNodes();
                element.removeChild(lastChild);
                for (int u = 0; u < lastChildContent.getLength(); ++u) {
                    Element childElement = (Element)lastChild.cloneNode(false);
                    Node branch = lastChildContent.item(u);
                    NodeList leaves = branch.getChildNodes();
                    for (int v = 0; v < leaves.getLength(); ++v) {
                        childElement.appendChild(leaves.item(v));
                    }
                    NamedNodeMap attributeMap = branch.getAttributes();
                    if (attributeMap != null) {
                        for (int w = 0; w < attributeMap.getLength(); ++w) {
                            childElement.setAttributeNodeNS((Attr)attributeMap.item(w).cloneNode(false));
                        }
                    }
                    element.appendChild(childElement);
                }
                continue;
            }
            if (property.getAUID().equals(InterchangeObjectImpl.ObjectClassPropertyID)) {
                XMLBuilder.manageObjectClass(element, metaClass, property, value);
                continue;
            }
            XMLBuilder.appendValue(element, property.getNamespace(), property.getPrefix(), property.getSymbol(), value);
        }
        if (metadataObject instanceof XMLSerializable) {
            ((XMLSerializable)((Object)metadataObject)).appendXMLChildren(element);
        }
        parent.appendChild(element);
    }

    public static final void appendValue(Element element, String namespace, String prefix, String symbolName, PropertyValue value) {
        Document document = element.getOwnerDocument();
        switch (value.getType().getTypeCategory()) {
            case Int: 
            case String: {
                if (symbolName.equals("ByteOrder") && element.getNodeName().endsWith("Preface")) {
                    XMLBuilder.appendElement((Node)element, namespace, prefix, symbolName, tv.amwa.maj.enumeration.ByteOrder.getByteOrderFromAAFCode((Short)value.getValue()).symbol());
                    break;
                }
                XMLBuilder.appendElement((Node)element, namespace, prefix, symbolName, value.getValue().toString());
                break;
            }
            case Record: {
                Object baseValue = value.getValue();
                if (baseValue instanceof XMLSerializable) {
                    Element recordChild = document.createElementNS(namespace, symbolName);
                    recordChild.setPrefix(prefix);
                    ((XMLSerializable)baseValue).appendXMLChildren(recordChild);
                    element.appendChild(recordChild);
                    break;
                }
                XMLBuilder.appendElement((Node)element, namespace, prefix, symbolName, baseValue.toString());
                break;
            }
            case WeakObjRef: {
                if (!(value.getValue() instanceof WeakReferenceTarget)) break;
                XMLBuilder.appendElement((Node)element, namespace, prefix, symbolName, ((WeakReferenceTarget)value.getValue()).getWeakTargetReference());
                break;
            }
            case StrongObjRef: {
                Element strongElement = document.createElementNS(namespace, symbolName);
                strongElement.setPrefix(prefix);
                XMLBuilder.appendObject(strongElement, (MetadataObject)value.getValue());
                element.appendChild(strongElement);
                break;
            }
            case Rename: {
                TypeDefinitionRename renamedType = (TypeDefinitionRename)value.getType();
                XMLBuilder.appendValue(element, namespace, prefix, symbolName, renamedType.getBaseValue(value));
                break;
            }
            case Stream: {
                Stream stream = (Stream)value.getValue();
                XMLBuilder.appendStream(element, namespace, prefix, symbolName, "stream", stream);
                break;
            }
            case VariableArray: {
                Object[] listValues;
                if (TypeDefinitions.DataValue.equals(value.getType())) {
                    List dataValueList = (List)value.getValue();
                    byte[] dataValueBytes = new byte[dataValueList.size()];
                    for (int x = 0; x < dataValueBytes.length; ++x) {
                        dataValueBytes[x] = (Byte)dataValueList.get(x);
                    }
                    XMLBuilder.appendElement((Node)element, namespace, prefix, symbolName, dataValueBytes);
                    break;
                }
                TypeDefinitionVariableArray variableArrayType = (TypeDefinitionVariableArray)value.getType();
                TypeDefinition elementType = variableArrayType.getType();
                Element subElement = document.createElementNS(namespace, symbolName);
                subElement.setPrefix(prefix);
                block40: for (Object listValue : listValues = variableArrayType.getArray(value)) {
                    switch (elementType.getTypeCategory()) {
                        case StrongObjRef: {
                            XMLBuilder.appendObject(subElement, (MetadataObject)listValue);
                            continue block40;
                        }
                        case WeakObjRef: {
                            if (!(listValue instanceof WeakReferenceTarget)) continue block40;
                            XMLBuilder.appendElement((Node)subElement, namespace, prefix, ((TypeDefinitionObjectReference)elementType).getObjectType().getName() + "WeakReference", ((WeakReferenceTarget)listValue).getWeakTargetReference());
                            continue block40;
                        }
                        case Character: {
                            if (variableArrayType.equals(TypeDefinitions.UTF16StringArray)) {
                                XMLBuilder.appendElement((Node)subElement, namespace, prefix, "Character", (String)listValue);
                                continue block40;
                            }
                            XMLBuilder.appendValue(subElement, namespace, prefix, elementType.getName(), elementType.createValue(listValue));
                            continue block40;
                        }
                        case Int: {
                            TypeDefinitionInteger varArrayIntType = (TypeDefinitionInteger)elementType;
                            long negativeValue = ((Number)listValue).longValue();
                            if (varArrayIntType.isSigned() || !varArrayIntType.isSigned() && negativeValue >= 0L) {
                                XMLBuilder.appendValue(subElement, namespace, prefix, elementType.getName(), elementType.createValue(listValue));
                                continue block40;
                            }
                            switch (varArrayIntType.getSize()) {
                                case 1: {
                                    negativeValue += 256L;
                                    break;
                                }
                                case 2: {
                                    negativeValue += 65536L;
                                    break;
                                }
                                case 3: {
                                    ++negativeValue;
                                    break;
                                }
                                case 4: {
                                    break;
                                }
                            }
                            XMLBuilder.appendValue(subElement, namespace, prefix, elementType.getName(), TypeDefinitions.UInt64.createValue(negativeValue));
                            continue block40;
                        }
                        default: {
                            XMLBuilder.appendValue(subElement, namespace, prefix, elementType.getName(), elementType.createValue(listValue));
                        }
                    }
                }
                element.appendChild(subElement);
                break;
            }
            case FixedArray: {
                Object[] fixedElements;
                TypeDefinitionFixedArrayImpl fixedArrayType = (TypeDefinitionFixedArrayImpl)value.getType();
                TypeDefinition elementArrayType = fixedArrayType.getType();
                Element fixedSubElement = document.createElementNS(namespace, symbolName);
                fixedSubElement.setPrefix(prefix);
                for (Object fixedElement : fixedElements = fixedArrayType.getArray(value)) {
                    XMLBuilder.appendValue(fixedSubElement, namespace, prefix, elementArrayType.getName(), elementArrayType.createValue(fixedElement));
                }
                element.appendChild(fixedSubElement);
                break;
            }
            case Enum: {
                XMLBuilder.appendElement((Node)element, namespace, prefix, symbolName, ((TypeDefinitionEnumerationImpl)value.getType()).getSymbolFromValue(value));
                break;
            }
            case ExtEnum: {
                XMLBuilder.appendElement((Node)element, namespace, prefix, symbolName, ((TypeDefinitionExtendibleEnumerationImpl)value.getType()).getSymbolFromValue(value));
                break;
            }
            case Set: {
                if (value.getType().equals(TypeDefinitions.ApplicationPluginObjectStrongReferenceSet)) {
                    Set pluginElements = (Set)value.getValue();
                    for (ApplicationPluginObject plugin : pluginElements) {
                        plugin.appendXMLChildren(element);
                    }
                    break;
                }
                TypeDefinitionSet setType = (TypeDefinitionSet)value.getType();
                TypeDefinition setElementType = setType.getElementType();
                Element setSubElement = document.createElementNS(namespace, symbolName);
                setSubElement.setPrefix(prefix);
                Set<PropertyValue> elementValues = setType.getElements(value);
                block43: for (PropertyValue elementValue : elementValues) {
                    switch (setElementType.getTypeCategory()) {
                        case StrongObjRef: {
                            XMLBuilder.appendObject(setSubElement, (MetadataObject)elementValue.getValue());
                            continue block43;
                        }
                        case WeakObjRef: {
                            if (!(elementValue.getValue() instanceof WeakReferenceTarget)) continue block43;
                            XMLBuilder.appendElement((Node)setSubElement, namespace, prefix, ((TypeDefinitionObjectReference)setElementType).getObjectType().getName() + "WeakReference", ((WeakReferenceTarget)elementValue.getValue()).getWeakTargetReference());
                            continue block43;
                        }
                        case Int: {
                            TypeDefinitionInteger setIntType = (TypeDefinitionInteger)setElementType;
                            long negativeValue = ((Number)elementValue.getValue()).longValue();
                            if (setIntType.isSigned() || !setIntType.isSigned() && negativeValue >= 0L) {
                                XMLBuilder.appendValue(setSubElement, namespace, prefix, setElementType.getName(), setElementType.createValue(elementValue.getValue()));
                                continue block43;
                            }
                            switch (setIntType.getSize()) {
                                case 1: {
                                    negativeValue += 256L;
                                    break;
                                }
                                case 2: {
                                    negativeValue += 65536L;
                                    break;
                                }
                                case 3: {
                                    ++negativeValue;
                                    break;
                                }
                            }
                            XMLBuilder.appendValue(setSubElement, namespace, prefix, setElementType.getName(), TypeDefinitions.UInt64.createValue(negativeValue));
                            continue block43;
                        }
                    }
                    XMLBuilder.appendValue(setSubElement, namespace, prefix, setElementType.getName(), elementValue);
                }
                element.appendChild(setSubElement);
                break;
            }
            case Indirect: {
                PropertyValue indirectValue = ((TypeDefinitionIndirect)value.getType()).getActualValue(value);
                XMLBuilder.appendValue(element, namespace, prefix, symbolName, indirectValue);
                Element indirectElement = (Element)element.getLastChild();
                XMLBuilder.setAttribute(indirectElement, namespace, prefix, "actualType", indirectValue.getType().getName());
                break;
            }
            case Opaque: {
                TypeDefinitionOpaque opaqueType = (TypeDefinitionOpaque)value.getType();
                try {
                    XMLBuilder.appendElement((Node)element, namespace, prefix, symbolName, opaqueType.getActualData(value));
                }
                catch (Exception e) {
                    System.err.println("Unable to create an opaque type data value due to a " + e.getClass().getName() + " for a property named " + symbolName + ": " + e.getMessage());
                }
                Element opaqueElement = (Element)element.getLastChild();
                TypeDefinition actualType = Warehouse.lookForType(opaqueType.getActualTypeID(value));
                if (actualType != null) {
                    XMLBuilder.appendComment(element, "Local type name for opaque value is: " + actualType.getName());
                }
                XMLBuilder.setAttribute(opaqueElement, namespace, prefix, "actualType", opaqueType.getActualTypeID(value).toString());
                XMLBuilder.setAttribute(opaqueElement, namespace, prefix, "byteOrder", opaqueType.getHandle(value).order() == ByteOrder.BIG_ENDIAN ? "BigEndian" : "LittleEndian");
                break;
            }
        }
    }

    private static void manageObjectClass(Element element, ClassDefinition propertyClass, PropertyDefinition property, PropertyValue value) {
        switch (propertyClass.getEmitXMLClassIDAs()) {
            case Element: {
                if (!(value.getValue() instanceof WeakReferenceTarget)) break;
                XMLBuilder.appendElement((Node)element, property.getNamespace(), property.getPrefix(), property.getSymbol(), ((WeakReferenceTarget)value.getValue()).getWeakTargetReference());
                break;
            }
            case Attribute: {
                XMLBuilder.setAttribute(element, property.getNamespace(), property.getPrefix(), "uid", value);
                break;
            }
            case Suppressed: {
                break;
            }
        }
    }

    public static final String toXML(XMLSerializable item, File xmlFile) {
        DocumentFragment fragment = XMLBuilder.createDocumentFragment();
        item.appendXMLChildren(fragment);
        fragment.normalize();
        String asXML = XMLBuilder.transformNodeToString(fragment);
        String docType = XMLBuilder.makeDoctype(fragment, xmlFile.getName());
        if (docType != null) {
            StringBuffer withDocType = new StringBuffer(asXML.length() + docType.length() + 1);
            withDocType.append(asXML.substring(0, 39));
            withDocType.append(docType);
            withDocType.append(asXML.substring(39));
            return withDocType.toString();
        }
        return asXML;
    }

    public static Comment appendComment(Node parent, String commentText) {
        Document document = parent.getOwnerDocument();
        Comment comment = document.createComment(commentText);
        parent.appendChild(comment);
        return comment;
    }

    public static Element appendElement(Node parent, String namespace, String prefix, String elementName, int value) {
        Document document = parent.getOwnerDocument();
        Element element = document.createElementNS(namespace, elementName);
        element.setPrefix(prefix);
        element.setTextContent(Integer.toString(value));
        parent.appendChild(element);
        return element;
    }

    public static Element appendElement(Node parent, String namespace, String prefix, String elementName, byte value) {
        Document document = parent.getOwnerDocument();
        Element element = document.createElementNS(namespace, elementName);
        element.setPrefix(prefix);
        element.setTextContent(Byte.toString(value));
        parent.appendChild(element);
        return element;
    }

    public static Element appendElement(Node parent, String namespace, String prefix, String elementName, boolean value) {
        Document document = parent.getOwnerDocument();
        Element element = document.createElementNS(namespace, elementName);
        element.setPrefix(prefix);
        element.setTextContent(value ? "true" : "false");
        parent.appendChild(element);
        return element;
    }

    public static Element appendElement(Node parent, String namespace, String prefix, String elementName, byte[] value) {
        Document document = parent.getOwnerDocument();
        Element element = document.createElementNS(namespace, elementName);
        element.setPrefix(prefix);
        element.setTextContent(new String(Utilities.bytesToHexChars(value)));
        parent.appendChild(element);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element appendStream(Node parent, String namespace, String prefix, String elementName, String attributeName, Stream entityData) {
        String streamName;
        Document document;
        Document document2 = document = parent.getOwnerDocument();
        synchronized (document2) {
            Integer entityCount = (Integer)document.getUserData("entityCount");
            if (entityCount == null) {
                entityCount = 0;
            }
            streamName = "stream_" + entityCount;
            entityCount = entityCount + 1;
            document.setUserData("entityCount", entityCount, null);
            document.setUserData(streamName, entityData, null);
        }
        Element streamElement = document.createElementNS(namespace, elementName);
        streamElement.setPrefix(prefix);
        XMLBuilder.setAttribute(streamElement, namespace, prefix, attributeName, streamName);
        parent.appendChild(streamElement);
        return streamElement;
    }

    public static final String makeDoctype(DocumentFragment fragment, String fileName) {
        Document document = fragment.getOwnerDocument();
        Integer entityCount = (Integer)document.getUserData("entityCount");
        if (entityCount == null) {
            return null;
        }
        if (entityCount == 0) {
            return null;
        }
        StringBuffer docType = new StringBuffer(100 + entityCount * 100);
        docType.append("<!DOCTYPE ");
        docType.append(fragment.getFirstChild().getLocalName());
        docType.append(" [\n<!NOTATION DataStream_0 SYSTEM \"urn:smpte:ul:060e2b34.01040101.04100200.00000000\">\n");
        for (int x = 0; x < entityCount; ++x) {
            docType.append("<!ENTITY stream_");
            docType.append(x);
            docType.append(" SYSTEM \"");
            docType.append(fileName);
            docType.append("_streams/stream_");
            docType.append(x);
            docType.append("\" NDATA DataStream_0>\n");
        }
        docType.append("]>\n");
        return docType.toString();
    }

    public static final void writeStreams(Document document, File associatedAafxFile) throws IOException {
        if (document.getUserData("entityCount") == null) {
            return;
        }
    }

    public static final void setAttribute(Element element, String namespace, String prefix, String attributeName, String attributeValue) {
        Document document = element.getOwnerDocument();
        Attr attribute = null;
        document.createAttributeNS(namespace, attributeName);
        if (prefix == null) {
            attribute = document.createAttribute(attributeName);
            attribute.setNodeValue(attributeValue);
            element.setAttributeNode(attribute);
        } else {
            attribute = document.createAttributeNS(namespace, attributeName);
            attribute.setPrefix(prefix);
            attribute.setNodeValue(attributeValue);
            element.setAttributeNodeNS(attribute);
        }
    }

    public static final void setAttribute(Element element, String namespace, String prefix, String attributeName, PropertyValue value) {
        String stringValue = XMLBuilder.propertyValueToString(value);
        if (stringValue != null) {
            XMLBuilder.setAttribute(element, namespace, prefix, attributeName, stringValue);
        }
    }

    static final String propertyValueToString(PropertyValue value) {
        switch (value.getType().getTypeCategory()) {
            case StrongObjRef: 
            case Int: 
            case String: 
            case Record: {
                return value.getValue().toString();
            }
            case Enum: {
                return ((TypeDefinitionEnumerationImpl)value.getType()).getSymbolFromValue(value);
            }
            case ExtEnum: {
                return ((TypeDefinitionExtendibleEnumerationImpl)value.getType()).getSymbolFromValue(value);
            }
            case Rename: {
                TypeDefinitionRename renamedType = (TypeDefinitionRename)value.getType();
                return XMLBuilder.propertyValueToString(renamedType.getBaseValue(value));
            }
        }
        return null;
    }

    public static Object createFromXML(InputSource xmlSource) throws NullPointerException, SAXException, IOException {
        if (xmlSource == null) {
            throw new NullPointerException("Cannot create a new object instance from a null input source.");
        }
        MasterContentHandler mch = new MasterContentHandler(xmlSource);
        mch.parse();
        return mch.getResult();
    }

    public static Object createFromXML(InputSource xmlSource, Map<String, InputStream> streams) throws NullPointerException, SAXException, IOException {
        if (xmlSource == null) {
            throw new NullPointerException("Cannot create a new object instance from a null input source.");
        }
        MasterContentHandler mch = new MasterContentHandler(xmlSource, streams);
        mch.parse();
        return mch.getResult();
    }

    public static Object createFromXMLString(String xmlSource) throws NullPointerException, SAXException {
        if (xmlSource == null) {
            throw new NullPointerException("Cannot create a new object instance from a null input source.");
        }
        try {
            return XMLBuilder.createFromXML(new InputSource(new StringReader(xmlSource)));
        }
        catch (IOException e) {
            throw new SAXException("IO exception thrown during the parse of an XML string.", e);
        }
    }

    public static Object createFromXMLString(String xmlSource, byte[][] streams) throws NullPointerException, SAXException {
        if (xmlSource == null) {
            throw new NullPointerException("Cannot create a new object instance from a null input source.");
        }
        HashMap<String, InputStream> streamMap = new HashMap<String, InputStream>(streams.length);
        for (int x = 0; x < streams.length; ++x) {
            streamMap.put("stream_" + x, new ByteArrayInputStream(streams[x]));
        }
        try {
            return XMLBuilder.createFromXML(new InputSource(new StringReader(xmlSource)), streamMap);
        }
        catch (IOException e) {
            throw new SAXException("IO exception thrown during the parse of an XML string.", e);
        }
    }

    public static Map<String, InputStream> parseDocTypeToStreams(File aafxFile) throws IOException {
        int token;
        FileReader reader = new FileReader(aafxFile);
        File parentDir = aafxFile.getParentFile();
        HashMap<String, InputStream> streams = new HashMap<String, InputStream>();
        StreamTokenizer tokenizer = new StreamTokenizer(new BufferedReader(reader));
        tokenizer.eolIsSignificant(true);
        tokenizer.ordinaryChar(95);
        boolean enteredDocType = false;
        while ((token = tokenizer.nextToken()) != -1) {
            if (tokenizer.sval == null || !tokenizer.sval.equals("DOCTYPE")) continue;
            enteredDocType = true;
            break;
        }
        if (!enteredDocType) {
            reader.close();
            return streams;
        }
        while (true) {
            token = tokenizer.nextToken();
            switch (token) {
                case -1: {
                    reader.close();
                    return streams;
                }
                case -3: {
                    if (tokenizer.sval.equals("ENTITY")) {
                        XMLBuilder.parseEntity(tokenizer, streams, parentDir);
                        break;
                    }
                    if (!tokenizer.sval.equals("HeaderDictionary")) break;
                    reader.close();
                    return streams;
                }
            }
        }
    }

    private static void parseEntity(StreamTokenizer tokenizer, Map<String, InputStream> streams, File parentDir) throws IOException {
        StringBuffer entityName = new StringBuffer();
        StringBuffer entityFileName = new StringBuffer();
        StringBuffer currentBuffer = entityName;
        block7: while (true) {
            int token = tokenizer.nextToken();
            switch (token) {
                case -1: {
                    return;
                }
                case -2: {
                    currentBuffer.append((int)tokenizer.nval);
                    continue block7;
                }
                case -3: {
                    if (tokenizer.sval.equals("SYSTEM")) {
                        currentBuffer = entityFileName;
                        continue block7;
                    }
                    if (tokenizer.sval.equals("NDATA") || tokenizer.sval.equals("ENTITY")) {
                        streams.put(entityName.toString(), new FileInputStream(new File(parentDir, entityFileName.toString())));
                        if (tokenizer.sval.equals("ENTITY")) {
                            tokenizer.pushBack();
                        }
                        return;
                    }
                    currentBuffer.append(tokenizer.sval);
                    continue block7;
                }
                case 10: {
                    continue block7;
                }
                case 34: {
                    currentBuffer.append(tokenizer.sval);
                    continue block7;
                }
            }
            currentBuffer.append((char)token);
        }
    }

    public static final void validate(String schemaPath, String document) throws NullPointerException, SAXException, IOException {
        if (schemaPath == null) {
            throw new NullPointerException("Cannot validate against a schema with a null name.");
        }
        if (document == null) {
            throw new NullPointerException("Cannot validate a null document.");
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaSource = new StreamSource(new File(schemaPath));
        Schema schema = schemaFactory.newSchema(schemaSource);
        Validator validator = schema.newValidator();
        StreamSource xmlSource = new StreamSource(new StringReader(document));
        validator.validate(xmlSource);
    }

    public static final void main(String[] args) throws Exception {
        Object fromXML = XMLBuilder.createFromXML(new InputSource(new FileInputStream(args[0])));
        System.out.println(fromXML.toString());
    }
}

