/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.industry.AAFSpecifiedClasses;
import tv.amwa.maj.industry.Forge;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.MetaDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionCharacter;
import tv.amwa.maj.meta.TypeDefinitionEnumeration;
import tv.amwa.maj.meta.TypeDefinitionExtendibleEnumeration;
import tv.amwa.maj.meta.TypeDefinitionFixedArray;
import tv.amwa.maj.meta.TypeDefinitionIndirect;
import tv.amwa.maj.meta.TypeDefinitionInteger;
import tv.amwa.maj.meta.TypeDefinitionOpaque;
import tv.amwa.maj.meta.TypeDefinitionRecord;
import tv.amwa.maj.meta.TypeDefinitionRename;
import tv.amwa.maj.meta.TypeDefinitionSet;
import tv.amwa.maj.meta.TypeDefinitionStream;
import tv.amwa.maj.meta.TypeDefinitionString;
import tv.amwa.maj.meta.TypeDefinitionStrongObjectReference;
import tv.amwa.maj.meta.TypeDefinitionVariableArray;
import tv.amwa.maj.meta.TypeDefinitionWeakObjectReference;
import tv.amwa.maj.record.AUID;

public class MetaDictionaryGenerator
implements CommonConstants {
    public static final DocumentFragment generateBaselineDictionary() {
        MediaEngine.initializeAAF();
        Collection<ClassDefinition> baselineClasses = MetaDictionaryGenerator.makeBaselineClasses();
        DocumentFragment baselineFragment = MetaDictionaryGenerator.generateMetaDictionary(baselineClasses, Forge.makeAUID(101591860, (short)257, (short)257, new byte[]{1, 1, 1, 1, 1, 1, 1, 1}), "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", "AAF baseline scheme", "http://www.smpte-ra.org/schemas/2001-1-2011/metadict", "", "AAF", "Preface");
        return baselineFragment;
    }

    public static final String generateBaselineDictionaryAsAString() {
        return XMLBuilder.transformNodeToString(MetaDictionaryGenerator.generateBaselineDictionary());
    }

    public static final DocumentFragment generateMetaDictionary(Collection<ClassDefinition> classes, AUID schemeID, String schemeURI, String preferredPrefix, String description, String localNamespace, String localPrefix) throws NullPointerException {
        return MetaDictionaryGenerator.generateMetaDictionary(classes, schemeID, schemeURI, preferredPrefix, description, localNamespace, localPrefix, null, null);
    }

    public static final DocumentFragment generateMetaDictionary(Collection<ClassDefinition> classes, AUID schemeID, String schemeURI, String preferredPrefix, String description, String localNamespace, String localPrefix, String rootElement, String rootObject) throws NullPointerException {
        if (classes == null) {
            throw new NullPointerException("Cannot generate a meta dictionary from a null collection of classes.");
        }
        if (schemeID == null) {
            throw new NullPointerException("Cannot generate a meta dictionary with a null scheme identification.");
        }
        if (schemeURI == null) {
            throw new NullPointerException("Cannot generate a meta dictionary with a null scheme URI.");
        }
        if (rootElement == null && rootObject != null || rootElement != null && rootObject == null) {
            throw new NullPointerException("Both root element and root object properties must be provided or both be null.");
        }
        ArrayList<ClassDefinition> classList = new ArrayList<ClassDefinition>(classes.size() * 2);
        ArrayList<PropertyDefinition> propertyList = new ArrayList<PropertyDefinition>(classes.size() * 20);
        ArrayList<TypeDefinitionInteger> integerList = new ArrayList<TypeDefinitionInteger>();
        ArrayList<TypeDefinitionEnumeration> enumerationList = new ArrayList<TypeDefinitionEnumeration>();
        ArrayList<TypeDefinitionCharacter> characterList = new ArrayList<TypeDefinitionCharacter>();
        ArrayList<TypeDefinitionString> stringList = new ArrayList<TypeDefinitionString>();
        ArrayList<TypeDefinitionExtendibleEnumeration> extEnumList = new ArrayList<TypeDefinitionExtendibleEnumeration>();
        ArrayList<TypeDefinitionIndirect> indirectList = new ArrayList<TypeDefinitionIndirect>();
        ArrayList<TypeDefinitionOpaque> opaqueList = new ArrayList<TypeDefinitionOpaque>();
        ArrayList<TypeDefinitionStream> streamList = new ArrayList<TypeDefinitionStream>();
        ArrayList<TypeDefinitionWeakObjectReference> weakRefList = new ArrayList<TypeDefinitionWeakObjectReference>();
        ArrayList<TypeDefinitionStrongObjectReference> strongRefList = new ArrayList<TypeDefinitionStrongObjectReference>();
        ArrayList<TypeDefinitionRecord> recordList = new ArrayList<TypeDefinitionRecord>();
        ArrayList<TypeDefinitionFixedArray> fixedArrayList = new ArrayList<TypeDefinitionFixedArray>();
        ArrayList<TypeDefinitionSet> setList = new ArrayList<TypeDefinitionSet>();
        ArrayList<TypeDefinitionVariableArray> variableArrayList = new ArrayList<TypeDefinitionVariableArray>();
        ArrayList<TypeDefinitionRename> renameList = new ArrayList<TypeDefinitionRename>();
        HashSet<MetaDefinition> baseline = new HashSet<MetaDefinition>();
        boolean aafMode = false;
        if (rootElement != null && rootElement.equals("AAF")) {
            aafMode = true;
        }
        for (ClassDefinition classItem : classes) {
            MetaDictionaryGenerator.addPropertiesAndTypes(classItem, baseline, classList, propertyList, aafMode);
        }
        boolean allTypesChecked = false;
        while (!allTypesChecked) {
            HashSet<MetaDefinition> newForBaseline = new HashSet<MetaDefinition>();
            allTypesChecked = true;
            block19: for (MetaDefinition metaDefinition : baseline) {
                if (!(metaDefinition instanceof TypeDefinition)) continue;
                TypeDefinition typeDefinition = (TypeDefinition)metaDefinition;
                switch (typeDefinition.getTypeCategory()) {
                    case Int: {
                        if (integerList.contains(typeDefinition)) break;
                        integerList.add((TypeDefinitionInteger)typeDefinition);
                        break;
                    }
                    case Enum: {
                        TypeDefinitionEnumeration enumerationType;
                        if (!enumerationList.contains(typeDefinition)) {
                            enumerationList.add((TypeDefinitionEnumeration)typeDefinition);
                        }
                        if (baseline.contains((enumerationType = (TypeDefinitionEnumeration)typeDefinition).getElementType())) break;
                        newForBaseline.add(enumerationType.getElementType());
                        allTypesChecked = false;
                        break;
                    }
                    case Character: {
                        if (characterList.contains(typeDefinition)) break;
                        characterList.add((TypeDefinitionCharacter)typeDefinition);
                        break;
                    }
                    case String: {
                        TypeDefinitionString stringType;
                        if (!stringList.contains(typeDefinition)) {
                            stringList.add((TypeDefinitionString)typeDefinition);
                        }
                        if (baseline.contains((stringType = (TypeDefinitionString)typeDefinition).getElementType())) break;
                        newForBaseline.add(stringType.getElementType());
                        allTypesChecked = false;
                        break;
                    }
                    case ExtEnum: {
                        if (extEnumList.contains(typeDefinition)) break;
                        extEnumList.add((TypeDefinitionExtendibleEnumeration)typeDefinition);
                        break;
                    }
                    case Indirect: {
                        if (indirectList.contains(typeDefinition)) break;
                        indirectList.add((TypeDefinitionIndirect)typeDefinition);
                        break;
                    }
                    case Opaque: {
                        if (opaqueList.contains(typeDefinition)) break;
                        opaqueList.add((TypeDefinitionOpaque)typeDefinition);
                        break;
                    }
                    case Stream: {
                        if (streamList.contains(typeDefinition)) break;
                        streamList.add((TypeDefinitionStream)typeDefinition);
                        break;
                    }
                    case Record: {
                        if (!recordList.contains(typeDefinition)) {
                            recordList.add((TypeDefinitionRecord)typeDefinition);
                        }
                        TypeDefinitionRecord recordType = (TypeDefinitionRecord)typeDefinition;
                        for (int u = 0; u < recordType.getCount(); ++u) {
                            if (baseline.contains(recordType.getMemberType(u))) continue;
                            newForBaseline.add(recordType.getMemberType(u));
                            allTypesChecked = false;
                        }
                        continue block19;
                    }
                    case WeakObjRef: {
                        TypeDefinitionWeakObjectReference weakRefType;
                        if (!weakRefList.contains(typeDefinition)) {
                            weakRefList.add((TypeDefinitionWeakObjectReference)typeDefinition);
                        }
                        if (classList.contains((weakRefType = (TypeDefinitionWeakObjectReference)typeDefinition).getObjectType())) break;
                        MetaDictionaryGenerator.addPropertiesAndTypes(weakRefType.getObjectType(), newForBaseline, classList, propertyList, aafMode);
                        allTypesChecked = false;
                        break;
                    }
                    case StrongObjRef: {
                        TypeDefinitionStrongObjectReference strongRefType;
                        if (!strongRefList.contains(typeDefinition)) {
                            strongRefList.add((TypeDefinitionStrongObjectReference)typeDefinition);
                        }
                        if (classList.contains((strongRefType = (TypeDefinitionStrongObjectReference)typeDefinition).getObjectType())) break;
                        MetaDictionaryGenerator.addPropertiesAndTypes(strongRefType.getObjectType(), newForBaseline, classList, propertyList, aafMode);
                        allTypesChecked = false;
                        break;
                    }
                    case FixedArray: {
                        TypeDefinitionFixedArray fixedArrayType;
                        if (!fixedArrayList.contains(typeDefinition)) {
                            fixedArrayList.add((TypeDefinitionFixedArray)typeDefinition);
                        }
                        if (baseline.contains((fixedArrayType = (TypeDefinitionFixedArray)typeDefinition).getType())) break;
                        newForBaseline.add(fixedArrayType.getType());
                        allTypesChecked = false;
                        break;
                    }
                    case Set: {
                        TypeDefinitionSet setType;
                        if (!setList.contains(typeDefinition)) {
                            setList.add((TypeDefinitionSet)typeDefinition);
                        }
                        if (baseline.contains((setType = (TypeDefinitionSet)typeDefinition).getElementType())) break;
                        newForBaseline.add(setType.getElementType());
                        allTypesChecked = false;
                        break;
                    }
                    case VariableArray: {
                        TypeDefinitionVariableArray variableArrayType;
                        if (!variableArrayList.contains(typeDefinition)) {
                            variableArrayList.add((TypeDefinitionVariableArray)typeDefinition);
                        }
                        if (baseline.contains((variableArrayType = (TypeDefinitionVariableArray)typeDefinition).getType())) break;
                        newForBaseline.add(variableArrayType.getType());
                        allTypesChecked = false;
                        break;
                    }
                    case Rename: {
                        TypeDefinitionRename renameType;
                        if (!renameList.contains(typeDefinition)) {
                            renameList.add((TypeDefinitionRename)typeDefinition);
                        }
                        if (baseline.contains((renameType = (TypeDefinitionRename)typeDefinition).getBaseType())) break;
                        newForBaseline.add(renameType.getBaseType());
                        allTypesChecked = false;
                        break;
                    }
                }
            }
            baseline.addAll(newForBaseline);
        }
        DocumentFragment metadictFragment = XMLBuilder.createDocumentFragment();
        Element schemeElement = null;
        metadictFragment.appendChild(metadictFragment.getOwnerDocument().createComment("Meta Dictionary generated by the media authoring with Java API (MAJ API"));
        if (rootElement == null) {
            schemeElement = XMLBuilder.createChild(metadictFragment, localNamespace, localPrefix, "Extension");
        } else {
            schemeElement = XMLBuilder.createChild(metadictFragment, localNamespace, localPrefix, "Baseline");
            XMLBuilder.setAttribute(schemeElement, "", "", "rootElement", rootElement);
            XMLBuilder.setAttribute(schemeElement, "", "", "rootObject", rootObject);
        }
        XMLBuilder.appendElement((Node)schemeElement, localNamespace, localPrefix, "SchemeID", schemeID.toString());
        XMLBuilder.appendElement((Node)schemeElement, localNamespace, localPrefix, "SchemeURI", schemeURI);
        if (preferredPrefix != null) {
            XMLBuilder.appendElement((Node)schemeElement, localNamespace, localPrefix, "PreferredPrefix", preferredPrefix);
        }
        if (description != null) {
            XMLBuilder.appendElement((Node)schemeElement, localNamespace, localPrefix, "Description", description);
        }
        Element definitions = XMLBuilder.createChild(schemeElement, localNamespace, localPrefix, "MetaDefinitions");
        for (ClassDefinition classItem : classList) {
            classItem.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (PropertyDefinition propertyItem : propertyList) {
            propertyItem.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionInteger integerType : integerList) {
            integerType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionEnumeration enumerationType : enumerationList) {
            enumerationType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionCharacter characterType : characterList) {
            characterType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionString stringType : stringList) {
            stringType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionExtendibleEnumeration extEnumType : extEnumList) {
            extEnumType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionIndirect indirectType : indirectList) {
            indirectType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionOpaque opaqueType : opaqueList) {
            opaqueType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionStream streamType : streamList) {
            streamType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionFixedArray fixedArrayType : fixedArrayList) {
            fixedArrayType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionRecord recordType : recordList) {
            recordType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionWeakObjectReference weakRefType : weakRefList) {
            weakRefType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionStrongObjectReference strongRefType : strongRefList) {
            strongRefType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionSet setType : setList) {
            setType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionVariableArray variableArrayType : variableArrayList) {
            variableArrayType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        for (TypeDefinitionRename renameType : renameList) {
            renameType.appendMetadictXML(definitions, localNamespace, localPrefix);
        }
        return metadictFragment;
    }

    public static final String generateMetaDictionaryAsAString(Collection<ClassDefinition> classes, AUID schemeID, String schemeURI, String preferredPrefix, String description, String localNamespace, String localPrefix, String rootElement, String rootObject) throws NullPointerException {
        return XMLBuilder.transformNodeToString(MetaDictionaryGenerator.generateMetaDictionary(classes, schemeID, schemeURI, preferredPrefix, description, localNamespace, localPrefix, rootElement, rootObject));
    }

    public static final String generateMetaDictionaryAsAString(Collection<ClassDefinition> classes, AUID schemeID, String schemeURI, String preferredPrefix, String description, String localNamespace, String localPrefix) throws NullPointerException {
        return XMLBuilder.transformNodeToString(MetaDictionaryGenerator.generateMetaDictionary(classes, schemeID, schemeURI, preferredPrefix, description, localNamespace, localPrefix));
    }

    static final void addPropertiesAndTypes(ClassDefinition classItem, Set<MetaDefinition> baseline, List<ClassDefinition> classList, List<PropertyDefinition> propertyList, boolean aafMode) {
        baseline.add(classItem);
        if (!classList.contains(classItem)) {
            if (!classItem.isRoot()) {
                MetaDictionaryGenerator.addPropertiesAndTypes(classItem.getParent(), baseline, classList, propertyList, aafMode);
            }
            classList.add(classItem);
            for (PropertyDefinition propertyDefinition : classItem.getPropertyDefinitions()) {
                if (aafMode && !MediaEngine.isBaseline(propertyDefinition)) continue;
                baseline.add(propertyDefinition);
                if (!propertyList.contains(propertyDefinition)) {
                    propertyList.add(propertyDefinition);
                }
                TypeDefinition propertyType = propertyDefinition.getTypeDefinition();
                baseline.add(propertyType);
            }
        }
    }

    static final Collection<ClassDefinition> makeBaselineClasses() {
        ArrayList<ClassDefinition> baselineClasses = new ArrayList<ClassDefinition>(AAFSpecifiedClasses.abstractInterchangeable.length + AAFSpecifiedClasses.interchangeable.length + AAFSpecifiedClasses.abstractMeta.length + AAFSpecifiedClasses.meta.length);
        for (Class<?> abstractInterchangeable : AAFSpecifiedClasses.abstractInterchangeable) {
            baselineClasses.add(Warehouse.lookForClass(abstractInterchangeable));
        }
        for (Class<?> interchangeable : AAFSpecifiedClasses.interchangeable) {
            baselineClasses.add(Warehouse.lookForClass(interchangeable));
        }
        for (Class<?> abstactMeta : AAFSpecifiedClasses.abstractMeta) {
            baselineClasses.add(Warehouse.lookForClass(abstactMeta));
        }
        for (Class<?> meta : AAFSpecifiedClasses.meta) {
            baselineClasses.add(Warehouse.lookForClass(meta));
        }
        return baselineClasses;
    }

    public static final void main(String[] args) {
        System.out.println(MetaDictionaryGenerator.generateBaselineDictionaryAsAString());
    }
}

