/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import tv.amwa.maj.io.xml.MasterContentHandler;

public abstract class LocalHandler
extends MasterContentHandler
implements ContentHandler {
    private final Set<String> dataElementNameSet = Collections.synchronizedSet(new HashSet());
    private final Set<String> subElementNameSet = Collections.synchronizedSet(new HashSet());
    private static final String nameSeparator = "_ _";
    private String currentElementName = null;
    private Attributes currentElementAttributes = null;
    private int charactersCallCount;
    boolean bufferOverflow;
    private Map<String, List<String>> dataElementValues = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<String, String>> elementAttributes = Collections.synchronizedMap(new HashMap());
    private Map<String, List<MasterContentHandler>> subElementHandlers = Collections.synchronizedMap(new HashMap());

    private final void addDataElementNames(Class<?> handlerClass) {
        if (!handlerClass.getSuperclass().equals(LocalHandler.class)) {
            this.addDataElementNames(handlerClass.getSuperclass());
        }
        try {
            String[] elementNames;
            Field elementNamesField = handlerClass.getField("dataElementNames");
            for (String name : elementNames = (String[])elementNamesField.get(null)) {
                this.dataElementNameSet.add(this.getElementName() + nameSeparator + name);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private final void addSubElementNames(Class<?> handlerClass) {
        if (!handlerClass.getSuperclass().equals(LocalHandler.class)) {
            this.addSubElementNames(handlerClass.getSuperclass());
        }
        try {
            String[] elementNames;
            Field subElementsField = handlerClass.getField("subElementNames");
            for (String name : elementNames = (String[])subElementsField.get(null)) {
                this.subElementNameSet.add(this.getElementName() + nameSeparator + name);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private final boolean dataElementsContains(String name) {
        if (!this.dataElementNameSet.contains(this.getElementName())) {
            this.addDataElementNames(this.getClass());
            this.dataElementNameSet.add(this.getElementName());
        }
        return this.dataElementNameSet.contains(this.getElementName() + nameSeparator + name);
    }

    private final boolean subElementsContains(String name) {
        if (!this.subElementNameSet.contains(this.getElementName())) {
            this.subElementNameSet.add(this.getElementName());
            this.addSubElementNames(this.getClass());
        }
        if (this.subElementNameSet.contains(this.getElementName() + nameSeparator + name)) {
            return true;
        }
        return this.checkParentName(this.getHandlerClassForName(name).getSuperclass());
    }

    private boolean checkParentName(Class<?> parentClass) {
        if (parentClass.equals(LocalHandler.class)) {
            return false;
        }
        try {
            Field parentName = parentClass.getField("elementName");
            if (this.subElementNameSet.contains(this.getElementName() + nameSeparator + parentName.get(null))) {
                return true;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return this.checkParentName(parentClass.getSuperclass());
    }

    private String getParentName(Class<?> parentClass) {
        if (parentClass.equals(LocalHandler.class)) {
            return null;
        }
        try {
            Field parentNameField = parentClass.getField("elementName");
            String parentName = (String)parentNameField.get(null);
            if (this.subElementNameSet.contains(this.getElementName() + nameSeparator + parentName)) {
                return parentName;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return this.getParentName(parentClass.getSuperclass());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        ++this.charactersCallCount;
        if (this.currentElementName != null) {
            if (!this.dataElementValues.containsKey(this.currentElementName)) {
                this.dataElementValues.put(this.currentElementName, new Vector());
            }
            List<String> existingElements = this.dataElementValues.get(this.currentElementName);
            existingElements.add(new String(ch, start, length));
            this.elementAttributes.put(this.currentElementName, LocalHandler.makeAttributeMap(this.currentElementAttributes));
        }
        if (start + length != ch.length) {
            this.currentElementName = null;
            this.currentElementAttributes = null;
        } else {
            this.bufferOverflow = true;
        }
    }

    @Override
    public final void endDocument() throws SAXException {
        throw new SAXException("Local handlers must not deal with the end of documents.");
    }

    @Override
    public final void endElement(String uri, String localName, String name) throws SAXException {
        if (this.bufferOverflow) {
            assert (this.charactersCallCount > 0);
            if (this.charactersCallCount == 1) {
                this.currentElementName = null;
                this.currentElementAttributes = null;
            } else {
                List<String> mergeRequired = this.dataElementValues.get(name);
                StringBuffer mergeResult = new StringBuffer();
                for (int x = 0; x < this.charactersCallCount; ++x) {
                    mergeResult.insert(0, mergeRequired.remove(mergeRequired.size() - 1));
                }
                mergeRequired.add(mergeResult.toString());
            }
        }
        this.bufferOverflow = false;
        try {
            if (name.equals(this.getElementName())) {
                this.getXMLReader().setContentHandler(this.getParentHandler());
                this.setResult(this.createResult());
            }
        }
        catch (Exception e) {
            throw new SAXException(e.getClass().getName() + " thrown while parsing " + this.getElementName() + " XML element.", e);
        }
    }

    protected abstract Object createResult() throws Exception;

    @Override
    public final void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (this.dataElementsContains(name)) {
            this.currentElementName = name;
            this.currentElementAttributes = atts;
            this.charactersCallCount = 0;
            this.bufferOverflow = false;
            return;
        }
        if (this.subElementsContains(name)) {
            MasterContentHandler subElementHandler = this.makeHandler(name, uri, this, atts);
            String parentName = this.subElementNameSet.contains(this.getElementName() + nameSeparator + name) ? name : this.getParentName(this.getHandlerClassForName(name));
            if (!this.subElementHandlers.containsKey(parentName)) {
                this.subElementHandlers.put(parentName, new Vector());
            }
            List<MasterContentHandler> currentHandlers = this.subElementHandlers.get(parentName);
            currentHandlers.add(subElementHandler);
            this.elementAttributes.put(name, LocalHandler.makeAttributeMap(atts));
            this.getXMLReader().setContentHandler(subElementHandler);
            return;
        }
        throw new SAXException("Unexpected element " + name + " when processing a " + this.getClass().getEnclosingClass().getSimpleName() + ".");
    }

    public final String getElementData(String elementName) throws NullPointerException {
        if (elementName == null) {
            throw new NullPointerException("Cannot retrieve text content using a null element name.");
        }
        if (!this.dataElementValues.containsKey(elementName)) {
            return null;
        }
        List<String> dataElementsList = this.dataElementValues.get(elementName);
        if (dataElementsList.size() == 0) {
            return null;
        }
        return dataElementsList.get(0);
    }

    public final List<String> getElementDataList(String elementName) {
        if (elementName == null) {
            throw new NullPointerException("Cannot retrieve text content using a null element name.");
        }
        return this.dataElementValues.get(elementName);
    }

    public final Map<String, String> getAttributesForElement(String elementName) throws NullPointerException {
        if (elementName == null) {
            throw new NullPointerException("Cannot retrieve attributes using a null element name.");
        }
        return this.elementAttributes.get(elementName);
    }

    public final String getAttributeValueChildElement(String elementName, String attributeName) throws NullPointerException {
        if (attributeName == null) {
            throw new NullPointerException("Cannot retrieve an attribute value with a null attribute name.");
        }
        Map<String, String> attributeMap = this.getAttributesForElement(elementName);
        if (attributeMap != null) {
            return attributeMap.get(attributeName);
        }
        return null;
    }

    public final Object getSubElement(String elementName) throws NullPointerException {
        if (elementName == null) {
            throw new NullPointerException("Cannot retrieve a sub element value using a null element name.");
        }
        if (!this.subElementHandlers.containsKey(elementName)) {
            return null;
        }
        MasterContentHandler handler = this.subElementHandlers.get(elementName).get(0);
        return handler.getResult();
    }

    public final List<Object> getSubElementList(String elementName) throws NullPointerException {
        if (elementName == null) {
            throw new NullPointerException("Cannot retrieve a list of sub element values using a null element name.");
        }
        if (!this.subElementHandlers.containsKey(elementName)) {
            return null;
        }
        Vector<Object> objectList = new Vector<Object>(this.subElementHandlers.get(elementName).size());
        for (MasterContentHandler handler : this.subElementHandlers.get(elementName)) {
            objectList.add(handler.getResult());
        }
        return objectList;
    }

    public final boolean isSubElementList(String elementName) throws NullPointerException {
        if (elementName == null) {
            throw new NullPointerException("Cannot check sub element kind with a null element name.");
        }
        if (!this.subElementHandlers.containsKey(elementName)) {
            return false;
        }
        return this.subElementHandlers.get(elementName).size() > 1;
    }

    public final boolean isDataElementList(String elementName) throws NullPointerException {
        if (elementName == null) {
            throw new NullPointerException("Cannot check data element kind with a null element name.");
        }
        if (!this.dataElementValues.containsKey(elementName)) {
            return false;
        }
        return this.dataElementValues.get(elementName).size() > 1;
    }

    public final boolean isSingleSubElement(String elementName) throws NullPointerException {
        if (elementName == null) {
            throw new NullPointerException("Cannot check sub element kind with a null element name.");
        }
        if (!this.subElementHandlers.containsKey(elementName)) {
            return false;
        }
        return this.subElementHandlers.get(elementName).size() == 1;
    }

    public final boolean isSingleDataElement(String elementName) throws NullPointerException {
        if (elementName == null) {
            throw new NullPointerException("Cannot check data element kind with a null element name.");
        }
        if (!this.dataElementValues.containsKey(elementName)) {
            return false;
        }
        return this.dataElementValues.get(elementName).size() == 1;
    }

    public final boolean isDataElementPresent(String elementName) throws NullPointerException {
        if (elementName == null) {
            throw new NullPointerException("Cannot check if the content of a data element is present using a null string.");
        }
        return this.dataElementValues.containsKey(elementName);
    }

    public final boolean isSubElementPresent(String elementName) throws NullPointerException {
        if (elementName == null) {
            throw new NullPointerException("Cannot check if a sub element value is present using a null string.");
        }
        return this.subElementHandlers.containsKey(elementName) && this.subElementHandlers.get(elementName).size() > 0;
    }

    public final boolean areAttributesPresent(String elementName) throws NullPointerException {
        if (elementName == null) {
            throw new NullPointerException("Cannot check if attributes are present for an element using a null string.");
        }
        if (this.elementAttributes.containsKey(elementName)) {
            return this.elementAttributes.get(elementName) != null;
        }
        return false;
    }

    @Override
    public InputStream getInputStreamForName(String streamName) {
        return this.getParentHandler().getInputStreamForName(streamName);
    }

    public byte[] getBytesFromStream(String streamName) throws IOException {
        InputStream stream = this.getInputStreamForName(streamName);
        if (stream == null) {
            return null;
        }
        byte[] streamData = new byte[stream.available()];
        stream.read(streamData);
        stream.close();
        return streamData;
    }
}

