/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import tv.amwa.maj.constant.RP224;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MediaSetAdd;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.integer.UInt16;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.integer.UInt64;
import tv.amwa.maj.io.mxf.FixedLengthPack;
import tv.amwa.maj.io.mxf.HeaderOpenIncompletePartitionPack;
import tv.amwa.maj.io.mxf.MXFBuilder;
import tv.amwa.maj.io.mxf.Padded;
import tv.amwa.maj.io.mxf.PartitionPack;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.impl.BodyClosedCompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.BodyClosedIncompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.BodyOpenCompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.BodyOpenIncompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.FooterClosedCompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.FooterClosedIncompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.HeaderClosedCompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.HeaderClosedIncompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.HeaderOpenCompletePartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.MXFFileImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=218169857, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 2, 5, 1, 1}, definedName="PartitionPack", description="A partition pack describes a single partition within an MXF file.", namespace="http://www.smpte-ra.org/rp210", prefix="mxf", symbol="PartitionPack")
public abstract class PartitionPackImpl
implements MetadataObject,
FixedLengthPack,
PartitionPack,
Cloneable,
Padded {
    private short majorVersion = 1;
    private short minorVersion = (short)3;
    private int kagSize = 1;
    private long thisPartition;
    private long previousPartition = 0L;
    private long footerPartition = 0L;
    private long headerByteCount = 0L;
    private long indexByteCount = 0L;
    private int indexSID = 0;
    private long bodyOffset;
    private int bodySID = 0;
    private AUID operationalPattern;
    private Set<AUID> essenceContainers = new HashSet<AUID>();
    private long paddingBytes = 0L;
    public static final String[] packOrder = new String[]{"Major Version", "Minor Version", "KAGSize", "ThisPartition", "PreviousPartition", "FooterPartition", "HeaderByteCount", "IndexByteCount", "IndexSID", "BodyOffset", "BodySID", "Operational Pattern", "EssenceContainers"};

    public static final void initializePackClasses() {
        Warehouse.lookForClass(HeaderClosedCompletePartitionPackImpl.class);
        Warehouse.lookForClass(HeaderClosedIncompletePartitionPackImpl.class);
        Warehouse.lookForClass(HeaderOpenCompletePartitionPackImpl.class);
        Warehouse.lookForClass(HeaderOpenIncompletePartitionPack.class);
        Warehouse.lookForClass(BodyClosedCompletePartitionPackImpl.class);
        Warehouse.lookForClass(BodyClosedIncompletePartitionPackImpl.class);
        Warehouse.lookForClass(BodyOpenCompletePartitionPackImpl.class);
        Warehouse.lookForClass(BodyOpenIncompletePartitionPackImpl.class);
        Warehouse.lookForClass(FooterClosedCompletePartitionPackImpl.class);
        Warehouse.lookForClass(FooterClosedIncompletePartitionPackImpl.class);
    }

    public PartitionPackImpl() {
    }

    public PartitionPackImpl(@UInt32 int kagSize, @UInt64 long thisPartition, @UInt64 long bodyOffset, AUID operationalPattern) {
        this.kagSize = kagSize;
        this.thisPartition = thisPartition;
        this.bodyOffset = bodyOffset;
        this.operationalPattern = operationalPattern.clone();
    }

    @Override
    @MediaProperty(uuid1=50397697, uuid2=1536, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="Major Version", typeName="UInt16", optional=false, uniqueIdentifier=false, pid=0, symbol="MajorVersion")
    @UInt16
    public short getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    @MediaPropertySetter(value="Major Version")
    public void setMajorVersion(@UInt16 short majorVersion) {
        this.majorVersion = majorVersion;
    }

    @Override
    @MediaProperty(uuid1=50397697, uuid2=1792, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="Minor Version", typeName="UInt16", optional=false, uniqueIdentifier=false, pid=0, symbol="MinorVersion")
    @UInt16
    public short getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    @MediaPropertySetter(value="Minor Version")
    public void setMinorVersion(@UInt16 short minorVersion) {
        this.minorVersion = minorVersion;
    }

    @Override
    @MediaProperty(uuid1=50397697, uuid2=2304, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="KAGSize", aliases={"KAG Size"}, typeName="UInt32", optional=false, uniqueIdentifier=false, pid=0, symbol="KAGSize")
    @UInt32
    public int getKagSize() {
        return this.kagSize;
    }

    @Override
    @MediaPropertySetter(value="KAGSize")
    public void setKagSize(@UInt32 int kagSize) {
        this.kagSize = kagSize;
    }

    @Override
    @MediaProperty(uuid1=101715971, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="ThisPartition", aliases={"Current Number in Sequence"}, typeName="UInt64", optional=false, uniqueIdentifier=false, pid=0, symbol="ThisPartition")
    @UInt64
    public long getThisPartition() {
        return this.thisPartition;
    }

    @Override
    @MediaPropertySetter(value="ThisPartition")
    public void setThisPartition(@UInt64 long thisPartition) {
        this.thisPartition = thisPartition;
    }

    @Override
    @MediaProperty(uuid1=101715970, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="PreviousPartition", aliases={"Previous Number in Sequence"}, typeName="UInt64", optional=false, uniqueIdentifier=false, pid=0, symbol="PreviousPartition")
    @UInt64
    public long getPreviousPartition() {
        return this.previousPartition;
    }

    @Override
    @MediaPropertySetter(value="PreviousPartition")
    public void setPreviousPartition(@UInt64 long previousPartition) {
        this.previousPartition = previousPartition;
    }

    @Override
    @MediaProperty(uuid1=101715973, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="FooterPartition", aliases={"Last Number in Sequence"}, typeName="UInt64", optional=false, uniqueIdentifier=false, pid=0, symbol="FooterPartition")
    @UInt64
    public long getFooterPartition() {
        return this.footerPartition;
    }

    @Override
    @MediaPropertySetter(value="FooterPartition")
    public void setFooterPartition(@UInt64 long footerPartition) {
        this.footerPartition = footerPartition;
    }

    @Override
    @MediaProperty(uuid1=67504385, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="HeaderByteCount", aliases={"Header Byte Count"}, typeName="UInt64", optional=false, uniqueIdentifier=false, pid=0, symbol="HeaderByteCount")
    @UInt64
    public long getHeaderByteCount() {
        return this.headerByteCount;
    }

    @Override
    @MediaPropertySetter(value="HeaderByteCount")
    public void setHeaderByteCount(@UInt64 long headerByteCount) {
        this.headerByteCount = headerByteCount;
    }

    @Override
    @MediaProperty(uuid1=67504386, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="IndexByteCount", aliases={"Index Byte Count"}, typeName="UInt64", optional=false, uniqueIdentifier=false, pid=0, symbol="IndexByteCount")
    @UInt64
    public long getIndexByteCount() {
        return this.indexByteCount;
    }

    @Override
    @MediaPropertySetter(value="IndexByteCount")
    public void setIndexByteCount(@UInt64 long indexByteCount) {
        this.indexByteCount = indexByteCount;
    }

    @Override
    @MediaProperty(uuid1=16974853, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="IndexSID", aliases={"Index Stream ID"}, typeName="UInt32", optional=false, uniqueIdentifier=false, pid=0, symbol="IndexSID")
    @UInt32
    public int getIndexSID() {
        return this.indexSID;
    }

    @Override
    @MediaPropertySetter(value="IndexSID")
    public void setIndexSID(int indexSID) {
        this.indexSID = indexSID;
    }

    @Override
    @MediaProperty(uuid1=101187842, uuid2=259, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="BodyOffset", aliases={"Stream Position Indicator"}, typeName="UInt64", optional=false, uniqueIdentifier=false, pid=0, symbol="BodyOffset")
    @UInt64
    public long getBodyOffset() {
        return this.bodyOffset;
    }

    @Override
    @MediaPropertySetter(value="BodyOffset")
    public void setBodyOffset(@UInt64 long bodyOffset) {
        this.bodyOffset = bodyOffset;
    }

    @Override
    @MediaProperty(uuid1=16974852, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="BodySID", aliases={"Essence Stream ID"}, typeName="UInt32", optional=false, uniqueIdentifier=false, pid=0, symbol="BodySID")
    @UInt32
    public int getBodySID() {
        return this.bodySID;
    }

    @Override
    @MediaPropertySetter(value="BodySID")
    public void setBodySID(@UInt32 int bodySID) {
        this.bodySID = bodySID;
    }

    @Override
    @MediaProperty(uuid1=16908803, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="Operational Pattern", typeName="AUID", optional=false, uniqueIdentifier=false, pid=0, symbol="OperationalPattern")
    public AUID getOperationalPattern() {
        return this.operationalPattern;
    }

    @Override
    @MediaPropertySetter(value="Operational Pattern")
    public void setOperationalPattern(AUID operationalPattern) {
        this.operationalPattern = operationalPattern;
    }

    @Override
    @MediaProperty(uuid1=0x1020210, uuid2=513, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="EssenceContainers", typeName="AUIDSet", optional=false, uniqueIdentifier=false, pid=0, symbol="EssenceContainers")
    public Set<AUID> getEssenceContainers() {
        return this.essenceContainers;
    }

    @Override
    @MediaPropertySetter(value="EssenceContainers")
    public void setEssenceContainers(Set<AUID> essenceContainers) {
        this.essenceContainers = essenceContainers;
    }

    @Override
    @MediaSetAdd(value="EssenceContainer")
    public void addEssenceContainer(AUID essenceContainerID) throws NullPointerException {
        if (essenceContainerID == null) {
            throw new NullPointerException("Cannot add a null essence container to the set of essence containers for this partition pack.");
        }
        this.essenceContainers.add(essenceContainerID);
    }

    @Override
    public String[] getPackOrder() {
        return packOrder;
    }

    @Override
    public long getPaddingFillSize() {
        return this.paddingBytes;
    }

    @Override
    public int getEncodedSize() {
        return 88 + this.essenceContainers.size() * 16;
    }

    @Override
    public void setPaddingFillSize(long paddingFillSize) throws IllegalArgumentException {
        if (paddingFillSize < 0L) {
            throw new IllegalArgumentException("Number of padding bytes must be greater than 0.");
        }
        this.paddingBytes = paddingFillSize;
    }

    public String toString() {
        return MediaEngine.toString(this);
    }

    @Override
    public PartitionPack clone() {
        try {
            return (PartitionPack)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    public static final PartitionPack readPartitionPack(MXFFileImpl material) throws EndOfDataException {
        UL key = material.readKey();
        long length = material.readBER();
        ByteBuffer buffer = material.read((int)length);
        buffer.rewind();
        return (PartitionPack)((Object)MXFBuilder.readFixedLengthPack((AUIDImpl)key, buffer));
    }

    public static final short initializeMajorVersion() {
        return 1;
    }

    public static final short initializeMinorVersion() {
        return 3;
    }

    public static final int initializeKAGSize() {
        return 1;
    }

    public static final long initializeThisPartition() {
        return 0L;
    }

    public static final long initializePreviousPartition() {
        return 0L;
    }

    public static final long initializeFooterPartition() {
        return 0L;
    }

    public static final long initializeHeaderByteCount() {
        return 0L;
    }

    public static final long initializeIndexByteCount() {
        return 0L;
    }

    public static final int initializeIndexSID() {
        return 0;
    }

    public static final long initializeBodyOffset() {
        return 0L;
    }

    public static final int initializeBodySID() {
        return 0;
    }

    public static final AUID initializeOperationalPattern() {
        return RP224.MXF_OP1a_SingleItem_SinglePackage_UniTrack_Stream_Internal;
    }

    public static final Set<AUID> initializeEssenceContainers() {
        return new HashSet<AUID>();
    }

    static {
        PartitionPackImpl.initializePackClasses();
    }
}

