/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.io.mxf.DeltaEntry;
import tv.amwa.maj.io.mxf.IndexEntry;
import tv.amwa.maj.io.mxf.IndexTable;
import tv.amwa.maj.io.mxf.IndexTableSegment;
import tv.amwa.maj.io.mxf.MXFBuilder;
import tv.amwa.maj.io.mxf.Padded;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.impl.DeltaEntryImpl;
import tv.amwa.maj.io.mxf.impl.ResolutionEntry;
import tv.amwa.maj.misctype.PositionType;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.record.impl.RationalImpl;

public class IndexTableImpl
implements IndexTable,
Cloneable,
Padded {
    @UInt32
    private int indexSID = -1;
    private SortedMap<Long, IndexTableSegment> segments = Collections.synchronizedSortedMap(new TreeMap());
    private long paddingFillSize = 0L;
    private static final Map<AUIDImpl, MetadataObject> referenceTable = new HashMap<AUIDImpl, MetadataObject>();
    private static final List<ResolutionEntry> resolutions = new Vector<ResolutionEntry>();
    public static final Rational zeroProportion = new RationalImpl(0, 1);
    public static final DeltaEntry[] singleElementDelta = new DeltaEntry[]{new DeltaEntryImpl(0)};

    @Override
    @UInt32
    public int getIndexSID() {
        return this.indexSID;
    }

    void addSegment(IndexTableSegment segment) throws NullPointerException {
        if (segment == null) {
            throw new NullPointerException("Cannot add a null index table segment to the index table.");
        }
        if (this.indexSID == -1) {
            this.indexSID = segment.getIndexSID();
        }
        this.segments.put(segment.getIndexStartPosition(), segment);
    }

    @Override
    public IndexTable clone() {
        try {
            return (IndexTable)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IndexTable createFromBuffer(ByteBuffer buffer) throws NullPointerException, BufferUnderflowException {
        if (buffer == null) {
            throw new NullPointerException("Cannot create an index table from a null value.");
        }
        long lastFillLength = 0L;
        IndexTableImpl indexTable = new IndexTableImpl();
        int preserveLimit = buffer.limit();
        while (buffer.hasRemaining()) {
            lastFillLength = MXFBuilder.skipKLVFill(buffer);
            if (lastFillLength > 0L) continue;
            lastFillLength = -1L;
            UL key = MXFBuilder.readKey(buffer);
            long length = MXFBuilder.readBERLength(buffer);
            int limit = (int)((long)buffer.position() + length);
            if (!key.equals(IndexTableSegment.key)) {
                buffer.position(limit);
                continue;
            }
            buffer.limit(limit);
            try {
                IndexTableSegment nextSegment = (IndexTableSegment)MXFBuilder.readLocalSet(key, buffer, indexPrimer, referenceTable, resolutions);
                indexTable.addSegment(nextSegment);
            }
            catch (Exception e) {
                System.err.println(e.getClass().getName() + " thrown when trying to read an index table segment: " + e.getMessage());
            }
            finally {
                buffer.limit(preserveLimit);
                buffer.position(limit);
            }
        }
        if (lastFillLength > 0L) {
            indexTable.setPaddingFillSize(lastFillLength);
        }
        referenceTable.clear();
        resolutions.clear();
        return indexTable;
    }

    @Override
    public long getPaddingFillSize() {
        return this.paddingFillSize;
    }

    @Override
    public void setPaddingFillSize(long paddingFillSize) throws IllegalArgumentException {
        if (paddingFillSize < 0L) {
            throw new IllegalArgumentException("Cannot set the padding size of an index table to a negative value.");
        }
        this.paddingFillSize = paddingFillSize;
    }

    public String toString() {
        StringBuffer tableAsString = new StringBuffer();
        tableAsString.append("Index table made up from ");
        tableAsString.append(this.segments.size());
        tableAsString.append(" segments:\n");
        for (Long startIndex : this.segments.keySet()) {
            tableAsString.append(((IndexTableSegment)this.segments.get(startIndex)).toString());
            tableAsString.append('\n');
        }
        return tableAsString.toString();
    }

    @Override
    public long streamOffset(@PositionType long position, int subStream) throws IllegalArgumentException {
        Rational proportion;
        Long likelyInstance = this.segments.headMap(position + 1L).lastKey();
        IndexTableSegment likelySegment = (IndexTableSegment)this.segments.get(likelyInstance);
        DeltaEntry[] deltas = null;
        try {
            deltas = likelySegment.getDeltaEntryArray();
        }
        catch (PropertyNotPresentException pnpe) {
            deltas = singleElementDelta;
        }
        if (subStream < 0 || subStream >= deltas.length) {
            throw new IllegalArgumentException("The given substream is outside of the range of the sub stream known to this index table.");
        }
        DeltaEntry elementDelta = deltas[subStream];
        if ((position -= likelySegment.getIndexStartPosition()) < 0L || position >= likelySegment.getIndexDuration()) {
            throw new IllegalArgumentException("Stream offset cannot be resolved.");
        }
        IndexEntry[] editUnitIndex = null;
        try {
            editUnitIndex = likelySegment.getIndexEntryArray();
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
        byte posTableIndex = elementDelta.getPosTableIndex();
        if (posTableIndex <= -1) {
            if (editUnitIndex == null) {
                throw new IllegalArgumentException("Temporal reordering expected but no index entries provided.");
            }
            position += (long)editUnitIndex[(int)position].getTemporalOffset();
        }
        long result = editUnitIndex != null ? editUnitIndex[(int)position].getStreamOffset() : position * (long)likelySegment.getEditUnitByteCount();
        byte slice = elementDelta.getSlice();
        if (slice > 0) {
            if (editUnitIndex == null) {
                throw new IllegalArgumentException("Slices in the delta table but no index entries provided.");
            }
            result += (long)editUnitIndex[(int)position].getSliceOffset()[slice - 1];
        }
        result += (long)elementDelta.getElementDelta();
        Rational rational = proportion = posTableIndex > 0 && editUnitIndex != null ? editUnitIndex[(int)position].getPosTable()[posTableIndex - 1] : zeroProportion;
        if (proportion.getNumerator() != 0) {
            throw new IllegalArgumentException("Fractional offset processing not supported in this version of MAJ.");
        }
        return result;
    }
}

