/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Vector;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.io.mxf.HeaderMetadata;
import tv.amwa.maj.io.mxf.MXFBuilder;
import tv.amwa.maj.io.mxf.PrimerPack;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.UnitType;
import tv.amwa.maj.io.mxf.impl.PrimerPackImpl;
import tv.amwa.maj.io.mxf.impl.ResolutionEntry;
import tv.amwa.maj.model.Preface;
import tv.amwa.maj.model.impl.PrefaceImpl;
import tv.amwa.maj.record.impl.AUIDImpl;

public class HeaderMetadataImpl
implements HeaderMetadata,
Cloneable {
    private PrimerPack primerPack;
    private Preface preface;
    private long primerPackPadding = 0L;
    private long endPadding = 0L;

    public HeaderMetadataImpl() {
    }

    public HeaderMetadataImpl(PrimerPack primerPack) throws NullPointerException {
        if (primerPack == null) {
            throw new NullPointerException("Cannot create new header metadata using a null primer pack.");
        }
        this.primerPack = primerPack;
    }

    public HeaderMetadataImpl(PrimerPack primerPack, Preface preface) throws NullPointerException {
        if (primerPack == null) {
            throw new NullPointerException("Cannot create new header metadata using a null primer pack.");
        }
        if (preface == null) {
            throw new NullPointerException("Cannot create new header metadata using a null preface.");
        }
        this.primerPack = primerPack;
        this.preface = preface;
    }

    public long getPrimerPackPadding() {
        return this.primerPackPadding;
    }

    void setPrimerPackPadding(long primerPackPadding) {
        if (primerPackPadding < 0L) {
            throw new IllegalArgumentException("Cannot have a negative number of bytes for padding!");
        }
        this.primerPackPadding = primerPackPadding;
    }

    public long getEndPadding() {
        return this.endPadding;
    }

    void setEndPadding(long endPadding) {
        if (endPadding < 0L) {
            throw new IllegalArgumentException("Cannot have a negative number of bytes for padding!");
        }
        this.endPadding = endPadding;
    }

    @Override
    public HeaderMetadata clone() {
        try {
            return (HeaderMetadata)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    @Override
    public Preface getPreface() {
        return this.preface;
    }

    @Override
    public PrimerPack getPrimerPack() {
        return this.primerPack;
    }

    public static final HeaderMetadata createFromBuffer(ByteBuffer buffer) throws IllegalArgumentException {
        try {
            PrimerPack primerPack = PrimerPackImpl.createFromBytes(buffer);
            if (primerPack == null) {
                throw new IllegalArgumentException("Problem reading a primer pack to create header metadata from a buffer.");
            }
            HeaderMetadataImpl headerMetadata = new HeaderMetadataImpl(primerPack);
            headerMetadata.setPrimerPackPadding(MXFBuilder.skipKLVFill(buffer));
            headerMetadata.readPreface(buffer);
            return headerMetadata;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create header metadata from the given buffer due to a " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    final Preface readPreface(ByteBuffer buffer) {
        PrefaceImpl preface = null;
        long lastFillSize = -1L;
        HashMap<AUIDImpl, MetadataObject> referenceTable = new HashMap<AUIDImpl, MetadataObject>();
        Vector<ResolutionEntry> resolutions = new Vector<ResolutionEntry>();
        int preserveLimit = buffer.limit();
        try {
            while (buffer.hasRemaining()) {
                lastFillSize = MXFBuilder.skipKLVFill(buffer);
                if (lastFillSize > 0L) continue;
                UL key = MXFBuilder.readKey(buffer);
                long length = MXFBuilder.readBERLength(buffer);
                buffer.limit((int)((long)buffer.position() + length));
                MetadataObject metadataFromFile = MXFBuilder.readLocalSet((AUIDImpl)key, buffer, this.primerPack, referenceTable, resolutions);
                buffer.limit(preserveLimit);
                if (!(metadataFromFile instanceof Preface)) continue;
                preface = (PrefaceImpl)metadataFromFile;
            }
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + " thrown when reading a preface: " + e.getMessage());
        }
        this.setEndPadding(lastFillSize);
        for (ResolutionEntry resolutionEntry : resolutions) {
            resolutionEntry.resolve(referenceTable);
        }
        this.preface = preface;
        return preface;
    }

    @Override
    public UnitType getUnitType() {
        return UnitType.HeaderMetadata;
    }
}

