/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.Forge;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.io.mxf.EssenceContainer;
import tv.amwa.maj.io.mxf.EssenceElement;
import tv.amwa.maj.io.mxf.EssencePartition;
import tv.amwa.maj.io.mxf.MXFBuilder;
import tv.amwa.maj.io.mxf.MXFConstants;
import tv.amwa.maj.io.mxf.Partition;
import tv.amwa.maj.io.mxf.PartitionPack;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.impl.CPSystemItemImpl;
import tv.amwa.maj.io.mxf.impl.EssenceElementImpl;
import tv.amwa.maj.io.mxf.impl.MXFFileImpl;
import tv.amwa.maj.io.mxf.impl.PartitionImpl;

public abstract class EssencePartitionImpl
extends PartitionImpl
implements EssencePartition,
MetadataObject {
    private long elementOffset = 0L;
    private EssenceContainer essenceContainer;
    private long essenceBytesWritten = 0L;

    @Override
    public EssenceContainer getEssenceContainer() {
        return null;
    }

    @Override
    public EssenceElement readEssenceElement() {
        MXFFileImpl file = this.getMXFFile();
        PartitionPack partitionPack = this.getPartitionPack();
        if (partitionPack.getBodySID() == 0) {
            return null;
        }
        long elementPosition = 0L;
        Partition nextPartition = file.getNextPartition(this);
        long nextPartitionStart = nextPartition.getPartitionPack().getThisPartition();
        UL elementKey = (UL)Forge.nilAUID();
        long length = 0L;
        ByteBuffer data = null;
        long startOfBody = this.getEndOfParitionPack() + partitionPack.getBodyOffset();
        elementPosition = startOfBody + this.elementOffset;
        file.seek(elementPosition);
        while (!this.isEssenceKey(elementKey)) {
            elementPosition = startOfBody + this.elementOffset;
            if (elementPosition + 16L >= nextPartitionStart) {
                file.seek(nextPartitionStart);
                return null;
            }
            elementKey = file.readKey();
            length = file.readBER();
            data = file.read((int)length);
            this.elementOffset = file.tell() - startOfBody;
        }
        if (elementKey.equals(CPSystemItemImpl.key)) {
            return CPSystemItemImpl.make(data);
        }
        if (EssenceElementImpl.isEssenceElement(elementKey)) {
            return EssenceElementImpl.make(elementKey, data);
        }
        return null;
    }

    boolean isEssenceKey(UL key) {
        if (key.equals(CPSystemItemImpl.key)) {
            return true;
        }
        return EssenceElementImpl.isEssenceElement(key);
    }

    @Override
    public void initializeWritingBody() throws NullPointerException, InsufficientSpaceException, IOException {
        this.writePartitionPack();
        this.getMXFFile().seek(this.getEndOfParitionPack());
        this.essenceBytesWritten = 0L;
    }

    @Override
    public void writeEssenceElementHeader(byte itemType, byte elementType, byte elementCount, byte elementItem, long length) throws IOException {
        byte[] keyBytes = ((UL)EssenceElement.essenceElementBase).getUniversalLabel();
        keyBytes[12] = itemType;
        keyBytes[14] = elementType;
        keyBytes[13] = elementCount;
        keyBytes[15] = elementItem;
        ByteBuffer essenceHeaderBytes = ByteBuffer.allocate(24);
        essenceHeaderBytes.rewind();
        essenceHeaderBytes.put(keyBytes);
        MXFBuilder.writeBERLength(length, 8, essenceHeaderBytes);
        essenceHeaderBytes.rewind();
        this.getMXFFile().write(essenceHeaderBytes);
        this.essenceBytesWritten += 24L;
    }

    @Override
    public void writeEssenceElementHeader(int trackNumber, long length) throws IOException {
        this.writeEssenceElementHeader((byte)(trackNumber >>> 24 & 0xFF), (byte)(trackNumber >>> 8 & 0xFF), (byte)(trackNumber >>> 16 & 0xFF), (byte)(trackNumber & 0xFF), length);
    }

    @Override
    public void writeEssenceBlock(ByteBuffer essence) throws IOException {
        long aboutToWrite = essence.remaining();
        this.getMXFFile().write(essence);
        this.essenceBytesWritten += aboutToWrite;
    }

    @Override
    public long fillToEnd() throws IOException {
        long fillMeUpSize = this.getEndOfParitionPack() + this.getInitialSize() - this.getMXFFile().tell();
        if (fillMeUpSize > 24L) {
            ByteBuffer fillBuffer = ByteBuffer.allocate((int)fillMeUpSize);
            MXFBuilder.writeKey((UL)MXFConstants.KLVFill, fillBuffer);
            MXFBuilder.writeBERLength(fillBuffer.remaining() - 8, 8, fillBuffer);
            fillBuffer.rewind();
            this.getMXFFile().write(fillBuffer);
        }
        return fillMeUpSize;
    }

    public void rewind() {
        this.elementOffset = 0L;
    }

    @Override
    public void updateSizes() {
        int packSize = this.getPartitionPack().getEncodedSize() + 20;
        long maxKnownSize = (long)packSize + this.getPartitionPack().getIndexByteCount() + this.getPartitionPack().getHeaderByteCount() + this.essenceBytesWritten;
        long initialPlusPack = this.getInitialSize() + (long)packSize;
        this.setActualSize(initialPlusPack > maxKnownSize ? initialPlusPack : maxKnownSize);
    }

    @Override
    public EssencePartition clone() {
        return (EssencePartition)super.clone();
    }
}

