/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.exception.BadParameterException;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.Forge;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.integer.UInt64;
import tv.amwa.maj.io.mxf.DeltaEntry;
import tv.amwa.maj.io.mxf.FixedLengthPack;
import tv.amwa.maj.io.mxf.IndexEntry;
import tv.amwa.maj.io.mxf.MXFConstants;
import tv.amwa.maj.io.mxf.MXFFile;
import tv.amwa.maj.io.mxf.PrimerPack;
import tv.amwa.maj.io.mxf.TypeDefinitions;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.impl.DeltaEntryImpl;
import tv.amwa.maj.io.mxf.impl.IndexEntryImpl;
import tv.amwa.maj.io.mxf.impl.IndexTableSegmentImpl;
import tv.amwa.maj.io.mxf.impl.MXFFileImpl;
import tv.amwa.maj.io.mxf.impl.PartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.PrimerPackImpl;
import tv.amwa.maj.io.mxf.impl.RandomIndexPackImpl;
import tv.amwa.maj.io.mxf.impl.ResolutionEntry;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.MetaDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionObjectReference;
import tv.amwa.maj.meta.TypeDefinitionStrongObjectReference;
import tv.amwa.maj.meta.impl.ClassDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionObjectReferenceImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionRecordImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionSetImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionVariableArrayImpl;
import tv.amwa.maj.model.Preface;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

public class MXFBuilder {
    private static boolean mxfRegistration = false;
    private static Set<String> propertyIgnoreList = new HashSet<String>();

    private MXFBuilder() {
    }

    public static final synchronized void registerMXF() {
        if (mxfRegistration) {
            return;
        }
        MediaEngine.initializeAAF();
        PartitionPackImpl.initializePackClasses();
        Warehouse.lookForClass(PrimerPackImpl.class);
        Warehouse.lookForClass(RandomIndexPackImpl.class);
        Warehouse.lookForClass(IndexTableSegmentImpl.class);
        Warehouse.registerTypes(TypeDefinitions.class, "http://www.smpte-ra.org/rp210", "mxf");
        TypeDefinitionRecordImpl.registerInterfaceMapping(DeltaEntry.class, DeltaEntryImpl.class);
        TypeDefinitionRecordImpl.registerInterfaceMapping(IndexEntry.class, IndexEntryImpl.class);
        mxfRegistration = true;
    }

    public static final void ignoreProperty(String ignoreMe) throws NullPointerException {
        if (ignoreMe == null) {
            throw new NullPointerException("Cannot set a property name to ignore with a null value.");
        }
        propertyIgnoreList.add(ignoreMe);
    }

    public static final void clearIgnoredProperties() {
        propertyIgnoreList.clear();
    }

    public static final FixedLengthPack readFixedLengthPack(AUID key, ByteBuffer buffer) throws NullPointerException, EndOfDataException, ClassCastException {
        if (buffer == null) {
            throw new NullPointerException("Cannot read a fixed length pack from a null buffer.");
        }
        if (key == null) {
            throw new NullPointerException("Cannot read a fixed length pack with a null key.");
        }
        ClassDefinition fixedLengthClass = null;
        FixedLengthPack fixedLengthValue = null;
        try {
            fixedLengthClass = Warehouse.lookForClass(key);
            fixedLengthValue = (FixedLengthPack)fixedLengthClass.createInstance();
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("The given key does not correspond to a metadata object that can be serialized as a fixed length pack. The key resolved to type " + fixedLengthClass.getName() + ".");
        }
        catch (NullPointerException npe) {
            throw new NullPointerException("The given key of " + key.toString() + " is now known in the warehouse.");
        }
        for (String propertyName : fixedLengthValue.getPackOrder()) {
            try {
                PropertyDefinition property = fixedLengthClass.lookupPropertyDefinition(propertyName);
                TypeDefinition propertyType = property.getTypeDefinition();
                PropertyValue propertyValue = propertyType.createFromBytes(buffer);
                property.setPropertyValue(fixedLengthValue, propertyValue);
            }
            catch (BadParameterException bpe) {
            }
            catch (EndOfDataException eode) {
                throw new EndOfDataException("Prematurely reached the end of the data buffer when reading a fixed length buffer for type " + fixedLengthClass.getName() + ".");
            }
        }
        return fixedLengthValue;
    }

    public static final void writeFixedLengthPack(FixedLengthPack fixedLengthPack, ByteBuffer buffer) throws NullPointerException, InsufficientSpaceException {
        if (fixedLengthPack == null) {
            throw new NullPointerException("Cannot write a fixed length pack from a null value.");
        }
        if (buffer == null) {
            throw new NullPointerException("Cannot write a fixed length pack to a null buffer.");
        }
        if (fixedLengthPack instanceof PrimerPack) {
            PrimerPackImpl.writeAsBytes((PrimerPack)fixedLengthPack, buffer);
            return;
        }
        ClassDefinition fixedLengthClass = Warehouse.lookForClass(fixedLengthPack.getClass());
        for (String propertyName : fixedLengthPack.getPackOrder()) {
            try {
                PropertyDefinition property = fixedLengthClass.lookupPropertyDefinition(propertyName);
                TypeDefinition propertyType = property.getTypeDefinition();
                PropertyValue propertyValue = property.getPropertyValue(fixedLengthPack);
                propertyType.writeAsBytes(propertyValue, buffer);
            }
            catch (IllegalPropertyValueException ipve) {
                throw new InternalError("Unexpected type problem dealing wih property " + propertyName + " of class " + fixedLengthClass.getName() + " when writing bytes for a fixed length pack.");
            }
            catch (BadParameterException bpe) {
                throw new InternalError("Unexpected failure to resolve property " + propertyName + " of class " + fixedLengthClass.getName() + " when writing bytes for a fixed length pack.");
            }
        }
    }

    public static final long lengthOfFixedLengthPack(FixedLengthPack fixedLengthPack) throws NullPointerException {
        if (fixedLengthPack == null) {
            throw new NullPointerException("Cannot calculate the length in bytes of a null fixed length pack.");
        }
        ClassDefinition fixedLengthClass = Warehouse.lookForClass(fixedLengthPack.getClass());
        long length = 0L;
        for (String propertyName : fixedLengthPack.getPackOrder()) {
            try {
                PropertyDefinition property = fixedLengthClass.lookupPropertyDefinition(propertyName);
                TypeDefinition propertyType = property.getTypeDefinition();
                PropertyValue propertyValue = property.getPropertyValue(fixedLengthPack);
                length += propertyType.lengthAsBytes(propertyValue);
            }
            catch (IllegalPropertyValueException e) {
                throw new InternalError("Unexpected type problem dealing wih property " + propertyName + " of class " + fixedLengthClass.getName() + " when calculating the length of a fixed length pack.");
            }
            catch (BadParameterException bpe) {
                throw new InternalError("Unexpected failure to resolve property " + propertyName + " of class " + fixedLengthClass.getName() + " when calaulating the length of a fixed length pack.");
            }
        }
        return length;
    }

    public static final MetadataObject readLocalSet(UL key, ByteBuffer buffer, PrimerPack primerPack, Map<AUIDImpl, MetadataObject> referenceTable, List<ResolutionEntry> resolutions) throws Exception {
        int preserveLimit = buffer.limit();
        ClassDefinition localSetClass = ClassDefinitionImpl.forAUID(key);
        if (localSetClass == null) {
            System.err.println("Unable to find a local implementation of class with id " + key.toString() + ". Skipping " + buffer.remaining() + " bytes.");
            buffer.position(preserveLimit);
            return null;
        }
        if (localSetClass.getName().equals("MetaDictionary")) {
            System.err.println("This version of MAJ does not support processing meta dictionaries in MXF files.");
            buffer.position(preserveLimit);
            return null;
        }
        MetadataObject localSetValue = localSetClass.createInstance();
        if (localSetValue == null) {
            System.err.println("Unable to create an instance of class " + localSetClass.getName() + " implemented by " + localSetClass.getJavaImplementation().getName() + ". Skipping.");
            buffer.position(preserveLimit);
            return null;
        }
        if (localSetValue instanceof MetaDefinition) {
            System.err.println("Skipping meta definition " + localSetClass.getName() + ".");
            buffer.position(preserveLimit);
            return null;
        }
        while (buffer.hasRemaining()) {
            int length;
            PropertyDefinition property;
            block27: {
                property = null;
                AUID propertyKey = null;
                short tag = buffer.getShort();
                length = 0;
                try {
                    if (primerPack != null) {
                        propertyKey = primerPack.lookupUID(tag);
                    } else {
                        property = localSetClass.lookupPropertyDefinition(tag);
                        propertyKey = property.getAUID();
                    }
                    int shortLength = buffer.getShort();
                    int n = length = shortLength >= 0 ? shortLength : 65536 - shortLength;
                    if (propertyKey == null) {
                        throw new BadParameterException("Unable to resolve tag in primer pack.");
                    }
                    if (propertyKey.equals(MXFConstants.InstanceUID)) {
                        byte[] instanceKey = new byte[16];
                        buffer.get(instanceKey);
                        referenceTable.put(new AUIDImpl(instanceKey), localSetValue);
                        continue;
                    }
                    if (property != null) break block27;
                    property = localSetClass.lookupPropertyDefinition(propertyKey);
                }
                catch (BadParameterException bpe) {
                    if (propertyKey != null) {
                        System.err.println("Unable to resolve tag " + Integer.toHexString(tag) + " and key " + propertyKey.toString() + " for class " + localSetClass.getName() + ". Skipping.");
                    } else {
                        System.err.println("Unable to resolve tag " + Integer.toHexString(tag) + " for class " + localSetClass.getName() + ". Skipping.");
                    }
                    buffer.limit(preserveLimit);
                    buffer.position(buffer.position() + length);
                    continue;
                }
            }
            if (propertyIgnoreList.contains(property.getName())) {
                System.err.println("Ignoring property " + property.getMemberOf().getName() + "." + property.getName() + ".");
                buffer.limit(preserveLimit);
                buffer.position(buffer.position() + length);
                continue;
            }
            TypeDefinition propertyType = property.getTypeDefinition();
            buffer.limit(buffer.position() + length);
            PropertyValue propertyValue = null;
            try {
                propertyValue = propertyType.createFromBytes(buffer);
                if (propertyValue == null) {
                    throw new NullPointerException("Unexpected null property value created when parsing bytes.");
                }
            }
            catch (Exception e) {
                System.err.println(e.getClass().getName() + " thrown when parsing value of " + property.getMemberOf().getName() + "." + property.getName() + ": " + e.getMessage());
                buffer.position(buffer.limit());
                buffer.limit(preserveLimit);
                continue;
            }
            switch (propertyType.getTypeCategory()) {
                case StrongObjRef: {
                    resolutions.add(new ResolutionEntry(property, localSetValue, propertyValue));
                    break;
                }
                case WeakObjRef: {
                    resolutions.add(0, new ResolutionEntry(property, localSetValue, propertyValue));
                    break;
                }
                case Set: {
                    if (((TypeDefinitionSetImpl)propertyType).getElementType() instanceof TypeDefinitionObjectReference) {
                        resolutions.add(new ResolutionEntry(property, localSetValue, propertyValue));
                        break;
                    }
                    property.setPropertyValue(localSetValue, propertyValue);
                    break;
                }
                case VariableArray: {
                    if (((TypeDefinitionVariableArrayImpl)propertyType).getType() instanceof TypeDefinitionObjectReference) {
                        resolutions.add(new ResolutionEntry(property, localSetValue, propertyValue));
                        break;
                    }
                    property.setPropertyValue(localSetValue, propertyValue);
                    break;
                }
                default: {
                    property.setPropertyValue(localSetValue, propertyValue);
                }
            }
            buffer.limit(preserveLimit);
        }
        if (localSetValue instanceof MetaDefinition) {
            MXFBuilder.testMetaDictionaryEntry((MetaDefinition)localSetValue);
            return null;
        }
        if (localSetValue instanceof WeakReferenceTarget) {
            WeakReference.registerTarget((WeakReferenceTarget)((Object)localSetValue));
        }
        return localSetValue;
    }

    public static final long writeLocalSet(MetadataObject toWrite, ByteBuffer buffer, PrimerPack primerPack, List<PropertyValue> forwardReferences) throws NullPointerException, InsufficientSpaceException {
        if (toWrite == null) {
            throw new NullPointerException("Cannot encode a null metadata object as a local set value.");
        }
        AUID instanceID = Forge.randomAUID();
        return MXFBuilder.writeToLocalSet(toWrite, instanceID, buffer, primerPack, forwardReferences);
    }

    public static final long writeLocalSet(PropertyValue referencedValue, ByteBuffer buffer, PrimerPack primerPack, List<PropertyValue> forwardReferences) throws NullPointerException, InsufficientSpaceException {
        if (referencedValue == null) {
            throw new NullPointerException("Cannot encode a null property value object as a local set value.");
        }
        if (referencedValue.getType() == null || !(referencedValue.getType() instanceof TypeDefinitionStrongObjectReference)) {
            throw new NullPointerException("The given referenced property has a null type or is not a strong reference type. Type provided was " + referencedValue.getType().getName() + ".");
        }
        if (referencedValue.getValue() == null || !(referencedValue.getValue() instanceof MetadataObject)) {
            throw new NullPointerException("The given referenced proeprty has a null value or references a inappropriate type of value.");
        }
        MetadataObject toWrite = (MetadataObject)referencedValue.getValue();
        AUID instanceID = TypeDefinitionObjectReferenceImpl.getLocalReference(referencedValue);
        return MXFBuilder.writeToLocalSet(toWrite, instanceID, buffer, primerPack, forwardReferences);
    }

    private static final long writeToLocalSet(MetadataObject toWrite, AUID instanceID, ByteBuffer buffer, PrimerPack primerPack, List<PropertyValue> forwardReferences) throws NullPointerException, InsufficientSpaceException {
        if (buffer == null) {
            throw new NullPointerException("Cannot write an encoded local set to a null buffer.");
        }
        if (forwardReferences == null) {
            throw new NullPointerException("The list of forward references provided is null and a metadata object might need to be added.");
        }
        ClassDefinition classOfMetadata = MediaEngine.getClassDefinition(toWrite);
        SortedMap<? extends PropertyDefinition, ? extends PropertyValue> properties = classOfMetadata.getProperties(toWrite);
        AUID classAUID = classOfMetadata.getAUID();
        MXFBuilder.writeKey((UL)classAUID, buffer);
        long lengthOfSetBody = MXFBuilder.lengthOfLocalSet(toWrite);
        MXFBuilder.writeBERLength(lengthOfSetBody, 4, buffer);
        buffer.putShort((short)15370);
        buffer.putShort((short)16);
        buffer.put(instanceID.getAUIDValue());
        long bytesWritten = 20L;
        for (PropertyDefinition propertyDefinition : properties.keySet()) {
            if (propertyDefinition.getAUID().equals(CommonConstants.ObjectClassID)) continue;
            PropertyValue value = (PropertyValue)properties.get(propertyDefinition);
            Short localTag = primerPack.lookupLocalTag(propertyDefinition);
            if (localTag == null) continue;
            long propertyLength = value.getType().lengthAsBytes(value);
            if (propertyLength > 65535L) {
                System.err.println("Cannot write a property value longer than 65535 bytes for property " + propertyDefinition.getMemberOf().getName() + "." + propertyDefinition.getName() + ".");
                continue;
            }
            buffer.putShort(localTag);
            buffer.putShort((short)propertyLength);
            bytesWritten += 4L;
            List<PropertyValue> childReferences = value.getType().writeAsBytes(value, buffer);
            if (childReferences != null) {
                forwardReferences.addAll(childReferences);
            }
            bytesWritten += propertyLength;
        }
        return bytesWritten;
    }

    @UInt64
    public static final long lengthOfLocalSet(MetadataObject toWrite) throws NullPointerException {
        if (toWrite == null) {
            throw new NullPointerException("Cannot calculat the length as a local set value for a null metadata object.");
        }
        ClassDefinition classOfMetadata = MediaEngine.getClassDefinition(toWrite);
        SortedMap<? extends PropertyDefinition, ? extends PropertyValue> properties = classOfMetadata.getProperties(toWrite);
        long localSetLength = 20L;
        for (PropertyDefinition propertyDefinition : properties.keySet()) {
            if (propertyDefinition.getAUID().equals(CommonConstants.ObjectClassID)) continue;
            localSetLength += 4L;
            PropertyValue value = (PropertyValue)properties.get(propertyDefinition);
            localSetLength += value.getType().lengthAsBytes(value);
        }
        return localSetLength;
    }

    public static final boolean isKLVFill(UL key) {
        if (key == null) {
            return false;
        }
        if (key.getData1() != MXFConstants.KLVFill.getData1()) {
            return false;
        }
        if (key.getData2() != MXFConstants.KLVFill.getData2()) {
            return false;
        }
        if (key.getData3() != MXFConstants.KLVFill.getData3()) {
            return false;
        }
        byte[] firstPartTest = key.getData4();
        byte[] firstPartShouldBe = MXFConstants.KLVFill.getData4();
        for (int u = 0; u < 7; ++u) {
            if (firstPartTest[u] == firstPartShouldBe[u]) continue;
            return false;
        }
        return true;
    }

    private static final void testMetaDictionaryEntry(MetaDefinition metaDefinition) {
        if (metaDefinition instanceof ClassDefinition) {
            ClassDefinition checkForClass = ClassDefinitionImpl.forAUID(metaDefinition.getAUID());
            if (checkForClass == null) {
                System.err.println("Warning: A class with name " + metaDefinition.getName() + " is not known to this MAJ runtime.");
            }
            return;
        }
        if (metaDefinition instanceof PropertyDefinition) {
            if (!ClassDefinitionImpl.isKnownProperty((PropertyDefinition)metaDefinition)) {
                System.err.println("Warning: A property with name " + metaDefinition.getName() + " is not known to this MAJ runtime.");
            }
            return;
        }
        if (metaDefinition instanceof TypeDefinition) {
            TypeDefinition checkForType = Warehouse.lookForType(metaDefinition.getAUID());
            if (checkForType == null) {
                System.err.println("Warning A type with name " + metaDefinition.getName() + " is not knowmn to this MAJ runtime.");
            }
            return;
        }
    }

    public static final long skipKLVFill(MXFFile mxfFile) {
        if (!(mxfFile instanceof MXFFileImpl)) {
            return 0L;
        }
        MXFFileImpl mxfFileImpl = (MXFFileImpl)mxfFile;
        long startPosition = mxfFileImpl.tell();
        UL key = mxfFileImpl.readKey();
        if (!MXFBuilder.isKLVFill(key)) {
            mxfFileImpl.seek(startPosition);
            return 0L;
        }
        long length = mxfFileImpl.readBER();
        mxfFileImpl.read((int)length);
        return mxfFileImpl.tell() - startPosition;
    }

    public static final long skipKLVFill(ByteBuffer buffer) {
        int startPosition = buffer.position();
        int preserveLimit = buffer.limit();
        UL key = MXFBuilder.readKey(buffer);
        if (!MXFBuilder.isKLVFill(key)) {
            buffer.position(startPosition);
            return 0L;
        }
        long length = MXFBuilder.readBERLength(buffer);
        if (length < (long)buffer.remaining()) {
            buffer.position((int)((long)buffer.position() + length));
        } else {
            buffer.position(preserveLimit);
        }
        return buffer.position() - startPosition;
    }

    public static final long readBERLength(ByteBuffer buffer) throws NullPointerException, BufferUnderflowException {
        if (buffer == null) {
            throw new NullPointerException("Cannot read a BER length from a null buffer.");
        }
        byte first = 0;
        try {
            first = buffer.get();
        }
        catch (BufferUnderflowException bue) {
            System.err.println("Incomplete BER length in buffer at 0x" + Long.toHexString(buffer.position()));
            return -1L;
        }
        if (first >= 0) {
            return first;
        }
        int berTailLength = first & 0x7F;
        byte[] lengthData = new byte[berTailLength];
        if (buffer.remaining() < berTailLength) {
            System.err.println("Incomplete BER length in buffer at 0x" + Long.toHexString(buffer.position()));
            return -1L;
        }
        long lengthValue = 0L;
        buffer.get(lengthData);
        for (int u = 0; u < lengthData.length; ++u) {
            lengthValue = lengthValue << 8 | (long)(lengthData[u] >= 0 ? lengthData[u] : 256 + lengthData[u]);
        }
        return lengthValue;
    }

    public static final void writeBERLength(long length, int encodedBytes, ByteBuffer buffer) throws NullPointerException, BufferOverflowException, IllegalArgumentException {
        long maxValue;
        if (buffer == null) {
            throw new NullPointerException("Cannot write a BER length to a null buffer.");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Cannot write a negative length value.");
        }
        if (encodedBytes < 1 || encodedBytes > 9) {
            throw new IllegalArgumentException("The number of encoded bytes must be between 1 and 9.");
        }
        if (encodedBytes == 1) {
            if (length > 127L) {
                throw new IllegalArgumentException("The number of encoded bytes is 1 but the length is greater than 127.");
            }
            buffer.put((byte)length);
            return;
        }
        if (length >= (maxValue = 2L << --encodedBytes * 8)) {
            throw new IllegalArgumentException("The given length of " + length + " is greater than the maximum value for the given number of bytes to encode at " + maxValue + ".");
        }
        buffer.put((byte)(128 + (byte)encodedBytes));
        for (int x = encodedBytes - 1; x >= 0; --x) {
            long mask = 255 << x * 8;
            buffer.put((byte)((length & mask) >> x * 8));
        }
    }

    public static final UL readKey(ByteBuffer keyData) {
        if (keyData.limit() < 16) {
            return null;
        }
        byte[] keySwap = new byte[16];
        keyData.get(keySwap, 8, 8);
        keyData.get(keySwap, 0, 8);
        return new AUIDImpl(keySwap);
    }

    public static final void writeKey(UL key, ByteBuffer buffer) throws NullPointerException, BufferOverflowException {
        if (buffer == null) {
            throw new NullPointerException("Cannot write a key into a null buffer.");
        }
        if (key == null) {
            throw new NullPointerException("Cannot write a null key into a buffer.");
        }
        if (buffer.remaining() < 16) {
            throw new BufferOverflowException();
        }
        byte[] keyBytes = key.getUniversalLabel();
        if (keyBytes[4] == 2 && keyBytes[5] == 6 && keyBytes[6] == 1) {
            keyBytes[5] = 83;
        }
        buffer.put(keyBytes);
    }

    public static final long calculateMinimumHeaderMetadataSize(Preface preface) throws NullPointerException {
        if (preface == null) {
            throw new NullPointerException("Cannot calculate the size of the header metadata using a null preface.");
        }
        PrimerPackImpl primerPack = new PrimerPackImpl();
        primerPack.addLocalTagEntry((short)15370, MXFConstants.InstanceUID);
        long lengthOfAllSets = PrimerPackImpl.addPropertiesForObject(primerPack, preface);
        return lengthOfAllSets + (long)PrimerPackImpl.lengthAsBytes(primerPack);
    }
}

