/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.aaf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import tv.amwa.maj.extensions.avid.AvidFactory;
import tv.amwa.maj.io.aaf.AAFBuilder;
import tv.amwa.maj.io.aaf.AAFConstants;
import tv.amwa.maj.io.aaf.AAFReader;
import tv.amwa.maj.io.aaf.AAFReaderListener;
import tv.amwa.maj.io.aaf.AAFWriterListener;
import tv.amwa.maj.model.Preface;

public class AAFFactory
implements AAFConstants {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Preface readPreface(String filename) throws IOException {
        AAFReader r = new AAFReader();
        AAFReaderListener eventReader = AAFBuilder.makeAAFEventReader();
        ((POIFSReader)r).registerListener(eventReader);
        try (InputStream fis = null;){
            File inputFile = new File(filename);
            eventReader.setFilePath(inputFile);
            fis = new FileInputStream(inputFile);
            ((POIFSReader)r).read(fis);
            eventReader.resolveEntries();
            Preface preface = eventReader.getPreface();
            return preface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writePreface(Preface preface, String outputFilename) throws IOException {
        POIFSFileSystem outputFileSystem = new POIFSFileSystem();
        DirectoryNode rootDir = outputFileSystem.getRoot();
        preface.updateDictionaries();
        AAFWriterListener aafWriter = AAFBuilder.makeAAFWriterListener();
        DirectoryEntry metaDictionaryDir = rootDir.createDirectory("MetaDictionary-1");
        DirectoryEntry prefaceDir = rootDir.createDirectory("Header-2");
        AAFBuilder.generateAAFStructure(prefaceDir, aafWriter, preface);
        AAFBuilder.generateMetaDictionary(metaDictionaryDir, aafWriter, preface);
        rootDir.createDocument("properties", 70, aafWriter);
        rootDir.createDocument("referenced properties", aafWriter.getReferencedPropertiesSize(), aafWriter);
        rootDir.setStorageClsid(new ClassID(rootEntryClassID, 0));
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFilename);
            outputFileSystem.writeFilesystem(fos);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        RandomAccessFile fixFile = null;
        try (AbstractInterruptibleChannel fixChannel = null;){
            fixFile = new RandomAccessFile(outputFilename, "rw");
            fixChannel = fixFile.getChannel();
            ((FileChannel)fixChannel).position(8L);
            if (outputFileSystem.getBigBlockSize() == 4096) {
                ((FileChannel)fixChannel).write(ByteBuffer.wrap(AAFSignatureSSBin4KBytes));
            } else {
                ((FileChannel)fixChannel).write(ByteBuffer.wrap(AAFSignatureSSBinaryBytes));
            }
        }
    }

    public static final void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java tv.amwa.maj.io.aaf.AAFFactory <aaf_file>");
            System.exit(1);
        }
        AvidFactory.registerAvidExtensions();
        String filename = args[0];
        try {
            Preface preface = null;
            long startTime = System.currentTimeMillis();
            preface = AAFFactory.readPreface(filename);
            long endTime = System.currentTimeMillis();
            System.out.println("INFO: Reading AAF file took " + (endTime - startTime) + "ms.");
            System.out.println(preface.toString());
        }
        catch (IOException ioe) {
            System.err.println("Error reading file " + filename + ": " + ioe.getMessage());
            ioe.printStackTrace();
            System.exit(1);
        }
    }
}

