/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.industry;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.industry.MediaEntity;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.model.DefinitionObject;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

public class WeakReference<T extends WeakReferenceTarget>
implements MediaEntity,
Cloneable {
    private static Map<AUID, WeakReferenceTarget> genericTable = Collections.synchronizedMap(new HashMap());
    private AUID identifier;
    private String canonicalTypeName;
    private long persistentID = 0L;
    private int persistentIndex = 0;
    private T cachedValue = null;

    public WeakReference() {
    }

    public WeakReference(T target) {
        this.setTarget(target);
    }

    public WeakReference(Class<T> targetType, AUID targetIdentifier) {
        this.canonicalTypeName = targetType.getCanonicalName();
        this.identifier = targetIdentifier.clone();
    }

    public T getTarget() {
        if (this.cachedValue != null) {
            return this.cachedValue;
        }
        if (this.canonicalTypeName.equals("tv.amwa.maj.meta.impl.TypeDefinitionImpl")) {
            this.cachedValue = Warehouse.lookForType(this.identifier);
            if (this.cachedValue != null) {
                return this.cachedValue;
            }
        }
        ClassDefinition targetType = Warehouse.lookForClass(this.canonicalTypeName);
        try {
            Method staticResolver = targetType.getJavaImplementation().getMethod("forAUID", AUID.class);
            this.cachedValue = (WeakReferenceTarget)staticResolver.invoke(null, this.identifier);
            if (this.cachedValue != null) {
                return this.cachedValue;
            }
        }
        catch (Exception staticResolver) {
            // empty catch block
        }
        try {
            return (T)genericTable.get(this.identifier);
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public void setTarget(T target) {
        this.identifier = target.getAUID();
        this.canonicalTypeName = target.getClass().getCanonicalName();
        this.cachedValue = target;
    }

    @Override
    public Long getPersistentID() {
        return this.persistentID;
    }

    @Override
    public void setPersistentIndex(int index) {
        this.persistentIndex = index;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof AUID) {
            return this.identifier.equals(o);
        }
        if (o instanceof WeakReferenceTarget) {
            return this.identifier.equals(((WeakReferenceTarget)o).getAUID());
        }
        if (o instanceof WeakReference) {
            return this.getTarget().equals(((WeakReference)o).getTarget());
        }
        return false;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public String toString() {
        return this.getTarget().toString();
    }

    @Override
    public WeakReference<T> clone() {
        try {
            return (WeakReference)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    public static final void registerTarget(WeakReferenceTarget target) throws NullPointerException {
        if (target == null) {
            throw new NullPointerException("Cannot register a weak reference target using a null value.");
        }
        try {
            genericTable.put(target.getAUID(), target);
            if (target instanceof DefinitionObject) {
                Warehouse.register((DefinitionObject)target);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static final void forgetTarget(WeakReferenceTarget target) {
        if (target == null) {
            return;
        }
        genericTable.remove(target.getAUID());
    }

    public static final void generateWeakReferenceORM(Node parent, String namespace, String prefix) {
        Element entity = XMLBuilder.createChild(parent, namespace, prefix, "entity");
        XMLBuilder.setAttribute(entity, namespace, prefix, "class", WeakReference.class.getCanonicalName());
        XMLBuilder.setAttribute(entity, namespace, prefix, "access", "FIELD");
        Element attributes = XMLBuilder.createChild(entity, namespace, prefix, "attributes");
        Element identifier = XMLBuilder.createChild(attributes, namespace, prefix, "embeddable");
        XMLBuilder.setAttribute(identifier, namespace, prefix, "name", "identifier");
        Element identifierOverride = XMLBuilder.createChild(identifier, namespace, prefix, "attribute-override");
        XMLBuilder.setAttribute(identifierOverride, namespace, prefix, "name", "auidValue");
        Element identifierColumn = XMLBuilder.createChild(identifierOverride, namespace, prefix, "column");
        XMLBuilder.setAttribute(identifierColumn, namespace, prefix, "name", "Identifier");
        XMLBuilder.setAttribute(identifierColumn, namespace, prefix, "nullable", "false");
        Element canonicalTypeName = XMLBuilder.createChild(attributes, namespace, prefix, "basic");
        XMLBuilder.setAttribute(canonicalTypeName, namespace, prefix, "name", "canonicalTypeName");
        Element typeNameColumn = XMLBuilder.createChild(canonicalTypeName, namespace, prefix, "column");
        XMLBuilder.setAttribute(typeNameColumn, namespace, prefix, "name", "TypeName");
        XMLBuilder.setAttribute(typeNameColumn, namespace, prefix, "nullable", "false");
        Element persistentID = XMLBuilder.createChild(attributes, namespace, prefix, "id");
        XMLBuilder.setAttribute(persistentID, namespace, prefix, "name", "persistentID");
        XMLBuilder.createChild(persistentID, namespace, prefix, "generated-id");
        Element persistentIDColumn = XMLBuilder.createChild(persistentID, namespace, prefix, "column");
        XMLBuilder.setAttribute(persistentIDColumn, namespace, prefix, "name", "PersistentID");
        Element persitentIndex = XMLBuilder.createChild(attributes, namespace, prefix, "basic");
        XMLBuilder.setAttribute(persitentIndex, namespace, prefix, "name", "persistentIndex");
        Element indexColumn = XMLBuilder.createChild(persitentIndex, namespace, prefix, "column");
        XMLBuilder.setAttribute(indexColumn, namespace, prefix, "name", "PersistentIndex");
        XMLBuilder.setAttribute(indexColumn, namespace, prefix, "nullable", "false");
        Element transientCache = XMLBuilder.createChild(attributes, namespace, prefix, "transient");
        XMLBuilder.setAttribute(transientCache, namespace, prefix, "name", "cachedValue");
    }

    public String getIdentifierString() {
        return AUIDImpl.toPersistentForm(this.identifier);
    }

    public void setIdentifierString(String identifier) {
        this.identifier = AUIDImpl.fromPersistentForm(identifier);
    }

    public AUID getIdentifier() {
        return this.identifier.clone();
    }
}

