/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.industry;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import tv.amwa.maj.constant.CodingEquationsType;
import tv.amwa.maj.constant.ColorPrimariesType;
import tv.amwa.maj.constant.OperationCategoryType;
import tv.amwa.maj.constant.PluginCategoryType;
import tv.amwa.maj.constant.TransferCharacteristicType;
import tv.amwa.maj.constant.UsageType;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.ExtendibleEnumerationItem;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.ExtensionScheme;
import tv.amwa.maj.meta.MetaDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionObjectReference;
import tv.amwa.maj.meta.TypeDefinitionSet;
import tv.amwa.maj.meta.TypeDefinitionVariableArray;
import tv.amwa.maj.meta.impl.ClassDefinitionImpl;
import tv.amwa.maj.meta.impl.ExtensionSchemeImpl;
import tv.amwa.maj.meta.impl.MetaDefinitionImpl;
import tv.amwa.maj.model.ApplicationObject;
import tv.amwa.maj.model.DefinitionObject;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

public final class Warehouse {
    private static final Map<AUID, ClassDefinition> idToClass = Collections.synchronizedMap(new HashMap());
    private static Map<Class<?>, ClassDefinition> knownClasses = Collections.synchronizedMap(new HashMap());
    private static Map<String, ClassDefinition> nameToClass = Collections.synchronizedMap(new HashMap());
    private static HashMap<String, String> classAliases = new HashMap();
    private static final Map<AUID, PropertyDefinition> globalPropertyIdTable = Collections.synchronizedMap(new HashMap());
    private static Map<String, TypeDefinition> knownTypes = Collections.synchronizedMap(new HashMap());
    private static Map<AUID, TypeDefinition> knownTypesByID = Collections.synchronizedMap(new HashMap());
    static final Class<?>[] typeDefinitionClasses = new Class[]{TypeDefinitions.class};
    private static Map<String, TreeMap<String, AUID>> extensibleEnumerations = new HashMap<String, TreeMap<String, AUID>>();
    private static Map<AUID, String> idToEnumeration = new HashMap<AUID, String>();
    private static Map<AUID, String> idToElementName = new HashMap<AUID, String>();
    static final Class<?>[] extensibleEnumerationClasses = new Class[]{OperationCategoryType.class, PluginCategoryType.class, TransferCharacteristicType.class, UsageType.class, ColorPrimariesType.class, CodingEquationsType.class};
    private static Map<AUID, ExtensionSchemeRecord> extensionSchemes = Collections.synchronizedMap(new HashMap());

    public static final void clear() {
        knownClasses.clear();
        nameToClass.clear();
        knownTypes.clear();
        knownTypesByID.clear();
        extensibleEnumerations.clear();
        idToEnumeration.clear();
        idToElementName.clear();
        idToClass.clear();
        globalPropertyIdTable.clear();
    }

    private Warehouse() {
    }

    public static final ClassDefinition lookForClass(Class<?> mediaClass) throws NullPointerException, IllegalArgumentException {
        if (mediaClass == null) {
            throw new NullPointerException("Cannot make a class definition from a null value.");
        }
        if (!mediaClass.isInterface() && mediaClass.getCanonicalName().contains("$")) {
            mediaClass = mediaClass.getSuperclass();
        }
        if (knownClasses.containsKey(mediaClass)) {
            return knownClasses.get(mediaClass);
        }
        if (mediaClass.isInterface()) {
            return Warehouse.lookForClass(mediaClass.getName());
        }
        ClassDefinition classDef = ClassDefinitionImpl.forClass(mediaClass);
        knownClasses.put(mediaClass, classDef);
        for (Class<?> implementing : mediaClass.getInterfaces()) {
            if (implementing.getCanonicalName().startsWith("java")) continue;
            knownClasses.put(implementing, classDef);
        }
        return classDef;
    }

    public static final void register(ClassDefinition classDefinition) throws NullPointerException {
        if (classDefinition == null) {
            throw new NullPointerException("Cannot register a class definition using a null value.");
        }
        idToClass.put(classDefinition.getAUID(), classDefinition);
        nameToClass.put(classDefinition.getName(), classDefinition);
        try {
            if (classDefinition.getJavaImplementation() != null && !ApplicationObject.class.isAssignableFrom(classDefinition.getJavaImplementation())) {
                nameToClass.put(classDefinition.getJavaImplementation().getCanonicalName(), classDefinition);
            }
            nameToClass.put(classDefinition.getSymbol(), classDefinition);
            if (classDefinition.getNamespace() != null && classDefinition.getNamespace().length() > 0) {
                nameToClass.put("{" + classDefinition.getNamespace() + "}" + classDefinition.getSymbol(), classDefinition);
                nameToClass.put("{" + classDefinition.getNamespace() + "}" + classDefinition.getName(), classDefinition);
            }
            Warehouse.putAliases(classDefinition);
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
    }

    private static void putAliases(ClassDefinition severalNames) {
        if (severalNames == null) {
            return;
        }
        if (severalNames.getAliases() == null) {
            return;
        }
        for (String alias : severalNames.getAliases()) {
            ClassDefinition checkBeforeRemoving;
            if (nameToClass.containsKey(alias) && (alias.equals((checkBeforeRemoving = nameToClass.get(alias)).getName()) || alias.equals(checkBeforeRemoving.getSymbol()))) {
                System.err.println("Warning: Cannot use alias " + alias + " for class " + severalNames.getName() + " because it clashes with another property name or symbol.");
                continue;
            }
            classAliases.put(alias, "{" + severalNames.getNamespace() + "}" + severalNames.getSymbol());
            classAliases.put("{" + severalNames.getNamespace() + "}" + alias, "{" + severalNames.getNamespace() + "}" + severalNames.getSymbol());
        }
    }

    public static final ClassDefinition lookForClass(String name) throws NullPointerException, IllegalArgumentException {
        ClassDefinition fromName;
        if (name == null) {
            throw new NullPointerException("Cannot retrieve a class definition from a null name.");
        }
        if (classAliases.containsKey(name)) {
            name = classAliases.get(name);
        }
        if ((fromName = nameToClass.get(name)) != null) {
            return fromName;
        }
        String guessedName = name;
        if (name.indexOf(46) >= 0) {
            try {
                Class<?> guess = Class.forName(guessedName);
                if (guess.isInterface()) {
                    int lastDot = name.lastIndexOf(46);
                    guessedName = name.substring(0, lastDot) + ".impl" + name.substring(lastDot) + "Impl";
                    guess = Class.forName(guessedName);
                }
                return Warehouse.lookForClass(guess);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to find a media class with full pathname " + name + ".", e);
            }
        }
        try {
            guessedName = "tv.amwa.maj.model.impl." + name + "Impl";
            Class<?> guess = Class.forName(guessedName);
            if (!guessedName.equals(name)) {
                return Warehouse.lookForClass(guess);
            }
            throw new IllegalArgumentException("Unable to find a media class called " + name);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                guessedName = name;
                guessedName = "tv.amwa.maj.meta.impl." + name + "Impl";
                Class<?> guess = Class.forName(guessedName);
                return Warehouse.lookForClass(guess);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to find a media class called " + name + ": " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to find a media class caled " + name + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public static final Collection<String> getClassInventory() {
        TreeSet<String> classNames = new TreeSet<String>();
        for (ClassDefinition currentClass : Warehouse.getClassDefinitions()) {
            classNames.add(currentClass.getName());
        }
        return classNames;
    }

    public static final Collection<ClassDefinition> getClassDefinitions() {
        ArrayList<ClassDefinition> classDefintions = new ArrayList<ClassDefinition>();
        for (ClassDefinition classDefinition : idToClass.values()) {
            if (classDefinition.getNamespace().equals("http://www.smpte-ra.org/rp210")) continue;
            classDefintions.add(classDefinition);
        }
        return classDefintions;
    }

    public static final int countClassDefinitions() {
        return idToClass.size();
    }

    public static final ClassDefinition lookForClass(AUID identification) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot resolve a registered class definition using a null value.");
        }
        byte[] classIdBytes = identification.getAUIDValue();
        if (classIdBytes[13] == 83) {
            classIdBytes[13] = 6;
            identification = new AUIDImpl(classIdBytes);
        }
        return idToClass.get(identification);
    }

    public static final <T extends DefinitionObject> T lookup(Class<T> definitionType, String definitionName) throws NullPointerException {
        if (definitionType == null) {
            throw new NullPointerException("Cannot lookup a definition from a null definition type.");
        }
        if (definitionName == null) {
            throw new NullPointerException("Cannot lookup a definition from a null name.");
        }
        if (definitionType.isInterface()) {
            ClassDefinition correspondingClass = Warehouse.lookForClass(definitionType);
            definitionType = correspondingClass.getJavaImplementation();
        }
        try {
            Method forName = definitionType.getMethod("forName", String.class);
            return (T)((DefinitionObject)forName.invoke(null, definitionName));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final <T extends DefinitionObject> T lookup(Class<T> definitionType, AUID definitionID) throws NullPointerException {
        if (definitionType == null) {
            throw new NullPointerException("Cannot lookup a definition from a null definition type.");
        }
        if (definitionID == null) {
            throw new NullPointerException("Cannot lookup a definition from a null identification.");
        }
        if (definitionType.isInterface()) {
            ClassDefinition correspondingClass = Warehouse.lookForClass(definitionType);
            definitionType = correspondingClass.getJavaImplementation();
        }
        try {
            Method forName = definitionType.getMethod("forIdentification", AUID.class);
            return (T)((DefinitionObject)forName.invoke(null, definitionID));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final <T extends DefinitionObject> T lookup(String definitionTypeName, String definitionName) throws NullPointerException, IllegalArgumentException {
        if (definitionTypeName == null) {
            throw new NullPointerException("Cannot lookup a definition using a null definition type name.");
        }
        if (definitionName == null) {
            throw new NullPointerException("Cannot lookup a definition using a null definition name.");
        }
        Class<DefinitionObject> correspondingClass = Warehouse.lookForClass(definitionTypeName).getJavaImplementation();
        if (correspondingClass.isAssignableFrom(DefinitionObject.class)) {
            throw new IllegalArgumentException("The given class name does not map to a definition.");
        }
        return (T)Warehouse.lookup(correspondingClass, definitionName);
    }

    public static final <T extends DefinitionObject> T lookup(String definitionTypeName, AUID definitionID) throws NullPointerException, IllegalArgumentException {
        if (definitionTypeName == null) {
            throw new NullPointerException("Cannot lookup a definition using a null definition type name.");
        }
        if (definitionID == null) {
            throw new NullPointerException("Cannot lookup a definition using a null definition name.");
        }
        Class<DefinitionObject> correspondingClass = Warehouse.lookForClass(definitionTypeName).getJavaImplementation();
        if (correspondingClass.isAssignableFrom(DefinitionObject.class)) {
            throw new IllegalArgumentException("The given class name does not map to a definition.");
        }
        return (T)Warehouse.lookup(correspondingClass, definitionID);
    }

    public static final Boolean register(DefinitionObject definition) throws NullPointerException {
        if (definition == null) {
            throw new NullPointerException("Cannot register a new definition using a null value.");
        }
        ClassDefinition definitionClassDefinition = Warehouse.lookForClass(definition.getClass());
        Class<?> definitionImplementation = definitionClassDefinition.getJavaImplementation();
        String registrationName = "register" + definitionClassDefinition.getName();
        Boolean alreadyRegistered = null;
        try {
            Method forName = null;
            for (Class<?> interfaceToCheck : definitionImplementation.getInterfaces()) {
                try {
                    forName = definitionImplementation.getMethod(registrationName, interfaceToCheck);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (forName != null) break;
            }
            alreadyRegistered = (Boolean)forName.invoke(null, definition);
        }
        catch (Exception e) {
            return null;
        }
        return alreadyRegistered == false;
    }

    public static final <T extends DefinitionObject> int count(Class<T> definitionType) throws NullPointerException {
        if (definitionType == null) {
            throw new NullPointerException("Cannot count definitions from a null definition type.");
        }
        if (definitionType.isInterface()) {
            ClassDefinition correspondingClass = Warehouse.lookForClass(definitionType);
            definitionType = correspondingClass.getJavaImplementation();
        }
        try {
            Method forName = definitionType.getMethod("count", new Class[0]);
            return (Integer)forName.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static final <T extends DefinitionObject> Collection<String> inventory(Class<T> definitionType) throws NullPointerException {
        if (definitionType == null) {
            throw new NullPointerException("Cannot lookup a definition from a null definition type.");
        }
        if (definitionType.isInterface()) {
            ClassDefinition correspondingClass = Warehouse.lookForClass(definitionType);
            definitionType = correspondingClass.getJavaImplementation();
        }
        try {
            Method forName = definitionType.getMethod("inventory", new Class[0]);
            return (Collection)forName.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final void registerTypes(Class<?> typeClass, String namespace, String prefix) throws NullPointerException {
        if (typeClass == null) {
            throw new NullPointerException("Cannot add type definitions from a null class.");
        }
        if (namespace == null) {
            throw new NullPointerException("Cannot add type definitions to the warehouse with a null namespace.");
        }
        if (prefix == null) {
            throw new NullPointerException("Cannot add type definitions to the warehouse with a null prefix.");
        }
        for (Field field : typeClass.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            try {
                Object value = field.get(null);
                if (!(value instanceof TypeDefinition)) continue;
                TypeDefinition foundType = (TypeDefinition)value;
                Warehouse.register(foundType, namespace, prefix);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static final TypeDefinition lookForType(String typeName) throws NullPointerException {
        if (typeName == null) {
            throw new NullPointerException("Cannot find a type definition with a null name value.");
        }
        if (!knownTypes.containsKey(typeName)) {
            Warehouse.registerTypes(TypeDefinitions.class, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf");
        }
        return knownTypes.get(typeName);
    }

    public static final TypeDefinition lookForType(AUID identification) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot find a type definition with a null identification value.");
        }
        return knownTypesByID.get(identification);
    }

    public static int countTypeDefinitions() {
        return knownTypesByID.size();
    }

    public static final void register(TypeDefinition typeDefinition, String namespace, String prefix) throws NullPointerException {
        if (typeDefinition == null) {
            throw new NullPointerException("Cannot add a type to the warehouse using a null value.");
        }
        if (namespace == null) {
            throw new NullPointerException("Cannot add a type to the warehouse using a null value.");
        }
        if (prefix == null) {
            throw new NullPointerException("Cannot add a type to the warehouse using a null value.");
        }
        typeDefinition.setNamespace(namespace);
        ((MetaDefinitionImpl)((Object)typeDefinition)).setPrefix(prefix);
        String namespaceWithBrackets = "{" + namespace + "}";
        knownTypes.put(typeDefinition.getName(), typeDefinition);
        knownTypes.put(namespaceWithBrackets + typeDefinition.getName(), typeDefinition);
        knownTypesByID.put(typeDefinition.getAUID(), typeDefinition);
        String targetTypeName = null;
        String angleName = null;
        String ofToName = null;
        switch (typeDefinition.getTypeCategory()) {
            case StrongObjRef: 
            case WeakObjRef: {
                targetTypeName = ((TypeDefinitionObjectReference)typeDefinition).getObjectType().getName();
                angleName = "StrongReference<" + targetTypeName + ">";
                ofToName = "StrongReference to " + targetTypeName;
                knownTypes.put(angleName, typeDefinition);
                knownTypes.put(ofToName, typeDefinition);
                knownTypes.put(namespaceWithBrackets + angleName, typeDefinition);
                knownTypes.put(namespaceWithBrackets + ofToName, typeDefinition);
                break;
            }
            case Set: {
                if (typeDefinition.getName().endsWith("WeakReferenceSet")) {
                    TypeDefinitionObjectReference referenceType = (TypeDefinitionObjectReference)((TypeDefinitionSet)typeDefinition).getElementType();
                    targetTypeName = referenceType.getObjectType().getName();
                    angleName = "WeakReferenceSet<" + targetTypeName + ">";
                    ofToName = "WeakReferenceSet of " + targetTypeName;
                    knownTypes.put(angleName, typeDefinition);
                    knownTypes.put(ofToName, typeDefinition);
                    knownTypes.put(namespaceWithBrackets + angleName, typeDefinition);
                    knownTypes.put(namespaceWithBrackets + ofToName, typeDefinition);
                    break;
                }
                if (!typeDefinition.getName().endsWith("StrongReferenceSet")) break;
                TypeDefinitionObjectReference referenceType = (TypeDefinitionObjectReference)((TypeDefinitionSet)typeDefinition).getElementType();
                targetTypeName = referenceType.getObjectType().getName();
                angleName = "StrongReferenceSet<" + targetTypeName + ">";
                ofToName = "StrongReferenceSet of " + targetTypeName;
                knownTypes.put(angleName, typeDefinition);
                knownTypes.put(ofToName, typeDefinition);
                knownTypes.put(namespaceWithBrackets + angleName, typeDefinition);
                knownTypes.put(namespaceWithBrackets + ofToName, typeDefinition);
                break;
            }
            case VariableArray: {
                if (typeDefinition.getName().endsWith("StrongReferenceVector")) {
                    TypeDefinitionObjectReference referenceType = (TypeDefinitionObjectReference)((TypeDefinitionVariableArray)typeDefinition).getType();
                    targetTypeName = referenceType.getObjectType().getName();
                    angleName = "StrongReferenceVector<" + targetTypeName + ">";
                    ofToName = "StrongReferenceVector of " + targetTypeName;
                    knownTypes.put(angleName, typeDefinition);
                    knownTypes.put(ofToName, typeDefinition);
                    knownTypes.put(namespaceWithBrackets + angleName, typeDefinition);
                    knownTypes.put(namespaceWithBrackets + ofToName, typeDefinition);
                    break;
                }
                if (!typeDefinition.getName().endsWith("WeakReferenceVector")) break;
                TypeDefinitionObjectReference referenceType = (TypeDefinitionObjectReference)((TypeDefinitionVariableArray)typeDefinition).getType();
                targetTypeName = referenceType.getObjectType().getName();
                angleName = "WeakReferenceVector<" + targetTypeName + ">";
                ofToName = "WeakReferenceVector of " + targetTypeName;
                knownTypes.put(angleName, typeDefinition);
                knownTypes.put(ofToName, typeDefinition);
                knownTypes.put(namespaceWithBrackets + angleName, typeDefinition);
                knownTypes.put(namespaceWithBrackets + ofToName, typeDefinition);
                break;
            }
        }
    }

    public static final Collection<String> getTypeInventory() {
        TreeSet<String> inventory = new TreeSet<String>();
        for (AUID typeID : knownTypesByID.keySet()) {
            inventory.add(knownTypesByID.get(typeID).getName());
        }
        return inventory;
    }

    public static final Collection<TypeDefinition> getTypeDefinitions() {
        return knownTypesByID.values();
    }

    public static final int registerExtendibleEnumerationElements(Class<?> extendibleEnumerationClass) throws NullPointerException, IllegalArgumentException {
        if (extendibleEnumerationClass == null) {
            throw new NullPointerException("Cannot add extensible enumeration items from a null class value.");
        }
        Field[] fields = extendibleEnumerationClass.getFields();
        int count = 0;
        try {
            for (Field field : fields) {
                ExtendibleEnumerationItem item = field.getAnnotation(ExtendibleEnumerationItem.class);
                if (item == null) continue;
                Warehouse.registerExtendibleEnumerationElement(item.target(), field.getName(), (AUID)field.get(null));
                ++count;
            }
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("When trying to read extendible enueratuin values, the fields of the given class are not accessible: " + iae.getMessage(), iae);
        }
        return count;
    }

    public static final boolean registerExtendibleEnumerationElement(String extendibleEnumerationName, String elementName, AUID elementValue) throws NullPointerException, IllegalArgumentException {
        if (extendibleEnumerationName == null) {
            throw new NullPointerException("Cannot register an element with a null name for an extendbiel enumeration.");
        }
        if (elementName == null) {
            throw new NullPointerException("Cannot register an element with a null element name.");
        }
        if (elementValue == null) {
            throw new NullPointerException("Cannot register an element with a null element value.");
        }
        if (idToEnumeration.containsKey(elementValue) && !idToEnumeration.get(elementValue).equals(extendibleEnumerationName)) {
            throw new IllegalArgumentException("Cannot register an extendible enumeration identifier in use by existing extendible enumeration " + idToEnumeration.get(elementValue) + ".");
        }
        if (!extensibleEnumerations.containsKey(extendibleEnumerationName)) {
            extensibleEnumerations.put(extendibleEnumerationName, new TreeMap());
        }
        TreeMap<String, AUID> expanding = extensibleEnumerations.get(extendibleEnumerationName);
        boolean replacement = idToElementName.containsKey(elementValue) || expanding.containsKey(elementName);
        expanding.put(elementName, elementValue);
        idToEnumeration.put(elementValue, extendibleEnumerationName);
        idToElementName.put(elementValue, elementName);
        return replacement;
    }

    public static final SortedMap<String, AUID> lookupExtendibleEnumeration(String extendibleEnumerationName) throws NullPointerException {
        if (extendibleEnumerationName == null) {
            throw new NullPointerException("Cannot look for an extendible enumeration using a null name.");
        }
        if (!extensibleEnumerations.containsKey(extendibleEnumerationName) && extendibleEnumerationName.endsWith("Type")) {
            return extensibleEnumerations.get(extendibleEnumerationName.substring(0, extendibleEnumerationName.length() - 4));
        }
        return extensibleEnumerations.get(extendibleEnumerationName);
    }

    public static final String extendibleEnumerationFullName(AUID elementValue) throws NullPointerException {
        if (elementValue == null) {
            throw new NullPointerException("Cannot lookup the full name of an element using a null element value.");
        }
        String enumerationName = idToEnumeration.get(elementValue);
        String enumerationElementName = idToElementName.get(elementValue);
        if (enumerationName == null || enumerationElementName == null) {
            return null;
        }
        if (enumerationElementName.charAt(0) != '_') {
            return enumerationName + "_" + enumerationElementName;
        }
        return enumerationName + enumerationElementName;
    }

    public static final AUID extendibleEnumerationElementValue(String fullElementName) throws NullPointerException {
        if (fullElementName == null) {
            throw new NullPointerException("Cannot lookup an extendible enumeration element value using a null full element name.");
        }
        int underscoreIndex = fullElementName.indexOf(95);
        if (underscoreIndex == -1) {
            return null;
        }
        String enumerationName = fullElementName.substring(0, underscoreIndex);
        String itemName = fullElementName.substring(underscoreIndex + 1);
        if (Character.isDigit(itemName.charAt(0))) {
            itemName = "_" + itemName;
        }
        return extensibleEnumerations.get(enumerationName).get(itemName);
    }

    public static final String extendibleEnumerationName(AUID elementValue) throws NullPointerException {
        if (elementValue == null) {
            throw new NullPointerException("Cannot find an extendible enumeration name from a null element value.");
        }
        return idToEnumeration.get(elementValue);
    }

    public static final String extendibleEnumerationElementName(AUID elementValue) throws NullPointerException {
        if (elementValue == null) {
            throw new NullPointerException("Cannot find an extendible enumeration element name from a null element value.");
        }
        return idToElementName.get(elementValue);
    }

    public static final Collection<String> getExtendibleEnumerationInventory() {
        return new TreeSet<String>(extensibleEnumerations.keySet());
    }

    public static final int countExtendibleEnumerations() {
        return extensibleEnumerations.size();
    }

    public static final String javaClassAlias(String aafName) {
        if (classAliases.containsKey(aafName)) {
            return classAliases.get(aafName);
        }
        return aafName;
    }

    public static final PropertyDefinition lookForProperty(AUID propertyID) throws NullPointerException {
        if (propertyID == null) {
            throw new NullPointerException("Cannot look for a property using a null identifier.");
        }
        return globalPropertyIdTable.get(propertyID);
    }

    public static final void register(PropertyDefinition propertyDefinition) throws NullPointerException {
        if (propertyDefinition == null) {
            throw new NullPointerException("Cannot register a property definition using a null value.");
        }
        globalPropertyIdTable.put(propertyDefinition.getAUID(), propertyDefinition);
    }

    public static final boolean isKnownProperty(PropertyDefinition property) {
        return globalPropertyIdTable.containsKey(property.getAUID());
    }

    public static final void register(ExtensionScheme extensionScheme) throws NullPointerException {
        if (extensionScheme == null) {
            throw new NullPointerException("Cannot register an extension scheme using a null value.");
        }
        ExtensionSchemeRecord extensionSchemeRecord = new ExtensionSchemeRecord(extensionScheme);
        if (extensionScheme.countMetaDefinitions() > 0) {
            for (MetaDefinition metaDefinition : extensionScheme.getMetaDefinitions()) {
                if (metaDefinition instanceof ClassDefinition) {
                    if (idToClass.containsKey(metaDefinition.getAUID())) continue;
                    Warehouse.register((ClassDefinition)metaDefinition);
                    continue;
                }
                if (metaDefinition instanceof PropertyDefinition) {
                    if (globalPropertyIdTable.containsKey(metaDefinition.getAUID())) continue;
                    Warehouse.register((PropertyDefinition)metaDefinition);
                    continue;
                }
                if (!(metaDefinition instanceof TypeDefinition) || knownTypesByID.containsKey(metaDefinition.getAUID())) continue;
                Warehouse.register((TypeDefinition)metaDefinition, extensionScheme.getSchemeURI(), extensionScheme.getPreferredPrefix());
            }
        }
        extensionSchemes.put(extensionSchemeRecord.schemeID, extensionSchemeRecord);
        WeakReference.registerTarget(extensionScheme);
    }

    public static final ExtensionScheme lookupExtensionScheme(AUID extensionSchemeID) throws NullPointerException {
        if (extensionSchemeID == null) {
            throw new NullPointerException("Cannot look for an extension scheme using a null scheme ID.");
        }
        if (!extensionSchemes.containsKey(extensionSchemeID)) {
            return null;
        }
        ExtensionSchemeRecord record = extensionSchemes.get(extensionSchemeID);
        ExtensionSchemeImpl scheme = new ExtensionSchemeImpl();
        scheme.setSchemeID(record.schemeID);
        scheme.setSchemeURI(record.schemeURI);
        scheme.setPreferredPrefix(record.preferredPrefix);
        scheme.setExtensionDescription(record.extensionDescription);
        for (ClassDefinition classDefinition : idToClass.values()) {
            if (!classDefinition.getNamespace().equals(record.schemeURI)) continue;
            scheme.addMetaDefinition(classDefinition);
        }
        for (TypeDefinition typeDefinition : knownTypesByID.values()) {
            if (!typeDefinition.getNamespace().equals(record.schemeURI)) continue;
            scheme.addMetaDefinition(typeDefinition);
        }
        for (PropertyDefinition propertyDefinition : globalPropertyIdTable.values()) {
            if (!propertyDefinition.getNamespace().equals(record.schemeURI)) continue;
            scheme.addMetaDefinition(propertyDefinition);
        }
        return scheme;
    }

    public static final ExtensionScheme lookupExtensionScheme(String extensionSchemeIdentifier) throws NullPointerException {
        if (extensionSchemeIdentifier == null) {
            throw new NullPointerException("Cannot look for an extension scheme using a null scheme identifier.");
        }
        AUID schemeToFind = null;
        for (ExtensionSchemeRecord record : extensionSchemes.values()) {
            if (!extensionSchemeIdentifier.equals(record.schemeURI) && !extensionSchemeIdentifier.equals(record.preferredPrefix) && !record.schemeID.toString().toLowerCase().contains(extensionSchemeIdentifier.toLowerCase())) continue;
            schemeToFind = record.schemeID;
            break;
        }
        if (schemeToFind != null) {
            return Warehouse.lookupExtensionScheme(schemeToFind);
        }
        return null;
    }

    static {
        classAliases.put("Timecode", "TimecodeSegment");
        classAliases.put("Edgecode", "EdgeCodeSegment");
        classAliases.put("EdgeCode", "EdgeCodeSegment");
        classAliases.put("File", "AAFFile");
        classAliases.put("FileDescriptor", "AAFFileDescriptor");
        classAliases.put("SourceReference", "SourceReferenceSegment");
        classAliases.put("AAFObject", "InterchangeObject");
        classAliases.put("Object", "InterchangeObject");
    }

    static class ExtensionSchemeRecord {
        AUID schemeID;
        String schemeURI;
        String preferredPrefix = null;
        String extensionDescription = null;

        public ExtensionSchemeRecord(ExtensionScheme extensionScheme) {
            this.schemeID = extensionScheme.getSchemeID();
            this.schemeURI = extensionScheme.getSchemeURI();
            try {
                this.preferredPrefix = extensionScheme.getPreferredPrefix();
            }
            catch (PropertyNotPresentException propertyNotPresentException) {
                // empty catch block
            }
            try {
                this.extensionDescription = extensionScheme.getExtensionDescription();
            }
            catch (PropertyNotPresentException propertyNotPresentException) {
                // empty catch block
            }
        }

        public int hashCode() {
            return this.schemeID.hashCode();
        }
    }
}

