/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.industry;

import java.util.HashSet;
import java.util.Set;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaEntity;

public class StrongReferenceSet {
    private StrongReferenceSet() {
    }

    public static final <T extends MediaEntity> void add(Set<T> set, T item) throws NullPointerException {
        if (set == null) {
            throw new NullPointerException("Cannot work with a null valued set.");
        }
        if (item == null) {
            throw new NullPointerException("Cannot add a null value to a set.");
        }
        set.add(item.clone());
    }

    public static final <T extends MediaEntity> boolean contains(Set<T> set, T item) throws NullPointerException {
        if (set == null) {
            throw new NullPointerException("Cannot work with a null valued set.");
        }
        if (item == null) {
            throw new NullPointerException("Cannot check whether an item is contained in a set using a null value.");
        }
        return set.contains(item);
    }

    public static final <T extends MediaEntity> boolean remove(Set<T> set, T item) throws NullPointerException {
        if (set == null) {
            throw new NullPointerException("Cannot work with a null valued set.");
        }
        if (item == null) {
            throw new NullPointerException("Cannot remove an item from a set using a null value.");
        }
        return set.remove(item);
    }

    public static final <T extends MediaEntity> Set<T> getOptionalSet(Set<T> set) throws PropertyNotPresentException {
        if (set == null) {
            throw new NullPointerException("Cannot work with a null valued set.");
        }
        if (set.size() == 0) {
            throw new PropertyNotPresentException("The optional strong reference set property is not present.");
        }
        return new HashSet<T>(set);
    }

    public static final <T extends MediaEntity> Set<T> getRequiredSet(Set<T> set) {
        if (set == null) {
            throw new NullPointerException("Cannot work with a null valued set.");
        }
        return new HashSet<T>(set);
    }
}

