/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.extensions.example.impl;

import java.io.Serializable;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.extensions.example.Organisation;
import tv.amwa.maj.extensions.example.Person;
import tv.amwa.maj.extensions.example.impl.ContributorImpl;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.integer.UInt64;
import tv.amwa.maj.io.xml.XMLSerializable;

@MediaClass(definedName="Organisation", uuid1=253759745, uuid2=260, uuid3=0, uuid4={6, 14, 43, 52, 2, 83, 1, 1}, description="Organisation that makes or contributes a resource.", namespace="http://amwa.tv/maj/extensions/example", prefix="eg", symbol="Organisation")
public class OrganisationImpl
extends ContributorImpl
implements Organisation,
CommonConstants,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = -7452986601899923598L;
    @UInt64
    private long companyNo;
    private Person contact;

    @Override
    @MediaProperty(definedName="CompanyNo", uuid1=253759745, uuid2=260, uuid3=256, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, typeName="UInt64", optional=false, uniqueIdentifier=false, pid=0, description="Registered company number for the organisation.", symbol="CompanyNo")
    @UInt64
    public long getCompanyNo() {
        return this.companyNo;
    }

    @Override
    @MediaPropertySetter(value="CompanyNo")
    public void setCompanyNo(@UInt64 long companyNo) throws IllegalArgumentException {
        this.companyNo = companyNo;
    }

    @Override
    @MediaProperty(definedName="Contact", uuid1=253759745, uuid2=260, uuid3=512, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, typeName="PersonStrongReference", optional=true, uniqueIdentifier=false, pid=0, description="Contact person at the organisation responsible for the contributed resource.", symbol="Contact")
    public Person getContact() throws PropertyNotPresentException {
        if (this.contact == null) {
            throw new PropertyNotPresentException("The optional contact property is not present for this organisation.");
        }
        return this.contact.clone();
    }

    @Override
    @MediaPropertySetter(value="Contact")
    public void setContact(Person contact) {
        if (contact == null) {
            this.contact = null;
            return;
        }
        this.contact = contact.clone();
    }

    @Override
    public Organisation clone() {
        return (Organisation)super.clone();
    }
}

