/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.xml;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.teleal.common.xml.ParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DOMElement<CHILD extends DOMElement, PARENT extends DOMElement> {
    public final Builder<PARENT> PARENT_BUILDER;
    public final ArrayBuilder<CHILD> CHILD_BUILDER;
    private final XPath xpath;
    private Element element;

    public DOMElement(XPath xpath, Element element) {
        this.xpath = xpath;
        this.element = element;
        this.PARENT_BUILDER = this.createParentBuilder(this);
        this.CHILD_BUILDER = this.createChildBuilder(this);
    }

    public Element getW3CElement() {
        return this.element;
    }

    public String getElementName() {
        return this.getW3CElement().getNodeName();
    }

    public String getContent() {
        return this.getW3CElement().getTextContent();
    }

    public DOMElement<CHILD, PARENT> setContent(String content) {
        this.getW3CElement().setTextContent(content);
        return this;
    }

    public String getAttribute(String attribute) {
        String v = this.getW3CElement().getAttribute(attribute);
        return v.length() > 0 ? v : null;
    }

    public DOMElement setAttribute(String attribute, String value) {
        this.getW3CElement().setAttribute(attribute, value);
        return this;
    }

    public PARENT getParent() {
        return this.PARENT_BUILDER.build((Element)this.getW3CElement().getParentNode());
    }

    public CHILD[] getChildren() {
        NodeList nodes = this.getW3CElement().getChildNodes();
        ArrayList children = new ArrayList();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            children.add(this.CHILD_BUILDER.build((Element)node));
        }
        return children.toArray(this.CHILD_BUILDER.newChildrenArray(children.size()));
    }

    public CHILD[] getChildren(String name) {
        Collection<CHILD> list = this.getXPathChildElements(this.CHILD_BUILDER, this.prefix(name));
        return list.toArray(this.CHILD_BUILDER.newChildrenArray(list.size()));
    }

    public CHILD getRequiredChild(String name) throws ParserException {
        DOMElement[] children = this.getChildren(name);
        if (children.length != 1) {
            throw new ParserException("Required single child element of '" + this.getElementName() + "' not found: " + name);
        }
        return (CHILD)children[0];
    }

    public CHILD[] findChildren(String name) {
        Collection<CHILD> list = this.getXPathChildElements(this.CHILD_BUILDER, "descendant::" + this.prefix(name));
        return list.toArray(this.CHILD_BUILDER.newChildrenArray(list.size()));
    }

    public CHILD findChildWithIdentifier(String id) {
        Collection<CHILD> list = this.getXPathChildElements(this.CHILD_BUILDER, "descendant::" + this.prefix("*") + "[@id=\"" + id + "\"]");
        if (list.size() == 1) {
            return (CHILD)((DOMElement)list.iterator().next());
        }
        return null;
    }

    public CHILD getFirstChild(String name) {
        return this.getXPathChildElement(this.CHILD_BUILDER, this.prefix(name) + "[1]");
    }

    public CHILD createChild(String name) {
        return this.createChild(name, null);
    }

    public CHILD createChild(String name, String namespaceURI) {
        Object child = this.CHILD_BUILDER.build(namespaceURI == null ? this.getW3CElement().getOwnerDocument().createElement(name) : this.getW3CElement().getOwnerDocument().createElementNS(namespaceURI, name));
        this.getW3CElement().appendChild(((DOMElement)child).getW3CElement());
        return (CHILD)child;
    }

    public CHILD appendChild(CHILD el, boolean copy) {
        el = this.adoptOrImport(this.getW3CElement().getOwnerDocument(), el, copy);
        this.getW3CElement().appendChild(((DOMElement)el).getW3CElement());
        return el;
    }

    public CHILD replaceChild(CHILD original, CHILD replacement, boolean copy) {
        replacement = this.adoptOrImport(this.getW3CElement().getOwnerDocument(), replacement, copy);
        this.getW3CElement().replaceChild(((DOMElement)replacement).getW3CElement(), ((DOMElement)original).getW3CElement());
        return replacement;
    }

    public void replaceEqualChild(DOMElement source, String identifier) {
        CHILD original = this.findChildWithIdentifier(identifier);
        CHILD replacement = source.findChildWithIdentifier(identifier);
        ((DOMElement)((DOMElement)original).getParent()).replaceChild(original, replacement, true);
    }

    public void removeChild(CHILD el) {
        this.getW3CElement().removeChild(((DOMElement)el).getW3CElement());
    }

    public void removeChildren() {
        NodeList children = this.getW3CElement().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            this.getW3CElement().removeChild(child);
        }
    }

    protected CHILD adoptOrImport(Document document, CHILD child, boolean copy) {
        if (document != null) {
            child = copy ? this.CHILD_BUILDER.build((Element)document.importNode(((DOMElement)child).getW3CElement(), true)) : this.CHILD_BUILDER.build((Element)document.adoptNode(((DOMElement)child).getW3CElement()));
        }
        return child;
    }

    protected abstract Builder<PARENT> createParentBuilder(DOMElement var1);

    protected abstract ArrayBuilder<CHILD> createChildBuilder(DOMElement var1);

    public String toSimpleXMLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.getElementName());
        NamedNodeMap map = this.getW3CElement().getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Node attr = map.item(i);
            sb.append(" ").append(attr.getNodeName()).append("=\"").append(attr.getTextContent()).append("\"");
        }
        if (this.getContent().length() > 0) {
            sb.append(">").append(this.getContent()).append("</").append(this.getElementName()).append(">");
        } else {
            sb.append("/>");
        }
        return sb.toString();
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") " + (this.getW3CElement() == null ? "UNBOUND" : this.getElementName());
    }

    public XPath getXpath() {
        return this.xpath;
    }

    protected String prefix(String localName) {
        return localName;
    }

    public Collection<PARENT> getXPathParentElements(Builder<CHILD> builder, String expr) {
        return this.getXPathElements(builder, expr);
    }

    public Collection<CHILD> getXPathChildElements(Builder<CHILD> builder, String expr) {
        return this.getXPathElements(builder, expr);
    }

    public PARENT getXPathParentElement(Builder<PARENT> builder, String expr) {
        Node node = (Node)this.getXPathResult(this.getW3CElement(), expr, XPathConstants.NODE);
        return node != null && node.getNodeType() == 1 ? (PARENT)builder.build((Element)node) : null;
    }

    public CHILD getXPathChildElement(Builder<CHILD> builder, String expr) {
        Node node = (Node)this.getXPathResult(this.getW3CElement(), expr, XPathConstants.NODE);
        return node != null && node.getNodeType() == 1 ? (CHILD)builder.build((Element)node) : null;
    }

    public Collection getXPathElements(Builder builder, String expr) {
        ArrayList col = new ArrayList();
        NodeList result = (NodeList)this.getXPathResult(this.getW3CElement(), expr, XPathConstants.NODESET);
        for (int i = 0; i < result.getLength(); ++i) {
            Object e = builder.build((Element)result.item(i));
            col.add(e);
        }
        return col;
    }

    public String getXPathString(XPath xpath, String expr) {
        return this.getXPathResult(this.getW3CElement(), expr, null).toString();
    }

    public Object getXPathResult(String expr, QName result) {
        return this.getXPathResult(this.getW3CElement(), expr, result);
    }

    public Object getXPathResult(Node context, String expr, QName result) {
        try {
            if (result == null) {
                return this.xpath.evaluate(expr, context);
            }
            return this.xpath.evaluate(expr, context, result);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public abstract class ArrayBuilder<T extends DOMElement>
    extends Builder<T> {
        protected ArrayBuilder(DOMElement element) {
            super(element);
        }

        public abstract T[] newChildrenArray(int var1);

        public T[] getChildElements() {
            return this.buildArray(this.element.getChildren());
        }

        public T[] getChildElements(String elementName) {
            return this.buildArray(this.element.getChildren(elementName));
        }

        protected T[] buildArray(DOMElement[] list) {
            DOMElement[] children = this.newChildrenArray(list.length);
            for (int i = 0; i < children.length; ++i) {
                children[i] = this.build(list[i].getW3CElement());
            }
            return children;
        }
    }

    public abstract class Builder<T extends DOMElement> {
        public DOMElement element;

        protected Builder(DOMElement element) {
            this.element = element;
        }

        public abstract T build(Element var1);

        public T firstChildOrNull(String elementName) {
            Object el = this.element.getFirstChild(elementName);
            return el != null ? (T)this.build(((DOMElement)el).getW3CElement()) : null;
        }
    }
}

