/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.xhtml;

import java.util.HashSet;
import javax.xml.xpath.XPath;
import org.teleal.common.xhtml.XHTML;
import org.teleal.common.xml.DOMParser;
import org.teleal.common.xml.NamespaceContextMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XHTMLParser
extends DOMParser<XHTML> {
    public XHTMLParser() {
        super(XHTML.createSchemaSources());
    }

    @Override
    protected XHTML createDOM(Document document) {
        return document != null ? new XHTML(document) : null;
    }

    public void checkDuplicateIdentifiers(XHTML document) throws IllegalStateException {
        final HashSet identifiers = new HashSet();
        XHTMLParser.accept(document.getW3CDocument().getDocumentElement(), new DOMParser.NodeVisitor(1){

            @Override
            public void visit(Node node) {
                Element element = (Element)node;
                String id = element.getAttribute(XHTML.ATTR.id.name());
                if (!"".equals(id)) {
                    if (identifiers.contains(id)) {
                        throw new IllegalStateException("Duplicate identifier, override/change value: " + id);
                    }
                    identifiers.add(id);
                }
            }
        });
    }

    public NamespaceContextMap createDefaultNamespaceContext(String ... optionalPrefixes) {
        NamespaceContextMap ctx = new NamespaceContextMap(){

            @Override
            protected String getDefaultNamespaceURI() {
                return "http://www.w3.org/1999/xhtml";
            }
        };
        for (String optionalPrefix : optionalPrefixes) {
            ctx.put(optionalPrefix, "http://www.w3.org/1999/xhtml");
        }
        return ctx;
    }

    public XPath createXPath() {
        return super.createXPath(this.createDefaultNamespaceContext("h"));
    }
}

