/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.xhtml;

import java.util.ArrayList;
import javax.xml.xpath.XPath;
import org.teleal.common.xhtml.Anchor;
import org.teleal.common.xhtml.Option;
import org.teleal.common.xhtml.XHTML;
import org.teleal.common.xml.DOMElement;
import org.w3c.dom.Element;

public class XHTMLElement
extends DOMElement<XHTMLElement, XHTMLElement> {
    public static final String XPATH_PREFIX = "h";

    public XHTMLElement(XPath xpath, Element element) {
        super(xpath, element);
    }

    @Override
    protected DOMElement.Builder<XHTMLElement> createParentBuilder(DOMElement el) {
        return new DOMElement.Builder<XHTMLElement>(el){

            @Override
            public XHTMLElement build(Element element) {
                return new XHTMLElement(XHTMLElement.this.getXpath(), element);
            }
        };
    }

    @Override
    protected DOMElement.ArrayBuilder<XHTMLElement> createChildBuilder(DOMElement el) {
        return new DOMElement.ArrayBuilder<XHTMLElement>(el){

            public XHTMLElement[] newChildrenArray(int length) {
                return new XHTMLElement[length];
            }

            @Override
            public XHTMLElement build(Element element) {
                return new XHTMLElement(XHTMLElement.this.getXpath(), element);
            }
        };
    }

    @Override
    protected String prefix(String localName) {
        return "h:" + localName;
    }

    public XHTML.ELEMENT getConstant() {
        return XHTML.ELEMENT.valueOf(this.getElementName());
    }

    public XHTMLElement[] getChildren(XHTML.ELEMENT el) {
        return (XHTMLElement[])super.getChildren(el.name());
    }

    public XHTMLElement getFirstChild(XHTML.ELEMENT el) {
        return (XHTMLElement)super.getFirstChild(el.name());
    }

    public XHTMLElement[] findChildren(XHTML.ELEMENT el) {
        return (XHTMLElement[])super.findChildren(el.name());
    }

    public XHTMLElement createChild(XHTML.ELEMENT el) {
        return (XHTMLElement)super.createChild(el.name(), "http://www.w3.org/1999/xhtml");
    }

    public String getAttribute(XHTML.ATTR attribute) {
        return this.getAttribute(attribute.name());
    }

    public XHTMLElement setAttribute(XHTML.ATTR attribute, String value) {
        super.setAttribute(attribute.name(), value);
        return this;
    }

    public String getId() {
        return this.getAttribute(XHTML.ATTR.id);
    }

    public XHTMLElement setId(String id) {
        this.setAttribute(XHTML.ATTR.id, id);
        return this;
    }

    public String getTitle() {
        return this.getAttribute(XHTML.ATTR.title);
    }

    public XHTMLElement setTitle(String title) {
        this.setAttribute(XHTML.ATTR.title, title);
        return this;
    }

    public XHTMLElement setClasses(String classes) {
        this.setAttribute("class", classes);
        return this;
    }

    public XHTMLElement setClasses(String[] classes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < classes.length; ++i) {
            sb.append(classes[i]);
            if (i == classes.length - 1) continue;
            sb.append(" ");
        }
        this.setAttribute("class", sb.toString());
        return this;
    }

    public String[] getClasses() {
        String v = this.getAttribute("class");
        if (v == null) {
            return new String[0];
        }
        return v.split(" ");
    }

    public Option[] getOptions() {
        return Option.fromString(this.getAttribute(XHTML.ATTR.style));
    }

    public Option getOption(String key) {
        for (Option option : this.getOptions()) {
            if (!option.getKey().equals(key)) continue;
            return option;
        }
        return null;
    }

    public Anchor[] findAllAnchors(String requiredScheme) {
        return this.findAllAnchors(requiredScheme, null);
    }

    public Anchor[] findAllAnchors(String requiredScheme, String requiredClass) {
        XHTMLElement[] elements = this.findChildrenWithClass(XHTML.ELEMENT.a, requiredClass);
        ArrayList<Anchor> anchors = new ArrayList<Anchor>(elements.length);
        for (XHTMLElement element : elements) {
            String href = element.getAttribute(XHTML.ATTR.href);
            if (requiredScheme != null && (href == null || !href.startsWith(requiredScheme))) continue;
            anchors.add(new Anchor(this.getXpath(), element.getW3CElement()));
        }
        return anchors.toArray(new Anchor[anchors.size()]);
    }

    public XHTMLElement[] findChildrenWithClass(XHTML.ELEMENT el, String clazz) {
        XHTMLElement[] children;
        ArrayList<XHTMLElement> list = new ArrayList<XHTMLElement>();
        block0: for (XHTMLElement child : children = this.findChildren(el)) {
            if (clazz == null) {
                list.add(child);
                continue;
            }
            for (String c : child.getClasses()) {
                if (!c.matches(clazz)) continue;
                list.add(child);
                continue block0;
            }
        }
        return (XHTMLElement[])list.toArray(this.CHILD_BUILDER.newChildrenArray(list.size()));
    }

    public XHTMLElement setContent(String content) {
        super.setContent(content);
        return this;
    }

    @Override
    public XHTMLElement setAttribute(String attribute, String value) {
        super.setAttribute(attribute, value);
        return this;
    }
}

