/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.xhtml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class Option {
    private String key;
    private String[] values;

    public Option(String key, String[] values) {
        this.key = key;
        this.values = values;
    }

    public static Option[] fromString(String string) {
        if (string == null || string.length() == 0) {
            return new Option[0];
        }
        ArrayList<Option> options = new ArrayList<Option>();
        try {
            String[] fields;
            for (String field : fields = string.split(";")) {
                field = field.trim();
                String[] keyValues = field.split(":");
                String key = keyValues[0].trim();
                String[] values = keyValues[1].split(",");
                for (int i = 0; i < values.length; ++i) {
                    values[i] = values[i].trim();
                }
                options.add(new Option(key, values));
            }
            return options.toArray(new Option[options.size()]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't parse options string: " + string, ex);
        }
    }

    public String getKey() {
        return this.key;
    }

    public String[] getValues() {
        return this.values;
    }

    public boolean isTrue() {
        return this.getValues().length == 1 && this.getValues()[0].toLowerCase().equals("true");
    }

    public boolean isFalse() {
        return this.getValues().length == 1 && this.getValues()[0].toLowerCase().equals("false");
    }

    public String getFirstValue() {
        return this.getValues()[0];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getKey()).append(": ");
        Iterator<String> it = Arrays.asList(this.getValues()).iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Option that = (Option)o;
        if (!this.key.equals(that.key)) {
            return false;
        }
        return Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }
}

