/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.util;

import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.BitSet;

public class URIUtil {
    public static final BitSet GEN_DELIMS = new BitSet();
    public static final BitSet SUB_DELIMS;
    public static final BitSet RESERVED;
    public static final BitSet LOW_ALPHA;
    public static final BitSet UP_ALPHA;
    public static final BitSet ALPHA;
    public static final BitSet DIGIT;
    public static final BitSet ALPHANUM;
    public static final BitSet UNRESERVED;
    public static final BitSet PCHAR;
    public static final BitSet PATH_SEGMENT;
    public static final BitSet PATH_PARAM_NAME;
    public static final BitSet PATH_PARAM_VALUE;
    public static final BitSet QUERY;
    public static final BitSet FRAGMENT;

    public static URI createAbsoluteURI(URI base, String uri) throws IllegalArgumentException {
        return URIUtil.createAbsoluteURI(base, URI.create(uri));
    }

    public static URI createAbsoluteURI(URI base, URI relativeOrNot) throws IllegalArgumentException {
        if (base == null && !relativeOrNot.isAbsolute()) {
            throw new IllegalArgumentException("Base URI is null and given URI is not absolute");
        }
        if (base == null && relativeOrNot.isAbsolute()) {
            return relativeOrNot;
        }
        assert (base != null);
        if (base.getPath().length() == 0) {
            try {
                base = new URI(base.getScheme(), base.getAuthority(), "/", base.getQuery(), base.getFragment());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return base.resolve(relativeOrNot);
    }

    public static URL createAbsoluteURL(URL base, String uri) throws IllegalArgumentException {
        return URIUtil.createAbsoluteURL(base, URI.create(uri));
    }

    public static URL createAbsoluteURL(URL base, URI relativeOrNot) throws IllegalArgumentException {
        if (base == null && !relativeOrNot.isAbsolute()) {
            throw new IllegalArgumentException("Base URL is null and given URI is not absolute");
        }
        if (base == null && relativeOrNot.isAbsolute()) {
            try {
                return relativeOrNot.toURL();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Base URL was null and given URI can't be converted to URL");
            }
        }
        try {
            assert (base != null);
            URI baseURI = base.toURI();
            URI absoluteURI = URIUtil.createAbsoluteURI(baseURI, relativeOrNot);
            return absoluteURI.toURL();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Base URL is not an URI, or can't create absolute URI (null?), or absolute URI can not be converted to URL", ex);
        }
    }

    public static URL createAbsoluteURL(URI base, URI relativeOrNot) throws IllegalArgumentException {
        try {
            return URIUtil.createAbsoluteURI(base, relativeOrNot).toURL();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Absolute URI can not be converted to URL", ex);
        }
    }

    public static URL createAbsoluteURL(InetAddress address, int localStreamPort, URI relativeOrNot) throws IllegalArgumentException {
        try {
            if (address instanceof Inet6Address) {
                return URIUtil.createAbsoluteURL(new URL("http://[" + address.getHostAddress() + "]:" + localStreamPort), relativeOrNot);
            }
            if (address instanceof Inet4Address) {
                return URIUtil.createAbsoluteURL(new URL("http://" + address.getHostAddress() + ":" + localStreamPort), relativeOrNot);
            }
            throw new IllegalArgumentException("InetAddress is neither IPv4 nor IPv6: " + address);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Address, port, and URI can not be converted to URL", ex);
        }
    }

    public static URI createRelativePathURI(URI uri) {
        int idx;
        URIUtil.assertRelativeURI("Given", uri);
        URI normalizedURI = uri.normalize();
        String uriString = normalizedURI.toString();
        while ((idx = uriString.indexOf("../")) != -1) {
            uriString = uriString.substring(0, idx) + uriString.substring(idx + 3);
        }
        while (uriString.startsWith("/")) {
            uriString = uriString.substring(1);
        }
        return URI.create(uriString);
    }

    public static URI createRelativeURI(URI base, URI full) {
        return base.relativize(full);
    }

    public static URI createRelativeURI(URL base, URL full) throws IllegalArgumentException {
        try {
            return URIUtil.createRelativeURI(base.toURI(), full.toURI());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't convert base or full URL to URI", ex);
        }
    }

    public static URI createRelativeURI(URI base, URL full) throws IllegalArgumentException {
        try {
            return URIUtil.createRelativeURI(base, full.toURI());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't convert full URL to URI", ex);
        }
    }

    public static URI createRelativeURI(URL base, URI full) throws IllegalArgumentException {
        try {
            return URIUtil.createRelativeURI(base.toURI(), full);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't convert base URL to URI", ex);
        }
    }

    public static boolean isAbsoluteURI(String s) {
        URI uri = URI.create(s);
        return uri.isAbsolute();
    }

    public static void assertRelativeURI(String what, URI uri) {
        if (uri.isAbsolute()) {
            throw new IllegalArgumentException(what + " URI must be relative, without scheme and authority");
        }
    }

    public static URL toURL(URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URI toURI(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String percentEncode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String percentDecode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String encodePathParamName(String pathParamName) {
        try {
            return URIUtil.encodePart(pathParamName, "UTF-8", PATH_PARAM_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodePathParamValue(String pathParamValue) {
        try {
            return URIUtil.encodePart(pathParamValue, "UTF-8", PATH_PARAM_VALUE);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeQueryNameOrValue(String queryNameOrValue) {
        try {
            return URIUtil.encodePart(queryNameOrValue, "UTF-8", QUERY);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeQueryNameOrValueNoParen(String queryNameOrValueNoParen) {
        try {
            String query = URIUtil.encodePart(queryNameOrValueNoParen, "UTF-8", QUERY);
            query = query.replace("(", "");
            return query.replace(")", "");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodePathSegment(String pathSegment) {
        try {
            return URIUtil.encodePart(pathSegment, "UTF-8", PATH_SEGMENT);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodePart(String part, String charset, BitSet allowed) throws UnsupportedEncodingException {
        char[] toEncode;
        if (part == null) {
            return null;
        }
        StringBuffer encoded = new StringBuffer(part.length() * 3);
        for (char c : toEncode = part.toCharArray()) {
            byte[] bytes;
            if (allowed.get(c)) {
                encoded.append(c);
                continue;
            }
            for (byte b : bytes = String.valueOf(c).getBytes(charset)) {
                int u8 = b & 0xFF;
                encoded.append(String.format("%%%1$02X", u8));
            }
        }
        return encoded.toString();
    }

    static {
        GEN_DELIMS.set(58);
        GEN_DELIMS.set(47);
        GEN_DELIMS.set(63);
        GEN_DELIMS.set(35);
        GEN_DELIMS.set(91);
        GEN_DELIMS.set(93);
        GEN_DELIMS.set(64);
        SUB_DELIMS = new BitSet();
        SUB_DELIMS.set(33);
        SUB_DELIMS.set(36);
        SUB_DELIMS.set(38);
        SUB_DELIMS.set(39);
        SUB_DELIMS.set(40);
        SUB_DELIMS.set(41);
        SUB_DELIMS.set(42);
        SUB_DELIMS.set(43);
        SUB_DELIMS.set(44);
        SUB_DELIMS.set(59);
        SUB_DELIMS.set(61);
        RESERVED = new BitSet();
        RESERVED.or(GEN_DELIMS);
        RESERVED.or(SUB_DELIMS);
        LOW_ALPHA = new BitSet();
        LOW_ALPHA.set(97);
        LOW_ALPHA.set(98);
        LOW_ALPHA.set(99);
        LOW_ALPHA.set(100);
        LOW_ALPHA.set(101);
        LOW_ALPHA.set(102);
        LOW_ALPHA.set(103);
        LOW_ALPHA.set(104);
        LOW_ALPHA.set(105);
        LOW_ALPHA.set(106);
        LOW_ALPHA.set(107);
        LOW_ALPHA.set(108);
        LOW_ALPHA.set(109);
        LOW_ALPHA.set(110);
        LOW_ALPHA.set(111);
        LOW_ALPHA.set(112);
        LOW_ALPHA.set(113);
        LOW_ALPHA.set(114);
        LOW_ALPHA.set(115);
        LOW_ALPHA.set(116);
        LOW_ALPHA.set(117);
        LOW_ALPHA.set(118);
        LOW_ALPHA.set(119);
        LOW_ALPHA.set(120);
        LOW_ALPHA.set(121);
        LOW_ALPHA.set(122);
        UP_ALPHA = new BitSet();
        UP_ALPHA.set(65);
        UP_ALPHA.set(66);
        UP_ALPHA.set(67);
        UP_ALPHA.set(68);
        UP_ALPHA.set(69);
        UP_ALPHA.set(70);
        UP_ALPHA.set(71);
        UP_ALPHA.set(72);
        UP_ALPHA.set(73);
        UP_ALPHA.set(74);
        UP_ALPHA.set(75);
        UP_ALPHA.set(76);
        UP_ALPHA.set(77);
        UP_ALPHA.set(78);
        UP_ALPHA.set(79);
        UP_ALPHA.set(80);
        UP_ALPHA.set(81);
        UP_ALPHA.set(82);
        UP_ALPHA.set(83);
        UP_ALPHA.set(84);
        UP_ALPHA.set(85);
        UP_ALPHA.set(86);
        UP_ALPHA.set(87);
        UP_ALPHA.set(88);
        UP_ALPHA.set(89);
        UP_ALPHA.set(90);
        ALPHA = new BitSet();
        ALPHA.or(LOW_ALPHA);
        ALPHA.or(UP_ALPHA);
        DIGIT = new BitSet();
        DIGIT.set(48);
        DIGIT.set(49);
        DIGIT.set(50);
        DIGIT.set(51);
        DIGIT.set(52);
        DIGIT.set(53);
        DIGIT.set(54);
        DIGIT.set(55);
        DIGIT.set(56);
        DIGIT.set(57);
        ALPHANUM = new BitSet();
        ALPHANUM.or(ALPHA);
        ALPHANUM.or(DIGIT);
        UNRESERVED = new BitSet();
        UNRESERVED.or(ALPHA);
        UNRESERVED.or(DIGIT);
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(95);
        UNRESERVED.set(126);
        PCHAR = new BitSet();
        PCHAR.or(UNRESERVED);
        PCHAR.or(SUB_DELIMS);
        PCHAR.set(58);
        PCHAR.set(64);
        PATH_SEGMENT = new BitSet();
        PATH_SEGMENT.or(PCHAR);
        PATH_SEGMENT.clear(59);
        PATH_PARAM_NAME = new BitSet();
        PATH_PARAM_NAME.or(PCHAR);
        PATH_PARAM_NAME.clear(59);
        PATH_PARAM_NAME.clear(61);
        PATH_PARAM_VALUE = new BitSet();
        PATH_PARAM_VALUE.or(PCHAR);
        PATH_PARAM_VALUE.clear(59);
        QUERY = new BitSet();
        QUERY.or(PCHAR);
        QUERY.set(47);
        QUERY.set(63);
        QUERY.clear(61);
        QUERY.clear(38);
        QUERY.clear(43);
        FRAGMENT = new BitSet();
        FRAGMENT.or(PCHAR);
        FRAGMENT.set(47);
        FRAGMENT.set(63);
    }
}

