/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class MimeType {
    public static final String WILDCARD = "*";
    private String type;
    private String subtype;
    private Map<String, String> parameters;

    public MimeType() {
        this(WILDCARD, WILDCARD);
    }

    public MimeType(String type, String subtype, Map<String, String> parameters) {
        this.type = type == null ? WILDCARD : type;
        String string = this.subtype = subtype == null ? WILDCARD : subtype;
        if (parameters == null) {
            this.parameters = Collections.EMPTY_MAP;
        } else {
            TreeMap<String, String> map = new TreeMap<String, String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                map.put(e.getKey().toLowerCase(), e.getValue());
            }
            this.parameters = Collections.unmodifiableMap(map);
        }
    }

    public MimeType(String type, String subtype) {
        this(type, subtype, Collections.EMPTY_MAP);
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardType() {
        return this.getType().equals(WILDCARD);
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isWildcardSubtype() {
        return this.getSubtype().equals(WILDCARD);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isCompatible(MimeType other) {
        if (other == null) {
            return false;
        }
        if (this.type.equals(WILDCARD) || other.type.equals(WILDCARD)) {
            return true;
        }
        if (this.type.equalsIgnoreCase(other.type) && (this.subtype.equals(WILDCARD) || other.subtype.equals(WILDCARD))) {
            return true;
        }
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype);
    }

    public static MimeType valueOf(String stringValue) throws IllegalArgumentException {
        if (stringValue == null) {
            throw new IllegalArgumentException("String value is null");
        }
        String params = null;
        int semicolonIndex = stringValue.indexOf(";");
        if (semicolonIndex > -1) {
            params = stringValue.substring(semicolonIndex + 1).trim();
            stringValue = stringValue.substring(0, semicolonIndex);
        }
        String major = null;
        String subtype = null;
        String[] paths = stringValue.split("/");
        if (paths.length < 2 && stringValue.equals(WILDCARD)) {
            major = WILDCARD;
            subtype = WILDCARD;
        } else if (paths.length == 2) {
            major = paths[0].trim();
            subtype = paths[1].trim();
        } else if (paths.length != 2) {
            throw new IllegalArgumentException("Error parsing string: " + stringValue);
        }
        if (params != null && params.length() > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            int start = 0;
            while (start < params.length()) {
                start = MimeType.readParamsIntoMap(map, params, start);
            }
            return new MimeType(major, subtype, map);
        }
        return new MimeType(major, subtype);
    }

    public static int readParamsIntoMap(Map<String, String> map, String params, int start) {
        int i;
        boolean quote = false;
        boolean backslash = false;
        int end = MimeType.getEnd(params, start);
        String name = params.substring(start, end).trim();
        if (end < params.length() && params.charAt(end) == '=') {
            ++end;
        }
        StringBuilder buffer = new StringBuilder(params.length() - end);
        block5: for (i = end; i < params.length(); ++i) {
            char c = params.charAt(i);
            switch (c) {
                case '\"': {
                    if (backslash) {
                        backslash = false;
                        buffer.append(c);
                        continue block5;
                    }
                    quote = !quote;
                    continue block5;
                }
                case '\\': {
                    if (!backslash) continue block5;
                    backslash = false;
                    buffer.append(c);
                    continue block5;
                }
                case ';': {
                    if (!quote) {
                        String value = buffer.toString().trim();
                        map.put(name, value);
                        return i + 1;
                    }
                    buffer.append(c);
                    continue block5;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        String value = buffer.toString().trim();
        map.put(name, value);
        return i;
    }

    protected static int getEnd(String params, int start) {
        int equals = params.indexOf(61, start);
        int semicolon = params.indexOf(59, start);
        if (equals == -1 && semicolon == -1) {
            return params.length();
        }
        if (equals == -1) {
            return semicolon;
        }
        if (semicolon == -1) {
            return equals;
        }
        return equals < semicolon ? equals : semicolon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MimeType mimeType = (MimeType)o;
        if (this.parameters != null ? !((Object)this.parameters).equals(mimeType.parameters) : mimeType.parameters != null) {
            return false;
        }
        if (!this.subtype.equalsIgnoreCase(mimeType.subtype)) {
            return false;
        }
        return this.type.equalsIgnoreCase(mimeType.type);
    }

    public int hashCode() {
        int result = this.type.toLowerCase().hashCode();
        result = 31 * result + this.subtype.toLowerCase().hashCode();
        result = 31 * result + (this.parameters != null ? ((Object)this.parameters).hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType().toLowerCase()).append("/").append(this.getSubtype().toLowerCase());
        if (this.getParameters() != null || this.getParameters().size() > 0) {
            for (String name : this.getParameters().keySet()) {
                sb.append(";").append(name).append("=\"").append(this.getParameters().get(name)).append("\"");
            }
        }
        return sb.toString();
    }
}

