/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.swingfwk.logging;

import java.util.Arrays;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.teleal.common.swingfwk.logging.LogMessage;

public abstract class LoggingHandler
extends Handler {
    public int sourcePathElements = 3;

    public LoggingHandler() {
    }

    public LoggingHandler(int sourcePathElements) {
        this.sourcePathElements = sourcePathElements;
    }

    @Override
    public void publish(LogRecord logRecord) {
        LogMessage logMessage = new LogMessage(logRecord.getLevel(), this.getSource(logRecord), logRecord.getMessage());
        this.log(logMessage);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    protected String getSource(LogRecord record) {
        StringBuilder sb = new StringBuilder(180);
        String[] split = record.getSourceClassName().split("\\.");
        if (split.length > this.sourcePathElements) {
            split = Arrays.copyOfRange(split, split.length - this.sourcePathElements, split.length);
        }
        for (String s : split) {
            sb.append(s).append(".");
        }
        sb.append(record.getSourceMethodName());
        return sb.toString();
    }

    protected abstract void log(LogMessage var1);
}

