/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.swingfwk.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;

public class LogMessage {
    private Level level;
    private Long createdOn = new Date().getTime();
    private String thread = Thread.currentThread().getName();
    private String source;
    private String message;

    public LogMessage(String message) {
        this(Level.INFO, message);
    }

    public LogMessage(String source, String message) {
        this(Level.INFO, source, message);
    }

    public LogMessage(Level level, String message) {
        this(level, null, message);
    }

    public LogMessage(Level level, String source, String message) {
        this.level = level;
        this.source = source;
        this.message = message;
    }

    public Level getLevel() {
        return this.level;
    }

    public Long getCreatedOn() {
        return this.createdOn;
    }

    public String getThread() {
        return this.thread;
    }

    public String getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss:SSS");
        return this.getLevel() + " - " + dateFormat.format(new Date(this.getCreatedOn())) + " - " + this.getThread() + " : " + this.getSource() + " : " + this.getMessage();
    }
}

