/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.swingfwk.logging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.teleal.common.swingfwk.logging.LogCategory;

public class LogCategorySelector
extends JDialog {
    protected final JPanel mainPanel = new JPanel();

    public LogCategorySelector(List<LogCategory> logCategories) {
        this.setTitle("Select logging categories...");
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addLogCategories(logCategories);
        JScrollPane scrollPane = new JScrollPane(this.mainPanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(scrollPane);
        this.setMaximumSize(new Dimension(750, 550));
        this.setResizable(false);
        this.pack();
    }

    protected void addLogCategories(List<LogCategory> logCategories) {
        for (LogCategory logCategory : logCategories) {
            this.addLogCategory(logCategory);
        }
    }

    protected void addLogCategory(LogCategory logCategory) {
        JPanel categoryPanel = new JPanel(new BorderLayout());
        categoryPanel.setBorder(BorderFactory.createTitledBorder(logCategory.getName()));
        this.addLoggerGroups(logCategory, categoryPanel);
        this.mainPanel.add(categoryPanel);
    }

    protected void addLoggerGroups(final LogCategory logCategory, final JPanel categoryPanel) {
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new BoxLayout(checkboxPanel, 1));
        for (final LogCategory.Group group : logCategory.getGroups()) {
            JCheckBox checkBox = new JCheckBox(group.getName());
            checkBox.setSelected(group.isEnabled());
            checkBox.setFocusable(false);
            checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        LogCategorySelector.this.disableLoggerGroup(group);
                    } else if (e.getStateChange() == 1) {
                        LogCategorySelector.this.enableLoggerGroup(group);
                    }
                }
            });
            checkboxPanel.add(checkBox);
        }
        JToolBar buttonBar = new JToolBar();
        buttonBar.setFloatable(false);
        JButton enableAllButton = new JButton("All");
        enableAllButton.setFocusable(false);
        enableAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (LogCategory.Group group : logCategory.getGroups()) {
                    LogCategorySelector.this.enableLoggerGroup(group);
                }
                categoryPanel.removeAll();
                LogCategorySelector.this.addLoggerGroups(logCategory, categoryPanel);
                categoryPanel.revalidate();
            }
        });
        buttonBar.add(enableAllButton);
        JButton disableAllButton = new JButton("None");
        disableAllButton.setFocusable(false);
        disableAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (LogCategory.Group group : logCategory.getGroups()) {
                    LogCategorySelector.this.disableLoggerGroup(group);
                }
                categoryPanel.removeAll();
                LogCategorySelector.this.addLoggerGroups(logCategory, categoryPanel);
                categoryPanel.revalidate();
            }
        });
        buttonBar.add(disableAllButton);
        categoryPanel.add((Component)checkboxPanel, "Center");
        categoryPanel.add((Component)buttonBar, "North");
    }

    protected void enableLoggerGroup(LogCategory.Group group) {
        group.setEnabled(true);
        group.getPreviousLevels().clear();
        for (LogCategory.LoggerLevel loggerLevel : group.getLoggerLevels()) {
            Logger logger = Logger.getLogger(loggerLevel.getLogger());
            group.getPreviousLevels().add(new LogCategory.LoggerLevel(logger.getName(), this.getLevel(logger)));
            logger.setLevel(loggerLevel.getLevel());
        }
    }

    protected void disableLoggerGroup(LogCategory.Group group) {
        Logger logger;
        group.setEnabled(false);
        for (LogCategory.LoggerLevel loggerLevel : group.getPreviousLevels()) {
            logger = Logger.getLogger(loggerLevel.getLogger());
            logger.setLevel(loggerLevel.getLevel());
        }
        if (group.getPreviousLevels().size() == 0) {
            for (LogCategory.LoggerLevel loggerLevel : group.getLoggerLevels()) {
                logger = Logger.getLogger(loggerLevel.getLogger());
                logger.setLevel(Level.INFO);
            }
        }
        group.getPreviousLevels().clear();
    }

    public Level getLevel(Logger logger) {
        Level level = logger.getLevel();
        if (level == null && logger.getParent() != null) {
            level = logger.getParent().getLevel();
        }
        return level;
    }
}

