/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.mock.http;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.teleal.common.mock.http.MockHttpServletResponse;

public class MockRequestDispatcher
implements RequestDispatcher {
    private final Logger log = Logger.getLogger(MockRequestDispatcher.class.getName());
    private final String url;

    public MockRequestDispatcher(String url) {
        this.url = url;
    }

    public void forward(ServletRequest request, ServletResponse response) {
        if (response.isCommitted()) {
            throw new IllegalStateException("Cannot perform forward - response is already committed");
        }
        this.getMockHttpServletResponse(response).setForwardedUrl(this.url);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("MockRequestDispatcher: forwarding to URL [" + this.url + "]");
        }
    }

    public void include(ServletRequest request, ServletResponse response) {
        this.getMockHttpServletResponse(response).setIncludedUrl(this.url);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("MockRequestDispatcher: including URL [" + this.url + "]");
        }
    }

    protected MockHttpServletResponse getMockHttpServletResponse(ServletResponse response) {
        if (response instanceof MockHttpServletResponse) {
            return (MockHttpServletResponse)response;
        }
        if (response instanceof HttpServletResponseWrapper) {
            return this.getMockHttpServletResponse(((HttpServletResponseWrapper)response).getResponse());
        }
        throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
    }
}

