/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.mock.http;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class HeaderValueHolder {
    private final List values = new LinkedList();

    HeaderValueHolder() {
    }

    public void setValue(Object value) {
        this.values.clear();
        this.values.add(value);
    }

    public void addValue(Object value) {
        this.values.add(value);
    }

    public void addValues(Collection values) {
        this.values.addAll(values);
    }

    public void addValueArray(Object values) {
        Object[] arr = HeaderValueHolder.toObjectArray(values);
        this.values.addAll(Arrays.asList(arr));
    }

    public List getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public Object getValue() {
        return !this.values.isEmpty() ? this.values.get(0) : null;
    }

    public static HeaderValueHolder getByName(Map headers, String name) {
        for (String headerName : headers.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return (HeaderValueHolder)headers.get(headerName);
        }
        return null;
    }

    public static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return new Object[0];
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + source);
        }
        int length = Array.getLength(source);
        if (length == 0) {
            return new Object[0];
        }
        Class<?> wrapperType = Array.get(source, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(source, i);
        }
        return newArray;
    }
}

