/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class SystemOutLoggingHandler
extends StreamHandler {
    public SystemOutLoggingHandler() {
        super(System.out, new SimpleFormatter());
        this.setLevel(Level.ALL);
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
    }

    public static class SimpleFormatter
    extends Formatter {
        @Override
        public String format(LogRecord record) {
            StringBuffer buf = new StringBuffer(180);
            SimpleDateFormat dateFormat = new SimpleDateFormat("kk:mm:ss,SS");
            buf.append("[").append(this.pad(Thread.currentThread().getName(), 32)).append("] ");
            buf.append(this.pad(record.getLevel().toString(), 12));
            buf.append(" - ");
            buf.append(this.pad(dateFormat.format(new Date(record.getMillis())), 24));
            buf.append(" - ");
            buf.append(this.toClassString(record.getSourceClassName(), 30));
            buf.append('#');
            buf.append(record.getSourceMethodName());
            buf.append(": ");
            buf.append(this.formatMessage(record));
            buf.append("\n");
            Throwable throwable = record.getThrown();
            if (throwable != null) {
                StringWriter sink = new StringWriter();
                throwable.printStackTrace(new PrintWriter((Writer)sink, true));
                buf.append(sink.toString());
            }
            return buf.toString();
        }

        public String pad(String s, int size) {
            if (s.length() < size) {
                for (int i = s.length(); i < size - s.length(); ++i) {
                    s = s + " ";
                }
            }
            return s;
        }

        public String toClassString(String name, int maxLength) {
            return name.length() > maxLength ? name.substring(name.length() - maxLength) : name;
        }
    }
}

