/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.jdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javadoc.JavadocTool;
import com.sun.tools.javadoc.ModifierFilter;
import com.sun.tools.javadoc.PublicMessager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyDoclet {
    private final Logger log = Logger.getLogger(EasyDoclet.class.getName());
    private final File sourceDirectory;
    private final String[] packageNames;
    private final File[] fileNames;
    private final RootDoc rootDoc;

    public EasyDoclet(File sourceDirectory, Collection<String> packageNames) {
        this("", sourceDirectory, packageNames.toArray(new String[packageNames.size()]), new File[0]);
    }

    public EasyDoclet(String locale, File sourceDirectory, Collection<String> packageNames) {
        this(locale, sourceDirectory, packageNames.toArray(new String[packageNames.size()]), new File[0]);
    }

    public EasyDoclet(File sourceDirectory, String ... packageNames) {
        this("", sourceDirectory, packageNames, new File[0]);
    }

    public EasyDoclet(String locale, File sourceDirectory, String ... packageNames) {
        this(locale, sourceDirectory, packageNames, new File[0]);
    }

    public EasyDoclet(File sourceDirectory, File ... fileNames) {
        this("", sourceDirectory, new String[0], fileNames);
    }

    public EasyDoclet(String locale, File sourceDirectory, File ... fileNames) {
        this(locale, sourceDirectory, new String[0], fileNames);
    }

    protected EasyDoclet(File sourceDirectory, String[] packageNames, File[] fileNames) {
        this("", sourceDirectory, packageNames, fileNames);
    }

    protected EasyDoclet(String locale, File sourceDirectory, String[] packageNames, File[] fileNames) {
        this.sourceDirectory = sourceDirectory;
        this.packageNames = packageNames;
        this.fileNames = fileNames;
        Context context = new Context();
        Options compOpts = Options.instance(context);
        if (this.getSourceDirectory().exists()) {
            this.log.fine("Using source path: " + this.getSourceDirectory().getAbsolutePath());
            compOpts.put("-sourcepath", this.getSourceDirectory().getAbsolutePath());
        } else {
            this.log.info("Ignoring non-existant source path, check your source directory argument");
        }
        ListBuffer<String> javaNames = new ListBuffer<String>();
        for (File fileName : fileNames) {
            this.log.fine("Adding file to documentation path: " + fileName.getAbsolutePath());
            javaNames.append(fileName.getPath());
        }
        ListBuffer<String> subPackages = new ListBuffer<String>();
        for (String packageName : packageNames) {
            this.log.fine("Adding sub-packages to documentation path: " + packageName);
            subPackages.append(packageName);
        }
        new PublicMessager(context, this.getApplicationName(), new PrintWriter((Writer)new LogWriter(Level.SEVERE), true), new PrintWriter((Writer)new LogWriter(Level.WARNING), true), new PrintWriter((Writer)new LogWriter(Level.FINE), true));
        JavadocTool javadocTool = JavadocTool.make0((Context)context);
        try {
            this.rootDoc = javadocTool.getRootDocImpl(locale, null, new ModifierFilter(-9223372036854775801L), javaNames.toList(), new ListBuffer().toList(), false, subPackages.toList(), new ListBuffer().toList(), false, false, false);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            for (ClassDoc classDoc : this.getRootDoc().classes()) {
                this.log.finest("Parsed Javadoc class source: " + classDoc.position() + " with inline tags: " + classDoc.inlineTags().length);
            }
        }
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String[] getPackageNames() {
        return this.packageNames;
    }

    public File[] getFileNames() {
        return this.fileNames;
    }

    public RootDoc getRootDoc() {
        return this.rootDoc;
    }

    protected String getApplicationName() {
        return this.getClass().getSimpleName() + " Application";
    }

    protected class LogWriter
    extends Writer {
        Level level;

        public LogWriter(Level level) {
            this.level = level;
        }

        public void write(char[] chars, int offset, int length) throws IOException {
            String s = new String(Arrays.copyOf(chars, length));
            if (!(s.equals("\n") || s.equals("\r") || s.equals(" "))) {
                EasyDoclet.this.log.log(this.level, s);
            }
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

