/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.http;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Query {
    private String qs = "";
    private Map<String, List<String>> parameters = new TreeMap<String, List<String>>();

    public static String parseParameters(Map<String, String[]> parameters) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            for (String v : entry.getValue()) {
                if (v == null || v.length() == 0) continue;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(entry.getKey());
                sb.append("=");
                sb.append(v);
            }
        }
        return sb.toString();
    }

    public Query() {
    }

    public Query(Map<String, String[]> parameters) {
        this(Query.parseParameters(parameters));
    }

    public Query(URL url) {
        this(url.getQuery());
    }

    public Query(String qs) {
        String[] pairs;
        if (qs == null) {
            return;
        }
        this.qs = qs;
        for (String pair : pairs = qs.split("&")) {
            String value;
            String name;
            int pos = pair.indexOf(61);
            if (pos == -1) {
                name = pair;
                value = null;
            } else {
                try {
                    name = URLDecoder.decode(pair.substring(0, pos), "UTF-8");
                    value = URLDecoder.decode(pair.substring(pos + 1, pair.length()), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("Query string is not UTF-8");
                }
            }
            List<String> list = this.parameters.get(name);
            if (list == null) {
                list = new ArrayList<String>();
                this.parameters.put(name, list);
            }
            list.add(value);
        }
    }

    public String get(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return "";
        }
        if (values.size() == 0) {
            return "";
        }
        return values.get(0);
    }

    public String[] getValues(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public Enumeration<String> getNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public Map<String, String[]> getMap() {
        TreeMap<String, String[]> map = new TreeMap<String, String[]>();
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            List<String> list = entry.getValue();
            String[] values = list == null ? null : list.toArray(new String[list.size()]);
            map.put(entry.getKey(), values);
        }
        return map;
    }

    public boolean isEmpty() {
        return this.parameters.size() == 0;
    }

    public String toString() {
        return this.qs;
    }
}

