/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.common.http;

import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Headers
implements Map<String, List<String>> {
    static final byte CR = 13;
    static final byte LF = 10;
    final Map<String, List<String>> map = new HashMap<String, List<String>>(32);

    public Headers() {
    }

    public Headers(Map<String, List<String>> map) {
        this.putAll((Map<? extends String, ? extends List<String>>)map);
    }

    public Headers(ByteArrayInputStream inputStream) {
        Headers headers = new Headers();
        String line = Headers.readLine(inputStream);
        String lastHeader = null;
        if (line.length() != 0) {
            do {
                char firstChar = line.charAt(0);
                if (lastHeader != null && (firstChar == ' ' || firstChar == '\t')) {
                    Object current = headers.get(lastHeader);
                    int lastPos = current.size() - 1;
                    String newString = (String)current.get(lastPos) + line.trim();
                    current.set(lastPos, newString);
                    continue;
                }
                String[] header = this.splitHeader(line);
                headers.add(header[0], header[1]);
                lastHeader = header[0];
            } while ((line = Headers.readLine(inputStream)).length() != 0);
        }
        this.putAll(headers);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key != null && key instanceof String && this.map.containsKey(this.normalize((String)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public List<String> get(Object key) {
        return this.map.get(this.normalize((String)key));
    }

    @Override
    public List<String> put(String key, List<String> value) {
        return this.map.put(this.normalize(key), value);
    }

    @Override
    public List<String> remove(Object key) {
        return this.map.remove(this.normalize((String)key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> t) {
        for (Map.Entry<? extends String, ? extends List<String>> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<List<String>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.map).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public String getFirstHeader(String key) {
        List<String> l = this.map.get(this.normalize(key));
        return l != null && l.size() > 0 ? l.get(0) : null;
    }

    public void add(String key, String value) {
        String k = this.normalize(key);
        List<String> l = this.map.get(k);
        if (l == null) {
            l = new LinkedList<String>();
            this.map.put(k, l);
        }
        l.add(value);
    }

    public void set(String key, String value) {
        LinkedList<String> l = new LinkedList<String>();
        l.add(value);
        this.put(key, (List<String>)l);
    }

    private String normalize(String key) {
        if (key == null) {
            return null;
        }
        if (key.length() == 0) {
            return key;
        }
        char[] b = key.toCharArray();
        if (b[0] >= 'a' && b[0] <= 'z') {
            b[0] = (char)(b[0] - 32);
        }
        for (int i = 1; i < key.length(); ++i) {
            if (b[i] < 'A' || b[i] > 'Z') continue;
            b[i] = (char)(b[i] + 32);
        }
        return new String(b);
    }

    public static String readLine(ByteArrayInputStream is) {
        char nextChar;
        int nextByte;
        StringBuilder sb = new StringBuilder(64);
        while ((nextByte = is.read()) != -1 && !((nextChar = (char)nextByte) == '\r' ? (nextByte = (int)((char)is.read())) == 10 : nextChar == '\n')) {
            sb.append(nextChar);
        }
        return sb.toString();
    }

    protected String[] splitHeader(String sb) {
        int colonEnd;
        int nameStart;
        char ch;
        int nameEnd;
        for (nameEnd = nameStart = this.findNonWhitespace(sb, 0); nameEnd < sb.length() && (ch = sb.charAt(nameEnd)) != ':' && !Character.isWhitespace(ch); ++nameEnd) {
        }
        for (colonEnd = nameEnd; colonEnd < sb.length(); ++colonEnd) {
            if (sb.charAt(colonEnd) != ':') continue;
            ++colonEnd;
            break;
        }
        int valueStart = this.findNonWhitespace(sb, colonEnd);
        int valueEnd = this.findEndOfString(sb);
        return new String[]{sb.substring(nameStart, nameEnd), sb.length() >= valueStart && sb.length() >= valueEnd && valueStart < valueEnd ? sb.substring(valueStart, valueEnd) : null};
    }

    protected int findNonWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    protected int findEndOfString(String sb) {
        int result;
        for (result = sb.length(); result > 0 && Character.isWhitespace(sb.charAt(result - 1)); --result) {
        }
        return result;
    }

    public String toString() {
        StringBuilder headerString = new StringBuilder();
        for (Map.Entry<String, List<String>> headerEntry : this.entrySet()) {
            StringBuilder headerLine = new StringBuilder();
            headerLine.append(headerEntry.getKey()).append(": ");
            for (String v : headerEntry.getValue()) {
                headerLine.append(v).append(",");
            }
            headerLine.delete(headerLine.length() - 1, headerLine.length());
            headerString.append((CharSequence)headerLine).append("\r\n");
        }
        return headerString.toString();
    }
}

