/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.transport.impl.apache;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.teleal.cling.model.message.StreamRequestMessage;
import org.teleal.cling.model.message.StreamResponseMessage;
import org.teleal.cling.model.message.UpnpHeaders;
import org.teleal.cling.model.message.UpnpMessage;
import org.teleal.cling.model.message.UpnpRequest;
import org.teleal.cling.model.message.UpnpResponse;
import org.teleal.cling.transport.impl.apache.HeaderUtil;
import org.teleal.cling.transport.impl.apache.StreamClientConfigurationImpl;
import org.teleal.cling.transport.spi.InitializationException;
import org.teleal.cling.transport.spi.StreamClient;
import org.teleal.common.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamClientImpl
implements StreamClient<StreamClientConfigurationImpl> {
    private static final Logger log = Logger.getLogger(StreamClient.class.getName());
    protected final StreamClientConfigurationImpl configuration;
    protected final ThreadSafeClientConnManager clientConnectionManager;
    protected final DefaultHttpClient httpClient;
    protected final HttpParams globalParams = new BasicHttpParams();

    public StreamClientImpl(StreamClientConfigurationImpl configuration) throws InitializationException {
        this.configuration = configuration;
        ConnManagerParams.setMaxTotalConnections(this.globalParams, this.getConfiguration().getMaxTotalConnections());
        HttpConnectionParams.setConnectionTimeout(this.globalParams, this.getConfiguration().getConnectionTimeoutSeconds() * 1000);
        HttpConnectionParams.setSoTimeout(this.globalParams, this.getConfiguration().getDataReadTimeoutSeconds() * 1000);
        HttpProtocolParams.setContentCharset(this.globalParams, this.getConfiguration().getContentCharset());
        if (this.getConfiguration().getSocketBufferSize() != -1) {
            HttpConnectionParams.setSocketBufferSize(this.globalParams, this.getConfiguration().getSocketBufferSize());
        }
        HttpConnectionParams.setStaleCheckingEnabled(this.globalParams, this.getConfiguration().getStaleCheckingEnabled());
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
        this.clientConnectionManager = new ThreadSafeClientConnManager(this.globalParams, registry);
        this.httpClient = new DefaultHttpClient(this.clientConnectionManager, this.globalParams);
        if (this.getConfiguration().getRequestRetryCount() != -1) {
            this.httpClient.setHttpRequestRetryHandler(new DefaultHttpRequestRetryHandler(this.getConfiguration().getRequestRetryCount(), false));
        }
    }

    @Override
    public StreamClientConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    public StreamResponseMessage sendRequest(StreamRequestMessage requestMessage) {
        UpnpRequest requestOperation = (UpnpRequest)requestMessage.getOperation();
        log.fine("Preparing HTTP request message with method '" + requestOperation.getHttpMethodName() + "': " + requestMessage);
        try {
            HttpUriRequest httpRequest = this.createHttpRequest(requestMessage, requestOperation);
            httpRequest.setParams(this.getRequestParams(requestMessage));
            HeaderUtil.add(httpRequest, requestMessage.getHeaders());
            log.fine("Sending HTTP request: " + httpRequest.getURI());
            return this.httpClient.execute(httpRequest, this.createResponseHandler());
        }
        catch (MethodNotSupportedException ex) {
            log.warning("Request aborted: " + ex.toString());
            return null;
        }
        catch (ClientProtocolException ex) {
            log.warning("HTTP protocol exception executing request: " + requestMessage);
            log.warning("Cause: " + Exceptions.unwrap(ex));
            return null;
        }
        catch (IOException ex) {
            log.fine("Client connection was aborted: " + ex.getMessage());
            return null;
        }
    }

    @Override
    public void stop() {
        log.fine("Shutting down HTTP client connection manager/pool");
        this.clientConnectionManager.shutdown();
    }

    protected HttpUriRequest createHttpRequest(UpnpMessage upnpMessage, UpnpRequest upnpRequestOperation) throws MethodNotSupportedException {
        switch (upnpRequestOperation.getMethod()) {
            case GET: {
                return new HttpGet(upnpRequestOperation.getURI());
            }
            case SUBSCRIBE: {
                return new HttpGet(upnpRequestOperation.getURI()){

                    public String getMethod() {
                        return UpnpRequest.Method.SUBSCRIBE.getHttpName();
                    }
                };
            }
            case UNSUBSCRIBE: {
                return new HttpGet(upnpRequestOperation.getURI()){

                    public String getMethod() {
                        return UpnpRequest.Method.UNSUBSCRIBE.getHttpName();
                    }
                };
            }
            case POST: {
                HttpPost post = new HttpPost(upnpRequestOperation.getURI());
                post.setEntity(this.createHttpRequestEntity(upnpMessage));
                return post;
            }
            case NOTIFY: {
                HttpPost notify = new HttpPost(upnpRequestOperation.getURI()){

                    public String getMethod() {
                        return UpnpRequest.Method.NOTIFY.getHttpName();
                    }
                };
                notify.setEntity(this.createHttpRequestEntity(upnpMessage));
                return notify;
            }
        }
        throw new MethodNotSupportedException(upnpRequestOperation.getHttpMethodName());
    }

    protected HttpEntity createHttpRequestEntity(UpnpMessage upnpMessage) {
        if (upnpMessage.getBodyType().equals((Object)UpnpMessage.BodyType.BYTES)) {
            log.fine("Preparing HTTP request entity as byte[]");
            return new ByteArrayEntity(upnpMessage.getBodyBytes());
        }
        log.fine("Preparing HTTP request entity as string");
        try {
            String charset = upnpMessage.getContentTypeCharset();
            return new StringEntity(upnpMessage.getBodyString(), charset != null ? charset : "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected ResponseHandler<StreamResponseMessage> createResponseHandler() {
        return new ResponseHandler<StreamResponseMessage>(){

            @Override
            public StreamResponseMessage handleResponse(HttpResponse httpResponse) throws IOException {
                StatusLine statusLine = httpResponse.getStatusLine();
                log.fine("Received HTTP response: " + statusLine);
                UpnpResponse responseOperation = new UpnpResponse(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                StreamResponseMessage responseMessage = new StreamResponseMessage(responseOperation);
                responseMessage.setHeaders(new UpnpHeaders(HeaderUtil.get(httpResponse)));
                HttpEntity entity = httpResponse.getEntity();
                if (entity == null || entity.getContentLength() == 0L) {
                    return responseMessage;
                }
                if (responseMessage.isContentTypeMissingOrText()) {
                    log.fine("HTTP response message contains text entity");
                    responseMessage.setBody(UpnpMessage.BodyType.STRING, EntityUtils.toString(entity));
                } else {
                    log.fine("HTTP response message contains binary entity");
                    responseMessage.setBody(UpnpMessage.BodyType.BYTES, EntityUtils.toByteArray(entity));
                }
                return responseMessage;
            }
        };
    }

    protected HttpParams getRequestParams(StreamRequestMessage requestMessage) {
        BasicHttpParams localParams = new BasicHttpParams();
        localParams.setParameter("http.protocol.version", ((UpnpRequest)requestMessage.getOperation()).getHttpMinorVersion() == 0 ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUserAgent(localParams, this.getConfiguration().getUserAgentValue(requestMessage.getUdaMajorVersion(), requestMessage.getUdaMinorVersion()));
        return new DefaultedHttpParams(localParams, this.globalParams);
    }
}

