/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.transport.impl.apache;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpServerConnection;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.teleal.cling.model.message.StreamRequestMessage;
import org.teleal.cling.model.message.StreamResponseMessage;
import org.teleal.cling.model.message.UpnpHeaders;
import org.teleal.cling.model.message.UpnpMessage;
import org.teleal.cling.model.message.UpnpOperation;
import org.teleal.cling.model.message.UpnpRequest;
import org.teleal.cling.model.message.UpnpResponse;
import org.teleal.cling.protocol.ProtocolFactory;
import org.teleal.cling.transport.impl.apache.HeaderUtil;
import org.teleal.cling.transport.spi.UnsupportedDataException;
import org.teleal.cling.transport.spi.UpnpStream;
import org.teleal.common.io.IO;
import org.teleal.common.util.Exceptions;

public class HttpServerConnectionUpnpStream
extends UpnpStream {
    private static final Logger log = Logger.getLogger(UpnpStream.class.getName());
    protected final HttpServerConnection connection;
    protected final BasicHttpProcessor httpProcessor = new BasicHttpProcessor();
    protected final HttpService httpService;
    protected final HttpParams params;

    protected HttpServerConnectionUpnpStream(ProtocolFactory protocolFactory, HttpServerConnection connection, HttpParams params) {
        super(protocolFactory);
        this.connection = connection;
        this.params = params;
        this.httpProcessor.addInterceptor(new ResponseDate());
        this.httpProcessor.addInterceptor(new ResponseContent());
        this.httpProcessor.addInterceptor(new ResponseConnControl());
        this.httpService = new UpnpHttpService(this.httpProcessor, new DefaultConnectionReuseStrategy(), new DefaultHttpResponseFactory());
        this.httpService.setParams(params);
    }

    public HttpServerConnection getConnection() {
        return this.connection;
    }

    public void run() {
        try {
            while (!Thread.interrupted() && this.connection.isOpen()) {
                log.fine("Handling request on open connection...");
                BasicHttpContext context = new BasicHttpContext(null);
                this.httpService.handleRequest(this.connection, context);
            }
        }
        catch (ConnectionClosedException ex) {
            log.fine("Client closed connection");
            this.responseException(ex);
        }
        catch (SocketTimeoutException ex) {
            log.fine("Server-side closed socket (this is 'normal' behavior of Apache HTTP Core!): " + ex.getMessage());
        }
        catch (IOException ex) {
            log.warning("I/O exception during HTTP request processing: " + ex.getMessage());
            this.responseException(ex);
        }
        catch (HttpException ex) {
            throw new UnsupportedDataException("Request malformed: " + ex.getMessage(), ex);
        }
        finally {
            try {
                this.connection.shutdown();
            }
            catch (IOException ex) {
                log.fine("Error closing connection: " + ex.getMessage());
            }
        }
    }

    protected class UpnpHttpService
    extends HttpService {
        public UpnpHttpService(HttpProcessor processor, ConnectionReuseStrategy reuse, HttpResponseFactory responseFactory) {
            super(processor, reuse, responseFactory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doService(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext ctx) throws HttpException, IOException {
            StreamResponseMessage responseMsg;
            StreamRequestMessage requestMessage;
            log.fine("Processing HTTP request: " + httpRequest.getRequestLine().toString());
            String requestMethod = httpRequest.getRequestLine().getMethod();
            String requestURI = httpRequest.getRequestLine().getUri();
            try {
                requestMessage = new StreamRequestMessage(UpnpRequest.Method.getByHttpName(requestMethod), URI.create(requestURI));
            }
            catch (IllegalArgumentException e) {
                String msg = "Invalid request URI: " + requestURI + ": " + e.getMessage();
                log.warning(msg);
                throw new HttpException(msg, e);
            }
            if (((UpnpRequest)requestMessage.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNKNOWN)) {
                log.fine("Method not supported by UPnP stack: " + requestMethod);
                throw new MethodNotSupportedException("Method not supported: " + requestMethod);
            }
            log.fine("Created new request message: " + requestMessage);
            int requestHttpMinorVersion = httpRequest.getProtocolVersion().getMinor();
            ((UpnpRequest)requestMessage.getOperation()).setHttpMinorVersion(requestHttpMinorVersion);
            requestMessage.setHeaders(new UpnpHeaders(HeaderUtil.get(httpRequest)));
            if (httpRequest instanceof HttpEntityEnclosingRequest) {
                byte[] bodyBytes;
                log.fine("Request contains entity body, setting on UPnP message");
                HttpEntityEnclosingRequest entityEnclosingHttpRequest = (HttpEntityEnclosingRequest)httpRequest;
                InputStream is = null;
                try {
                    is = entityEnclosingHttpRequest.getEntity().getContent();
                    bodyBytes = IO.readBytes(is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
                if (bodyBytes.length > 0 && requestMessage.isContentTypeMissingOrText()) {
                    log.fine("Request contains textual entity body, converting then setting string on message");
                    requestMessage.setBodyCharacters(bodyBytes);
                } else if (bodyBytes.length > 0) {
                    log.fine("Request contains binary entity body, setting bytes on message");
                    requestMessage.setBody(UpnpMessage.BodyType.BYTES, bodyBytes);
                } else {
                    log.fine("Request did not contain entity body");
                }
            } else {
                log.fine("Request did not contain entity body");
            }
            try {
                responseMsg = HttpServerConnectionUpnpStream.this.process(requestMessage);
            }
            catch (RuntimeException ex) {
                log.fine("Exception occured during UPnP stream processing: " + ex);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Cause: " + Exceptions.unwrap(ex), Exceptions.unwrap(ex));
                }
                log.fine("Sending HTTP response: 500");
                httpResponse.setStatusCode(500);
                HttpServerConnectionUpnpStream.this.responseException(ex);
                return;
            }
            if (responseMsg != null) {
                log.fine("Sending HTTP response message: " + responseMsg);
                httpResponse.setStatusLine(new BasicStatusLine(new ProtocolVersion("HTTP", 1, ((UpnpResponse)responseMsg.getOperation()).getHttpMinorVersion()), ((UpnpResponse)responseMsg.getOperation()).getStatusCode(), ((UpnpResponse)responseMsg.getOperation()).getStatusMessage()));
                log.fine("Response status line: " + httpResponse.getStatusLine());
                httpResponse.setParams(this.getResponseParams((UpnpOperation)requestMessage.getOperation()));
                HeaderUtil.add(httpResponse, responseMsg.getHeaders());
                if (responseMsg.hasBody() && responseMsg.getBodyType().equals((Object)UpnpMessage.BodyType.BYTES)) {
                    httpResponse.setEntity(new ByteArrayEntity(responseMsg.getBodyBytes()));
                } else if (responseMsg.hasBody() && responseMsg.getBodyType().equals((Object)UpnpMessage.BodyType.STRING)) {
                    StringEntity responseEntity = new StringEntity(responseMsg.getBodyString(), "UTF-8");
                    httpResponse.setEntity(responseEntity);
                }
            } else {
                log.fine("Sending HTTP response: 404");
                httpResponse.setStatusCode(404);
            }
            HttpServerConnectionUpnpStream.this.responseSent(responseMsg);
        }

        protected HttpParams getResponseParams(UpnpOperation operation) {
            BasicHttpParams localParams = new BasicHttpParams();
            return new DefaultedHttpParams(localParams, HttpServerConnectionUpnpStream.this.params);
        }
    }
}

