/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.transport.impl;

import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.teleal.cling.model.XMLUtil;
import org.teleal.cling.model.message.UpnpMessage;
import org.teleal.cling.model.message.gena.IncomingEventRequestMessage;
import org.teleal.cling.model.message.gena.OutgoingEventRequestMessage;
import org.teleal.cling.model.meta.StateVariable;
import org.teleal.cling.model.state.StateVariableValue;
import org.teleal.cling.transport.spi.GENAEventProcessor;
import org.teleal.cling.transport.spi.UnsupportedDataException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GENAEventProcessorImpl
implements GENAEventProcessor {
    private static Logger log = Logger.getLogger(GENAEventProcessor.class.getName());

    public void writeBody(OutgoingEventRequestMessage requestMessage) throws UnsupportedDataException {
        log.fine("Writing body of: " + requestMessage);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document d = factory.newDocumentBuilder().newDocument();
            Element propertysetElement = this.writePropertysetElement(d);
            this.writeProperties(d, propertysetElement, requestMessage);
            requestMessage.setBody(UpnpMessage.BodyType.STRING, this.toString(d));
            if (log.isLoggable(Level.FINER)) {
                log.finer("===================================== GENA BODY BEGIN ============================================");
                log.finer(requestMessage.getBody().toString());
                log.finer("-===================================== GENA BODY END ============================================");
            }
        }
        catch (Exception ex) {
            throw new UnsupportedDataException("Can't transform message payload: " + ex.getMessage(), ex);
        }
    }

    public void readBody(IncomingEventRequestMessage requestMessage) throws UnsupportedDataException {
        log.fine("Reading body of: " + requestMessage);
        if (log.isLoggable(Level.FINER)) {
            log.finer("===================================== GENA BODY BEGIN ============================================");
            log.finer(requestMessage.getBody().toString());
            log.finer("-===================================== GENA BODY END ============================================");
        }
        if (requestMessage.getBody() == null || !requestMessage.getBodyType().equals((Object)UpnpMessage.BodyType.STRING)) {
            throw new UnsupportedDataException("Can't transform null or non-string body of: " + requestMessage);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document d = factory.newDocumentBuilder().parse(new InputSource(new StringReader(requestMessage.getBodyString().trim())));
            Element propertysetElement = this.readPropertysetElement(d);
            this.readProperties(propertysetElement, requestMessage);
        }
        catch (Exception ex) {
            throw new UnsupportedDataException("Can't transform message payload: " + ex.getMessage(), ex);
        }
    }

    protected Element writePropertysetElement(Document d) {
        Element propertysetElement = d.createElementNS("urn:schemas-upnp-org:event-1-0", "e:propertyset");
        d.appendChild(propertysetElement);
        return propertysetElement;
    }

    protected Element readPropertysetElement(Document d) {
        Element propertysetElement = d.getDocumentElement();
        if (propertysetElement == null || !this.getUnprefixedNodeName(propertysetElement).equals("propertyset")) {
            throw new RuntimeException("Root element was not 'propertyset'");
        }
        return propertysetElement;
    }

    protected void writeProperties(Document d, Element propertysetElement, OutgoingEventRequestMessage message) {
        for (StateVariableValue stateVariableValue : message.getStateVariableValues()) {
            Element propertyElement = d.createElementNS("urn:schemas-upnp-org:event-1-0", "e:property");
            propertysetElement.appendChild(propertyElement);
            XMLUtil.appendNewElement(d, propertyElement, stateVariableValue.getStateVariable().getName(), stateVariableValue.toString());
        }
    }

    protected void readProperties(Element propertysetElement, IncomingEventRequestMessage message) {
        NodeList propertysetElementChildren = propertysetElement.getChildNodes();
        StateVariable<S>[] stateVariables = message.getService().getStateVariables();
        for (int i = 0; i < propertysetElementChildren.getLength(); ++i) {
            Node propertysetChild = propertysetElementChildren.item(i);
            if (propertysetChild.getNodeType() != 1 || !this.getUnprefixedNodeName(propertysetChild).equals("property")) continue;
            NodeList propertyChildren = propertysetChild.getChildNodes();
            block1: for (int j = 0; j < propertyChildren.getLength(); ++j) {
                Node propertyChild = propertyChildren.item(j);
                if (propertyChild.getNodeType() != 1) continue;
                String stateVariableName = this.getUnprefixedNodeName(propertyChild);
                for (StateVariable stateVariable : stateVariables) {
                    if (!stateVariable.getName().equals(stateVariableName)) continue;
                    log.fine("Reading state variable value: " + stateVariableName);
                    String value = XMLUtil.getTextContent(propertyChild);
                    message.getStateVariableValues().add(new StateVariableValue(stateVariable, (Object)value));
                    continue block1;
                }
            }
        }
    }

    protected String toString(Document d) throws Exception {
        String output = XMLUtil.documentToString(d);
        while (output.endsWith("\n") || output.endsWith("\r")) {
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }

    protected String getUnprefixedNodeName(Node node) {
        return node.getPrefix() != null ? node.getNodeName().substring(node.getPrefix().length() + 1) : node.getNodeName();
    }
}

