/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.transport.impl;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teleal.cling.model.message.IncomingDatagramMessage;
import org.teleal.cling.model.message.OutgoingDatagramMessage;
import org.teleal.cling.model.message.UpnpHeaders;
import org.teleal.cling.model.message.UpnpOperation;
import org.teleal.cling.model.message.UpnpRequest;
import org.teleal.cling.model.message.UpnpResponse;
import org.teleal.cling.transport.spi.DatagramProcessor;
import org.teleal.cling.transport.spi.UnsupportedDataException;
import org.teleal.common.http.Headers;

public class DatagramProcessorImpl
implements DatagramProcessor {
    private static Logger log = Logger.getLogger(DatagramProcessor.class.getName());

    public IncomingDatagramMessage read(InetAddress receivedOnAddress, DatagramPacket datagram) throws UnsupportedDataException {
        try {
            ByteArrayInputStream is;
            String[] startLine;
            if (log.isLoggable(Level.FINER)) {
                log.finer("===================================== DATAGRAM BEGIN ============================================");
                log.finer(new String(datagram.getData()));
                log.finer("-===================================== DATAGRAM END =============================================");
            }
            if ((startLine = Headers.readLine(is = new ByteArrayInputStream(datagram.getData())).split(" "))[0].startsWith("HTTP/1.")) {
                return this.readResponseMessage(receivedOnAddress, datagram, is, Integer.valueOf(startLine[1]), startLine[2], startLine[0]);
            }
            return this.readRequestMessage(receivedOnAddress, datagram, is, startLine[0], startLine[2]);
        }
        catch (Exception ex) {
            throw new UnsupportedDataException("Could not parse headers: " + ex, ex);
        }
    }

    public DatagramPacket write(OutgoingDatagramMessage message) throws UnsupportedDataException {
        StringBuilder statusLine = new StringBuilder();
        Object operation = message.getOperation();
        if (operation instanceof UpnpRequest) {
            UpnpRequest requestOperation = (UpnpRequest)operation;
            statusLine.append(requestOperation.getHttpMethodName()).append(" * ");
            statusLine.append("HTTP/1.").append(((UpnpOperation)operation).getHttpMinorVersion()).append("\r\n");
        } else if (operation instanceof UpnpResponse) {
            UpnpResponse responseOperation = (UpnpResponse)operation;
            statusLine.append("HTTP/1.").append(((UpnpOperation)operation).getHttpMinorVersion()).append(" ");
            statusLine.append(responseOperation.getStatusCode()).append(" ").append(responseOperation.getStatusMessage());
            statusLine.append("\r\n");
        } else {
            throw new UnsupportedDataException("Message operation is not request or response, don't know how to process: " + message);
        }
        StringBuilder messageData = new StringBuilder();
        messageData.append((CharSequence)statusLine);
        messageData.append(message.getHeaders().toString()).append("\r\n");
        if (log.isLoggable(Level.FINER)) {
            log.finer("Writing message data for: " + message);
            log.finer("---------------------------------------------------------------------------------");
            log.finer(messageData.toString().substring(0, messageData.length() - 2));
            log.finer("---------------------------------------------------------------------------------");
        }
        try {
            byte[] data = messageData.toString().getBytes("US-ASCII");
            log.fine("Writing new datagram packet with " + data.length + " bytes for: " + message);
            return new DatagramPacket(data, data.length, message.getDestinationAddress(), message.getDestinationPort());
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnsupportedDataException("Can't convert message content to US-ASCII: " + ex.getMessage(), ex);
        }
    }

    protected IncomingDatagramMessage readRequestMessage(InetAddress receivedOnAddress, DatagramPacket datagram, ByteArrayInputStream is, String requestMethod, String httpProtocol) throws Exception {
        UpnpHeaders headers = new UpnpHeaders(is);
        UpnpRequest upnpRequest = new UpnpRequest(UpnpRequest.Method.getByHttpName(requestMethod));
        upnpRequest.setHttpMinorVersion(httpProtocol.toUpperCase().equals("HTTP/1.1") ? 1 : 0);
        IncomingDatagramMessage<UpnpRequest> requestMessage = new IncomingDatagramMessage<UpnpRequest>(upnpRequest, datagram.getAddress(), datagram.getPort(), receivedOnAddress);
        requestMessage.setHeaders(headers);
        return requestMessage;
    }

    protected IncomingDatagramMessage readResponseMessage(InetAddress receivedOnAddress, DatagramPacket datagram, ByteArrayInputStream is, int statusCode, String statusMessage, String httpProtocol) throws Exception {
        UpnpHeaders headers = new UpnpHeaders(is);
        UpnpResponse upnpResponse = new UpnpResponse(statusCode, statusMessage);
        upnpResponse.setHttpMinorVersion(httpProtocol.toUpperCase().equals("HTTP/1.1") ? 1 : 0);
        IncomingDatagramMessage<UpnpResponse> responseMessage = new IncomingDatagramMessage<UpnpResponse>(upnpResponse, datagram.getAddress(), datagram.getPort(), receivedOnAddress);
        responseMessage.setHeaders(headers);
        return responseMessage;
    }
}

